package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AprovacaoMudancaDTO;
import br.com.centralit.citcorpore.bean.AprovacaoPropostaDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.HistoricoMudancaDTO;
import br.com.centralit.citcorpore.bean.PesquisaRequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface RequisicaoMudancaService extends CrudService {

	Collection findByConhecimento(final BaseConhecimentoDTO baseConhecimentoDto) throws ServiceException, LogicException;

	ServicoContratoDTO findByIdContratoAndIdServico(final Integer idContrato, final Integer idServico) throws Exception;

	Collection findBySolictacaoServico(final RequisicaoMudancaDTO bean) throws ServiceException, LogicException;

	Collection gravaInformacoesGED(final Collection colArquivosUpload, final int idEmpresa, final RequisicaoMudancaDTO requisicaoMudancaDto, final TransactionControler tc) throws Exception;

	void gravaPlanoDeReversaoGED(final RequisicaoMudancaDTO requisicaomudacaDTO, final TransactionControler tc, final HistoricoMudancaDTO historicoMudancaDTO) throws Exception;

	Collection<RequisicaoMudancaDTO> listaMudancaPorBaseConhecimento(final RequisicaoMudancaDTO mudanca) throws Exception;

	Collection listaQuantidadeMudancaPorImpacto(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaQuantidadeMudancaPorPeriodo(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaQuantidadeMudancaPorProprietario(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaQuantidadeMudancaPorSolicitante(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaQuantidadeMudancaPorStatus(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaQuantidadeMudancaPorUrgencia(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaQuantidadeSemAprovacaoPorPeriodo(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	List<RequisicaoMudancaDTO> listMudancaByIdItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

	Integer listQuantidadeMudancaByIdItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

	String getUrlInformacoesComplementares(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	void updateNotNull(final IDto obj) throws Exception;

	List<RequisicaoMudancaDTO> listMudancaByIdSolicitacao(final RequisicaoMudancaDTO bean) throws Exception;

	Collection<PesquisaRequisicaoMudancaDTO> listRequisicaoMudancaByCriterios(final PesquisaRequisicaoMudancaDTO requisicaoMudancaDto) throws Exception;

	Collection<RequisicaoMudancaDTO> quantidadeMudancaPorBaseConhecimento(final RequisicaoMudancaDTO mudanca) throws Exception;

	void reativa(final UsuarioDTO usuarioDto, final RequisicaoMudancaDTO RequisicaoMudancaDto) throws Exception;

	RequisicaoMudancaDTO restoreAll(final Integer idRequisicaoMudanca) throws Exception;

	void suspende(final UsuarioDTO usuarioDto, final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	boolean validacaoAvancaFluxo(final RequisicaoMudancaDTO requisicaoMudancaDto, final TransactionControler tc) throws Exception;

	String verificaAprovacaoProposta(final RequisicaoMudancaDTO requisicaoMudancaDto, final TransactionControler tc) throws Exception;

	String verificaAprovacaoMudanca(final RequisicaoMudancaDTO requisicaoMudancaDto, final TransactionControler tc) throws Exception;

	boolean verificarSeRequisicaoMudancaPossuiTipoMudanca(final Integer idTipoMudanca) throws Exception;

	Collection listaQuantidadeERelacionamentos(final HttpServletRequest request, final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	Collection listaIdETituloMudancasPorPeriodo(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws Exception;

	boolean verificaPermissaoGrupoCancelar(final Integer idTipoMudana, final Integer idGrupo) throws ServiceException, Exception;

	boolean verificarItensRelacionados(final RequisicaoMudancaDTO requisicaoMudancaDto) throws ServiceException, Exception;

	public Set<AprovacaoPropostaDTO> retornaAprovacoesProposta(RequisicaoMudancaDTO requisicaoMudancaDto, UsuarioDTO usuarioDto, HttpServletRequest request) throws Exception;

	public Set<AprovacaoMudancaDTO> retornaAprovacoesMudanca(RequisicaoMudancaDTO requisicaoMudancaDto, UsuarioDTO usuarioDto, HttpServletRequest request) throws Exception;

	public ArrayList<RequisicaoMudancaItemConfiguracaoDTO> listItensRelacionadosRequisicaoMudanca(final RequisicaoMudancaDTO requisicaoMudancaDTO) throws ServiceException, Exception;

	public Collection<RequisicaoMudancaServicoDTO> listServicosRequisicaoMudanca(RequisicaoMudancaDTO requisicaoMudancaDTO);

	public Collection<SolicitacaoServicoDTO> listaSolicitacoesRequisicaoMudanca(Integer idRequisicaoMudanca);

	public boolean seHoraInicialMenorQAtual(RequisicaoMudancaDTO requisicaoMudancaDto);

	public boolean seHoraFinalMenorQHoraInicial(RequisicaoMudancaDTO requisicaoMudancaDto);

	public boolean seHoraFinalMenorQAtual(RequisicaoMudancaDTO requisicaoMudancaDto);

	public IDto create(IDto model, DocumentHTML document, HttpServletRequest request) throws ServiceException, LogicException;

	public void update(IDto model, DocumentHTML document, HttpServletRequest request) throws ServiceException, LogicException;

	boolean planoDeReversaoInformado(final RequisicaoMudancaDTO requisicaoMudancaDto, final HttpServletRequest request) throws Exception;

	boolean validaVotacaoAprovacao(final RequisicaoMudancaDTO requisicaoMudancaDto, final HttpServletRequest request) throws Exception;

	void salvaListaAprovacaoPropostaRequisicao(RequisicaoMudancaDTO requisicaoMudancaDto) throws ServiceException, LogicException;
}
