package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.RequisitosNivelServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.integracao.RequisitosNivelServicoDao;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

/**
 * @author douglas.japiassu
 * @since 19.10.2015
 */
@SuppressWarnings("unchecked")
public class RequisitosNivelServicoServiceEjb extends CrudServiceImpl implements RequisitosNivelServicoService {
	private static final String DIRETORIO_PADRAO = "1";
	private static final String EXTENSAO_GED = ".ged";
	private static final String FS = System.getProperty("file.separator");
	
	private RequisitosNivelServicoDao dao;
	private ControleGEDDao controleGEDDao;

	@Override
	protected RequisitosNivelServicoDao getDao() {
		if (this.dao == null) {
			this.dao = new RequisitosNivelServicoDao();
		}
		return this.dao;
	}

	@Override
	public Collection<RequisitosNivelServicoDTO> findByIdServicoNegocio(final Integer idServicoNegocio) throws PersistenceException {
		return this.getDao().findByIdServicoNegocio(idServicoNegocio);
	}

	@Override
	public RequisitosNivelServicoDTO salvar(RequisitosNivelServicoDTO requisitosNivelServico) throws PersistenceException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			tc.start();
			this.validaCreate(requisitosNivelServico);
			requisitosNivelServico = this.executarAcaoSalvar(requisitosNivelServico, tc);
			tc.commit();
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(tc, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			requisitosNivelServico = null;
			tc.close();
		}
		
		return requisitosNivelServico;
	}

	private RequisitosNivelServicoDTO executarAcaoSalvar(RequisitosNivelServicoDTO requisitosNivelServico, final TransactionControler tc)
			throws PersistenceException, Exception {
		
		if (requisitosNivelServico.getIdRequisitosNivelServico() != null && requisitosNivelServico.getIdRequisitosNivelServico().intValue() > 0) {
			if (this.isServicoExiste(requisitosNivelServico.getIdServicoNegocio())) {
				this.getDao().update(requisitosNivelServico);
			}
		} else {
			requisitosNivelServico = (RequisitosNivelServicoDTO) this.getDao().create(requisitosNivelServico);
		}
		
		if (requisitosNivelServico != null && requisitosNivelServico.getColsUploadGED() != null && !requisitosNivelServico.getColsUploadGED().isEmpty()) {
			this.gravarInformacaoGED(requisitosNivelServico, tc);
		}
		
		return requisitosNivelServico;
	}

	private void gravarInformacaoGED(final RequisitosNivelServicoDTO requisitosNivelServico, final TransactionControler tc) throws Exception {
		this.definirTransacao(tc);
		this.tratarListaDeArquivoGED(requisitosNivelServico);
	}

	private void tratarListaDeArquivoGED(final RequisitosNivelServicoDTO requisitosNivelServico) throws Exception {
		final String pasta = this.definirDiretorioGed(requisitosNivelServico);
		
		for (final UploadDTO uploadDTO : requisitosNivelServico.getColsUploadGED()) {
			if (uploadDTO.getTemporario().equals(SimNao.SIM.getValorStr())) {
				ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
				
				this.definirControleGED(requisitosNivelServico, pasta, uploadDTO, controleGEDDTO);
				this.definirPathArquivo(uploadDTO, controleGEDDTO);
				this.salvarSetarControleGED(uploadDTO, controleGEDDTO);
				this.criarGEDInternoBD(uploadDTO, controleGEDDTO);
			}
		}
	}

	/**
	 * Cria o arquivo no diretrio, faz a encriptao do mesmo e depois o deleta.
	 * 
	 * @param requisitosNivelServico
	 * @param uploadDTO
	 * @param controleGEDDTO
	 * @throws Exception
	 * 
	 * @author douglas.japiassu
	 * @since 21.10.2015
	 */
	private void criarGEDInternoBD(final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) throws Exception {
		if (getGedInternoBD().equalsIgnoreCase(SimNao.NAO.getValorStr())) {
			if (controleGEDDTO != null) {
				try {
					String caminho = getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS)
							.concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED()));
					
					final File arquivo = new File(caminho.concat(".").concat(Util.getFileExtension(uploadDTO.getNameFile())));
					
					CriptoUtils.encryptFile(uploadDTO.getPath(),
							caminho.concat(EXTENSAO_GED), 
							((String) System.getProperties().get("user.dir")).concat(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));
					
					arquivo.delete();
				} catch (ClassNotFoundException | IOException | GeneralSecurityException e) {
					e.printStackTrace();
				}
			}
		}
		
	}

	private void salvarSetarControleGED(final UploadDTO uploadDTO, 
			ControleGEDDTO controleGEDDTO) throws PersistenceException {
		controleGEDDTO = (ControleGEDDTO) getControleGEDDao().create(controleGEDDTO);
		uploadDTO.setIdControleGED(controleGEDDTO.getIdControleGED());
	}

	private void definirPathArquivo(final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) {
		if (SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInterno().trim()) && SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInternoBD().trim())) {
			controleGEDDTO.setPathArquivo(uploadDTO.getPath());
		} else {
			controleGEDDTO.setPathArquivo(null);
		}
	}

	private void definirControleGED(final RequisitosNivelServicoDTO requisitosNivelServico, final String pasta, final UploadDTO uploadDTO,
			final ControleGEDDTO controleGEDDTO) {
		controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_REQUISITOS_NIVEL_SERVICO);
		controleGEDDTO.setId(requisitosNivelServico.getIdRequisitosNivelServico());
		controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
		controleGEDDTO.setDescricaoArquivo(uploadDTO.getDescricao());
		controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDTO.getNameFile()));
		controleGEDDTO.setPasta(pasta);
		controleGEDDTO.setNomeArquivo(uploadDTO.getNameFile());
	}
	
	@Override
	public void removerAnexosDiretorioGed(final DocumentHTML document, RequisitosNivelServicoDTO requisitosNivelServico) throws PersistenceException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			this.deletarArquivos(document, requisitosNivelServico, tc);
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(tc, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			tc.close();
		}

	}
	
	private void deletarArquivos(final DocumentHTML document, RequisitosNivelServicoDTO requisitosNivelServico, final TransactionControler tc) throws Exception {
		if (requisitosNivelServico.getColsUploadGEDExcluidos() != null && !requisitosNivelServico.getColsUploadGEDExcluidos().isEmpty()) {
			final String gedDiretorio = this.getGedDiretorio();
			
			for (final String valorId : requisitosNivelServico.getColsUploadGEDExcluidos()) {
				if (valorId.startsWith("ID=")) {
					tc.start();
					this.definirTransacao(tc);
					
					ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
					controleGEDDTO.setIdControleGED(this.obterIdParaExclusaoGed(valorId));
					controleGEDDTO = (ControleGEDDTO) this.getControleGEDDao().restore(controleGEDDTO);
					this.getControleGEDDao().delete(controleGEDDTO);

					final File arquivo = new File(gedDiretorio.concat(FS).concat(DIRETORIO_PADRAO).concat(FS)
							.concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED()))
							.concat(EXTENSAO_GED));
					
					this.deleteDir(arquivo);
					tc.commit();
					document.executeScript("parent.reloadAnexosRNS();");
				} else {
					final File arquivoTemporario = new File(valorId);
					
					this.deleteDir(arquivoTemporario);
				}
			}
		}
	}

	private boolean deleteDir(final File dir) {
		if (dir.isDirectory()) {
			final String[] children = dir.list();
			for (final String element : children) {
				final boolean success = this.deleteDir(new File(dir, element));
				if (!success) {
					return false;
				}
			}
		}
		
		return dir.delete();
	}

	private Integer obterIdParaExclusaoGed(final String strParaVerificar) {
		Integer idParaExclusao = null;
		
		final String[] strParaVerificarArray = strParaVerificar.split("=");
		
		if (strParaVerificarArray[1] != null) {
			idParaExclusao = Integer.valueOf(strParaVerificarArray[1].toString());
		}
		
		return idParaExclusao;
	}

	private String definirDiretorioGed(final RequisitosNivelServicoDTO requisitosNivelServico)
			throws Exception {
		String pasta = "";

		if (getGedInterno().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
			pasta = getControleGEDDao().getProximaPastaArmazenar();

			File fileDir = new File(getGedDiretorio());
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(pasta));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
		}
		
		return pasta;
	}

	private String getGedInternoBD() {
		String gedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD,
				SimNao.NAO.getValorStr());
		
		return gedInternoBancoDados;
	}

	private String getGedInterno() {
		String gedInterno = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, 
				SimNao.SIM.getValorStr());
		
		return gedInterno;
	}

	private String getGedDiretorio() throws Exception {
		final String gedDiretorio = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "");
		if ("".equals(gedDiretorio.trim())) {
			throw new Exception("Diretrio No Informado.");
		}
		return gedDiretorio;
	}

	private void definirTransacao(final TransactionControler tc) {
		if (tc != null) {
			getControleGEDDao().setTransactionControler(tc);
		}
	}

	private boolean isServicoExiste(final Integer idServico) throws PersistenceException {
		final Collection<RequisitosNivelServicoDTO> colRequisitosNivelServico = this.findByIdServicoNegocio(idServico);
		return (colRequisitosNivelServico != null && !colRequisitosNivelServico.isEmpty()) ? Boolean.TRUE : Boolean.FALSE;
	}
	
	private ControleGEDDao getControleGEDDao() {
		if (controleGEDDao == null) {
			controleGEDDao = new ControleGEDDao();
		}
		
		return controleGEDDao;
	}
}