package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.ServicoAutoRelacionamentoDTO;
import br.com.centralit.citcorpore.integracao.ServicoAutoRelacionamentoDao;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public class ServicoAutoRelacionamentoServiceEjb extends CrudServiceImpl implements ServicoAutoRelacionamentoService {

    private ServicoAutoRelacionamentoDao dao;

    @Override
    protected ServicoAutoRelacionamentoDao getDao() {
        if (dao == null) {
            dao = new ServicoAutoRelacionamentoDao();
        }
        return dao;
    }

	@Override
	public ServicoAutoRelacionamentoDTO findServicoRelacionado(Integer idServico, Integer idServicoRelacionado) throws Exception {
		return this.getDao().findServicoRelacionado(idServico, idServicoRelacionado);
	}

	@Override
	public void updateNotNull(ServicoAutoRelacionamentoDTO servicoAutoRelacionamentoDTO) throws Exception {
		this.getDao().updateNotNull(servicoAutoRelacionamentoDTO);
	}

	@Override
	public void deleteServicoRelacionado(Integer idServico, Integer idServicoRelacionado) throws Exception {
		ServicoAutoRelacionamentoDTO servicoAutoRelacionamentoDTO = this.findServicoRelacionado(idServico, idServicoRelacionado);
		
		if(servicoAutoRelacionamentoDTO!=null){
			servicoAutoRelacionamentoDTO.setDataFim(UtilDatas.getDataAtual());
			this.updateNotNull(servicoAutoRelacionamentoDTO);
		}

	}
	
	@Override
	public List<Integer> listIdsServicosRelacionadosVincularContrato(Integer idPortfolioServico, Integer idServicoRelacionado, String tipoServico, Integer idContrato) throws Exception {
		return this.getDao().listIdsServicosRelacionadosVincularContrato(idPortfolioServico, idServicoRelacionado, tipoServico, idContrato);
	}

	@Override
	public void recuperaServicoRelacionadoDeletado(Integer idServico, Integer idServicoRelacionado) throws Exception {
		ServicoAutoRelacionamentoDTO servicoAutoRelacionamentoDTO = this.findServicoRelacionadoDeletado(idServico, idServicoRelacionado);
		
		if(servicoAutoRelacionamentoDTO!=null){
			servicoAutoRelacionamentoDTO.setDataFim(null);
			this.update(servicoAutoRelacionamentoDTO);
		}		
	}

	@Override
	public ServicoAutoRelacionamentoDTO findServicoRelacionadoDeletado(Integer idServico, Integer idServicoRelacionado) throws Exception {
		return this.getDao().findServicoRelacionadoDeletado(idServico, idServicoRelacionado);
	}

}
