package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.ServicoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.integracao.ServicoBaseConhecimentoDAO;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ServicoBaseConhecimentoServiceEjb extends CrudServiceImpl implements ServicoBaseConhecimentoService {

	private ServicoBaseConhecimentoDAO dao;

	    @Override
	protected ServicoBaseConhecimentoDAO getDao() {
		if (dao == null) {
			dao = new ServicoBaseConhecimentoDAO();
		}
		return dao;
	}
	    
	@Override
	public Collection<ServicoBaseConhecimentoDTO> findConhecimentosByServico(Integer idServico, String like)
			throws Exception {
		try {
			return getDao().findConhecimentosByServico(idServico, like);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception(e);
		}
	}
	    
	@Override
	public void deletaVinculo(Integer idVinculo) throws Exception {
		try {
			getDao().deletaVinculo(idVinculo);
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception(e);
		}
	}
}
