package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioServicoContratoANSDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoANSDTO;
import br.com.centralit.citcorpore.integracao.ServicoContratoANSDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ServicoContratoANSServiceEjb extends CrudServiceImpl implements ServicoContratoANSService {

	private ServicoContratoANSDao dao;

	@Override
	protected ServicoContratoANSDao getDao() {
		if (dao == null) {
			dao = new ServicoContratoANSDao();
		}
		return dao;
	}

	@Override
	public Page<GerenciamentoPortfolioServicoContratoANSDTO> findByIdServicoContrato(Integer idServicoContrato, String filtro, final Pageable pageable, Boolean isTotalizacao) throws Exception {
		return this.getDao().findByIdServicoContrato(idServicoContrato, filtro, pageable, isTotalizacao);
	}

	@Override
	public void updateNotNull(ServicoContratoANSDTO servicoContratoANSDTO) throws Exception {
		this.getDao().updateNotNull(servicoContratoANSDTO);
	}

	@Override
	public Boolean existeAnsAtivoByServicoContrato(Integer idServicoContrato) throws Exception {
		return this.getDao().existeAnsAtivoByServicoContrato(idServicoContrato);
	}
	
	@Override
	public ServicoContratoANSDTO getServicoContratoANSDTOAtivoByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		Collection<ServicoContratoANSDTO> colServicoContratoANS = this.getDao().getServicoContratoANSDTOAtivoByIdServicoContrato(idServicoContrato);
		if(colServicoContratoANS != null && !colServicoContratoANS.isEmpty()){
			return new ArrayList<>(colServicoContratoANS).get(0);
		}
		return null;
	}
}
