package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.ServicoContratoCalendarioDTO;
import br.com.centralit.citcorpore.integracao.ServicoContratoCalendarioDAO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ServicoContratoCalendarioServiceEjb extends CrudServiceImpl implements ServicoContratoCalendarioService {

	private ServicoContratoCalendarioDAO servicoContratoCalendarioDAO;

	@Override
	protected ServicoContratoCalendarioDAO getDao() {
		if (servicoContratoCalendarioDAO == null) {
			servicoContratoCalendarioDAO = new ServicoContratoCalendarioDAO();
		}
		return servicoContratoCalendarioDAO;
	}

	@Override
	public Page<ServicoContratoCalendarioDTO> listCalendario(Integer idServicoContrato, String filtroContratoCalendario, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		return this.getDao().listCalendario(idServicoContrato, filtroContratoCalendario, pageable, isTotalizacao);
	}

	@Override
	public void updateNotNull(ServicoContratoCalendarioDTO servicoContratoCalendarioDTO) throws Exception {
		this.getDao().updateNotNull(servicoContratoCalendarioDTO);
	}

	@Override
	public Boolean existeCalendarioAtivoByServicoContrato(Integer idServicoContrato) throws Exception {
		return this.getDao().existeCalendarioAtivoByServicoContrato(idServicoContrato);
	}
	
	@Override
	public ServicoContratoCalendarioDTO getServicoContratoCalendarioDTOAtivoByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		Collection<ServicoContratoCalendarioDTO> colServicoContratoCalendario = this.getDao().getServicoContratoCalendarioDTOAtivoByIdServicoContrato(idServicoContrato);
		if(colServicoContratoCalendario != null && !colServicoContratoCalendario.isEmpty()){
			return new ArrayList<>(colServicoContratoCalendario).get(0);
		}
		return null;
	}
}
