package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.ProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoProcessoNegocioDTO;
import br.com.centralit.citcorpore.integracao.ProcessoNegocioDao;
import br.com.centralit.citcorpore.integracao.ServicoProcessoNegocioDAO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ServicoProcessoNegocioServiceEjb extends CrudServiceImpl implements ServicoProcessoNegocioService {

	private ServicoProcessoNegocioDAO dao;

	@Override
	protected ServicoProcessoNegocioDAO getDao() {
		if(this.dao == null)
			return new ServicoProcessoNegocioDAO();
		
		return this.dao;
	}
	
	@Override
    public IDto create(final IDto model) throws ServiceException, LogicException {
        final ServicoProcessoNegocioDAO servicoProcessoNegocioDao = this.getDao();
        final TransactionControler tc = new TransactionControlerImpl(servicoProcessoNegocioDao.getAliasDB());

        try {
            this.validaCreate(model);

            servicoProcessoNegocioDao.setTransactionControler(tc);

            tc.start();

            ServicoProcessoNegocioDTO servicoProcessoNegocioDTO = (ServicoProcessoNegocioDTO) model;

            servicoProcessoNegocioDao.create(servicoProcessoNegocioDTO);

            tc.commit();
            tc.close();
        } catch (final Exception e) {
            this.rollbackTransaction(tc, e);
        }
        return model;
    }

	@Override
	public Collection<ProcessoNegocioDTO> findProcessosNegocioByIdServico(Integer idServico) throws Exception {
		try {
			Collection<ServicoProcessoNegocioDTO> listaServicoProcessosNegocio = this.getDao().findIdsProcessosNegocioByIdServico(idServico);
			Collection<ProcessoNegocioDTO> listaProcessosNegocio = new ArrayList<ProcessoNegocioDTO>();
			ProcessoNegocioDao processoNegocioDao = new ProcessoNegocioDao();
			if (listaServicoProcessosNegocio != null && !listaServicoProcessosNegocio.isEmpty()) {
				for (ServicoProcessoNegocioDTO dto : listaServicoProcessosNegocio) {
					listaProcessosNegocio.add(processoNegocioDao.findById(dto.getIdProcessoNegocio()));
				}
			}
			return listaProcessosNegocio;
			
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
	
	@Override
	public void deleteProcessoFromServico(Integer idProcessoNegocio, Integer idServico) throws Exception {
		try {
			this.getDao().deleteProcessoNegocioFromServico(idProcessoNegocio, idServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}		
	}
	
	@Override
	public Collection<ServicoDTO> findServicosByIdProcessosNegocio(final Integer idProcessoNegocio) throws Exception {
		try {
			return this.getDao().findServicosByIdProcessosNegocio(idProcessoNegocio);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

}
