package br.com.centralit.citcorpore.negocio;

import br.com.centralit.citcorpore.bean.ControleQuestionariosDTO;
import br.com.centralit.citcorpore.bean.ServicoQuestionarioDTO;
import br.com.centralit.citcorpore.integracao.ControleQuestionariosDao;
import br.com.centralit.citcorpore.integracao.ServicoQuestionarioDao;
import br.com.centralit.citquestionario.integracao.RespostaItemQuestionarioDao;
import br.com.centralit.citquestionario.negocio.RespostaItemQuestionarioServiceBean;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

/**
*
* @author douglas.japiassu
* @since 13.03.2016
*/
@SuppressWarnings("unchecked")
public class ServicoQuestionarioServiceEjb extends CrudServiceImpl implements ServicoQuestionarioService {

	private ServicoQuestionarioDao dao;

	@Override
	protected ServicoQuestionarioDao getDao() {
		if (dao == null) {
			dao = new ServicoQuestionarioDao();
		}
		return dao;
	}

	@Override
	public IDto create(IDto model) throws ServiceException, LogicException {
		final ControleQuestionariosDao controleQuestionariosDao = new ControleQuestionariosDao();
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		final ServicoQuestionarioDTO servicoQuestionariosDTO = (ServicoQuestionarioDTO) model;
		final RespostaItemQuestionarioServiceBean respostaItemQuestionarioServiceBean = new RespostaItemQuestionarioServiceBean();

		try {
			this.getDao().setTransactionControler(tc);
			controleQuestionariosDao.setTransactionControler(tc);

			tc.start();

			ControleQuestionariosDTO controleQuestionariosDto = new ControleQuestionariosDTO();
			controleQuestionariosDto = (ControleQuestionariosDTO) controleQuestionariosDao.create(controleQuestionariosDto);

			servicoQuestionariosDTO.setIdServicoQuestionario(controleQuestionariosDto.getIdControleQuestionario());

			servicoQuestionariosDTO.setDataHoraGrav(UtilDatas.getDataHoraAtual());
			model = this.getDao().create(model);

			final Integer idIdentificadorResposta = servicoQuestionariosDTO.getIdServicoQuestionario();

			respostaItemQuestionarioServiceBean.processCollection(tc, servicoQuestionariosDTO.getColValores(), servicoQuestionariosDTO.getColAnexos(), idIdentificadorResposta, null);

			tc.commit();
			tc.close();

			return model;
		} catch (final Exception e) {
			this.rollbackTransaction(tc, e);
		}
		return model;
	}

	@Override
	public void update(final IDto model) throws ServiceException, LogicException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		final RespostaItemQuestionarioDao respostaItemDao = new RespostaItemQuestionarioDao();
		final ServicoQuestionarioDTO servicoQuestionariosDTO = (ServicoQuestionarioDTO) model;
		final RespostaItemQuestionarioServiceBean respostaItemQuestionarioServiceBean = new RespostaItemQuestionarioServiceBean();

		try {
			this.getDao().setTransactionControler(tc);
			respostaItemDao.setTransactionControler(tc);

			final Integer idIdentificadorResposta = servicoQuestionariosDTO.getIdServicoQuestionario();

			tc.start();

			respostaItemDao.deleteByIdIdentificadorResposta(idIdentificadorResposta);
			servicoQuestionariosDTO.setDataHoraGrav(UtilDatas.getDataHoraAtual());
			this.getDao().update(model);

			respostaItemQuestionarioServiceBean.processCollection(tc, servicoQuestionariosDTO.getColValores(), servicoQuestionariosDTO.getColAnexos(), idIdentificadorResposta, null);

			tc.commit();
			tc.close();
		} catch (final Exception e) {
			this.rollbackTransaction(tc, e);
		}
	}

	@Override
	public boolean existeQuestionarioByIdServico(Integer idServico) throws Exception {
		ServicoQuestionarioDTO servicoQuestionarioDTO = this.getDao().findByIdServico(idServico);

		if (servicoQuestionarioDTO != null) {
			return true;
		}
		return false;
	}

}
