package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoQuestionarioDTO;
import br.com.centralit.citcorpore.util.ArvoreServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface ServicoService extends CrudService {
	/**
	 * Verifica se o ServicoDTO informado existe.
	 *
	 * @param ServicoDTO
	 * @return boolean
	 * @throws Exception
	 * @author rodrigo.guilherme
	 */
	public boolean verificarSeServicoExiste(final ServicoDTO servicoDto) throws Exception;

	public Collection findByIdCategoriaServico(Integer parm) throws Exception;

	public void deleteByIdCategoriaServico(Integer parm) throws Exception;

	public Collection findByIdSituacaoServico(Integer parm) throws Exception;

	public void deleteByIdSituacaoServico(Integer parm) throws Exception;

	public Collection findByIdTipoDemandaAndIdCategoria(Integer idTipoDemanda, Integer idCategoria) throws Exception;

	public Collection findByIdServicoAndIdTipoDemandaAndIdCategoria(Integer idServico, Integer idTipoDemanda, Integer idCategoria) throws Exception;

	/**
	 * Retorna Sigla do Servio por idOs.
	 *
	 * @param idOs
	 * @return
	 * @throws Exception
	 */
	public String retornarSiglaPorIdOs(Integer idOs) throws Exception;

	public Collection findByIdTipoDemandaAndIdContrato(Integer idTipoDemanda, Integer idContrato, Integer idCategoria) throws Exception;

	public Collection<ServicoDTO> findByServico(Integer idServico) throws Exception;

	public Collection<ServicoDTO> findByServico(Integer idServico, String nome) throws Exception;

	public Collection<ServicoDTO> listaQuantidadeServicoAnalitico(ServicoDTO servicoDTO)
			throws Exception;

	public ServicoDTO findByIdServico(Integer idServico) throws Exception;

	public Collection<ServicoDTO> listAtivos() throws Exception;

	public void desvincularServicosRelacionadosTemplate(Integer idTemplate) throws Exception;

	public Collection<ServicoDTO> findAutocompleteServico(Integer idTipoDemanda, Integer idContrato, Integer idCategoria, String nome, final Integer idServicoNegocioTecnico) throws Exception;

	public Collection<ServicoDTO> findAutocompleteServicoNegocioTecnico(Integer idContrato, final String tipoServicoNegocioTecnico, final String queryConsulta) throws Exception;

	public Collection<ServicoDTO> findAutocompleteServicoNegocioTecnico(Integer idContrato, final String tipoServicoNegocioTecnico, final String queryConsulta, final Integer idCategoriaServicoNegocio) throws Exception;

	public ServicoDTO findById(Integer idServico) throws Exception;

	String verificaIdCategoriaServico(HashMap mapFields) throws Exception;

	/**
	 * Retorna uma lista de servicos ativos que ainda no foram adicionados a
	 * este contrato
	 *
	 * @param servicoDto
	 * @return
	 * @throws Exception
	 * @author thays.araujo
	 */
	public Collection<ServicoDTO> listAtivosDiferenteContrato(ServicoDTO servicoDto) throws Exception;

	public Integer calculaTotalPaginas(Integer itensPorPagina) throws Exception;

	public Collection<ServicoDTO> paginacaoServico(Integer paginaAtual, Integer itensPorPagina) throws PersistenceException;

	public Collection<ServicoDTO> findByIdPortfolioServico(Integer idPortfolioServico) throws Exception;

	public List<ServicoDTO> listServicosDeNegocioPortal(Integer idPortfolio, Collection<ContratoDTO> contratosDTO, String categoriaPortfolio, String filtroServico, String ordenarPor, String ascDesc) throws PersistenceException;

	public Page<ServicoDTO> listServicosDeNegocio(Integer idPortfolio, String categoriaPortfolio, String filtroServico, String ordenarPor, String ascDesc, final Pageable pageable, final Boolean isTotalizacao) throws PersistenceException;

	public Page<ServicoDTO> listServicosDeApoio(Integer idPortfolio, Integer idServicoRelacionado, String filtroServico, final Pageable pageable, final Boolean isTotalizacao) throws PersistenceException;

	public Page<ServicoDTO> listServicosNegocioRequisicaoIncidente(String tipoServico, Integer idPortfolio, Integer idServicoRelacionado, String filtroServico, final Pageable pageable, final Boolean isTotalizacao) throws PersistenceException;

	public List<ServicoDTO> listServicosVinculadosAoContratoPortal(List<TipoServico> tiposServico, Integer idPortfolio, Integer idServicoRelacionado, Collection<ContratoDTO> contratosDTO, String filtroServico) throws PersistenceException;

	public Page<ServicoDTO> listServicosVinculadoAoContrato(String tipoServico, Integer idPortfolio, Integer idServicoRelacionado, Integer idContrato, String filtroServico,
			final Pageable pageable, final Boolean isTotalizacao) throws PersistenceException;

	public String recuperaStatusServico(Integer idServico) throws Exception;

	public String recuperaFaseServico(Integer idServico) throws Exception;

	public String recuperaTipoServico(Integer idServico) throws Exception;

	public Long getTotalRegistrosPorCategoriaPortfolio(Integer idPortfolio, String categoriaPortfolio) throws PersistenceException;

	void removerAnexosDiretorioGed(final DocumentHTML document, final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO) throws PersistenceException;

	GerenciamentoPortfolioCadastroServicoNegocioDTO salvar(ServicoDTO servicoDTO, GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO, HttpServletRequest request) throws PersistenceException;

	ServicoDTO recuperaServicoRelacionado(final Integer idContrato, final Integer idServico) throws PersistenceException;

	public List<ServicoDTO> listServicoRelacionadoByItemConfiguracao(Integer idItemConfiguracao) throws Exception;

	String getUrlInformacoesComplementares(ServicoDTO servicoDto) throws Exception;

	void deserializaInformacoesComplementares(ServicoDTO servicoDto, ServicoQuestionarioDTO servicoQuestionarioDTO) throws Exception;

	public Collection findByNomeAndContratoAndTipoDemandaAndCategoria(Integer idTipoDemanda, Integer idContrato, Integer idCategoria, String nome) throws Exception;

	public Collection<ServicoDTO> listServicosCombo(ServicoDTO dto) throws PersistenceException;

	public Collection<ServicoDTO> listServicosPorFuncaoVital(Integer idFuncaoVital) throws PersistenceException;

	public Collection<ServicoDTO> getServicosImpactadosByIdItemConfiguracao(Integer idItemConfiguracao) throws PersistenceException;

	public ArvoreServico getHieraquiaServicoApoioImpactado(Integer idServicoApoio) throws Exception;
	
	public boolean isServicoEmProducao(Integer idServico) throws Exception;

	public boolean existeQuestionarioServico(final Integer idServico) throws PersistenceException;

	public Integer obterIdQuestionarioServico(Integer idServico);
}