package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ControleQuestionariosDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoQuestionarioDTO;
import br.com.centralit.citcorpore.bean.TemplateServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.integracao.CategoriaServicoDao;
import br.com.centralit.citcorpore.integracao.ControleQuestionariosDao;
import br.com.centralit.citcorpore.integracao.ServicoDao;
import br.com.centralit.citcorpore.integracao.ServicoQuestionarioDao;
import br.com.centralit.citcorpore.util.ArvoreServico;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.FaseServico;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.centralit.citquestionario.integracao.RespostaItemQuestionarioDao;
import br.com.centralit.citquestionario.negocio.RespostaItemQuestionarioServiceBean;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ServicoServiceEjb extends CrudServiceImpl implements ServicoService {
	private static final String DIRETORIO_PADRAO = "1";
	private static final String EXTENSAO_GED = ".ged";
	private static final String FS = System.getProperty("file.separator");

	private ServicoDao dao;
	private ServicoDao daoDataBaseAlias;
	private ControleGEDDao controleGEDDao;
	private ServicoQuestionarioService servicoQuestionarioService;

	@Override
	protected ServicoDao getDao() {
		if (dao == null) {
			dao = new ServicoDao();
		}
		return dao;
	}

	/**
	 * Desenvolvedor: Fabio Amorim - Data: 13/08/2015 - Horrio: 14:48 - ID
	 * Citsmart: 176361 - Motivo/Comentrio: Possibilitara gerao dos
	 * relatrios do Citsmart atravs do dataSsource passado por parmetro para
	 * o DAO, citsmart_reports, por exemplo.
	 *
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido,
	 *         seno dao com o datasource principal
	 */
	private ServicoDao getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (daoDataBaseAlias == null) {
				daoDataBaseAlias = new ServicoDao(databaseAlias);
			}
			return daoDataBaseAlias;
		}
		return this.getDao();
	}

	@Override
	public boolean verificarSeServicoExiste(final ServicoDTO servicoDto) throws Exception {
		try {
			return this.getDao().verificarSeServicoExiste(servicoDto);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdCategoriaServico(final Integer parm) throws Exception {
		try {
			return this.getDao().findByIdCategoriaServico(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void deleteByIdCategoriaServico(final Integer parm) throws Exception {
		try {
			this.getDao().deleteByIdCategoriaServico(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdSituacaoServico(final Integer parm) throws Exception {
		try {
			return this.getDao().findByIdSituacaoServico(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void deleteByIdSituacaoServico(final Integer parm) throws Exception {
		try {
			this.getDao().deleteByIdSituacaoServico(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdTipoDemandaAndIdCategoria(final Integer idTipoDemanda, final Integer idCategoria) throws Exception {
		try {
			return this.getDao().findByIdTipoDemandaAndIdCategoria(idTipoDemanda, idCategoria);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection findByIdTipoDemandaAndIdContrato(final Integer idTipoDemanda, final Integer idContrato, final Integer idCategoria) throws Exception {
		try {
			return this.getDao().findByIdTipoDemandaAndIdContrato(idTipoDemanda, idContrato, idCategoria);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public String retornarSiglaPorIdOs(final Integer idOs) throws Exception {
		return this.getDao().retornaSiglaPorIdOs(idOs);
	}

	@Override
	public Collection findByIdServicoAndIdTipoDemandaAndIdCategoria(final Integer idServico, final Integer idTipoDemanda, final Integer idCategoria) throws Exception {
		try {
			return this.getDao().findByIdServicoAndIdTipoDemandaAndIdCategoria(idServico, idTipoDemanda, idCategoria);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	public ServicoDTO restoreByIdServico(final Integer idServico) {
		final ArrayList<Condition> condicoes = new ArrayList<Condition>();

		condicoes.add(new Condition("idServico", "=", idServico));

		ArrayList<ServicoDTO> retorno;
		try {
			retorno = (ArrayList<ServicoDTO>) this.getDao().findByCondition(condicoes, null);
			if (retorno != null) {
				return retorno.get(0);
			}
		} catch (final Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public Collection<ServicoDTO> findByServico(final Integer idServico) throws Exception {
		return this.getDao().findByServico(idServico);
	}

	@Override
	public Collection<ServicoDTO> findByServico(final Integer idServico, final String nome) throws Exception {
		return this.getDao().findByServico(idServico, nome);
	}

	@Override
	public Collection<ServicoDTO> listaQuantidadeServicoAnalitico(final ServicoDTO servicoDTO) throws Exception {
		return this.getDao(servicoDTO.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeServicoAnalitico(servicoDTO);
	}

	@Override
	public ServicoDTO findByIdServico(final Integer idServico) throws Exception {
		return this.getDao().findByIdServico(idServico);
	}

	@Override
	public Collection<ServicoDTO> listAtivos() throws Exception {
		return this.getDao().listAtivos();
	}

	@Override
	public void desvincularServicosRelacionadosTemplate(final Integer idTemplate) throws Exception {
		final Collection<ServicoDTO> servicos = this.getDao().findByIdTemplate(idTemplate);

		if (servicos != null && !servicos.isEmpty()) {
			for (final ServicoDTO servico : servicos) {
				if (servico.getIdTemplateAcompanhamento() != null && servico.getIdTemplateAcompanhamento().intValue() == idTemplate.intValue()) {
					servico.setIdTemplateAcompanhamento(null);
				}
				if (servico.getIdTemplateSolicitacao() != null && servico.getIdTemplateSolicitacao().intValue() == idTemplate.intValue()) {
					servico.setIdTemplateSolicitacao(null);
				}
				this.getDao().update(servico);
			}
		}
	}

	@Override
	public Collection<ServicoDTO> findAutocompleteServico(final Integer idTipoDemanda, final Integer idContrato, final Integer idCategoria, final String nome, final Integer idServicoNegocioTecnico) throws Exception {
		return this.getDao().findAutocompleteServico(idTipoDemanda, idContrato, idCategoria, nome, idServicoNegocioTecnico);
	}

	@Override
	public ServicoDTO findById(final Integer idServico) throws Exception {
		return this.getDao().findById(idServico);
	}

	@Override
	public String verificaIdCategoriaServico(final HashMap mapFields) throws Exception {
		final CategoriaServicoDao categoriaServicoDao = new CategoriaServicoDao();
		List<CategoriaServicoDTO> listaCategoriaServicoDTO = null;
		String id = mapFields.get("IDCATEGORIASERVICO").toString().trim();
		if (id == null || id.equals("")) {
			id = "0";
		}
		if (UtilStrings.soContemNumeros(id)) {
			final Integer idCategoriaServico = Integer.parseInt(id);
			listaCategoriaServicoDTO = categoriaServicoDao.findByIdCategoriaServico(idCategoriaServico);
		} else {
			listaCategoriaServicoDTO = categoriaServicoDao.findByNomeCategoria(id);
		}
		if (listaCategoriaServicoDTO != null && listaCategoriaServicoDTO.size() > 0) {
			return String.valueOf(listaCategoriaServicoDTO.get(0).getIdCategoriaServico());
		} else {
			return "0";
		}
	}

	@Override
	public Collection<ServicoDTO> listAtivosDiferenteContrato(final ServicoDTO servicoDto) throws Exception {
		return this.getDao().listAtivosDiferenteContrato(servicoDto);
	}

	@Override
	public Integer calculaTotalPaginas(Integer itensPorPagina) throws Exception {
		return this.getDao().calculaTotalPaginas(itensPorPagina);
	}

	@Override
	public Collection<ServicoDTO> paginacaoServico(Integer paginaAtual, Integer itensPorPagina) throws PersistenceException {
		return this.getDao().paginacaoServico(paginaAtual, itensPorPagina);
	}

	@Override
	public Collection<ServicoDTO> findByIdPortfolioServico(Integer idPortfolioServico) throws Exception {
		return this.getDao().findByIdPortfolioServico(idPortfolioServico);
	}

	@Override
	public List<ServicoDTO> listServicosDeNegocioPortal(Integer idPortfolio, Collection<ContratoDTO> contratosDTO, String categoriaPortfolio, String filtroServico, String ordenarPor, String ascDesc) throws PersistenceException {
		return this.getDao().listServicosDeNegocioPortal(idPortfolio, contratosDTO, categoriaPortfolio, filtroServico, ordenarPor, ascDesc);
	}

	@Override
	public Page<ServicoDTO> listServicosDeNegocio(Integer idPortfolio, String categoriaPortfolio, String filtroServico, String ordenarPor, String ascDesc, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		return this.getDao().listServicosDeNegocio(idPortfolio, categoriaPortfolio, filtroServico, ordenarPor, ascDesc, pageable, isTotalizacao);
	}

	@Override
	public Page<ServicoDTO> listServicosNegocioRequisicaoIncidente(String tipoServico, Integer idPortfolio, Integer idServicoRelacionado, String filtroServico, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		return this.getDao().listServicosRequisicaoIncidente(tipoServico, idPortfolio, idServicoRelacionado, filtroServico, pageable, isTotalizacao);
	}

	@Override
	public List<ServicoDTO> listServicosVinculadosAoContratoPortal(List<TipoServico> tiposServico, Integer idPortfolio, Integer idServicoRelacionado, Collection<ContratoDTO> contratosDTO, String filtroServico) throws PersistenceException {
		return this.getDao().listServicosVinculadosAoContratoPortal(tiposServico, idPortfolio, idServicoRelacionado, contratosDTO, filtroServico);
	}

	@Override
	public Page<ServicoDTO> listServicosVinculadoAoContrato(String tipoServico, Integer idPortfolio, Integer idServicoRelacionado, Integer idContrato, String filtroServico, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		return this.getDao().listServicosVinculadosAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServico, pageable, isTotalizacao);
	}

	@Override
	public Page<ServicoDTO> listServicosDeApoio(Integer idPortfolio, Integer idServicoRelacionado, String filtroServico, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		return this.getDao().listServicosDeApoio(idPortfolio, idServicoRelacionado, filtroServico, pageable, isTotalizacao);
	}

	@Override
	public String recuperaStatusServico(Integer idServico) throws Exception {
		ServicoDTO servico = findById(idServico);
		return servico.getStatusServico();
	}

	@Override
	public String recuperaFaseServico(Integer idServico) throws Exception {
		ServicoDTO servico = findById(idServico);
		return servico.getFaseServico();
	}

	@Override
	public Long getTotalRegistrosPorCategoriaPortfolio(Integer idPortfolio, String categoriaPortfolio) throws PersistenceException {
		return this.getDao().getTotalRegistrosPorCategoriaPortfolio(idPortfolio, categoriaPortfolio);
	}

	@Override
	public void removerAnexosDiretorioGed(final DocumentHTML document, GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO) throws PersistenceException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			this.deletarArquivos(document, servicoNegocioDTO, tc);
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(tc, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			tc.close();
		}

	}

	private void deletarArquivos(final DocumentHTML document, GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO, final TransactionControler tc) throws Exception {
		if (servicoNegocioDTO.getColsUploadGEDExcluidos() != null && !servicoNegocioDTO.getColsUploadGEDExcluidos().isEmpty()) {
			final String gedDiretorio = this.getGedDiretorio();

			for (final String valorId : servicoNegocioDTO.getColsUploadGEDExcluidos()) {
				if (valorId.startsWith("ID=")) {
					tc.start();
					this.definirTransacao(tc);

					ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
					controleGEDDTO.setIdControleGED(this.obterIdParaExclusaoGed(valorId));
					controleGEDDTO = (ControleGEDDTO) this.getControleGEDDao().restore(controleGEDDTO);
					this.getControleGEDDao().delete(controleGEDDTO);

					final File arquivo = new File(gedDiretorio.concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED())).concat(EXTENSAO_GED));

					this.deleteDir(arquivo);
					tc.commit();
					document.executeScript("parent.reloadAnexosServicoNegocio();");
				} else {
					final File arquivoTemporario = new File(valorId);

					this.deleteDir(arquivoTemporario);
				}
			}
		}
	}

	private boolean deleteDir(final File dir) {
		if (dir.isDirectory()) {
			final String[] children = dir.list();
			for (final String element : children) {
				final boolean success = this.deleteDir(new File(dir, element));
				if (!success) {
					return false;
				}
			}
		}

		return dir.delete();
	}

	private Integer obterIdParaExclusaoGed(final String strParaVerificar) {
		Integer idParaExclusao = null;

		final String[] strParaVerificarArray = strParaVerificar.split("=");

		if (strParaVerificarArray[1] != null) {
			idParaExclusao = Integer.valueOf(strParaVerificarArray[1].toString());
		}

		return idParaExclusao;
	}

	private String getGedInternoBD() {
		String gedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD, SimNao.NAO.getValorStr());

		return gedInternoBancoDados;
	}

	private String getGedInterno() {
		String gedInterno = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, SimNao.SIM.getValorStr());

		return gedInterno;
	}

	private String getGedDiretorio() throws Exception {
		final String gedDiretorio = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "");
		if ("".equals(gedDiretorio.trim())) {
			throw new Exception("Diretrio No Informado.");
		}
		return gedDiretorio;
	}

	private void definirTransacao(final TransactionControler tc) {
		if (tc != null) {
			getControleGEDDao().setTransactionControler(tc);
		}
	}

	private ControleGEDDao getControleGEDDao() {
		if (controleGEDDao == null) {
			controleGEDDao = new ControleGEDDao();
		}

		return controleGEDDao;
	}

	@Override
	public GerenciamentoPortfolioCadastroServicoNegocioDTO salvar(ServicoDTO servicoDTO, GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO, HttpServletRequest request) throws PersistenceException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			tc.start();
			servicoNegocioDTO = this.executarAcaoSalvar(servicoDTO, servicoNegocioDTO, tc, request);
			tc.commit();
		} catch (final Exception e) {
			e.printStackTrace();
			try {
				this.rollbackTransaction(tc, e);
			} catch (LogicException e1) {
				servicoNegocioDTO.setMsgErroSalvarQuestionario(e1.getMessage());
				e1.printStackTrace();
			} catch (ServiceException e1) {
				servicoNegocioDTO = null;
				e1.printStackTrace();
			}

			tc.close();
		}

		return servicoNegocioDTO;
	}

	private GerenciamentoPortfolioCadastroServicoNegocioDTO executarAcaoSalvar(ServicoDTO servicoDTO, GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO, final TransactionControler tc, HttpServletRequest request) throws PersistenceException, Exception {

		this.getDao().setTransactionControler(tc);

		ServicoDTO servicoOld = null;

		if (servicoDTO.getIdServico() != null && servicoDTO.getIdServico().intValue() > 0) {
			servicoOld = this.restoreByIdServico(servicoDTO.getIdServico());
			if (Util.isNullOrEmpty(servicoDTO.getCriticidadeServico()) && !FaseServico.ANALISAR.getIdentificador().equalsIgnoreCase(servicoDTO.getFaseServico())) {
				servicoDTO.setCriticidadeServico(servicoOld.getCriticidadeServico());
			}
			this.getDao().update(servicoDTO);
		} else {
			servicoDTO = (ServicoDTO) this.getDao().create(servicoDTO);
			servicoNegocioDTO.setIdServico(servicoDTO.getIdServico());
		}

		if (servicoDTO.getInformacoesComplementares() != null || servicoDTO.getServicoQuestionarioDTO() != null) {
			TemplateServicoDTO templateDto = new TemplateServicoServiceEjb().findById(servicoNegocioDTO.getIdTemplateServico());
			if (templateDto != null) {
				if (templateDto.isQuestionario()) {
					atualizaInformacoesQuestionario(servicoDTO, tc, request);
				} else if (templateDto.getNomeClasseServico() != null) {
					ComplemInfServicoService informacoesComplementaresService = getInformacoesComplementaresService(templateDto.getNomeClasseServico());
					informacoesComplementaresService.create(tc, servicoDTO, servicoNegocioDTO.getInformacoesComplementares());
				}
			}
		}

		if (servicoNegocioDTO != null && servicoNegocioDTO.getColsUploadGED() != null && !servicoNegocioDTO.getColsUploadGED().isEmpty()) {
			this.gravarInformacaoGED(servicoNegocioDTO, tc);
		}

		return servicoNegocioDTO;
	}

	private ComplemInfServicoService getInformacoesComplementaresService(String nomeClasse) throws Exception {
		ComplemInfServicoService informacoesComplementaresService = (ComplemInfServicoService) Class.forName(nomeClasse).newInstance();
		return informacoesComplementaresService;
	}

	private void atualizaInformacoesQuestionario(ServicoDTO solicitacaoServicoDto, TransactionControler tc, HttpServletRequest request) throws Exception {
		ControleQuestionariosDao controleQuestionariosDao = new ControleQuestionariosDao();
		ServicoQuestionarioDao servicoQuestionarioDao = new ServicoQuestionarioDao();
		RespostaItemQuestionarioDao respostaItemDao = new RespostaItemQuestionarioDao();
		RespostaItemQuestionarioServiceBean respostaItemQuestionarioServiceBean = new RespostaItemQuestionarioServiceBean();

		controleQuestionariosDao.setTransactionControler(tc);
		servicoQuestionarioDao.setTransactionControler(tc);
		respostaItemDao.setTransactionControler(tc);

		ServicoQuestionarioDTO servicoQuestionarioDto = solicitacaoServicoDto.getServicoQuestionarioDTO();
		if (servicoQuestionarioDto.getIdServicoQuestionario() != null && servicoQuestionarioDto.getIdServicoQuestionario().intValue() > 0) {
			servicoQuestionarioDto.setIdServico(solicitacaoServicoDto.getIdServico());
			servicoQuestionarioDto.setDataHoraGrav(UtilDatas.getDataHoraAtual());
			servicoQuestionarioDao.updateNotNull(servicoQuestionarioDto);

			respostaItemDao.deleteByIdIdentificadorResposta(servicoQuestionarioDto.getIdServicoQuestionario());
			respostaItemQuestionarioServiceBean.processCollection(tc, servicoQuestionarioDto.getColValores(), servicoQuestionarioDto.getColAnexos(), servicoQuestionarioDto.getIdServicoQuestionario(), request);
		} else {
			ControleQuestionariosDTO controleQuestionariosDto = new ControleQuestionariosDTO();
			controleQuestionariosDto = (ControleQuestionariosDTO) controleQuestionariosDao.create(controleQuestionariosDto);

			servicoQuestionarioDto.setIdServico(solicitacaoServicoDto.getIdServico());

			if (servicoQuestionarioDto.getDataQuestionario() == null) {
				servicoQuestionarioDto.setDataQuestionario(UtilDatas.getDataAtual());
			}

			servicoQuestionarioDto.setSituacao("E");
			servicoQuestionarioDto.setIdServicoQuestionario(controleQuestionariosDto.getIdControleQuestionario());
			servicoQuestionarioDto.setDataHoraGrav(UtilDatas.getDataHoraAtual());

			ServicoQuestionarioDTO solQuestionariosDTO = (ServicoQuestionarioDTO) servicoQuestionarioDao.create(servicoQuestionarioDto);

			Integer idIdentificadorResposta = solQuestionariosDTO.getIdServicoQuestionario();
			respostaItemQuestionarioServiceBean.processCollection(tc, solQuestionariosDTO.getColValores(), solQuestionariosDTO.getColAnexos(), idIdentificadorResposta, request);
		}
	}

	private void gravarInformacaoGED(final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO, final TransactionControler tc) throws Exception {
		this.definirTransacao(tc);
		this.tratarListaDeArquivoGED(servicoNegocioDTO);
	}

	private void tratarListaDeArquivoGED(final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO) throws Exception {
		final String pasta = this.definirDiretorioGed(servicoNegocioDTO);

		for (final UploadDTO uploadDTO : servicoNegocioDTO.getColsUploadGED()) {
			if (uploadDTO.getTemporario().equals(SimNao.SIM.getValorStr())) {
				ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

				this.definirControleGED(servicoNegocioDTO, pasta, uploadDTO, controleGEDDTO);
				this.definirPathArquivo(uploadDTO, controleGEDDTO);
				this.salvarSetarControleGED(uploadDTO, controleGEDDTO);
				this.criarGEDInternoBD(uploadDTO, controleGEDDTO);
			}
		}
	}

	private void criarGEDInternoBD(final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) throws Exception {
		if (getGedInternoBD().equalsIgnoreCase(SimNao.NAO.getValorStr())) {
			if (controleGEDDTO != null) {
				try {
					String caminho = getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED()));

					final File arquivo = new File(caminho.concat(".").concat(Util.getFileExtension(uploadDTO.getNameFile())));

					CriptoUtils.encryptFile(uploadDTO.getPath(), caminho.concat(EXTENSAO_GED), ((String) System.getProperties().get("user.dir")).concat(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));

					arquivo.delete();
				} catch (ClassNotFoundException | IOException | GeneralSecurityException e) {
					e.printStackTrace();
				}
			}
		}

	}

	private void salvarSetarControleGED(final UploadDTO uploadDTO, ControleGEDDTO controleGEDDTO) throws PersistenceException {
		controleGEDDTO = (ControleGEDDTO) getControleGEDDao().create(controleGEDDTO);
		uploadDTO.setIdControleGED(controleGEDDTO.getIdControleGED());
	}

	private void definirPathArquivo(final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) {
		if (SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInterno().trim()) && SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInternoBD().trim())) {
			controleGEDDTO.setPathArquivo(uploadDTO.getPath());
		} else {
			controleGEDDTO.setPathArquivo(null);
		}
	}

	private String definirDiretorioGed(final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO) throws Exception {
		String pasta = "";

		if (getGedInterno().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
			pasta = getControleGEDDao().getProximaPastaArmazenar();

			File fileDir = new File(getGedDiretorio());
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(pasta));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
		}

		return pasta;
	}

	private void definirControleGED(final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO, final String pasta, final UploadDTO uploadDTO, final ControleGEDDTO controleGEDDTO) {
		controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_SERVICO_NEGOCIO);
		controleGEDDTO.setId(servicoNegocioDTO.getIdServico());
		controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
		controleGEDDTO.setDescricaoArquivo(uploadDTO.getDescricao());
		controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDTO.getNameFile()));
		controleGEDDTO.setPasta(pasta);
		controleGEDDTO.setNomeArquivo(uploadDTO.getNameFile());
	}

	@Override
	public String recuperaTipoServico(Integer idServico) throws Exception {
		ServicoDTO servico = findById(idServico);
		return servico.getTipoServico();
	}

	@Override
	public Collection<ServicoDTO> findAutocompleteServicoNegocioTecnico(Integer idContrato, String tipoServicoNegocioTecnico, String queryConsulta) throws Exception {
		return this.findAutocompleteServicoNegocioTecnico(idContrato, tipoServicoNegocioTecnico, queryConsulta, null);
	}

	@Override
	public Collection<ServicoDTO> findAutocompleteServicoNegocioTecnico(Integer idContrato, String tipoServicoNegocioTecnico, String queryConsulta, final Integer idCategoriaServicoNegocio) throws Exception {
		return this.getDao().findAutocompleteServicoNegocioTecnico(idContrato, tipoServicoNegocioTecnico, queryConsulta, idCategoriaServicoNegocio);
	}

	@Override
	public ServicoDTO recuperaServicoRelacionado(Integer idContrato, Integer idServico) throws PersistenceException {
		return this.getDao().recuperaServicoRelacionado(idContrato, idServico);
	}

	@Override
	public List<ServicoDTO> listServicoRelacionadoByItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().listServicoRelacionadoByItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public Collection findByNomeAndContratoAndTipoDemandaAndCategoria(Integer idTipoDemanda, Integer idContrato, Integer idCategoria, String nome) throws Exception {
		return this.getDao().findByNomeAndContratoAndTipoDemandaAndCategoria(idTipoDemanda, idContrato, idCategoria, nome);
	}

	@Override
	public String getUrlInformacoesComplementares(ServicoDTO servicoDto) throws Exception {
		String url = "";

		TemplateServicoDTO templateDto = new TemplateServicoServiceEjb().findById(servicoDto.getIdTemplateServico());
		if (templateDto != null) {
			url = Constantes.getValue("CONTEXTO_APLICACAO");
			if (templateDto.isQuestionario()) {
				ServicoQuestionarioDTO servicoQuestionarioDto = null;
				if (servicoDto.getIdServico() != null) {
					servicoQuestionarioDto = new ServicoQuestionarioDao().findByIdServico(servicoDto.getIdServico());
				}

				url += "/pages/visualizacaoQuestionario/visualizacaoQuestionario.load?tabela100=true";

				if (servicoQuestionarioDto != null && servicoQuestionarioDto.getIdServicoQuestionario() != null) {
					url += "&idQuestionario=" + servicoQuestionarioDto.getIdQuestionario();
					url += "&idIdentificadorResposta=" + servicoQuestionarioDto.getIdServicoQuestionario();
					if (servicoQuestionarioDto.getSituacao().equalsIgnoreCase("F")) {
						url += "&modo=somenteleitura";
					} else {
						url += "&modo=edicao";
					}
				} else {
					url += "&idQuestionarioOrigem=" + templateDto.getIdQuestionario();
					url += "&modo=edicao";
				}
			} else {
				url += templateDto.getUrlRecuperacao();
			}
			if (servicoDto.getIdServico() != null && servicoDto.getIdServico().intValue() > 0) {
				url += "&idServico=" + servicoDto.getIdServico();
			}
			url += "&editar=S";
		}
		return url;
	}

	@Override
	public void deserializaInformacoesComplementares(ServicoDTO servicoDto, ServicoQuestionarioDTO servicoQuestionarioDTO) throws Exception {
		if (servicoDto.getInformacoesComplementares_serialize() != null) {
			TemplateServicoDTO templateDto = new TemplateServicoServiceEjb().findById(servicoDto.getIdTemplateServico());
			if (templateDto != null) {
				if (templateDto.isQuestionario()) {
					servicoDto.setServicoQuestionarioDTO(servicoQuestionarioDTO);
				} else if (templateDto.getNomeClasseServico() != null) {
					ComplemInfServicoService informacoesComplementaresService = getInformacoesComplementaresService(templateDto.getNomeClasseServico());
					IDto informacoesComplementares = informacoesComplementaresService.deserializaObjeto(servicoDto.getInformacoesComplementares_serialize());
					servicoDto.setInformacoesComplementares(informacoesComplementares);
				}
			}
			servicoDto.setInformacoesComplementares_serialize(null);
		}
	}

	@Override
	public Collection<ServicoDTO> listServicosCombo(ServicoDTO dto) throws PersistenceException {
		return getDao().listServicosCombo(dto);
	}

	@Override
	public Collection<ServicoDTO> listServicosPorFuncaoVital(Integer idFuncaoVital) throws PersistenceException {
		return this.getDao().listServicosPorFuncaoVital(idFuncaoVital);
	}

	@Override
	public Collection<ServicoDTO> getServicosImpactadosByIdItemConfiguracao(Integer idItemConfiguracao) throws PersistenceException {
		return this.getDao().getServicosImpactadosByIdItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public ArvoreServico getHieraquiaServicoApoioImpactado(Integer idServicoApoio) throws Exception {
		return this.getDao().getHieraquiaServicoApoioImpactado(idServicoApoio);
	}

	private ServicoQuestionarioService getServicoQuestionarioService() throws ServiceException {
		if (servicoQuestionarioService == null) {
			servicoQuestionarioService = (ServicoQuestionarioService) ServiceLocator.getInstance().getService(ServicoQuestionarioService.class, null);
		}
		return servicoQuestionarioService;
	}

	@Override
	public boolean isServicoEmProducao(Integer idServico) throws Exception {
		return this.getDao().isServicoEmProducao(idServico);
	}

	@Override
	public boolean existeQuestionarioServico(Integer idServico) throws PersistenceException {
		return this.getDao().existeQuestionarioServico(idServico);
	}

	@Override
	public Integer obterIdQuestionarioServico(Integer idServico) {
		return this.getDao().obterIdQuestionarioServico(idServico);
	}
}
