package br.com.centralit.citcorpore.negocio;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import br.com.centralit.citcorpore.integracao.SmartDecisionsDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

public class SmartDecisionsServiceEjb extends CrudServiceImpl implements SmartDecisionsService {

	private static final long serialVersionUID = 691866409981469644L;

	private SmartDecisionsDAO dao;

	@Override
	protected SmartDecisionsDAO getDao() {
		if (dao == null) {
			dao = new SmartDecisionsDAO();
		}
		return dao;
	}

	@Override
	public Map<String, HashMap<Integer, Integer>> dashboardProcessos(String month, String year) throws ServiceException, Exception {
		return this.getDao().dashboardProcessos(month, year);
	}

	@Override
	public List<Object[]> solicitacoesPorServico(Date dataInicio, Date dataFim, Integer idServicoNegocio) throws ServiceException, Exception {
		return this.getDao().solicitacoesPorServico(dataInicio, dataFim, idServicoNegocio);
	}

	@Override
	public List<Object[]> itensConfiguracaoSoftwares(String periodo, String palavraChave) throws ServiceException, Exception {
		return this.getDao().itensConfiguracaoSoftwares(periodo, palavraChave);
	}

}
