package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.SmartReportGrupoDTO;
import br.com.centralit.citcorpore.integracao.GrupoDao;
import br.com.centralit.citcorpore.integracao.SmartReportGrupoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class SmartReportGrupoServiceEjb extends CrudServiceImpl implements SmartReportGrupoService {

	private SmartReportGrupoDAO dao;

	@Override
	protected SmartReportGrupoDAO getDao() {
		if (this.dao == null) {
			this.dao = new SmartReportGrupoDAO();
		}
		return this.dao;
	}

	@Override
	public Collection<GrupoDTO> findGruposByIdSmartReport(final Integer idSmartReport) throws Exception {
		try {
			Collection<SmartReportGrupoDTO> listaIds = this.getDao().findIdsGruposByIdSmartReport(idSmartReport);
			Collection<GrupoDTO> lista = new ArrayList<GrupoDTO>();
			GrupoDao grupoDao = new GrupoDao();
			if (listaIds != null && !listaIds.isEmpty()) {
				for (SmartReportGrupoDTO dto : listaIds) {
					lista.add(grupoDao.listGrupoById(dto.getIdGrupo()));
				}
			}
			return lista;
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void deleteAllGruposByIdSmartReport(final Integer idSmartReport) throws Exception {
		try {
			this.getDao().deleteAllGruposByIdSmartReport(idSmartReport);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

}
