package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citgerencial.bean.SmartReportParameterOptionDTO;
import br.com.centralit.citgerencial.bean.SmartReportParameterOptionsDTO;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

public interface SmartReportService extends CrudService {

	List execSQL(SmartReportDTO smartReportDTO) throws Exception;

	List<Map<String, Object>> executeQuery(SmartReportDTO smartReportDTO, Object[] parametros) throws Exception;

	List<String> getResultColumns(SmartReportDTO smartReportDTO, Object[] parametros) throws Exception;

	List<SmartReportDTO> findAtivos() throws Exception;

	List<SmartReportDTO> findByIdsGrupoUsuarioAndIdCategoria(Collection<GrupoDTO> gruposUsuario, Integer idCategoria) throws Exception;

	public Integer getTotalByIdsGrupoUsuarioAndIdCategoria(Collection<GrupoDTO> gruposUsuario, Integer idCategoria) throws Exception;

	Collection<SmartReportParameterOptionDTO> findParametroOptions(SmartReportParameterOptionsDTO options) throws Exception;

	Collection<SmartReportDTO> findByIdentificacao(String consulta) throws Exception;

	SmartReportDTO getByIdentificacao(String identificacao) throws Exception;

	Page<SmartReportDTO> findPaged(String filter, Pageable pageable, boolean isTotalizacao) throws Exception;

	List<SmartReportDTO> findByIdsGrupoUsuarioAndTipoModuloExibicao(Collection<GrupoDTO> gruposUsuario, String tipoExibicao, String moduloExibicao) throws Exception;

	List<SmartReportDTO> findAvailablesByUsuario(UsuarioDTO usuarioDTO) throws Exception;
}
