package br.com.centralit.citcorpore.negocio;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.bpm.dto.AtribuicaoFluxoDTO;
import br.com.centralit.bpm.dto.FluxoDTO;
import br.com.centralit.bpm.dto.ItemTrabalhoFluxoDTO;
import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.bpm.negocio.ItemTrabalho;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.RelatorioQuantitativoSubRelatorioDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.CtrlTelefoniaDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoServicosDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.PesquisaSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeDTO;
import br.com.centralit.citcorpore.bean.RelatorioCausaSolucaoDTO;
import br.com.centralit.citcorpore.bean.RelatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodoDTO;
import br.com.centralit.citcorpore.bean.RelatorioEficaciaTesteDTO;
import br.com.centralit.citcorpore.bean.RelatorioIncidenteRequisicaoPorServicoDTO;
import br.com.centralit.citcorpore.bean.RelatorioIncidentesNaoResolvidosDTO;
import br.com.centralit.citcorpore.bean.RelatorioKpiProdutividadeDTO;
import br.com.centralit.citcorpore.bean.RelatorioQuantitativoRetornoDTO;
import br.com.centralit.citcorpore.bean.RelatorioQuantitativoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO;
import br.com.centralit.citcorpore.bean.RelatorioSolicitacaoPorExecutanteDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoQuestionarioDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.util.Enumerados.TipoSolicitacaoServico;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

@SuppressWarnings({"rawtypes", "unchecked" })
public interface SolicitacaoServicoService extends CrudService {

    void deserializaInformacoesComplementares(final SolicitacaoServicoDTO solicitacaoServicoDto, final SolicitacaoServicoQuestionarioDTO solQuestionarioDto) throws Exception;

    void encerra(final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    /**
	 * Retorna Solicitaes de Servio associados ao conhecimento informado.
	 *
	 * @param baseConhecimentoDto
	 * @return Collection
	 * @throws ServiceException
	 * @throws LogicException
	 * @author Vadoilo Damasceno
	 */
    Collection findByConhecimento(final BaseConhecimentoDTO baseConhecimentoDto) throws ServiceException, LogicException;

    Collection findByIdSolictacaoServico(final Integer parm) throws ServiceException, LogicException;

    Collection<SolicitacaoServicoDTO> findByServico(final Integer idServico) throws Exception;

    Collection<SolicitacaoServicoDTO> findSolicitacoesNaoResolvidasNoPrazoKPI(final RelatorioIncidentesNaoResolvidosDTO relatorioIncidentesNaoResolvidosDTO) throws Exception;

    Collection<SolicitacaoServicoDTO> findByServico(final Integer idServico, final String nome) throws Exception;

    List<SolicitacaoServicoDTO> findSolicitacoesServicosUsuario(final Integer idUsuario, final Integer idItemConfiguracao);

    Collection<SolicitacaoServicoDTO> getHistoricoByIdSolicitacao(final Integer idSolicitacao) throws Exception;

    ItemTrabalho getItemTrabalho(final Integer idItemTrabalho) throws Exception;

    Integer getQuantidadeByIdServico(final int idServico) throws Exception;

    Integer getQuantidadeByIdServicoContrato(final int idServicoContrato) throws Exception;

    String getUrlInformacoesComplementares(final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    void gravaInformacoesGED(final Collection colArquivosUpload, final int idEmpresa, final SolicitacaoServicoDTO solicitacaoServicoDto, final TransactionControler tc)
            throws Exception;

    Collection<SolicitacaoServicoDTO> listAll() throws Exception;

    Collection<SolicitacaoServicoDTO> listAllIncidentes(final Integer idUsuario) throws Exception;

    Collection<SolicitacaoServicoDTO> listAllServicos() throws Exception;

    Collection<SolicitacaoServicoDTO> listAllServicosLikeNomeServico(final String nome) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por fase
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorFase(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por
	 * grupoSolucionador.
	 *
	 * @return
	 * @throws Exception
	 * @author Thays.araujo
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorGrupo(final HttpServletRequest request, final SolicitacaoServicoDTO solicitacaoDto)
            throws Exception;

    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorHoraAbertura(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por Item
	 * Configurao.
	 *
	 * @return
	 * @throws Exception
	 * @author Thays.araujo
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorItemConfiguracao(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por Origem
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorOrigem(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorPesquisaSatisfacao(final HttpServletRequest request, final SolicitacaoServicoDTO solicitacaoDto)
            throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por prioridade
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorPrioridade(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorResponsavel(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por servio
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
	Collection<RelatorioQuantitativoSolicitacaoDTO> listaQuantidadeSolicitacaoPorServico(
			final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    /**
	 * Metodo retornar os servios aprovados e abertos
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
    Collection<RelatorioQuantitativoSolicitacaoDTO> listaServicosAbertosAprovados(final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por situao
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorSituacao(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    Collection<RelatorioQuantitativoSolicitacaoDTO> listaQuantidadeSolicitacaoPorSituacaoSLA(final HttpServletRequest request, final SolicitacaoServicoDTO solicitacaoDto)
            throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por
	 * solicitante.
	 *
	 * @return
	 * @throws Exception
	 * @author Thays.araujo
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorSolicitante(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    /**
	 * Metodo retornar uma lista com a quantidade de solicitao por tipo
	 *
	 * @param solicitacaoDto
	 * @return
	 * @throws Exception
	 */
    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorTipo(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorTipoServico(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    String listaServico(final Integer idSolicitacaoservico) throws PersistenceException, Exception;

    /**
     * Retorna uma lista de idSolicitacaoServico
     *
     * @param solicitacao
     * @return
     * @throws Exception
     */
    Collection<SolicitacaoServicoDTO> listaSolicitacaoPorBaseConhecimento(final SolicitacaoServicoDTO solicitacao) throws Exception;

    /**
	 * Retorna Solicitaes servio de acordo com os criterios passados
	 *
	 * @param pesquisaSolicitacaoServicoDto
	 * @return
	 * @throws Exception
	 * @author thays.araujo
	 */
    Collection<SolicitacaoServicoDTO> listPesquisaAvancadaRelatorioDetalhado(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto) throws Exception;

    Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriteriosPaginado(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, final String paginacao,
            final Integer pagAtual, final Integer pagAtualAux, final Integer totalPag, final Integer quantidadePaginator, final String campoPesquisa) throws Exception;

    Collection listaSolicitacoesSemPesquisaSatisfacao() throws Exception;

    SolicitacaoServicoDTO listIdentificacao(final Integer idItemConfiguracao) throws Exception;

    Collection<SolicitacaoServicoDTO> listIncidentesNaoFinalizados() throws Exception;

    SolicitacaoServicoDTO listInformacaoContato(final String nomeContato) throws Exception;;

    /**
	 * Retorna Solicita��es de Servios de acordo com o Tipo de Demanda e
	 * Usu�rio.
	 *
	 * @param tipoDemandaServico
	 * @param grupoSeguranca
	 * @param usuario
	 * @return
	 * @throws Exception
	 */
    Collection<SolicitacaoServicoDTO> listSolicitacaoServico(final String tipoDemandaServico, final GrupoDTO grupoSeguranca, final UsuarioDTO usuario, final Date dataInicio,
            final Date dataFim, final Integer idStatus) throws Exception;

    Collection<SolicitacaoServicoDTO> listSolicitacaoServicoByCriterios(final Collection colCriterios) throws Exception;

    List<SolicitacaoServicoDTO> listSolicitacaoServicoByItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

	List<SolicitacaoServicoDTO> listIncidentesByItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

	List<SolicitacaoServicoDTO> listSolicitacoesByItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

	Integer listQuantidadeIncidentesByItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

	Integer listQuantidadeSolicitacoesByItemConfiguracao(final Integer idItemConfiguracao) throws Exception;

    Collection<SolicitacaoServicoDTO> listSolicitacaoServicoEmAndamento(final Integer idSolicitacaoServico);

    Collection<SolicitacaoServicoDTO> listSolicitacaoServicoNaoFinalizadas() throws Exception;

    Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionada(final int idSolicitacaoPai);

    Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionadaPai(final int idSolicitacaoPai);

    Collection<SolicitacaoServicoDTO> listSolicitacoesFilhas() throws Exception;

    /**
     * Retorna quantidade
     *
     * @param solicitacao
     * @return Integer
     * @throws Exception
     * @author Thays
     */
    Collection<SolicitacaoServicoDTO> quantidadeSolicitacaoPorBaseConhecimento(final SolicitacaoServicoDTO solicitacao) throws Exception;

    void reabre(final UsuarioDTO usuarioDto, final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    void reativa(final UsuarioDTO usuarioDto, final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    FluxoDTO recuperaFluxo(final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    Collection<SolicitacaoServicoDTO> relatorioControleSla(final SolicitacaoServicoDTO solicitacao) throws Exception;

    SolicitacaoServicoDTO restoreAll(final Integer idSolicitacaoServico) throws Exception;

    SolicitacaoServicoDTO restoreAll(final Integer idSolicitacaoServico, final TransactionControler tc) throws Exception;

    /**
	 * Retorna SolicitacaoServico com Item de Configura��o do Solicitante.
	 *
	 * @param login
	 * @return SolicitacaoServicoDTO
	 * @throws Exception
	 */
    SolicitacaoServicoDTO retornaSolicitacaoServicoComItemConfiguracaoDoSolicitante(final String login) throws Exception;

    void suspende(final UsuarioDTO usuarioDto, final SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

    boolean temSolicitacaoServicoAbertaDoEmpregado(final Integer idEmpregado);

    IDto updateInfo(final IDto model) throws ServiceException, LogicException;

    IDto updateInfoCollection(final IDto model) throws ServiceException, LogicException;

    void updateNotNull(final IDto obj) throws Exception;

    void updateNotNull(final IDto obj, final TransactionControler tc) throws Exception;

    void updateSLA(final IDto model) throws ServiceException, LogicException;

    void updateSolicitacaoPai(final int idSolicitacaoPai, final int idSolicitacao);

    /**
     * Retornar verdadeiro ou falso
     *
     * @param idUnidade
     * @return
     * @throws Exception
     * @author thays.araujo
     */
    boolean verificarExistenciaDeUnidade(final Integer idUnidade) throws Exception;

    /**
	 * Verifica se solicitao servio possui Solicitao Filho.
	 *
	 * @param idSolicitacaoServico
	 * @return true = possui; false = no possui.
	 * @throws Exception
	 */
    boolean verificarExistenciaSolicitacaoFilho(final Integer idSolicitacaoServico) throws Exception;

    SolicitacaoServicoDTO verificaSituacaoSLA(final SolicitacaoServicoDTO solicitacaoDto) throws Exception;

    Collection incidentesPorContrato(final Integer idContrato) throws Exception;

    Collection<SolicitacaoServicoDTO> listarSLA() throws Exception;

    Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorServicoContrato(final Integer idServicoContratoContabil) throws Exception;

    String calculaSLA(final SolicitacaoServicoDTO solicitacaoServicoDto, final HttpServletRequest request) throws Exception;

    SolicitacaoServicoDTO findByIdSolicitacaoServico(final Integer idSolicitacaoServico) throws Exception;

    /**
	 * Retorna uma lista de solicitacao servio de acordo com os parametro
	 * passados com o principal objetivo de trazer somente solicitaes fechadas
	 * ou canceladas.
	 *
	 * @param relatorioSolicitacaoPorSolucionarDto
	 * @return Collection
	 * @throws Exception
	 * @author thays.araujo
	 */
    Collection<RelatorioSolicitacaoPorExecutanteDTO> listaSolicitacaoPorExecutante(final RelatorioSolicitacaoPorExecutanteDTO relatorioSolicitacaoPorExecutanteDto)
            throws Exception;

    Collection<RelatorioCausaSolucaoDTO> listaCausaSolicitacao(final RelatorioCausaSolucaoDTO relatorioCausaSolicitacao) throws Exception;

    Collection<RelatorioCausaSolucaoDTO> listaSolucaoSolicitacao(final RelatorioCausaSolucaoDTO relatorioCausaSolicitacao) throws Exception;

    Collection<RelatorioCausaSolucaoDTO> listaCausaSolucaoAnalitico(final RelatorioCausaSolucaoDTO relatorioCausaSolicitacao) throws Exception;

    /**
	 * Retorna uma lista de Servios que estejam associada a uma solicitao
	 * servio.
	 *
	 * @param relatorioAnaliseServicoDto
	 * @return Collection<RelatorioAnaliseServicoDTO>
	 * @throws Exception
	 * @author thays.araujo
	 */
    Collection<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO> listaServicoPorSolicitacaoServico(
            final RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO relatorioAnaliseServicoDto) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupo(final Integer idGrupo) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataBaixa(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataMedia(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAlta(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataTotal(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasBaixa(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasMedia(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasAlta(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataSuspensasTotal(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdPessoaEDataAtendidas(final Integer idGrupo, final String login, final String nome, final Date dataInicio, final Date dataFim)
            throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdPessoaEData(final Integer idGrupo, final String login, final String nome, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdPessoaEDataNaoAtendidas(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<RelatorioQuantitativoRetornoDTO> listaServicosRetorno(final SolicitacaoServicoDTO solicitacaoServicoDTO, final String grupoRetorno) throws Exception;

    Collection<RelatorioQuantitativoRetornoDTO> listaServicosRetornoNomeResponsavel(final RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception;

    SolicitacaoServicoDTO listaIdItemTrabalho(final Integer idInstancia) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasTotal(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtrasadasTotal(final Integer idGrupo, final Date dataInicio, final Date dataFim) throws Exception;

    IDto create(final IDto model, final TransactionControler tc, final boolean determinaPrioridadePrazo, final boolean determinaHoraInicio,
            final boolean determinaDataHoraSolicitacao) throws Exception;

    Collection<SolicitacaoServicoDTO> listaSolicitacoesPorIdEmpregado(final Integer pgAtual, final Integer qtdPaginacao, final GerenciamentoServicosDTO gerenciamentoBean,
            final Collection<ContratoDTO> listContratoUsuarioLogado) throws Exception;

	Map<String, Integer> resumoTipoDemandaServico(final List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception;

    RelatorioQuantitativoRetornoDTO servicoRetorno(final RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception;

    boolean validaQuantidadeRetorno(final RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception;

    RelatorioQuantitativoRetornoDTO retornarIdEncerramento(final String encerramento, final RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception;

    /**
     * @param solicitacaoServicoDTO
     * @return Retorna Solicitacao com porcentagem de sla no prazo fora do prazo com referencia a prioridade
     * @throws Exception
     * @author maycon.fernandes
     */
    SolicitacaoServicoDTO relatorioControlePercentualQuantitativoSla(final SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception;

    boolean confirmaEncerramento(final RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO, final Integer idElemento) throws Exception;

    Collection<SolicitacaoServicoDTO> findByCodigoExterno(final String codigoExterno) throws Exception;

    SolicitacaoServicoDTO restoreByIdInstanciaFluxo(final Integer idInstanciaFluxo) throws Exception;

    Collection<SolicitacaoServicoDTO> listByTarefas(final Collection<TarefaFluxoDTO> listTarefas, final TipoSolicitacaoServico[] tiposSolicitacao) throws Exception;

	Collection<PrioridadeDTO> resumoPrioridade(final List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception;

	HashMap resumoPorPrazoLimite(final List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception;

	HashMap resumoPorSituacao(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception;

    ComplemInfSolicitacaoServicoService getInformacoesComplementaresService(final ItemTrabalho itemTrabalho) throws Exception;

    boolean existeSolicitacaoServico(final SolicitacaoServicoDTO solicitacaoservico) throws Exception;

    boolean permissaoGrupoExecutorServico(final int idGrupoExecutor, final int idTipoFluxoSolicitacaoServico) throws Exception;

    Collection<SolicitacaoServicoDTO> listarSolicitacoesAbertasEmAndamentoPorGrupo(final int idGrupoAtual, final String situacaoSla) throws Exception;

    Collection<SolicitacaoServicoDTO> listarSolicitacoesMultadasSuspensasPorGrupo(final int idGrupoAtual, final String situacaoSla) throws Exception;

    Collection<SolicitacaoServicoDTO> listaServicosPorResponsavelNoPeriodo(final RelatorioKpiProdutividadeDTO relatorioKpiProdutividadeDTO) throws Exception;

    Collection<SolicitacaoServicoDTO> listaServicosPorSolicitanteNoPeriodoEnviadosAoteste(final Date dataIncio, final Date dataFim, final int idFuncionario,
            final boolean mostrarIncidentes, final boolean mostrarRequisicoes) throws Exception;

    Collection<SolicitacaoServicoDTO> listaServicosPorAbertosParaDocumentacao(final Date dataIncio, final Date dataFim, final boolean mostrarIncidentes,
            final boolean mostrarRequisicoes) throws Exception;

    Collection<SolicitacaoServicoDTO> listaServicosPorResponsavelNoPeriodoDocumentacao(final Date dataIncio, final Date dataFim, final int idFuncionario,
            final boolean mostrarIncidentes, final boolean mostrarRequisicoes) throws Exception;

    Collection<SolicitacaoServicoDTO> listaServicosPorResponsavelNoPeriodoDocumentacaoPorServico(final Date dataIncio, final Date dataFim, final int idFuncionario,
            final boolean mostrarIncidentes, final boolean mostrarRequisicoes, final String listaIdsServicosHomologacaoDocumentacao) throws Exception;

    Collection<SolicitacaoServicoDTO> listaServicosPorAbertosPelotesteParaValidacao(final Date dataIncio, final Date dataFim, final boolean mostrarIncidentes,
            final boolean mostrarRequisicoes) throws Exception;

    SolicitacaoServicoDTO buscarNumeroItemTrabalhoPorNumeroSolicitacao(final int idSolicitacao) throws Exception;

    Collection<RelatorioEficaciaTesteDTO> listaSolicitacaoPorServicosAbertosNoPerido(final Date dataIncio, final Date dataFim, final List<ServicoDTO> listaServicos)
            throws Exception;

    Collection<RelatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodoDTO> listaQtdSolicitacoesCanceladasFinalizadasporServicoNoPeriodo(final Date dataIncio,
            final Date dataFim, final List<ServicoDTO> listaServicos) throws Exception;

    /**
	 * lista com os quantitativos por empregado de solicitaes servios
	 * emcaminhadas e foram concluidas com exito.
	 *
	 * @param relatorioKpiProdutividadeDto
	 * @return
	 * @throws Exception
	 * @author thays.araujo
	 */
    Collection<RelatorioKpiProdutividadeDTO> listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito(final RelatorioKpiProdutividadeDTO relatorioKpiProdutividadeDto) throws Exception;

    Collection<SolicitacaoServicoDTO> findSolicitacoesNaoResolvidasEntrePrazoKPI(final RelatorioIncidentesNaoResolvidosDTO relatorioIncidentesNaoResolvidosDTO) throws Exception;

    boolean verificaPermGestorSolicitanteRH(final Integer idSolicitante) throws PersistenceException;

    Collection<SolicitacaoServicoDTO> listSolicitacoesFilhasFiltradas(final GerenciamentoServicosDTO gerenciamentoBean, final Collection<ContratoDTO> listContratoUsuarioLogado)
            throws Exception;

    Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriteriosPaginado(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, final String paginacao,
            final Integer pagAtual, final Integer pagAtualAux, final Integer totalPag, final Integer quantidadePaginator, final String campoPesquisa,
            final Collection<UnidadeDTO> unidadesColaborador) throws Exception;

    /**
	 * Mtodo para listar nmero de solicitaes fora do perodo fornecido pelo
	 * usurio
	 *
	 * @param relatorioIncidentesNaoResolvidosDTO
	 * @return
	 * @throws PersistenceException
	 * @throws ServiceException
	 * @author thyen.chang
	 * @throws LogicException
	 * @throws Exception
	 */
    Integer numeroSolicitacoesForaPeriodo(final RelatorioIncidentesNaoResolvidosDTO relatorioIncidentesNaoResolvidosDTO) throws PersistenceException, ServiceException;

    /**
     * @author thyen.chang
     */
    Long listaRelatorioGetQuantidadeRegistros(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, final boolean isDetalhado) throws ParseException,
            PersistenceException, ServiceException, LogicException, Exception;

    List<SolicitacaoServicoDTO> listPesquisaAvancadaPaginada(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDTO, final Integer paginaAtual,
            final Integer quantidadePorPagina) throws Exception;

    List<SolicitacaoServicoDTO> listPesquisaAvancadaRelatorio(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDTO) throws Exception;

    void determinaPrazoLimite(final SolicitacaoServicoDTO solicitacao, final Integer idCalendario, final TransactionControler tc) throws Exception;

	@Override
	IDto create(IDto model) throws ServiceException, LogicException;

    public ItemTrabalhoFluxoDTO restauraItemTrabalhoFluxoAtualDaSolicitacao(Integer idSolicitcaoServico);

	public Collection<AtribuicaoFluxoDTO> findTarefasDisponiveis(SolicitacaoServicoDTO solicitacao, TransactionControler tc) throws Exception;

	public SolicitacaoServicoDTO updateInfo(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc, boolean atualizarRelacionados) throws Exception;

    String calculaSLAMultinivel(final SolicitacaoServicoDTO solicitacaoServicoDto, DocumentHTML document, final HttpServletRequest request) throws Exception;

	public Collection<RelatorioIncidenteRequisicaoPorServicoDTO> listaRelatorioQuantitativoServicoCatalogo(
			RelatorioIncidenteRequisicaoPorServicoDTO dto) throws ParseException, PersistenceException;

	public Collection<SolicitacaoServicoDTO> consultarIncidentesMajorAbertosEAprovados(Integer idUsuario, Integer idContinuidade);

	public Collection<SolicitacaoServicoDTO> consultarProcedimentosRelacionadosAoIncidenteMajor(Integer idUsuario);

	public Collection<SolicitacaoServicoDTO> consultarSeProcedimentosEstaCriadoParaIncidenteMajor(SolicitacaoServicoDTO solicitacaoServicoDTO)throws PersistenceException;

    /**
	 * Retorna as solicitaes relacionadas ao @param e do tipo da demanda procedimento
	 *
	 * @param solicitacaoServicoPai
	 * @return lista de solicitacoes relacionadas somente com o id preenchido
	 */
	public Collection<SolicitacaoServicoDTO> consultarProcedimentosRelacionadosAoIncidenteMajor(SolicitacaoServicoDTO solicitacaoServicoDTO);

	public Collection<SolicitacaoServicoDTO> consultarProcedimentosRelacionadosAoIncidenteMajor(SolicitacaoServicoDTO solicitacaoServicoDTO, Integer idUsuario);

	public Collection<SolicitacaoServicoDTO> createList(Collection<SolicitacaoServicoDTO> models) throws ServiceException, LogicException;

	public SolicitacaoServicoDTO consultarSolicitacaoServico(Integer idSolicitacao);

	public String calculaTempoRestante(Timestamp dataHoraLimite, Integer idCalendario) throws Exception;

	Long retornaQtdeSolicitacoesDoSolicitante(final Integer idEmpregado) throws Exception;

	Page<SolicitacaoServicoDTO> findSolicitacoesSolicitante(Integer idEmpregado, Integer idStatus, String campoBusca, Pageable pageable, Boolean isTotalizacao) throws Exception;

	public SolicitacaoServicoDTO restoreSolicitacaoServicoWithIdTarefa(final Integer idSolicitacaoServico) throws Exception;

	/**
	 *
	 * Realiza a pesquisa da tela do portal com todos os filtros e opcoes de ordenacao
	 *
	 * @author gilberto.nery
	 *
	 * @param pgAtual
	 * @param qtdPaginacao
	 * @param gerenciamentoBean
	 * @param vinculaColaboradorContrato
	 * @return
	 * @throws Exception
	 */
	public Collection<SolicitacaoServicoDTO> listaSolicitacoesDoPortal(Integer pgAtual, Integer qtdPaginacao, GerenciamentoServicosDTO gerenciamentoBean, String vinculaColaboradorContrato) throws Exception;

	/**
	 * Realiza a paginacao na tela do portal de servicos
	 *
	 * @author gilberto.nery
	 *
	 * @param gerenciamentoBean
	 * @param pageable
	 * @param vinculaColaboradorContrato
	 * @return
	 * @throws Exception
	 */
	public Page<SolicitacaoServicoDTO> paginacaoPortal(GerenciamentoServicosDTO gerenciamentoBean, Pageable pageable,
			String vinculaColaboradorContrato) throws Exception;

	/**
	 * Seta o idCalendario na solicitao de servio quando o mesmo no estiver alimentado.
	 *
	 * @author euler.ramos
	 *
	 * @param solicitacaoServicoDto
	 * @throws Exception
	 */
	public void determinaCalendario(SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception;

	void determinaPrazoLimite(SolicitacaoServicoDTO solicitacaoDto, TransactionControler tc) throws Exception;

	/**
	 * Quantidade de solicitaes de servio EmAndamento do solicitante encontrado pelo CPF;
	 *
	 * @param cpf
	 * @return
	 * @throws Exception
	 *
	 * @author gilberto.nery
	 */
	public Long getQtdSolicitacoesEmAndamentoPorCpf(String cpf) throws Exception;

	/**
	 * Exibe uma solicitao de servio pelo ID da solicitao e o CPF do solicitante
	 *
	 * @param idSolicitacaoServico
	 * @param cpf
	 * @return
	 * @throws Exception
	 */
	public SolicitacaoServicoDTO getSolicitacaoDeServicoEmAndamentoPorCpf(Integer idSolicitacaoServico, String cpf) throws Exception;

	/**
	 * Retorna os itens de trabalho abertos e que o usurio tem permisso para execuo.
	 *
	 * @param idSolicitacaoServico
	 * @param idUsuario
	 * @author euler.ramos
	 * @since 14.06.2013
	 */
	public ArrayList<CtrlTelefoniaDTO> obterItensTrabalhoParaExecucaoSolicitacaoServico(Integer idSolicitacaoServico, Integer idUsuario) throws PersistenceException;

	/**
	 * Retorna os itens de trabalho que o usurio tem permisso para visualizao.
	 *
	 * @param idSolicitacaoServico
	 * @param idUsuario
	 * @author euler.ramos
	 * @since 14.06.2013
	 */
	public ArrayList<CtrlTelefoniaDTO> obterItensTrabalhoParaVisualizacaoSolicitacaoServico(Integer idSolicitacaoServico, Integer idUsuario) throws PersistenceException;

	/**
	 * Retorna as solicitaes de servio EmAndamento do solicitante que possui o CPF passado como parmetro
	 *
	 * @param cpf
	 * @author euler.ramos
	 * @throws PersistenceException
	 * @throws ServiceException
	 * @since 21.06.2013
	 */
	public ArrayList<SolicitacaoServicoDTO> obterSolicitacoesDeServicoEmAndamentoPorCpf(String cpf) throws PersistenceException, ServiceException;

	/**
	 * Verififica se o contrato possui solicitaes em andamento vinculados
	 *
	 * @author gilmar.junior
	 * @since 08.08.2016
	 */
	public boolean verificaContSolAndamento (Integer idContrato)throws Exception;

	/**
	 * Recupera as solicitaes de servio a partir do usurio e seus grupos.
	 *
	 * @author douglas.japiassu
	 * @since 12.08.2016
	 */
	public List<SolicitacaoServicoDTO> recuperaSolicitacoesPorUsuario(UsuarioDTO usuario) throws Exception;

	/**
	 * Recupera as solicitaes de servio a partir do usurio e seus grupos, com o filtro da tela de Gerenciamento de Servios
	 * e os contratos do usurio logado.
	 *
	 * @author douglas.japiassu
	 * @since 12.08.2016
	 */
	public List<SolicitacaoServicoDTO> recuperaSolicitacoesPorUsuarioComFiltro(UsuarioDTO usuario, Collection<ContratoDTO> listContratoUsuarioLogado, GerenciamentoServicosDTO gerenciamentoServicosDTO) throws Exception;


	/**
	 * Atualizar as datas de tempo de atendimento da solicitacao de servico
	 *
	 * @param idSolicitacaoServico
	 * @param prazo - em segundos
	 *
	 * @author gilberto.nery
	 * @since 2016.09.19
	 */
	public void atualizarTemposDeAtendimento(Integer idSolicitacaoServico, double prazo, TransactionControler tc);

	/**
	 * Atualizar o tempo de atraso da solicitacao de servico e a datahoralimiteSla
	 * @param idSolicitacaoServico
	 * @param tempoAtrasoHH
	 * @param tempoAtrasoMM
	 * @param tc
	 */
	public void atualizarDataHoraLimiteETempoDeAtrasoDaSolicitacaoServico(Integer idSolicitacaoServico, double tempoAtraso, Timestamp dataHoraLimiteSla, TransactionControler tc);
	
	/**
	 * Atualizar o tempo de atraso da solicitacao de servico
	 * @param idSolicitacaoServico
	 * @param tempoAtrasoHH
	 * @param tempoAtrasoMM
	 * @param tc
	 */
	public void atualizarTempoDeAtrasoDaSolicitacaoServico(Integer idSolicitacaoServico, double tempoAtraso, TransactionControler tc);
}