/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.google.gson.Gson;

import br.com.centralit.bpm.dto.AtribuicaoFluxoDTO;
import br.com.centralit.bpm.dto.FluxoDTO;
import br.com.centralit.bpm.dto.ItemTrabalhoFluxoDTO;
import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.bpm.dto.TipoFluxoDTO;
import br.com.centralit.bpm.integracao.AtribuicaoFluxoDao;
import br.com.centralit.bpm.integracao.FluxoDao;
import br.com.centralit.bpm.integracao.ItemTrabalhoFluxoDao;
import br.com.centralit.bpm.integracao.TipoFluxoDao;
import br.com.centralit.bpm.negocio.ItemTrabalho;
import br.com.centralit.bpm.negocio.Tarefa;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.RelatorioQuantitativoSubRelatorioDTO;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.CalculoJornadaDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.ContatoSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ControleQuestionariosDTO;
import br.com.centralit.citcorpore.bean.ControleSlaDTO;
import br.com.centralit.citcorpore.bean.CtrlTelefoniaDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.ExecucaoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.FaseServicoDTO;
import br.com.centralit.citcorpore.bean.FluxoServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoServicosDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ItemCfgSolicitacaoServDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.JustificativaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.LiberacaoSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.ModeloEmailDTO;
import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.PesquisaSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeDTO;
import br.com.centralit.citcorpore.bean.PrioridadeServicoUnidadeDTO;
import br.com.centralit.citcorpore.bean.PrioridadeServicoUsuarioDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.RelatorioCausaSolucaoDTO;
import br.com.centralit.citcorpore.bean.RelatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodoDTO;
import br.com.centralit.citcorpore.bean.RelatorioEficaciaTesteDTO;
import br.com.centralit.citcorpore.bean.RelatorioIncidenteRequisicaoPorServicoDTO;
import br.com.centralit.citcorpore.bean.RelatorioIncidentesNaoResolvidosDTO;
import br.com.centralit.citcorpore.bean.RelatorioKpiProdutividadeDTO;
import br.com.centralit.citcorpore.bean.RelatorioQuantitativoRetornoDTO;
import br.com.centralit.citcorpore.bean.RelatorioQuantitativoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO;
import br.com.centralit.citcorpore.bean.RelatorioSolicitacaoPorExecutanteDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoMudancaDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoProblemaDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoQuestionarioDTO;
import br.com.centralit.citcorpore.bean.TemplateSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.TempoAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoEmpregadoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoUnidadeDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.bpm.negocio.ExecucaoSolicitacao;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.AcordoServicoContratoDao;
import br.com.centralit.citcorpore.integracao.BaseConhecimentoDAO;
import br.com.centralit.citcorpore.integracao.ConhecimentoSolicitacaoDao;
import br.com.centralit.citcorpore.integracao.ContatoSolicitacaoServicoDao;
import br.com.centralit.citcorpore.integracao.ContratoDao;
import br.com.centralit.citcorpore.integracao.ControleQuestionariosDao;
import br.com.centralit.citcorpore.integracao.EmpregadoDao;
import br.com.centralit.citcorpore.integracao.ExecucaoSolicitacaoDao;
import br.com.centralit.citcorpore.integracao.FaseServicoDao;
import br.com.centralit.citcorpore.integracao.FluxoServicoDao;
import br.com.centralit.citcorpore.integracao.GrupoDao;
import br.com.centralit.citcorpore.integracao.ItemCfgSolicitacaoServDAO;
import br.com.centralit.citcorpore.integracao.LiberacaoSolicitacaoServicoDAO;
import br.com.centralit.citcorpore.integracao.MatrizPrioridadeDAO;
import br.com.centralit.citcorpore.integracao.ModeloEmailDao;
import br.com.centralit.citcorpore.integracao.OcorrenciaSolicitacaoDao;
import br.com.centralit.citcorpore.integracao.PastaDAO;
import br.com.centralit.citcorpore.integracao.PrioridadeAcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.PrioridadeServicoUnidadeDao;
import br.com.centralit.citcorpore.integracao.PrioridadeServicoUsuarioDao;
import br.com.centralit.citcorpore.integracao.ServicoContratoDao;
import br.com.centralit.citcorpore.integracao.ServicoDao;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoDao;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoMudancaDao;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoProblemaDao;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoQuestionarioDao;
import br.com.centralit.citcorpore.integracao.TempoAcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.TempoAtendimentoEmpregadoDao;
import br.com.centralit.citcorpore.integracao.TempoAtendimentoUnidadeDao;
import br.com.centralit.citcorpore.integracao.UnidadeDao;
import br.com.centralit.citcorpore.mail.MensagemEmail;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ControleSLA;
import br.com.centralit.citcorpore.util.Enumerados.Nota;
import br.com.centralit.citcorpore.util.Enumerados.OccurrenceCategory;
import br.com.centralit.citcorpore.util.Enumerados.OrigemOcorrencia;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.SituacaoSLA;
import br.com.centralit.citcorpore.util.Enumerados.TipoSolicitacaoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.centralit.citquestionario.integracao.RespostaItemQuestionarioDao;
import br.com.centralit.citquestionario.negocio.RespostaItemQuestionarioServiceBean;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilFormatacao;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;
import net.htmlparser.jericho.Source;

@SuppressWarnings({ "unchecked", "rawtypes", "static-access","unused" })
public class SolicitacaoServicoServiceEjb extends CrudServiceImpl implements SolicitacaoServicoService {

	private SolicitacaoServicoDao solicitacaoServicoDao;
	private EmpregadoDao empregadoDao;

	private SolicitacaoServicoDao solicitacaoServicoDaoDataBaseAlias;
	private ControleSlaService controleSLAService;
	private AcordoNivelServicoService acordoNivelServicoService;

	@Override
	public IDto create(IDto model) throws ServiceException, LogicException {
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			tc.start();
			model = create(model, tc, true, true, true);
			if(model == null) {
				throw new Exception();
			}

			tc.commit();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}
		}
		return model;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> createList(Collection<SolicitacaoServicoDTO> models) throws ServiceException, LogicException {
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

		List<SolicitacaoServicoDTO> IDtos = new ArrayList<>();

		try {
			tc.start();

			for (SolicitacaoServicoDTO model : models) {
				model = (SolicitacaoServicoDTO) create(model, tc, true, true, true);

				if(model == null) {
					throw new Exception();
				}

				IDtos.add(model);
			}

			tc.commit();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}
		}

		return IDtos;
	}


	@Override
	public IDto create(IDto model, TransactionControler tc, boolean determinaPrioridadePrazo, boolean determinaHoraInicio, boolean determinaDataHoraSolicitacao) throws Exception {
		SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) model;

		ExecucaoSolicitacaoServiceEjb execucaoSolicitacaoService = new ExecucaoSolicitacaoServiceEjb();
		ContatoSolicitacaoServicoDao contatoSolicitacaoServicoDao = new ContatoSolicitacaoServicoDao();
		ContatoSolicitacaoServicoDTO contatoSolicitacaoServicoDTO = new ContatoSolicitacaoServicoDTO();
		SolicitacaoServicoProblemaDao solicitacaoServicoProblemaDao = new SolicitacaoServicoProblemaDao();
		SolicitacaoServicoMudancaDao solicitacaoServicoMudancaDao = new SolicitacaoServicoMudancaDao();
		LiberacaoSolicitacaoServicoDAO liberacaoSolicitacaoServicoDAO = new LiberacaoSolicitacaoServicoDAO();
		ConhecimentoSolicitacaoDao conhecimentoSolicitacaoDao = new ConhecimentoSolicitacaoDao();
		ItemCfgSolicitacaoServDAO itemCfgSolicitacaoServDAO = new ItemCfgSolicitacaoServDAO();

		ServicoContratoDao servicoContratoDao = new ServicoContratoDao();
		GrupoDao grupoDao = new GrupoDao();

		// Faz validacao, caso exista.
		validaCreate(model);

		this.getDao().setTransactionControler(tc);
		contatoSolicitacaoServicoDao.setTransactionControler(tc);

		if (solicitacaoServicoDto != null) {
			contatoSolicitacaoServicoDTO.setNomecontato(solicitacaoServicoDto.getNomecontato());
			contatoSolicitacaoServicoDTO.setEmailcontato(solicitacaoServicoDto.getEmailcontato());
			contatoSolicitacaoServicoDTO.setTelefonecontato(solicitacaoServicoDto.getTelefonecontato());
			contatoSolicitacaoServicoDTO.setObservacao(solicitacaoServicoDto.getObservacao());
			contatoSolicitacaoServicoDTO.setRamal(solicitacaoServicoDto.getRamal());
		} else {
			throw new LogicException("O model est nulo. Verificar.");
		}

		solicitacaoServicoProblemaDao.setTransactionControler(tc);
		solicitacaoServicoMudancaDao.setTransactionControler(tc);
		liberacaoSolicitacaoServicoDAO.setTransactionControler(tc);
		conhecimentoSolicitacaoDao.setTransactionControler(tc);
		itemCfgSolicitacaoServDAO.setTransactionControler(tc);

		servicoContratoDao.setTransactionControler(tc);
		grupoDao.setTransactionControler(tc);

		if (solicitacaoServicoDto.getIdTipoDemandaServico() == null || solicitacaoServicoDto.getIdTipoDemandaServico() <= 0) {
			throw new LogicException(i18nMessage("citcorpore.comum.informeTipoSolicitacao"));
		}

		if (solicitacaoServicoDto.getIdLocalidade() != null) {
			contatoSolicitacaoServicoDTO.setIdLocalidade(solicitacaoServicoDto.getIdLocalidade());
		}
		contatoSolicitacaoServicoDTO = (ContatoSolicitacaoServicoDTO) contatoSolicitacaoServicoDao.create(contatoSolicitacaoServicoDTO);

		ServicoContratoDTO servicoContratoDto = servicoContratoDao.findByIdContratoAndIdServico(solicitacaoServicoDto.getIdContrato(), solicitacaoServicoDto.getIdServico());

		if (servicoContratoDto == null) {
			throw new LogicException(i18nMessage("solicitacaoservico.validacao.servicolocalizado"));
		}

		if (solicitacaoServicoDto.getIdServicoContrato() == null) {
			solicitacaoServicoDto.setIdServicoContrato(servicoContratoDto.getIdServicoContrato());
		}
		solicitacaoServicoDto.setCustoServico(servicoContratoDto.getCusto());
		UsuarioDTO usuarioDto = solicitacaoServicoDto.getUsuarioDto();
		solicitacaoServicoDto.setIdResponsavel(usuarioDto.getIdUsuario());

		this.determinaCalendario(solicitacaoServicoDto, servicoContratoDto);

		solicitacaoServicoDto.setTempoDecorridoHH(new Integer(0));
		solicitacaoServicoDto.setTempoDecorridoMM(new Integer(0));
		solicitacaoServicoDto.setDataHoraSuspensao(null);
		solicitacaoServicoDto.setDataHoraReativacao(null);
		solicitacaoServicoDto.setDataHoraInicioSLA(null);
		solicitacaoServicoDto.setSituacaoSLA(SituacaoSLA.N.name());

		if (solicitacaoServicoDto.getIdGrupoNivel1() == null || solicitacaoServicoDto.getIdGrupoNivel1().intValue() <= 0) {
			Integer idGrupoNivel1 = null;
			if (servicoContratoDto.getIdGrupoNivel1() != null && servicoContratoDto.getIdGrupoNivel1().intValue() > 0) {
				idGrupoNivel1 = servicoContratoDto.getIdGrupoNivel1();
			} else {
				String idGrupoN1 = ParametroUtil.getValor(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1, null, null);
				if (idGrupoN1 != null && !idGrupoN1.trim().equalsIgnoreCase("")) {
					try {
						idGrupoNivel1 = new Integer(idGrupoN1);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
			if (idGrupoNivel1 == null || idGrupoNivel1.intValue() <= 0) {
				throw new LogicException(i18nMessage("solicitacaoservico.validacao.grupoatendnivel"));
			}
			GrupoDTO grupoDto = new GrupoDTO();
			grupoDto.setIdGrupo(idGrupoNivel1);
			grupoDto = (GrupoDTO) grupoDao.restore(grupoDto);
			if (grupoDto == null || grupoDto.getDataFim() != null) {
				throw new LogicException(i18nMessage("solicitacaoservico.validacao.grupoatendnivel"));
			}
			solicitacaoServicoDto.setIdGrupoNivel1(idGrupoNivel1);
		}

		FluxoServicoDao fluxoServicoDao = new FluxoServicoDao();
		TipoFluxoDao tipoFluxoDao = new TipoFluxoDao();
		TipoFluxoDTO tipoFluxoDto = new TipoFluxoDTO();
		FluxoServicoDTO fluxoServicoDto = fluxoServicoDao.findPrincipalByIdServicoContrato(servicoContratoDto.getIdServicoContrato());

		int idTipoFluxoSolicitacaoServico = 0;

		// Verifica se h fluxo associado ao servio contrato
		if (fluxoServicoDto != null && fluxoServicoDto.getIdTipoFluxo() != null) {
			idTipoFluxoSolicitacaoServico = fluxoServicoDto.getIdTipoFluxo();
		} else {
			// Verifica o fluxo padro para Solicitao Servio definido em
			// Parmetro
			String nomeFluxoPadraoSolicitacaoServico = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.NomeFluxoPadraoServicos,"");

			if (nomeFluxoPadraoSolicitacaoServico != null && !nomeFluxoPadraoSolicitacaoServico.isEmpty()) {
				tipoFluxoDto = tipoFluxoDao.findByNome(nomeFluxoPadraoSolicitacaoServico);

				if (tipoFluxoDto != null && tipoFluxoDto.getIdTipoFluxo() != null) {
					idTipoFluxoSolicitacaoServico = tipoFluxoDto.getIdTipoFluxo();
				}
			}
		}

		int idGrupo = 0;
		if (solicitacaoServicoDto != null && solicitacaoServicoDto.getIdGrupoAtual() != null) {
			idGrupo = solicitacaoServicoDto.getIdGrupoAtual();
			/*
			 * Inserido por Carlos Santos em 05/11/2013 -> Antes de testar o nvel 1, deve ser testado o grupo executor do contrato
			 */
		} else if (servicoContratoDto != null && servicoContratoDto.getIdGrupoExecutor() != null) {
			idGrupo = servicoContratoDto.getIdGrupoExecutor();
		} else if (solicitacaoServicoDto != null && solicitacaoServicoDto.getIdGrupoNivel1() != null) {
			idGrupo = solicitacaoServicoDto.getIdGrupoNivel1();
		}

		if (idTipoFluxoSolicitacaoServico > 0) {
			if (idGrupo > 0) {
				boolean resultado = permissaoGrupoExecutorServico(idGrupo, idTipoFluxoSolicitacaoServico);

				if (resultado == false) {
					throw new LogicException(i18nMessage("solicitacaoServico.grupoSemPermissao"));
				}
			} else {
				throw new LogicException(i18nMessage("controle.grupoObrigatorio"));
			}
		} else {
			throw new LogicException(i18nMessage("fluxo.fluxoserviconaodefinido"));
		}

		solicitacaoServicoDto.setIdContatoSolicitacaoServico(contatoSolicitacaoServicoDTO.getIdcontatosolicitacaoservico());
		if (determinaDataHoraSolicitacao) {
			solicitacaoServicoDto.setDataHoraSolicitacao(new Timestamp(new java.util.Date().getTime()));
		}

		if (determinaPrioridadePrazo) {
			determinaPrioridadeEPrazo(solicitacaoServicoDto, tc);
		}
		if (determinaHoraInicio) {
			solicitacaoServicoDto.setDataHoraInicio(new Timestamp(new java.util.Date().getTime()));
		}

		solicitacaoServicoDto.setSeqReabertura(new Integer(0));

		if (solicitacaoServicoDto.escalada()) {
			String tipoCaptura = ParametroUtil.getValor(ParametroSistema.TIPO_CAPTURA_SOLICITACOES, tc, "1");
			if (tipoCaptura.equals("2")) {
				solicitacaoServicoDto.setDataHoraCaptura(solicitacaoServicoDto.getDataHoraInicio());
			}
		}

		if (solicitacaoServicoDto.getIdCalendario() == null) {
			determinaCalendario(solicitacaoServicoDto);
		}

		solicitacaoServicoDto = (SolicitacaoServicoDTO) solicitacaoServicoDao.create(solicitacaoServicoDto);
		if (solicitacaoServicoDto != null) {
			if (solicitacaoServicoDto.getColItensProblema() != null) {
				for (Iterator it = solicitacaoServicoDto.getColItensProblema().iterator(); it.hasNext();) {
					ProblemaDTO problemaDTO = (ProblemaDTO) it.next();
					SolicitacaoServicoProblemaDTO solicitacaoServicoProblemaDTO = new SolicitacaoServicoProblemaDTO();
					solicitacaoServicoProblemaDTO.setIdProblema(problemaDTO.getIdProblema());
					solicitacaoServicoProblemaDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
					solicitacaoServicoProblemaDao.create(solicitacaoServicoProblemaDTO);
				}
			}

			if (solicitacaoServicoDto.getColItensMudanca() != null) {

				for (Iterator it = solicitacaoServicoDto.getColItensMudanca().iterator(); it.hasNext();) {
					RequisicaoMudancaDTO requisicaoMudancaDTO = (RequisicaoMudancaDTO) it.next();

					SolicitacaoServicoMudancaDTO solicitacaoServicoMudancaDTO = new SolicitacaoServicoMudancaDTO();
					solicitacaoServicoMudancaDTO.setIdRequisicaoMudanca(requisicaoMudancaDTO.getIdRequisicaoMudanca());
					solicitacaoServicoMudancaDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
					solicitacaoServicoMudancaDao.create(solicitacaoServicoMudancaDTO);
				}
			}

			if (solicitacaoServicoDto.getColItensLiberacao() != null) {
				for (Iterator it = solicitacaoServicoDto.getColItensLiberacao().iterator(); it.hasNext();) {
					RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) it.next();
					LiberacaoSolicitacaoServicoDTO liberacaoSolicitacaoServicoDTO = new LiberacaoSolicitacaoServicoDTO();
					liberacaoSolicitacaoServicoDTO.setIdLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
					liberacaoSolicitacaoServicoDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
					liberacaoSolicitacaoServicoDAO.create(liberacaoSolicitacaoServicoDTO);
				}
			}

			if (solicitacaoServicoDto.getColItensICSerialize() != null) {
				for (ItemConfiguracaoDTO bean : solicitacaoServicoDto.getColItensICSerialize()) {
					ItemCfgSolicitacaoServDTO dto = new ItemCfgSolicitacaoServDTO();
					dto.setIdItemConfiguracao(bean.getIdItemConfiguracao());
					dto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
					dto.setDataInicio(Util.getSqlDataAtual());

					itemCfgSolicitacaoServDAO.create(dto);
				}
			}

			if (solicitacaoServicoDto.getColItensBaseConhecimento() != null) {
				for (Iterator it = solicitacaoServicoDto.getColItensBaseConhecimento().iterator(); it.hasNext();) {
					BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) it.next();

					ConhecimentoSolicitacaoDTO conhecimentoSolicitacaoDTO = new ConhecimentoSolicitacaoDTO();
					conhecimentoSolicitacaoDTO.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());
					conhecimentoSolicitacaoDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
					conhecimentoSolicitacaoDao.create(conhecimentoSolicitacaoDTO);
				}
			}

			if (solicitacaoServicoDto.getInformacoesComplementares() != null || solicitacaoServicoDto.getSolicitacaoServicoQuestionarioDTO() != null) {
				TemplateSolicitacaoServicoDTO templateDto = new TemplateSolicitacaoServicoServiceEjb().recuperaTemplateServico(solicitacaoServicoDto, tc);
				if (templateDto != null) {
					if (templateDto.isQuestionario()) {
						atualizaInformacoesQuestionario(solicitacaoServicoDto, tc);
					} else if (templateDto.getNomeClasseServico() != null) {
						ComplemInfSolicitacaoServicoService informacoesComplementaresService = getInformacoesComplementaresService(templateDto.getNomeClasseServico());
						informacoesComplementaresService.create(tc, solicitacaoServicoDto, solicitacaoServicoDto.getInformacoesComplementares());
					}
				}
			}
		}

		try {
			OcorrenciaSolicitacaoServiceEjb.create(solicitacaoServicoDto, null, null, OrigemOcorrencia.OUTROS, OccurrenceCategory.CREATION, new Gson().toJson(contatoSolicitacaoServicoDTO), OccurrenceCategory.CREATION.getI18NKey(),
					usuarioDto, 0, null, tc);
		} catch (Exception e) {
			e.printStackTrace();
		}

		ExecucaoSolicitacao execucaoSolicitacao = execucaoSolicitacaoService.registraSolicitacao(solicitacaoServicoDto, tc);
		if (execucaoSolicitacao == null) {
			tc.rollback();
			return null;
		}

		if (solicitacaoServicoDto.getColArquivosUpload() != null && solicitacaoServicoDto.getColArquivosUpload().size() > 0) {
			gravaInformacoesGED(solicitacaoServicoDto.getColArquivosUpload(), 1, solicitacaoServicoDto, tc);
		}

		Source source = new Source(solicitacaoServicoDto.getRegistroexecucao());
		solicitacaoServicoDto.setRegistroexecucao(source.getTextExtractor().toString());

		if (solicitacaoServicoDto.getRegistroexecucao() != null && !solicitacaoServicoDto.getRegistroexecucao().trim().equalsIgnoreCase("")) {
			TarefaFluxoDTO tarefaDto = null;
			if (solicitacaoServicoDto.getIdTarefa() != null) {
				tarefaDto = new TarefaFluxoDTO();
				tarefaDto.setIdItemTrabalho(solicitacaoServicoDto.getIdTarefa());
			}

			OcorrenciaSolicitacaoServiceEjb.create(solicitacaoServicoDto, tarefaDto, solicitacaoServicoDto.getRegistroexecucao(), OrigemOcorrencia.OUTROS, OccurrenceCategory.REGISTRATION_EXECUTION, null,
					OccurrenceCategory.REGISTRATION_EXECUTION.getI18NKey(), usuarioDto, 0, null, tc);
		}

		if (solicitacaoServicoDto != null && solicitacaoServicoDto.getBeanBaseConhecimento() != null && solicitacaoServicoDto.getBeanBaseConhecimento().getTitulo() != null
				&& !solicitacaoServicoDto.getBeanBaseConhecimento().getTitulo().isEmpty()) {
			this.inserirNaBaseConhecimento(solicitacaoServicoDto, tc);
		}

		return solicitacaoServicoDto;
	}

	// Criado por Bruno.Aquino
	// Se a Situao estiver como "Resolvida" Capturo: a descricao do problema e
	// a Soluo/Resposta
	private void inserirNaBaseConhecimento(SolicitacaoServicoDTO solicitacaoServicoDTO, TransactionControler tc) throws ServiceException, Exception {

		BaseConhecimentoDTO beanBaseConhecimento = solicitacaoServicoDTO.getBeanBaseConhecimento();
		beanBaseConhecimento.setIdSolicitacaoServico(solicitacaoServicoDTO.getIdSolicitacaoServico());

		BaseConhecimentoDAO baseConhecimentoDAO = new BaseConhecimentoDAO();
		PastaDAO pastaDao = new PastaDAO();

		pastaDao.setTransactionControler(tc);
		baseConhecimentoDAO.setTransactionControler(tc);

		BaseConhecimentoDTO baseAux = baseConhecimentoDAO.findByIdSolicitacaoServico(solicitacaoServicoDTO);

		// verifica se j no existe uma registro na base de conhecimento
		// referente a essa solicitao, s pode armazenar um.
		if (baseAux == null) {

			PastaServiceEjb pastaEjb = new PastaServiceEjb();
			PastaDTO pastaBean = new PastaDTO();
			int cont = 0;

			// verifica se a pasta existe
			Collection<PastaDTO> lista = pastaEjb.consultarPastasAtivas();
			for (PastaDTO p : lista) {
				if (p.getNome() != null) {
					if (p.getNome().equals(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.PASTA_SALVA_DESCRICAO_RESPOSTA_DE_SOLICITACAOSERVICO_EM_BASECONHECIMENTO, "Descrio_Resposta_Para_BaseConhecimento"))) {
						pastaBean.setId(p.getId());
						cont++;
					}
				}
			}

			// se a pasta no existir, pasta vai ser criada pelo parametro ou
			// com o nome do padro
			if (cont == 0) {
				pastaBean.setNome(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.PASTA_SALVA_DESCRICAO_RESPOSTA_DE_SOLICITACAOSERVICO_EM_BASECONHECIMENTO, "Descrio_Resposta_Para_BaseConhecimento"));
				pastaDao.create(pastaBean);

				Collection<PastaDTO> lista2 = pastaEjb.consultarPastasAtivas();
				for (PastaDTO p2 : lista2) {
					if (p2.getNome() != null) {
						if (p2.getNome()
								.equals(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.PASTA_SALVA_DESCRICAO_RESPOSTA_DE_SOLICITACAOSERVICO_EM_BASECONHECIMENTO, "Descrio_Resposta_Para_BaseConhecimento"))) {
							pastaBean.setId(p2.getId());
						}
					}
				}
			}

			beanBaseConhecimento.setIdPasta(pastaBean.getId());
			baseConhecimentoDAO.create(beanBaseConhecimento);
		}
	}

	public void PersistirItemBaseConhecimento(SolicitacaoServicoDTO solicitacaoServicoDto, ConhecimentoSolicitacaoDao conhecimentoSolicitacaoDao) throws Exception {
		List<ConhecimentoSolicitacaoDTO> listaTelaConhecimentoDTO = solicitacaoServicoDto.getColConhecimentoSolicitacaoSerialize();
		if (listaTelaConhecimentoDTO != null) {
			ConhecimentoSolicitacaoDTO dto;
			// Inserindo no Banco de Dados os Itens da lista ainda no
			// cadastrados
			for (ConhecimentoSolicitacaoDTO bean : listaTelaConhecimentoDTO) {
				dto = new ConhecimentoSolicitacaoDTO();
				dto.setIdBaseConhecimento(bean.getIdBaseConhecimento());
				dto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				if (!conhecimentoSolicitacaoDao.seCadastrada(dto)) {
					conhecimentoSolicitacaoDao.create(dto);
				}
			}
			// Apagando Itens no banco que no esto na lista informada
			Collection<ConhecimentoSolicitacaoDTO> listaDBConhecimentoSolicitacaoDTO = conhecimentoSolicitacaoDao.findByidSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
			Boolean encontrou;
			for (ConhecimentoSolicitacaoDTO elemento : listaDBConhecimentoSolicitacaoDTO) {
				encontrou = new Boolean("False");
				for (ConhecimentoSolicitacaoDTO itemBaseConhecimento : listaTelaConhecimentoDTO) {
					if (elemento.getIdBaseConhecimento().equals(itemBaseConhecimento.getIdBaseConhecimento())) {
						encontrou = true;
						break;
					}
				}
				if (!encontrou) {
					conhecimentoSolicitacaoDao.delete(elemento);
				}
			}
			// Para o Garbage Collection agir mais rpido
			listaTelaConhecimentoDTO = null;
			dto = null;
			listaDBConhecimentoSolicitacaoDTO = null;
			encontrou = null;
		}
	}

	@Override
	public void deserializaInformacoesComplementares(SolicitacaoServicoDTO solicitacaoServicoDto, SolicitacaoServicoQuestionarioDTO solQuestionarioDto) throws Exception {
		if (solicitacaoServicoDto.getInformacoesComplementares_serialize() != null) {
			TemplateSolicitacaoServicoDTO templateDto = new TemplateSolicitacaoServicoServiceEjb().recuperaTemplateServico(solicitacaoServicoDto);
			if (templateDto != null && templateDto.getNomeClasseServico() != null) {
				if (templateDto.isQuestionario()) {
					solicitacaoServicoDto.setSolicitacaoServicoQuestionarioDTO(solQuestionarioDto);
				} else {
					ComplemInfSolicitacaoServicoService informacoesComplementaresService = getInformacoesComplementaresService(templateDto.getNomeClasseServico());
					IDto informacoesComplementares = informacoesComplementaresService.deserializaObjeto(solicitacaoServicoDto.getInformacoesComplementares_serialize());
					solicitacaoServicoDto.setInformacoesComplementares(informacoesComplementares);
				}
			}
			solicitacaoServicoDto.setInformacoesComplementares_serialize(null);
		}
	}

	@Deprecated
	public void determinaPrazoLimiteSolicitacaoACombinarReclassificada(SolicitacaoServicoDTO solicitacaoDto, Integer idCalendarioParm, TransactionControler tc) throws Exception {
		solicitacaoDto.setIdCalendario(idCalendarioParm);
		this.determinaPrazoLimiteSolicitacaoACombinarReclassificada(solicitacaoDto, tc);
	}

	public void determinaPrazoLimiteSolicitacaoACombinarReclassificada(SolicitacaoServicoDTO solicitacaoDto, TransactionControler tc) throws Exception {
		new ExecucaoSolicitacaoServiceEjb().determinaPrazoLimiteSolicitacaoACombinarReclassificada(solicitacaoDto, tc);
	}

	public void determinaPrioridadeEPrazo(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		EmpregadoDTO empregadoDTO = null;
		if (solicitacaoServicoDto != null) {
			if (solicitacaoServicoDto.getIdSolicitante() != null) {
				EmpregadoDao empregadoDao = new EmpregadoDao();
				if (tc != null) {
					empregadoDao.setTransactionControler(tc);
				}

				empregadoDTO = empregadoDao.restoreByIdEmpregado(solicitacaoServicoDto.getIdSolicitante());
				if (empregadoDTO != null && empregadoDTO.getIdUnidade() != null) {
					if (solicitacaoServicoDto.getIdUnidade() == null || solicitacaoServicoDto.getIdUnidade().intValue() == 0) {
						solicitacaoServicoDto.setIdUnidade(empregadoDTO.getIdUnidade());
					}
				}
			}
			UnidadeDTO unidadeDTO = null;
			if (solicitacaoServicoDto.getIdUnidade() != null) {
				UnidadeDao unidadeDao = new UnidadeDao();
				if (tc != null) {
					unidadeDao.setTransactionControler(tc);
				}

				unidadeDTO = new UnidadeDTO();
				unidadeDTO.setIdUnidade(solicitacaoServicoDto.getIdUnidade());
				unidadeDTO = (UnidadeDTO) unidadeDao.restore(unidadeDTO);
			}

			AcordoNivelServicoDao acordoNivelServicoDao = new AcordoNivelServicoDao();
			if (tc != null) {
				acordoNivelServicoDao.setTransactionControler(tc);
			}

			// AcordoNivelServicoDTO acordoNivelServicoDto = acordoNivelServicoDao.findAtivoByIdServicoContrato(solicitacaoServicoDto.getIdServicoContrato(), "T");
			AcordoNivelServicoDTO acordoNivelServicoDto = acordoNivelServicoDao.findANSIncReqProcByIdServicoContrato(solicitacaoServicoDto.getIdServicoContrato());
			if (acordoNivelServicoDto == null) {
				AcordoServicoContratoDao acordoServicoContratoDao = new AcordoServicoContratoDao();
				if (tc != null) {
					acordoServicoContratoDao.setTransactionControler(tc);
				}

				// Se nao houver acordo especifico, ou seja, associado direto ao
				// servicocontrato, entao busca um acordo geral que esteja vinculado
				// ao servicocontrato.
				// AcordoServicoContratoDTO acordoServicoContratoDTO = acordoServicoContratoDao.findAtivoByIdServicoContrato(solicitacaoServicoDto.getIdServicoContrato(), "T");
				AcordoServicoContratoDTO acordoServicoContratoDTO = acordoServicoContratoDao.getANSGlobalClienteHierarquicoByIdServicoContrato(solicitacaoServicoDto.getIdServicoContrato());
				if (acordoServicoContratoDTO == null) {
					throw new Exception(i18nMessage("solicitacaoservico.validacao.tempoacordoDesabilitado"));
				}
				// Apos achar a vinculacao do acordo com o servicocontrato, entao
				// faz um restore do acordo de nivel de servico.
				acordoNivelServicoDto = new AcordoNivelServicoDTO();
				acordoNivelServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
				acordoNivelServicoDto = (AcordoNivelServicoDTO) acordoNivelServicoDao.restore(acordoNivelServicoDto);
				if (acordoNivelServicoDto == null) {
					// Se nao houver acordo especifico, ou seja, associado direto ao
					// servicocontrato
					throw new Exception(i18nMessage("solicitacaoservico.validacao.tempoacordo"));
				}
				solicitacaoServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());

				// Consulta prioridade do usurio de acordo com sla global
				PrioridadeServicoUsuarioDao prioridadeServicoUsuarioDao = new PrioridadeServicoUsuarioDao();
				if (tc != null) {
					prioridadeServicoUsuarioDao.setTransactionControler(tc);
				}
				PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioDTO = prioridadeServicoUsuarioDao.findByIdAcordoNivelServicoAndIdUsuario(solicitacaoServicoDto.getIdAcordoNivelServico(), solicitacaoServicoDto.getIdSolicitante());
				if (prioridadeServicoUsuarioDTO != null) {
					solicitacaoServicoDto.setIdPrioridade(prioridadeServicoUsuarioDTO.getIdPrioridade());
				}

				// Consulta prioridade da unidade do usurio de acordo com sla
				// global
				PrioridadeAcordoNivelServicoDao prioridadeAcordoNivelServicoDao = new PrioridadeAcordoNivelServicoDao();
				if (tc != null) {
					prioridadeAcordoNivelServicoDao.setTransactionControler(tc);
				}
				PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoDTO = prioridadeAcordoNivelServicoDao.findByIdAcordoNivelServicoAndIdUnidade(solicitacaoServicoDto.getIdAcordoNivelServico(), solicitacaoServicoDto.getIdUnidade());
				if (prioridadeAcordoNivelServicoDTO != null) {
					solicitacaoServicoDto.setIdPrioridade(prioridadeAcordoNivelServicoDTO.getIdPrioridade());
				}

			} else {
				solicitacaoServicoDto.setIdAcordoNivelServico(acordoNivelServicoDto.getIdAcordoNivelServico());
			}

			if (solicitacaoServicoDto.getUrgencia() == null || solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("")) {
				solicitacaoServicoDto.setUrgencia("B");
			}
			if (solicitacaoServicoDto.getImpacto() == null || solicitacaoServicoDto.getImpacto().equalsIgnoreCase("")) {
				solicitacaoServicoDto.setImpacto("B");
			}

			String calcularDinamicamente = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE, "N");
			Integer idPrioridade = 5;
			if (!calcularDinamicamente.trim().equalsIgnoreCase("S")) {
				if (solicitacaoServicoDto.getIdPrioridade() == null) { // Aqui determina
					// prazo pela
					// Urgencia e
					// Impacto -
					// Como mando o
					// ITIL.
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 5;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 4;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 3;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 4;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 3;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 2;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 3;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 2;
					}
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 1;
					}
				}
			} else {
				MatrizPrioridadeDAO matrizPrioriDao = new MatrizPrioridadeDAO();
				if (tc != null) {
					matrizPrioriDao.setTransactionControler(tc);
				}

				String siglaImpacto = solicitacaoServicoDto.getImpacto();
				String siglaUrgencia = solicitacaoServicoDto.getUrgencia();
				Integer valorPrioridade = matrizPrioriDao.consultaValorPrioridade(siglaImpacto.trim().toUpperCase(), siglaUrgencia.trim().toUpperCase());
				idPrioridade = valorPrioridade;
			}

			TempoAtendimentoEmpregadoDao tempoAtendimentoEmpregadoDao = new TempoAtendimentoEmpregadoDao();
			TempoAtendimentoUnidadeDao tempoAtendimentoUnidadeDao = new TempoAtendimentoUnidadeDao();
			TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregadoDTO;
			TempoAtendimentoUnidadeDTO tempoAtendimentoUnidadeDTO;
			if (solicitacaoServicoDto.getIdSolicitante() != null) {
				tempoAtendimentoEmpregadoDTO = tempoAtendimentoEmpregadoDao.restoreByIdEmpregadoIdANS(solicitacaoServicoDto.getIdSolicitante(), acordoNivelServicoDto.getIdAcordoNivelServico());
			} else {
				tempoAtendimentoEmpregadoDTO = tempoAtendimentoEmpregadoDao.restoreByIdAcordoNivelServico(acordoNivelServicoDto.getIdAcordoNivelServico());
			}

			if (solicitacaoServicoDto.getIdUnidade() != null) {
				tempoAtendimentoUnidadeDTO = tempoAtendimentoUnidadeDao.restoreByIdUnidadeIdANS(solicitacaoServicoDto.getIdUnidade(), acordoNivelServicoDto.getIdAcordoNivelServico());
			} else {
				tempoAtendimentoUnidadeDTO = tempoAtendimentoUnidadeDao.restoreByIdAcordoNivelServico(acordoNivelServicoDto.getIdAcordoNivelServico());
			}
			List<Integer> listPrioridade = new ArrayList();

			listPrioridade.add(idPrioridade);

			if (tempoAtendimentoEmpregadoDTO != null && tempoAtendimentoEmpregadoDTO.getPrioridade() != null) {
				listPrioridade.add(tempoAtendimentoEmpregadoDTO.getPrioridade());
			}
			if (tempoAtendimentoUnidadeDTO != null && tempoAtendimentoUnidadeDTO.getPrioridade() != null) {
				listPrioridade.add(tempoAtendimentoUnidadeDTO.getPrioridade());
			}

			Integer majorPriority = Integer.MAX_VALUE;

			if (listPrioridade != null && !listPrioridade.isEmpty()) {
				for (Integer key : listPrioridade) {
					if (key < majorPriority) {
						majorPriority = key;
					}
				}
			} else {
				majorPriority = solicitacaoServicoDto.getIdPrioridade();
			}
			solicitacaoServicoDto.setIdPrioridade(majorPriority);

/*
			if (solicitacaoServicoDto.getIdPrioridade() == null) {// Se ainda a
																	// prioridade
																	// estiver NULA,
																	// vai a padrao
				solicitacaoServicoDto.setIdPrioridade(acordoNivelServicoDto.getIdPrioridadePadrao());
			}
*/
			if (solicitacaoServicoDto.getIdPrioridade() == null) {
				throw new Exception(i18nMessage("solicitacaoservico.validacao.prioridadesolicitacao"));
			}

			int prazoCapturaHH = 0;
			int prazoCapturaMM = 0;
			int prazoHH = 0;
			int prazoMM = 0;
			TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
			if (tc != null) {
				tempoAcordoNivelServicoDao.setTransactionControler(tc);
			}

			Collection<TempoAcordoNivelServicoDTO> colTempos = new ArrayList<>();

			if (tempoAtendimentoEmpregadoDTO != null || tempoAtendimentoUnidadeDTO != null) {
				colTempos = tempoAcordoNivelServicoDao.findByIdAcordoAndIdPrioridade(acordoNivelServicoDto.getIdAcordoNivelServico(), solicitacaoServicoDto.getIdPrioridade());

			} else {
				TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = this.getTempoAtendimento(empregadoDTO, unidadeDTO, solicitacaoServicoDto);

				if (tempoAcordoNivelServicoDTO != null && tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() != null) {
					colTempos = tempoAcordoNivelServicoDao.findByIdAcordoAndIdPrioridade(tempoAcordoNivelServicoDTO.getIdAcordoNivelServico(), solicitacaoServicoDto.getIdPrioridade());
				}
			}

			if (colTempos != null) {
				FluxoServicoDao fluxoServicoDao = new FluxoServicoDao();
				if (tc != null) {
					fluxoServicoDao.setTransactionControler(tc);
				}

				String idFasePadraoStr = ParametroUtil.getValor(ParametroSistema.IDFaseExecucaoServicos, tc, null);
				if (idFasePadraoStr == null) {
					throw new Exception(i18nMessage("solicitacaoservico.validacao.padraoexecucao"));
				}

				FaseServicoDao faseServicoDao = new FaseServicoDao();
				if (tc != null) {
					faseServicoDao.setTransactionControler(tc);
				}
				Collection<FaseServicoDTO> colFases = faseServicoDao.list();
				HashMap<String, FaseServicoDTO> mapFasesCaptura = new HashMap();
				if (colFases != null) {
					for (FaseServicoDTO faseDto : colFases) {
						if (faseDto.getFaseCaptura() != null && faseDto.getFaseCaptura().equalsIgnoreCase("S")) {
							mapFasesCaptura.put("" + faseDto.getIdFase(), faseDto);
						}
					}
				}

				Collection colFluxos = fluxoServicoDao.findByIdServicoContrato(solicitacaoServicoDto.getIdServicoContrato());
				boolean bExisteFluxo = colFluxos != null && !colFluxos.isEmpty();

				for (TempoAcordoNivelServicoDTO tempoAcordoDto : colTempos) {
					boolean bAcumula = false;
					if (bExisteFluxo) {
						colFluxos = fluxoServicoDao.findByIdServicoContratoAndIdFase(solicitacaoServicoDto.getIdServicoContrato(), tempoAcordoDto.getIdFase());
						bAcumula = colFluxos != null && !colFluxos.isEmpty();
					} else {
						bAcumula = tempoAcordoDto.getIdFase().intValue() == new Integer(idFasePadraoStr).intValue();
					}

					/*
					 * -- RETIRADO POR EMAURI EM 13/08/2012. NAO JUSTIFICA A EXCLUSAO DO CALCULO DO SLA. if (!bAcumula) continue;
					 */

					if (tempoAcordoDto.getTempoHH() != null) {
						if (mapFasesCaptura.get("" + tempoAcordoDto.getIdFase()) != null) {
							prazoCapturaHH += tempoAcordoDto.getTempoHH().intValue();
						}
						prazoHH += tempoAcordoDto.getTempoHH().intValue();
					}
					if (tempoAcordoDto.getTempoMM() != null) {
						if (mapFasesCaptura.get("" + tempoAcordoDto.getIdFase()) != null) {
							prazoCapturaMM += tempoAcordoDto.getTempoMM().intValue();
						}
						prazoMM += tempoAcordoDto.getTempoMM().intValue();
					}
				}
			}

			if (prazoHH + prazoMM == 0) {
				if (solicitacaoServicoDto.getIdPrioridade() != null && solicitacaoServicoDto.getIdPrioridade().intValue() == 5) {
					solicitacaoServicoDto.setPrazoCapturaHH(0);
					solicitacaoServicoDto.setPrazoCapturaMM(0);
					solicitacaoServicoDto.setPrazoHH(0);
					solicitacaoServicoDto.setPrazoMM(0);
					solicitacaoServicoDto.setSlaACombinar("S");
				} else {
					throw new Exception(i18nMessage("solicitacaoservico.prazoacordonivel") + " " + solicitacaoServicoDto.getIdPrioridade());
				}
			}

			while (prazoCapturaMM > 60) {
				prazoCapturaMM = prazoCapturaMM - 60;
				prazoCapturaHH += 1;
			}
			while (prazoMM > 60) {
				prazoMM = prazoMM - 60;
				prazoHH += 1;
			}

			solicitacaoServicoDto.setPrazoCapturaHH(prazoCapturaHH);
			solicitacaoServicoDto.setPrazoCapturaMM(prazoCapturaMM);
			solicitacaoServicoDto.setPrazoHH(prazoHH);
			solicitacaoServicoDto.setPrazoMM(prazoMM);

			// tratamento especial para solicitaes a combinar reclassificadas
			SolicitacaoServicoDTO solAux = null;
			if (solicitacaoServicoDto != null && solicitacaoServicoDto.getIdSolicitacaoServico() != null) {
				solAux = (SolicitacaoServicoDTO) this.getDao().restore(solicitacaoServicoDto);
				if (solAux.getDataHoraLimiteStr() != null) {
					if (solAux.getDataHoraLimiteStr().contains("--") && solAux.getSlaACombinar().equalsIgnoreCase("S")) {
						solicitacaoServicoDto.setIdCalendario(null); // para forar a atualizao do calendrio
						determinaPrazoLimiteSolicitacaoACombinarReclassificada(solicitacaoServicoDto, tc);
						return;
					}
				}

			}

			if (solicitacaoServicoDto.getDataHoraInicio() != null && solicitacaoServicoDto.getDataHoraInicioSLA() == null) {
				solicitacaoServicoDto.setDataHoraInicioSLA(UtilDatas.getDataHoraAtual());
			}

			determinaPrazoLimite(solicitacaoServicoDto, null, tc);
		}
	}

	@Override
	public void encerra(SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		try {
			tc.start();

			encerra(solicitacaoServicoDto, tc);

			tc.commit();

		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		}finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	public void encerra(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		SolicitacaoServicoDTO solicitacaoAuxDto = restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico(), tc);
		new ExecucaoSolicitacaoServiceEjb().encerra(solicitacaoAuxDto, tc);
	}

	public void fechaSolicitacaoServicoVinculadaByProblemaOrMudanca(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {

		SolicitacaoServicoDTO solicitacaoAuxDto = restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico(), tc);
		this.getDao().setTransactionControler(tc);

		if (solicitacaoAuxDto != null && solicitacaoAuxDto.getIdSolicitacaoServico() != null) {

			if(solicitacaoServicoDto.getResposta() != null){
				solicitacaoAuxDto.setResposta(solicitacaoServicoDto.getResposta());
			}

			if(solicitacaoServicoDto.getIdUsuarioResponsavelAtual() != null){
				solicitacaoAuxDto.setIdUsuarioResponsavelAtual(solicitacaoServicoDto.getIdUsuarioResponsavelAtual());
			}

			List lista = new ArrayList<>();
			lista = this.getDao().consultaListaDeIdDaTarefaDaSolicitacaoDeServico(solicitacaoAuxDto);

			if(lista.get(0) != null) {
				solicitacaoAuxDto.setIdTarefaEncerramento( (Long) ((Object[]) lista.get(0))[0]);
			}

			solicitacaoAuxDto.setIdStatus(ServiceRequestStatus.SOLVED.getId());
			this.getDao().updateNotNull(solicitacaoAuxDto);

			new ExecucaoSolicitacaoServiceEjb().encerra(solicitacaoAuxDto, tc);
		}

	}

	@Override
	public Collection findByConhecimento(BaseConhecimentoDTO baseConhecimentoDto) throws ServiceException, LogicException {
		try {
			return this.getDao().findByConhecimento(baseConhecimentoDto);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public Collection findByIdSolictacaoServico(Integer parm) throws ServiceException, LogicException {
		SolicitacaoServicoProblemaDao solicitacaoServicoProblemaDao = new SolicitacaoServicoProblemaDao();

		try {
			return solicitacaoServicoProblemaDao.findByIdSolictacaoServico(parm);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByServico(Integer idServico) throws Exception {
		return this.getDao().findByServico(idServico);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByServico(Integer idServico, String nome) throws Exception {
		return this.getDao().findByServico(idServico, nome);
	}

	/**
	 * @author breno.guimaraes
	 * @return Resumo das solicita��es relacionadas ao clinte passado como argumento.
	 */
	@Override
	public ArrayList<SolicitacaoServicoDTO> findSolicitacoesServicosUsuario(Integer idUsuario, Integer idItemConfiguracao) {
		Collection<SolicitacaoServicoDTO> solicitacoesSimplificada = null;
		ArrayList<SolicitacaoServicoDTO> solicitacoesCompleta = new ArrayList<SolicitacaoServicoDTO>();

		List condicoes = new ArrayList();
		if (idUsuario != null) {
			condicoes.add(new Condition("idSolicitante", "=", idUsuario.intValue()));
		}

		if (idItemConfiguracao != null) {
			condicoes.add(new Condition("idItemConfiguracao", "=", idItemConfiguracao.intValue()));
		}

		try {
			solicitacoesSimplificada = getDao().findByCondition(condicoes, null);
			int i = 0;
			if (solicitacoesSimplificada != null) {
				for (SolicitacaoServicoDTO s : solicitacoesSimplificada) {
					solicitacoesCompleta.add(this.restoreAll(s.getIdSolicitacaoServico()));
				}
			}
		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return solicitacoesCompleta;
	}

	@Override
	protected SolicitacaoServicoDao getDao() {
		if(solicitacaoServicoDao == null) {
			solicitacaoServicoDao = new SolicitacaoServicoDao();
		}
		return solicitacaoServicoDao;
	}

	private EmpregadoDao getEmpregadoDao() {
		if(empregadoDao == null) {
			empregadoDao = new EmpregadoDao();
		}
		return empregadoDao;
	}

	/**
	 * Desenvolvedor: Fabio Amorim - Data: 13/08/2015 - Horrio: 14:48 - ID Citsmart: 176361 - Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por
	 * parmetro para o DAO, citsmart_reports, por exemplo.
	 *
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
	private SolicitacaoServicoDao getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (solicitacaoServicoDaoDataBaseAlias == null) {
				solicitacaoServicoDaoDataBaseAlias = new SolicitacaoServicoDao(databaseAlias);
			}
			return solicitacaoServicoDaoDataBaseAlias;
		}
		return this.getDao();
	}

	@Override
	public Collection<SolicitacaoServicoDTO> getHistoricoByIdSolicitacao(Integer idSolicitacao) throws Exception {
		try {
			return this.getSolicitacaoServicoDao().getHistoricoByIdSolicitacao(idSolicitacao);
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public ComplemInfSolicitacaoServicoService getInformacoesComplementaresService(ItemTrabalho itemTrabalho) throws Exception {
		TemplateSolicitacaoServicoDTO templateDto = new TemplateSolicitacaoServicoServiceEjb().recuperaTemplateServico(itemTrabalho);
		if (templateDto != null) {
			return getInformacoesComplementaresService(templateDto.getNomeClasseServico());
		} else {
			return null;
		}
	}

	public ComplemInfSolicitacaoServicoService getInformacoesComplementaresService(String nomeClasse) throws Exception {
		ComplemInfSolicitacaoServicoService informacoesComplementaresService = (ComplemInfSolicitacaoServicoService) Class.forName(nomeClasse).newInstance();
		informacoesComplementaresService.setUsuario(this.usuario);
		return informacoesComplementaresService;
	}

	@Override
	public ItemTrabalho getItemTrabalho(Integer idItemTrabalho) throws Exception {
		return new Tarefa().getItemTrabalho(idItemTrabalho);
	}

	@Override
	public Integer getQuantidadeByIdServico(int idServico) throws Exception {
		try {
			return this.getDao().getQuantidadeByIdServico(idServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Integer getQuantidadeByIdServicoContrato(int idServicoContrato) throws Exception {
		try {
			return this.getDao().getQuantidadeByIdServicoContrato(idServicoContrato);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * Retorna DAO de solicitacao servico.
	 *
	 * @return SolicitacaoServicoDao
	 * @throws ServiceException
	 * @author valdoilo
	 */
	public SolicitacaoServicoDao getSolicitacaoServicoDao() throws ServiceException {
		return this.getDao();
	}

	@Override
	public String getUrlInformacoesComplementares(SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		String url = "";

		TemplateSolicitacaoServicoDTO templateDto = new TemplateSolicitacaoServicoServiceEjb().recuperaTemplateServico(solicitacaoServicoDto);
		if (templateDto != null) {
			url = Constantes.getValue("CONTEXTO_APLICACAO");
			// url = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.URL_Sistema, "");
			if (templateDto.isQuestionario()) {
				SolicitacaoServicoQuestionarioDTO solicitacaoServicoQuestionarioDto = null;
				if (solicitacaoServicoDto.getIdSolicitacaoServico() != null) {
					solicitacaoServicoQuestionarioDto = new SolicitacaoServicoQuestionarioDao().findByIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				}

				url += "/pages/visualizacaoQuestionario/visualizacaoQuestionario.load?tabela100=true";

				if (solicitacaoServicoQuestionarioDto != null && solicitacaoServicoQuestionarioDto.getIdSolicitacaoQuestionario() != null) {
					// if (solicitacaoServicoDto.getIdTarefa() == null) {
					url += "&idQuestionario=" + solicitacaoServicoQuestionarioDto.getIdQuestionario();
					url += "&idIdentificadorResposta=" + solicitacaoServicoQuestionarioDto.getIdSolicitacaoQuestionario();
					if (solicitacaoServicoQuestionarioDto.getSituacao().equalsIgnoreCase("F")) {
						url += "&modo=somenteleitura";
					}
					else {
						url += "&modo=edicao";
					// }else{
					// url += "&idQuestionarioOrigem=" + templateDto.getIdQuestionario();
					// url += "&modo=edicao";
					// }
					}
				} else {
					url += "&idQuestionarioOrigem=" + templateDto.getIdQuestionario();
					url += "&modo=edicao";
				}
				url += "&";
			} else {
				url += templateDto.getUrlRecuperacao();
				url += "?";
			}
			String editar = "S";
			if (solicitacaoServicoDto.getIdSolicitacaoServico() != null && solicitacaoServicoDto.getIdSolicitacaoServico().intValue() > 0) {
				url += "idSolicitacaoServico=" + solicitacaoServicoDto.getIdSolicitacaoServico() + "&";
				if (solicitacaoServicoDto.getIdTarefa() == null) {
					editar = "N";
				} else {
					url += "idTarefa=" + solicitacaoServicoDto.getIdTarefa() + "&";
			}
			}
			url += "idServico=2007&idContrato=" + solicitacaoServicoDto.getIdContrato();
			url += "&editar=" + editar;
		}
		return url;
	}

	@Override
	public void gravaInformacoesGED(Collection colArquivosUpload, int idEmpresa, SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		// Setando a transaction no GED
		ControleGEDDao controleGEDDao = new ControleGEDDao();
		if (tc != null) {
			controleGEDDao.setTransactionControler(tc);
		}

		String PRONTUARIO_GED_DIRETORIO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "");
		if (PRONTUARIO_GED_DIRETORIO == null || PRONTUARIO_GED_DIRETORIO.trim().equalsIgnoreCase("")) {
			PRONTUARIO_GED_DIRETORIO = "";
		}

		if (PRONTUARIO_GED_DIRETORIO.equalsIgnoreCase("")) {
			PRONTUARIO_GED_DIRETORIO = Constantes.getValue("DIRETORIO_GED");
		}

		if (PRONTUARIO_GED_DIRETORIO == null || PRONTUARIO_GED_DIRETORIO.equalsIgnoreCase("")) {
			PRONTUARIO_GED_DIRETORIO = "/ged";
		}
		String PRONTUARIO_GED_INTERNO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, "S");
		if (PRONTUARIO_GED_INTERNO == null) {
			PRONTUARIO_GED_INTERNO = "S";
		}
		String prontuarioGedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD, "N");
		if (!UtilStrings.isNotVazio(prontuarioGedInternoBancoDados)) {
			prontuarioGedInternoBancoDados = "N";
		}
		String pasta = "";
		if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S")) {
			pasta = controleGEDDao.getProximaPastaArmazenar();
			File fileDir = new File(PRONTUARIO_GED_DIRETORIO);
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
			fileDir = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa);
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
			fileDir = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta);
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
		}

		for (Iterator it = colArquivosUpload.iterator(); it.hasNext();) {
			UploadDTO uploadDTO = (UploadDTO) it.next();
			ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
			controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_SOLICITACAOSERVICO);
			controleGEDDTO.setId(solicitacaoServicoDto.getIdSolicitacaoServico());
			controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
			controleGEDDTO.setDescricaoArquivo(uploadDTO.getDescricao());
			controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDTO.getNameFile()));
			controleGEDDTO.setPasta(pasta);
			controleGEDDTO.setNomeArquivo(uploadDTO.getNameFile());

			if (!uploadDTO.getTemporario().equalsIgnoreCase("S")) { // Se nao //
																	// for //
																	// temporario
				continue;
			}

			if (PRONTUARIO_GED_INTERNO.trim().equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados.trim())) { // Se
				// utiliza
				// GED
				// interno e eh BD
				controleGEDDTO.setPathArquivo(uploadDTO.getPath()); // Isso vai
																	// fazer a
																	// gravacao
																	// no BD.
																	// dento do
																	// create
																	// abaixo.
			} else {
				controleGEDDTO.setPathArquivo(null);
			}
			controleGEDDTO = (ControleGEDDTO) controleGEDDao.create(controleGEDDTO);
			if (controleGEDDTO != null) {
				uploadDTO.setIdControleGED(controleGEDDTO.getIdControleGED());
			}
			if (PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)) { // Se
																															// utiliza
																															// GED
				// interno e nao eh BD
				if (controleGEDDTO != null) {
					try {
						File arquivo = new File(PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + "."
								+ Util.getFileExtension(uploadDTO.getNameFile()));
						CriptoUtils.encryptFile(uploadDTO.getPath(), PRONTUARIO_GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged", System
								.getProperties().get("user.dir") + Constantes.getValue("CAMINHO_CHAVE_PUBLICA"));
						arquivo.delete();
					} catch (Exception e) {

					}

				}
			} /*
			 * else if (!PRONTUARIO_GED_INTERNO.equalsIgnoreCase("S")) { // Se // utiliza // GED // externo // FALTA IMPLEMENTAR!!! }
			 */
		}
		Collection<ControleGEDDTO> colAnexo = controleGEDDao.listByIdTabelaAndIdBaseConhecimento(ControleGEDDTO.TABELA_SOLICITACAOSERVICO, solicitacaoServicoDto.getIdSolicitacaoServico());
		if (colAnexo != null) {
			for (ControleGEDDTO dtoGed : colAnexo) {
				boolean b = false;
				for (Iterator it = colArquivosUpload.iterator(); it.hasNext();) {
					UploadDTO uploadDTO = (UploadDTO) it.next();
					if (uploadDTO.getIdControleGED() == null) {
						b = true;
						break;
					}
					if (uploadDTO.getIdControleGED().intValue() == dtoGed.getIdControleGED().intValue()) {
						b = true;
					}
					if (b) {
						break;
					}
				}
				if (!b) {
					controleGEDDao.delete(dtoGed);
				}
			}
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listAll() throws Exception {
		return null;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listAllIncidentes(Integer idEmpregado) throws Exception {
		return this.getDao().listAllIncidentes(idEmpregado);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listAllServicos() throws Exception {
		return this.getDao().listAllServicos();
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listAllServicosLikeNomeServico(String nome) throws Exception {
		return this.getDao().listAllServicosLikeNomeServico(nome);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorFase(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorFase(solicitacaoDto);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listarSLA() throws Exception {
		return this.getDao().listarSLA();
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorGrupo(HttpServletRequest request, SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorGrupo = this.getDao(
				solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorGrupo(
				solicitacaoDto);
		return listaQuantidadeSolicitacaoPorGrupo;
					}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorHoraAbertura(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorHoraAbertura(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorItemConfiguracao(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorItemConfiguracao(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorOrigem(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorOrigem(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorPesquisaSatisfacao(HttpServletRequest request, SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorPesquisaSatisfacao = this.getDao(
				solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorPesquisaSatisfacao(
				solicitacaoDto);
		for (RelatorioQuantitativoSubRelatorioDTO relatorioQuantitativoSubRelatorioDTO : listaQuantidadeSolicitacaoPorPesquisaSatisfacao) {
			relatorioQuantitativoSubRelatorioDTO.setNota(UtilI18N.internacionaliza(request, Nota.getNotaChaveInternacionalizada(Integer.parseInt(relatorioQuantitativoSubRelatorioDTO.getNota().trim()))));
				}
		return listaQuantidadeSolicitacaoPorPesquisaSatisfacao;
			}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorPrioridade(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorPrioridade(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorResponsavel(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorResponsavel(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSolicitacaoDTO> listaQuantidadeSolicitacaoPorServico(
			SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		return this.getDao(solicitacaoServicoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null)
				.listaQuantidadeSolicitacaoPorServico(solicitacaoServicoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSolicitacaoDTO> listaServicosAbertosAprovados(SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaServicosAbertosAprovados(solicitacaoServicoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorSituacao(SolicitacaoServicoDTO solicitacaoDto) throws Exception {

		Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorSituacao = null;
		try {
			listaQuantidadeSolicitacaoPorSituacao = getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null)
							.listaQuantidadeSolicitacaoPorSituacao(solicitacaoDto);
		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return listaQuantidadeSolicitacaoPorSituacao;
	}

	@Override
	public Collection<RelatorioQuantitativoSolicitacaoDTO> listaQuantidadeSolicitacaoPorSituacaoSLA(HttpServletRequest request, SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		List<RelatorioQuantitativoSolicitacaoDTO> listaQuantidadeSolicitacaoPorSituacaoSLA = this.getDao().listaQuantidadeSolicitacaoPorSituacaoSLA(solicitacaoDto);

		// A LISTA DEVE TER APENAS DOIS REGISTROS: QUANTIDADE DE ATRAZOS DE SLA (PRIMEIRO) E QUANTIDADE DE SLA DENTRO DO PRAZO (SEGUNDO)
		if (listaQuantidadeSolicitacaoPorSituacaoSLA != null && listaQuantidadeSolicitacaoPorSituacaoSLA.size() == 2) {
			listaQuantidadeSolicitacaoPorSituacaoSLA.get(0).setSituacaoSLA(UtilI18N.internacionaliza(request, "citcorpore.comum.comAtraso"));
			listaQuantidadeSolicitacaoPorSituacaoSLA.get(1).setSituacaoSLA(UtilI18N.internacionaliza(request, "citcorpore.comum.semAtraso"));
		}

		return listaQuantidadeSolicitacaoPorSituacaoSLA;
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorSolicitante(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorSolicitante(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorTipo(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorTipo(solicitacaoDto);
	}

	@Override
	public Collection<RelatorioQuantitativoSubRelatorioDTO> listaQuantidadeSolicitacaoPorTipoServico(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return this.getDao(solicitacaoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaQuantidadeSolicitacaoPorTipoServico(solicitacaoDto);
	}

	@Override
	public String listaServico(Integer idSolicitacaoservico) throws Exception {
		return this.getDao().listaServico(idSolicitacaoservico);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaSolicitacaoPorBaseConhecimento(SolicitacaoServicoDTO solicitacao) throws Exception {
		Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorBaseConhecimento = null;

		try {
			listaSolicitacaoServicoPorBaseConhecimento = getDao().listaSolicitacaoPorBaseConhecimento(solicitacao);
			if (listaSolicitacaoServicoPorBaseConhecimento != null) {
				for (SolicitacaoServicoDTO solicitacaoServicoDto : listaSolicitacaoServicoPorBaseConhecimento) {
					Source source = new Source(solicitacaoServicoDto.getDescricao());
					solicitacaoServicoDto.setDescricao(source.getTextExtractor().toString());
					}
				}
		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return listaSolicitacaoServicoPorBaseConhecimento;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listPesquisaAvancadaRelatorioDetalhado(PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto) throws Exception {
		Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios = null;

		try {

			listaSolicitacaoServicoPorCriterios = getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listPesquisaAvancadaRelatorioDetalhado(pesquisaSolicitacaoServicoDto);

		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return listaSolicitacaoServicoPorCriterios;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorServicoContrato(Integer idServicoContratoContabil) throws Exception {
		try {
			return this.getDao().listaSolicitacaoServicoPorServicoContrato(idServicoContratoContabil);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection listaSolicitacoesSemPesquisaSatisfacao() throws Exception {
		return this.getDao().listaSolicitacoesSemPesquisaSatisfacao();
	}

	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, TransactionControler tc) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDto = new ArrayList();

		listSolicitacaoServicoDto = this.getDao().listByTarefas(listTarefas);

		if (listSolicitacaoServicoDto != null && !listSolicitacaoServicoDto.isEmpty()) {

			for (SolicitacaoServicoDTO solicitacaoDto : listSolicitacaoServicoDto) {

				if (solicitacaoDto != null) {
					solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());
					solicitacaoDto.setDataHoraInicioSLA(solicitacaoDto.getDataHoraInicioSLA());

					solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
					if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
					}

					if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
					}

					solicitacaoDto = this.verificaSituacaoSLA(solicitacaoDto, tc);
				}
			}
		}
		return listSolicitacaoServicoDto;
	}

	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, TipoSolicitacaoServico[] tiposSolicitacao, TransactionControler tc) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDto = new ArrayList();

		listSolicitacaoServicoDto = this.getDao().listByTarefas(listTarefas, tiposSolicitacao);

		if (listSolicitacaoServicoDto != null && !listSolicitacaoServicoDto.isEmpty()) {

			for (SolicitacaoServicoDTO solicitacaoDto : listSolicitacaoServicoDto) {

				if (solicitacaoDto != null) {
					solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());
					solicitacaoDto.setDataHoraInicioSLA(solicitacaoDto.getDataHoraInicioSLA());

					solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
					if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
					}

					if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
					}

					solicitacaoDto = this.verificaSituacaoSLA(solicitacaoDto, tc);
				}
			}
		}
		return listSolicitacaoServicoDto;
	}

	@Override
	public SolicitacaoServicoDTO listIdentificacao(Integer idItemConfiguracao) throws Exception {

		try {
			return this.getDao().listIdentificacao(idItemConfiguracao);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listIncidentesNaoFinalizados() throws Exception {
		try {
			return this.getSolicitacaoServicoDao().listIncidentesNaoFinalizados();
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public SolicitacaoServicoDTO listInformacaoContato(String nomeContato) throws Exception {
		try {
			return this.getDao().retornaSolicitacaoServicoComInformacoesDoContato(nomeContato);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * Retorna Solicita��es de Servios de acordo com o Tipo de Demanda e Usu�rio.
	 *
	 * @param tipoDemandaServico
	 * @param grupoSeguranca
	 * @param usuario
	 * @return
	 * @throws Exception
	 */
	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacaoServico(String tipoDemandaServico, GrupoDTO grupoSeguranca, UsuarioDTO usuario, Date dataInicio, Date dataFim, Integer idStatus)
			throws Exception {
		try {
			return getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listSolicitacaoServico(tipoDemandaServico, grupoSeguranca, usuario, dataInicio, dataFim, idStatus);
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacaoServicoByCriterios(Collection colCriterios) throws Exception {
		Collection<SolicitacaoServicoDTO> listaSolicitacaoServico = null;

		try {

			listaSolicitacaoServico = getDao().listSolicitacaoServicoByCriterios(colCriterios);

			/*
			 * for (SolicitacaoServicoDTO solicitacaoServicoDto : listaSolicitacaoServico) { Source source = new Source(solicitacaoServicoDto.getDescricao()); solicitacaoServicoDto
			 * .setDescricao(source.getTextExtractor().toString());
			 * if (solicitacaoServicoDto.getSituacao().equalsIgnoreCase("Fechada")) { SolicitacaoServicoDTO solicitacao = new SolicitacaoServicoDTO();
			 * solicitacao.setIdSolicitacaoServico(solicitacaoServicoDto .getIdSolicitacaoServico()); solicitacao = (SolicitacaoServicoDTO) this.restore(solicitacao); solicitacaoServicoDto
			 * .setTempoAtendimentoHH(solicitacao.getTempoAtendimentoHH()); solicitacaoServicoDto .setTempoAtendimentoMM(solicitacao.getTempoAtendimentoMM()); }
			 * if (StringUtils.contains(StringUtils.upperCase(solicitacaoServicoDto .getSituacao()), StringUtils.upperCase("EmAndamento"))) { solicitacaoServicoDto.setSituacao("Em Andamento"); }
			 * }
			 */

		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return listaSolicitacaoServico;
	}

	@Override
	public List<SolicitacaoServicoDTO> listSolicitacaoServicoByItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().listSolicitacaoServicoByItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public List<SolicitacaoServicoDTO> listIncidentesByItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().listIncidentesByItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public List<SolicitacaoServicoDTO> listSolicitacoesByItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().listSolicitacoesByItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public Integer listQuantidadeIncidentesByItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().listQuantidadeIncidentesByItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public Integer listQuantidadeSolicitacoesByItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().listQuantidadeSolicitacoesByItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacaoServicoEmAndamento(Integer idSolicitacaoServico) {
		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoEmAndamento = new ArrayList<SolicitacaoServicoDTO>();

		try {

			listSolicitacaoServicoEmAndamento = this.getDao().listSolicitacaoServicoEmAndamento(idSolicitacaoServico);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return listSolicitacaoServicoEmAndamento;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacaoServicoNaoFinalizadas() throws Exception {
		try {
			return this.getSolicitacaoServicoDao().listSolicitacaoServicoNaoFinalizadas();
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionada(int idSolicitacaoPai) {

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionada = new ArrayList<SolicitacaoServicoDTO>();

		try {

			listSolicitacaoServicoRelacionada = this.getDao().listSolicitacaoServicoRelacionada(idSolicitacaoPai);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return listSolicitacaoServicoRelacionada;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionadaPai(int idSolicitacaoPai) {

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionada = new ArrayList<SolicitacaoServicoDTO>();

		try {

			listSolicitacaoServicoRelacionada = this.getDao().listSolicitacaoServicoRelacionadaPai(idSolicitacaoPai);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return listSolicitacaoServicoRelacionada;
	}

	public Collection<SolicitacaoServicoDTO> listSolicitacoesFilhas(TransactionControler tc) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}
		return this.getDao().listSolicitacoesFilhas();
	}

	@Override
	public Collection<SolicitacaoServicoDTO> quantidadeSolicitacaoPorBaseConhecimento(SolicitacaoServicoDTO solicitacao) throws Exception {
		return this.getDao().quantidadeSolicitacaoPorBaseConhecimento(solicitacao);
	}

	@Override
	public void reabre(UsuarioDTO usuarioDto, SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		try {
			tc.start();

			reabre(usuarioDto, solicitacaoServicoDto, tc);

			tc.commit();

		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		}finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	public void reabre(UsuarioDTO usuarioDto, SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		SolicitacaoServicoDTO solicitacaoAuxDto = restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico(), tc);
		new ExecucaoSolicitacaoServiceEjb().reabre(usuarioDto, solicitacaoAuxDto, tc);
	}

	@Override
	public void reativa(UsuarioDTO usuarioDto, SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		try {
			tc.start();

			reativa(usuarioDto, solicitacaoServicoDto, tc);

			tc.commit();

		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		}finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	public void reativa(UsuarioDTO usuarioDto, SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		if(solicitacaoServicoDto.getSituacaoSLA()!=null && (solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase(SituacaoSLA.M.name()) || solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase(SituacaoSLA.A.name()))){
			new ExecucaoSolicitacaoServiceEjb().reativa(usuarioDto, solicitacaoServicoDto, tc);
		}
		else{
			SolicitacaoServicoDTO solicitacaoAuxDto = restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico(), tc);
			solicitacaoAuxDto.setIdTarefa(solicitacaoServicoDto.getIdTarefa());
			new ExecucaoSolicitacaoServiceEjb().reativa(usuarioDto, solicitacaoAuxDto, tc);
		}

	}

	@Override
	public FluxoDTO recuperaFluxo(SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		return recuperaFluxo(solicitacaoServicoDto, null);
	}

	public FluxoDTO recuperaFluxo(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		if (solicitacaoServicoDto == null || solicitacaoServicoDto.getIdSolicitacaoServico() == null) {
			throw new Exception(i18nMessage("solicitacaoservico.validacao.solicitacaoservico"));
		}

		FluxoDTO fluxoDto = null;
		ExecucaoSolicitacaoDao execucaoSolicitacaoDao = new ExecucaoSolicitacaoDao();
		if (tc != null) {
			execucaoSolicitacaoDao.setTransactionControler(tc);
		}
		Collection<ExecucaoSolicitacaoDTO> colExecucao = execucaoSolicitacaoDao.listByIdSolicitacao(solicitacaoServicoDto.getIdSolicitacaoServico());
		if (colExecucao != null && !colExecucao.isEmpty()) {
			fluxoDto = new FluxoDTO();
			ExecucaoSolicitacaoDTO execucaoDto = (ExecucaoSolicitacaoDTO) ((List) colExecucao).get(0);
			fluxoDto.setIdFluxo(execucaoDto.getIdFluxo());
			fluxoDto = (FluxoDTO) new FluxoDao().restore(fluxoDto);
		}

		return fluxoDto;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> relatorioControleSla(SolicitacaoServicoDTO solicitacao) throws Exception {
		return this.getDao(solicitacao.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).relatorioControleSla(solicitacao);
	}

	/**
	 * @param solicitacaoServicoDTO
	 * @return Coleo de Solicitao de servio com datas horas de sla da solicitacao servio.
	 * @throws Exception
	 */
	@Override
	public SolicitacaoServicoDTO relatorioControlePercentualQuantitativoSla(SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
		SolicitacaoServicoDTO solicitacaoServicoBean = solicitacaoServicoDTO;

		List<SolicitacaoServicoDTO> listSolicitacaoservico = (List<SolicitacaoServicoDTO>) this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).relatorioControleSla(solicitacaoServicoDTO);

		solicitacaoServicoBean.setMapPorcentagemSla(this.calculaProcentagemSLAComAtraso(listSolicitacaoservico));

		return solicitacaoServicoBean;
	}

	public Map<String, Object> calculaProcentagemSLAComAtraso(List<SolicitacaoServicoDTO> listSolicitacaoservico) {

		int[] totalPrioridade = { 0, 0, 0, 0, 0 };
		int[] totalPrioridadeDentroPrazoSla = { 0, 0, 0, 0, 0 };
		int[] totalPrioridadeForaPrazoSla = { 0, 0, 0, 0, 0 };

		double totalPrioridadeDentroPrazo = 0;
		double totalPrioridadeForaDoPrazo = 0;
		double totalPrioridadeGeral = 0;

		double[] percentualPrioridadeDentroSla = { 0, 0, 0, 0, 0 };
		double[] percentualPrioridadeForaSla = { 0, 0, 0, 0, 0 };
		double percentualTotalPrioridadeDentroSla = 0;
		double percentualTotalPrioridadeForaSla = 0;

		Map<String, Object> parametros = new HashMap<String, Object>();

		if (listSolicitacaoservico != null && listSolicitacaoservico.size() > 0) {
			for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacaoservico) {

				if (solicitacaoServicoDTO.getIdPrioridade() != null) {
					switch (solicitacaoServicoDTO.getIdPrioridade().intValue()) {
					case 1:
						totalPrioridade[0]++;
						if (solicitacaoServicoDTO.getAtrasoSLAStr() != null && solicitacaoServicoDTO.getAtrasoSLAStr().equalsIgnoreCase("S") || solicitacaoServicoDTO.getAtrasoSLA() > 0) {
							totalPrioridadeForaPrazoSla[0]++;
						} else {
							totalPrioridadeDentroPrazoSla[0]++;
						}
						break;
					case 2:
						totalPrioridade[1]++;
						if (solicitacaoServicoDTO.getAtrasoSLAStr() != null && solicitacaoServicoDTO.getAtrasoSLAStr().equalsIgnoreCase("S") || solicitacaoServicoDTO.getAtrasoSLA() > 0) {
							totalPrioridadeForaPrazoSla[1]++;
						} else {
							totalPrioridadeDentroPrazoSla[1]++;
						}
						break;
					case 3:
						totalPrioridade[2]++;
						if (solicitacaoServicoDTO.getAtrasoSLAStr() != null && solicitacaoServicoDTO.getAtrasoSLAStr().equalsIgnoreCase("S") || solicitacaoServicoDTO.getAtrasoSLA() > 0) {
							totalPrioridadeForaPrazoSla[2]++;
						} else {
							totalPrioridadeDentroPrazoSla[2]++;
						}
						break;
					case 4:
						totalPrioridade[3]++;
						if (solicitacaoServicoDTO.getAtrasoSLAStr() != null && solicitacaoServicoDTO.getAtrasoSLAStr().equalsIgnoreCase("S") || solicitacaoServicoDTO.getAtrasoSLA() > 0) {
							totalPrioridadeForaPrazoSla[3]++;
						} else {
							totalPrioridadeDentroPrazoSla[3]++;
						}
						break;
					case 5:
						totalPrioridade[4]++;
						if (solicitacaoServicoDTO.getAtrasoSLAStr() != null && solicitacaoServicoDTO.getAtrasoSLAStr().equalsIgnoreCase("S") || solicitacaoServicoDTO.getAtrasoSLA() > 0) {
							totalPrioridadeForaPrazoSla[4]++;
						} else {
							totalPrioridadeDentroPrazoSla[4]++;
						}

						break;
					default:
						break;
					}
				}
			}

			// Calcula Porcentagem dentro e fora do Prazo individual
			for (int i = 0; totalPrioridade.length > i; i++) {
				double prioridadeDentroPrazoSla = 0;
				double totalPrioridadeSla = 0;
				double prioridadeForaPrazoSla = 0;
				int prioridade = 1;
				prioridade += i;
				if (totalPrioridade[i] > 0) {
					// Verifica se existe sla dentro do pazo e calcula porcentagem
					if (totalPrioridadeDentroPrazoSla[i] > 0) {
						prioridadeDentroPrazoSla = totalPrioridadeDentroPrazoSla[i];
						totalPrioridadeSla = totalPrioridade[i];
						parametros.put("percentDentroSlaPrio" + prioridade, UtilFormatacao.formatDouble(prioridadeDentroPrazoSla / totalPrioridadeSla * 100, 2));
						parametros.put("quantDentroSlaPrio" + prioridade, UtilFormatacao.formatDouble(prioridadeDentroPrazoSla, 0));
						parametros.put("quantDentroSlaPrio" + prioridade, UtilFormatacao.formatDouble(prioridadeDentroPrazoSla, 0));
						totalPrioridadeDentroPrazo += prioridadeDentroPrazoSla;
					} else {
						parametros.put("percentDentroSlaPrio" + prioridade, "" + 0);
						parametros.put("quantDentroSlaPrio" + prioridade, UtilFormatacao.formatDouble(prioridadeDentroPrazoSla, 0));
					}
					// Verifica se existe sla fora do pazo e calcula porcentagem
					if (totalPrioridadeForaPrazoSla[i] > 0) {
						prioridadeForaPrazoSla = totalPrioridadeForaPrazoSla[i];
						totalPrioridadeSla = totalPrioridade[i];

						parametros.put("percentForaSlaPrio" + prioridade, UtilFormatacao.formatDouble(prioridadeForaPrazoSla / totalPrioridadeSla * 100, 2));
						parametros.put("quantForaSlaPrio" + prioridade, UtilFormatacao.formatDouble(prioridadeForaPrazoSla, 0));

						totalPrioridadeForaDoPrazo += prioridadeForaPrazoSla;
					} else {
						parametros.put("percentForaSlaPrio" + prioridade, "" + 0);
						parametros.put("quantForaSlaPrio" + prioridade, "" + 0);
					}
					parametros.put("totalPercentPri" + prioridade, UtilFormatacao.formatDouble(100.00, 0));
				} else {
					parametros.put("percentDentroSlaPrio" + prioridade, "" + 0);
					parametros.put("percentForaSlaPrio" + prioridade, "" + 0);
					parametros.put("quantDentroSlaPrio" + prioridade, "" + 0);
					parametros.put("quantForaSlaPrio" + prioridade, "" + 0);
					parametros.put("totalPercentPri" + prioridade, "" + 0);
				}

				parametros.put("totalQuantPri" + prioridade, UtilFormatacao.formatDouble(prioridadeForaPrazoSla + prioridadeDentroPrazoSla, 0));
			}
			// Calcula porcentagem dentro e fora do prazo total
			totalPrioridadeGeral = listSolicitacaoservico.size();
			percentualTotalPrioridadeDentroSla = totalPrioridadeDentroPrazo / totalPrioridadeGeral * 100;
			percentualTotalPrioridadeForaSla = totalPrioridadeForaDoPrazo / totalPrioridadeGeral * 100;

			// Carrega objeto de valores.
			parametros.put("totalPrioridadeDentroPrazo", "" + UtilFormatacao.formatDouble(totalPrioridadeDentroPrazo, 0));
			parametros.put("totalPrioridadeForaDoPrazo", "" + UtilFormatacao.formatDouble(totalPrioridadeForaDoPrazo, 0));
			parametros.put("totalPrioridadeGeral", "" + UtilFormatacao.formatDouble(totalPrioridadeGeral, 0));
			parametros.put("percentualTotalPrioridadeDentroSla", UtilFormatacao.formatDouble(percentualTotalPrioridadeDentroSla, 2));
			parametros.put("percentualTotalPrioridadeForaSla", UtilFormatacao.formatDouble(percentualTotalPrioridadeForaSla, 2));
			parametros.put("percentualTotalPrioridadeSla", UtilFormatacao.formatDouble(percentualTotalPrioridadeForaSla + percentualTotalPrioridadeDentroSla, 2));

		}
		return parametros;
	}

	public Collection<SolicitacaoServicoDTO> listarSLA(SolicitacaoServicoDTO solicitacao) throws Exception {
		return this.getDao().relatorioControleSla(solicitacao);
	}

	@Override
	public SolicitacaoServicoDTO restoreAll(Integer idSolicitacaoServico) throws Exception {
		return restoreAll(idSolicitacaoServico, null);
	}

	@Override
	public SolicitacaoServicoDTO restoreAll(Integer idSolicitacaoServico, TransactionControler tc) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}
		SolicitacaoServicoDTO solicitacaoDto = null;
		try {
			solicitacaoDto = this.getDao().restoreAll(idSolicitacaoServico);
		} catch (Exception e) {
			throw new Exception(i18nMessage("solicitacaoservico.erro.recuperardadosolicitacao") + " " + idSolicitacaoServico);
		}

		if (solicitacaoDto != null) {
			// Parece estranho, mas isto executa o metodo interno do DTO. Isto
			// eh necessario!!!
			solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());

			solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
			if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
				solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
			} else {
				solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante());
			}
			if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
				solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
		}
		}
		return verificaSituacaoSLA(solicitacaoDto, tc);
	}

	public SolicitacaoServicoDTO restoreByIdInstanciaFluxo(Integer idInstanciaFluxo, TransactionControler tc) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}
		SolicitacaoServicoDTO solicitacaoDto = null;
		try {
			solicitacaoDto = this.getDao().restoreByIdInstanciaFluxo(idInstanciaFluxo);
		} catch (Exception e) {
			System.out.println("CITSMART - Erro na recuperao dos dados da solicitao da instncia fluxo" + " "
					+ idInstanciaFluxo);

			e.printStackTrace();
		}

		if (solicitacaoDto != null) {
			// Parece estranho, mas isto executa o metodo interno do DTO. Isto eh necessario!!!
			solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());

			solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
			if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
				solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
			}

			if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
				solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
		}
		}
		return verificaSituacaoSLA(solicitacaoDto, tc);
	}

	@Override
	public SolicitacaoServicoDTO restoreByIdInstanciaFluxo(Integer idInstanciaFluxo) throws Exception {
		return restoreByIdInstanciaFluxo(idInstanciaFluxo, null);
	}

	@Override
	public SolicitacaoServicoDTO retornaSolicitacaoServicoComItemConfiguracaoDoSolicitante(String login) throws Exception {
		try {
			return this.getDao().retornaSolicitacaoServicoComItemConfiguracaoDoSolicitante(login);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void suspende(UsuarioDTO usuarioDto, SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		try {
			tc.start();
			suspende(usuarioDto, solicitacaoServicoDto, tc);
			tc.commit();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		}finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	public void suspende(UsuarioDTO usuarioDto, SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		if(solicitacaoServicoDto.getSituacaoSLA()!=null && (solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase(SituacaoSLA.M.name()) || solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase(SituacaoSLA.A.name()))){
			new ExecucaoSolicitacaoServiceEjb().suspende(usuarioDto, solicitacaoServicoDto, tc);
		}else{
			SolicitacaoServicoDTO solicitacaoAuxDto = restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico(), tc);
			solicitacaoAuxDto.setIdJustificativa(solicitacaoServicoDto.getIdJustificativa());
			solicitacaoAuxDto.setComplementoJustificativa(solicitacaoServicoDto.getComplementoJustificativa());
		}
	}

	@Override
	public boolean temSolicitacaoServicoAbertaDoEmpregado(Integer idEmpregado) {
		List retorno = null;
		ArrayList<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("idSolicitante", "=", idEmpregado));
		try {
			retorno = (List) getDao().findByCondition(condicoes, null);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if (retorno != null && retorno.size() > 0) {
			return retorno.get(0) == null ? false : true;
		} else {
			return false;
		}
	}

	@Override
	public void update(IDto model) throws LogicException, ServiceException {
		ExecucaoSolicitacaoServiceEjb execucaoSolicitacaoService = new ExecucaoSolicitacaoServiceEjb();
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			tc.start();

			// Faz validacao, caso exista.
			validaUpdate(model);

			IDto solicitacaoOld = this.restore(model);

			this.getDao().setTransactionControler(tc);
			this.getDao().updateNotNull(model);

			// Executa operacoes pertinentes ao negocio.
			SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) model;

			//valida email
			if(solicitacaoServicoDto.getEmailcontato() != null && !Util.isValidEmailAddress(solicitacaoServicoDto.getEmailcontato())){
				throw new LogicException(i18nMessage("citcorpore.validacao.emailInvalido"));
			}

			if (solicitacaoServicoDto.getIdTarefa() != null) {
				execucaoSolicitacaoService.executa(solicitacaoServicoDto, solicitacaoServicoDto.getIdTarefa(), solicitacaoServicoDto.getAcaoFluxo(), tc);
			}

			tc.commit();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	public void updateSimples(IDto model) throws LogicException, ServiceException {
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			tc.start();

			// Faz validacao, caso exista.
			validaUpdate(model);

			this.getDao().setTransactionControler(tc);
			this.getDao().update(model);

			// Executa operacoes pertinentes ao negocio.
			SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) model;

			tc.commit();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public IDto updateInfo(IDto model) throws ServiceException, LogicException {
		SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) model;
		TransactionControler tc = new TransactionControlerImpl( this.getDao().getAliasDB());
		try {
			tc.start();
			validaCreate(model);
			IDto solicitacaoOld = this.restore(model);
			updateInfo(solicitacaoServicoDto, tc, true);
			tc.commit();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}
		}
		return solicitacaoServicoDto;
	}


	/**
	 * Faz a atualizacao de informacoes da solicitacao, mas nao altera as informacoes da classificacao.
	 *
	 * @param model
	 * @return
	 * @throws ServiceException
	 * @throws LogicException
	 */
	 @Override
	 public SolicitacaoServicoDTO updateInfo(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc, boolean atualizarRelacionados) throws Exception{
		if(null != solicitacaoServicoDto){
			boolean mudancaDescricao = false;
			ExecucaoSolicitacaoServiceEjb execucaoSolicitacaoService = new ExecucaoSolicitacaoServiceEjb();
			ContatoSolicitacaoServicoDao contatoSolicitacaoServicoDao = new ContatoSolicitacaoServicoDao();
			SolicitacaoServicoProblemaDao solicitacaoServicoProblemaDao = new SolicitacaoServicoProblemaDao();
			LiberacaoSolicitacaoServicoDAO liberacaoSolicitacaoServicoDAO = new LiberacaoSolicitacaoServicoDAO();
			SolicitacaoServicoMudancaDao solicitacaoServicoMudancaDao = new SolicitacaoServicoMudancaDao();
			ConhecimentoSolicitacaoDao conhecimentoSolicitacaoDao = new ConhecimentoSolicitacaoDao();
			ItemCfgSolicitacaoServDAO itemCfgSolicitacaoServDAO = new ItemCfgSolicitacaoServDAO();
			ServicoContratoDao servicoContratoDao = new ServicoContratoDao();
			GrupoDao grupoDao = new GrupoDao();

			ContatoSolicitacaoServicoDTO contatoSolicitacaoServicoDTO = new ContatoSolicitacaoServicoDTO();

			SolicitacaoServicoDTO dtoAux = this.restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico());

			if (dtoAux != null && dtoAux.getDescricao() != null && StringUtils.isNotEmpty(dtoAux.getDescricao()) && solicitacaoServicoDto.getDescricao() != null && StringUtils.isNotEmpty(solicitacaoServicoDto.getDescricao())) {
				if(solicitacaoServicoDto.getDescricao().hashCode() == dtoAux.getDescricao().hashCode()){
					mudancaDescricao = true;
				}
			}

			this.getDao().setTransactionControler(tc);
			contatoSolicitacaoServicoDao.setTransactionControler(tc);
			solicitacaoServicoProblemaDao.setTransactionControler(tc);
			liberacaoSolicitacaoServicoDAO.setTransactionControler(tc);
			itemCfgSolicitacaoServDAO.setTransactionControler(tc);
			solicitacaoServicoMudancaDao.setTransactionControler(tc);
			conhecimentoSolicitacaoDao.setTransactionControler(tc);
			servicoContratoDao.setTransactionControler(tc);
			grupoDao.setTransactionControler(tc);

			//valida email
			if(solicitacaoServicoDto.getEmailcontato() != null && !Util.isValidEmailAddress(solicitacaoServicoDto.getEmailcontato())){
				throw new LogicException(i18nMessage("citcorpore.validacao.emailInvalido"));
			}

			// Executa operacoes pertinentes ao negocio.
			String nomeServicoAnterior = "";
			String nomeContratoAnterior = "";
			String strDescricaoAnterior = "";
			SolicitacaoServicoDTO solicitacaoServicoAux = (SolicitacaoServicoDTO) this.getDao().restore(solicitacaoServicoDto);
			if (solicitacaoServicoAux != null && solicitacaoServicoDto.getIdGrupoNivel1() == null) {
				solicitacaoServicoDto.setIdGrupoNivel1(solicitacaoServicoAux.getIdGrupoNivel1());
			}

			if (solicitacaoServicoDto.getReclassificar() != null && solicitacaoServicoDto.getReclassificar().equalsIgnoreCase("S")) {
				ServicoContratoDTO servicoContratoDto = servicoContratoDao.findByIdContratoAndIdServico(solicitacaoServicoDto.getIdContrato(), solicitacaoServicoDto.getIdServico());
				if (servicoContratoDto == null) {
					throw new LogicException(i18nMessage("solicitacaoservico.validacao.servicolocalizado"));
				}

				if (solicitacaoServicoDto.getIdServicoContrato() == null) {
					solicitacaoServicoDto.setIdServicoContrato(servicoContratoDto.getIdServicoContrato());
				}

				if (solicitacaoServicoDto.getIdGrupoNivel1() == null || solicitacaoServicoDto.getIdGrupoNivel1().intValue() <= 0) {
					Integer idGrupoNivel1 = null;
					if (servicoContratoDto.getIdGrupoNivel1() != null && servicoContratoDto.getIdGrupoNivel1().intValue() > 0) {
						idGrupoNivel1 = servicoContratoDto.getIdGrupoNivel1();
					} else {
						String idGrupoN1 = ParametroUtil.getValor(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1, tc, null);
						if (idGrupoN1 != null && !idGrupoN1.trim().equalsIgnoreCase("")) {
							try {
								idGrupoNivel1 = new Integer(idGrupoN1);
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					}
					if (idGrupoNivel1 == null || idGrupoNivel1.intValue() <= 0) {
						throw new LogicException(i18nMessage("solicitacaoservico.validacao.grupoatendnivel"));
					}
					GrupoDTO grupoDto = new GrupoDTO();
					grupoDto.setIdGrupo(idGrupoNivel1);
					grupoDto = (GrupoDTO) grupoDao.restore(grupoDto);
					if (grupoDto == null || grupoDto.getDataFim() != null) {
						throw new LogicException(i18nMessage("solicitacaoservico.validacao.grupoatendnivel"));
					}
					solicitacaoServicoDto.setIdGrupoNivel1(idGrupoNivel1);
				}

				if (solicitacaoServicoAux != null) {

					solicitacaoServicoDto.setDataHoraSolicitacao(solicitacaoServicoAux.getDataHoraSolicitacao());
					solicitacaoServicoDto.setDataHoraInicio(solicitacaoServicoAux.getDataHoraInicio());
					solicitacaoServicoDto.setDataHoraCaptura(solicitacaoServicoAux.getDataHoraCaptura());
					strDescricaoAnterior = solicitacaoServicoAux.getDescricao();

					ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();
					servicoContratoDTO.setIdServicoContrato(solicitacaoServicoAux.getIdServicoContrato());
					servicoContratoDTO = (ServicoContratoDTO) servicoContratoDao.restore(servicoContratoDTO);
					if (servicoContratoDTO != null) {
						ServicoDao servicoDao = new ServicoDao();
						servicoDao.setTransactionControler(tc);
						ServicoDTO servicoDto = new ServicoDTO();
						servicoDto.setIdServico(servicoContratoDTO.getIdServico());
						servicoDto = (ServicoDTO) servicoDao.restore(servicoDto);
						if (servicoDto != null) {
							nomeServicoAnterior = i18nMessage("citcorpore.comum.codigo") + ": " + servicoDto.getIdServico() + " - " + i18nMessage("citcorpore.comum.nome") + ": "
									+ servicoDto.getNomeServico();
						}
						ContratoDao contratoDao = new ContratoDao();
						contratoDao.setTransactionControler(tc);
						ContratoDTO contratoDto = new ContratoDTO();
						contratoDto.setIdContrato(servicoContratoDTO.getIdContrato());
						contratoDto = (ContratoDTO) contratoDao.restore(contratoDto);
						if (contratoDto != null) {
							nomeContratoAnterior = i18nMessage("citcorpore.comum.codigo") + ": " + contratoDto.getIdContrato() + " - " + i18nMessage("citcorpore.comum.numero") + ": "
									+ contratoDto.getNumero();
						}
					}
				}

				if (solicitacaoServicoDto.getIdGrupoNivel1() == null || solicitacaoServicoDto.getIdGrupoNivel1().intValue() <= 0) {
					Integer idGrupoNivel1 = null;
					if (servicoContratoDto.getIdGrupoNivel1() != null) {
						idGrupoNivel1 = servicoContratoDto.getIdGrupoNivel1();
					} else {
						String idGrupoN1 = ParametroUtil.getValor(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1, tc, null);
						if (idGrupoN1 != null && !idGrupoN1.trim().equalsIgnoreCase("")) {
							try {
								idGrupoNivel1 = new Integer(idGrupoN1);
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					}
					if (idGrupoNivel1 == null || idGrupoNivel1.intValue() <= 0) {
						throw new LogicException(i18nMessage("solicitacaoservico.validacao.grupoatendnivel"));
					}
					solicitacaoServicoDto.setIdGrupoNivel1(idGrupoNivel1);
				}

				if (solicitacaoServicoDto.getIdGrupoNivel1() == null || solicitacaoServicoDto.getIdGrupoNivel1().intValue() <= 0) {
					Integer idGrupoNivel1 = null;
					if (servicoContratoDto.getIdGrupoNivel1() != null) {
						idGrupoNivel1 = servicoContratoDto.getIdGrupoNivel1();
					} else {
						String idGrupoN1 = ParametroUtil.getValor(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1, tc, null);
						if (idGrupoN1 != null && !idGrupoN1.trim().equalsIgnoreCase("")) {
							try {
								idGrupoNivel1 = new Integer(idGrupoN1);
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					}
					if (idGrupoNivel1 == null || idGrupoNivel1.intValue() <= 0) {
						throw new LogicException("Grupo de atendimento nivel 1 no parametrizado");
					}
					solicitacaoServicoDto.setIdGrupoNivel1(idGrupoNivel1);
				}

				determinaPrioridadeEPrazo(solicitacaoServicoDto, tc);
			} else {
				solicitacaoServicoDto.setIdServico(null);
				solicitacaoServicoDto.setIdServicoContrato(null);
				solicitacaoServicoDto.setIdPrioridade(null);
				solicitacaoServicoDto.setPrazoCapturaHH(null);
				solicitacaoServicoDto.setPrazoCapturaMM(null);
				solicitacaoServicoDto.setPrazoHH(null);
				solicitacaoServicoDto.setPrazoMM(null);
				solicitacaoServicoDto.setDataHoraInicio(null);
				solicitacaoServicoDto.setDataHoraFim(null);
				solicitacaoServicoDto.setDataHoraLimite(null);
				solicitacaoServicoDto.setDataHoraSolicitacao(null);
				solicitacaoServicoDto.setIdTipoDemandaServico(null);
				solicitacaoServicoDto.setIdFaseAtual(null);
				solicitacaoServicoDto.setSlaACombinar(null);
			}

			if (solicitacaoServicoAux != null && !solicitacaoServicoAux.escalada() && solicitacaoServicoDto.escalada()) {
				String tipoCaptura = ParametroUtil.getValor(ParametroSistema.TIPO_CAPTURA_SOLICITACOES, tc, "1");
				if (tipoCaptura.equals("2")) {
					solicitacaoServicoDto.setDataHoraCaptura(solicitacaoServicoDto.getDataHoraInicio());
			}
			}

			this.getDao().updateNotNull(solicitacaoServicoDto);

			if (solicitacaoServicoAux != null && solicitacaoServicoAux.getIdTarefaEncerramento() == null && solicitacaoServicoDto.atendida()) {
			if (solicitacaoServicoDto.getIdTarefa() != null
					&& (solicitacaoServicoDto.getAcaoFluxo().equalsIgnoreCase(br.com.centralit.bpm.util.Enumerated.ACTION_START) || solicitacaoServicoDto.getAcaoFluxo().equalsIgnoreCase(
							br.com.centralit.bpm.util.Enumerated.ACTION_EXECUTE))) {
					solicitacaoServicoDto.setIdTarefaEncerramento(Long.valueOf(solicitacaoServicoDto.getIdTarefa()));
					this.getDao().atualizaIdTarefaEncerramento(solicitacaoServicoDto);
				}
			} else if (solicitacaoServicoAux != null && solicitacaoServicoAux.atendida() && !solicitacaoServicoDto.atendida()) {
				solicitacaoServicoDto.setIdTarefaEncerramento(null);
				this.getDao().atualizaIdTarefaEncerramento(solicitacaoServicoDto);
			}

			if (solicitacaoServicoDto.getInformacoesComplementares() != null || solicitacaoServicoDto.getSolicitacaoServicoQuestionarioDTO() != null) {
				TemplateSolicitacaoServicoDTO templateDto = new TemplateSolicitacaoServicoServiceEjb().recuperaTemplateServico(solicitacaoServicoDto);
				if (templateDto != null) {
					if (templateDto.isQuestionario()) {
						atualizaInformacoesQuestionario(solicitacaoServicoDto, tc);
					} else if (templateDto.getNomeClasseServico() != null) {
						ComplemInfSolicitacaoServicoService informacoesComplementaresService = getInformacoesComplementaresService(templateDto.getNomeClasseServico());
						informacoesComplementaresService.update(tc, solicitacaoServicoDto, solicitacaoServicoDto.getInformacoesComplementares());
					}
				}
			}

			UsuarioDTO usuarioDTO = new UsuarioDTO();
			usuarioDTO.setLogin(solicitacaoServicoDto.getRegistradoPor());
			if (solicitacaoServicoDto.getReclassificar() != null && solicitacaoServicoDto.getReclassificar().equalsIgnoreCase("S")) {
				String strRecl = i18nMessage("citcorpore.comum.reclassificaosolicitacao");
				strRecl += "\n" + i18nMessage("citcorpore.comum.servicoanterior") + ": " + nomeServicoAnterior;
				strRecl += "\n" + i18nMessage("citcorpore.comum.contratoanterior") + ": " + nomeContratoAnterior;
				strRecl += "\n" + i18nMessage("citcorpore.comum.descricaoanterior") + ": " + strDescricaoAnterior;
				OcorrenciaSolicitacaoServiceEjb.create(solicitacaoServicoDto, null, strRecl, OrigemOcorrencia.OUTROS, OccurrenceCategory.RECLASSIFICATION, null,
						OccurrenceCategory.RECLASSIFICATION.getI18NKey(), usuarioDTO, 0, null, tc);
			}
			if (solicitacaoServicoDto.getRegistroexecucao() != null && !solicitacaoServicoDto.getRegistroexecucao().trim().equalsIgnoreCase("")) {
				OcorrenciaSolicitacaoServiceEjb.create(solicitacaoServicoDto, null, solicitacaoServicoDto.getRegistroexecucao(), OrigemOcorrencia.OUTROS, OccurrenceCategory.REGISTRATION_EXECUTION, null,
						OccurrenceCategory.REGISTRATION_EXECUTION.getI18NKey(), usuarioDTO, 0, null, tc);
			}

			if(atualizarRelacionados){
				contatoSolicitacaoServicoDTO.setNomecontato(solicitacaoServicoDto.getNomecontato());
				contatoSolicitacaoServicoDTO.setEmailcontato(solicitacaoServicoDto.getEmailcontato());
				contatoSolicitacaoServicoDTO.setTelefonecontato(solicitacaoServicoDto.getTelefonecontato());
				contatoSolicitacaoServicoDTO.setObservacao(solicitacaoServicoDto.getObservacao());
				contatoSolicitacaoServicoDTO.setRamal(solicitacaoServicoDto.getRamal());

				if (CITCorporeUtil.SGBD_PRINCIPAL.equalsIgnoreCase("SQLSERVER")) {
					if (tc != null) {
						contatoSolicitacaoServicoDao.setTransactionControler(tc);
					}
				}

				if (solicitacaoServicoDto.getIdLocalidade() != null) {
					contatoSolicitacaoServicoDTO.setIdLocalidade(solicitacaoServicoDto.getIdLocalidade());
				}

				if (solicitacaoServicoDto.getIdContatoSolicitacaoServico() != null) {
					contatoSolicitacaoServicoDTO.setIdcontatosolicitacaoservico(solicitacaoServicoDto.getIdContatoSolicitacaoServico());
					contatoSolicitacaoServicoDao.update(contatoSolicitacaoServicoDTO);
				} else {
					contatoSolicitacaoServicoDTO = (ContatoSolicitacaoServicoDTO) contatoSolicitacaoServicoDao.create(contatoSolicitacaoServicoDTO);
				}
				solicitacaoServicoDto.setIdContatoSolicitacaoServico(contatoSolicitacaoServicoDTO.getIdcontatosolicitacaoservico());

				solicitacaoServicoProblemaDao.deleteByIdSolictacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				if (solicitacaoServicoDto.getColItensProblema() != null) {
					solicitacaoServicoProblemaDao.deleteByIdSolictacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
					for (Iterator it = solicitacaoServicoDto.getColItensProblema().iterator(); it.hasNext();) {
						ProblemaDTO problemaDTO = (ProblemaDTO) it.next();
						SolicitacaoServicoProblemaDTO solicitacaoServicoProblemaDTO = new SolicitacaoServicoProblemaDTO();
						solicitacaoServicoProblemaDTO.setIdProblema(problemaDTO.getIdProblema());
						solicitacaoServicoProblemaDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
						solicitacaoServicoProblemaDao.create(solicitacaoServicoProblemaDTO);
					}
				}

				liberacaoSolicitacaoServicoDAO.deleteByIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				if (solicitacaoServicoDto.getColItensLiberacao() != null) {
					for (Iterator it = solicitacaoServicoDto.getColItensLiberacao().iterator(); it.hasNext();) {
						RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) it.next();
						LiberacaoSolicitacaoServicoDTO liberacaoSolicitacaoServicoDTO = new LiberacaoSolicitacaoServicoDTO();
						liberacaoSolicitacaoServicoDTO.setIdLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
						liberacaoSolicitacaoServicoDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
						liberacaoSolicitacaoServicoDAO.create(liberacaoSolicitacaoServicoDTO);
					}
				}

				solicitacaoServicoMudancaDao.deleteByIdSolictacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				if (solicitacaoServicoDto.getColItensMudanca() != null) {
					for (Iterator it = solicitacaoServicoDto.getColItensMudanca().iterator(); it.hasNext();) {
						RequisicaoMudancaDTO requisicaoMudancaDTO = (RequisicaoMudancaDTO) it.next();

						SolicitacaoServicoMudancaDTO solicitacaoServicoMudancaDTO = new SolicitacaoServicoMudancaDTO();
						solicitacaoServicoMudancaDTO.setIdRequisicaoMudanca(requisicaoMudancaDTO.getIdRequisicaoMudanca());
						solicitacaoServicoMudancaDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
						solicitacaoServicoMudancaDao.create(solicitacaoServicoMudancaDTO);
					}
				}

				conhecimentoSolicitacaoDao.deleteByIdSolictacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				if (solicitacaoServicoDto.getColItensBaseConhecimento() != null) {
					for (Iterator it = solicitacaoServicoDto.getColItensBaseConhecimento().iterator(); it.hasNext();) {
						BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) it.next();

						ConhecimentoSolicitacaoDTO conhecimentoSolicitacaoDTO = new ConhecimentoSolicitacaoDTO();
						conhecimentoSolicitacaoDTO.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());
						conhecimentoSolicitacaoDTO.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
						conhecimentoSolicitacaoDao.create(conhecimentoSolicitacaoDTO);
					}
				}


				itemCfgSolicitacaoServDAO.deleteByIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());

				if (solicitacaoServicoDto.getColItensICSerialize() != null) {
					for (ItemConfiguracaoDTO bean : solicitacaoServicoDto.getColItensICSerialize()) {
						ItemCfgSolicitacaoServDTO dto = new ItemCfgSolicitacaoServDTO();
						dto.setIdItemConfiguracao(bean.getIdItemConfiguracao());
						dto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
						dto.setDataInicio(Util.getSqlDataAtual());

						itemCfgSolicitacaoServDAO.create(dto);
					}
				}

				if (solicitacaoServicoDto.getColArquivosUpload() != null) {
					gravaInformacoesGED(solicitacaoServicoDto.getColArquivosUpload(), 1, solicitacaoServicoDto, tc);
				}

			if (ServiceRequestStatus.SOLVED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					if (solicitacaoServicoDto.getBeanBaseConhecimento() != null && solicitacaoServicoDto.getBeanBaseConhecimento().getTitulo() != null && !solicitacaoServicoDto.getBeanBaseConhecimento().getTitulo().isEmpty()) {
						this.inserirNaBaseConhecimento(solicitacaoServicoDto, tc);
					}
				}
			}

			if (solicitacaoServicoDto.getIdTarefa() != null) {
				execucaoSolicitacaoService.executa(solicitacaoServicoDto, solicitacaoServicoDto.getIdTarefa(), solicitacaoServicoDto.getAcaoFluxo(), tc);
			}

			if (solicitacaoServicoAux != null && solicitacaoServicoDto.getIdGrupoAtual() != null
					&& UtilStrings.nullToVazio(solicitacaoServicoDto.getAcaoFluxo()).equals(br.com.centralit.bpm.util.Enumerated.ACTION_EXECUTE)
					&& (!solicitacaoServicoAux.escalada() || solicitacaoServicoAux.getIdGrupoAtual().intValue() != solicitacaoServicoDto.getIdGrupoAtual().intValue())) {
				execucaoSolicitacaoService.direcionaAtendimento(solicitacaoServicoDto, tc);
			}

			/*
			 * Bruno.aquino 29/05/2014 Se ocorrerem alguma alteraao na solicitao,  enviado um email ao solicitante informando que ocorreu alguma alterao. Se a alterao foi feita na Descrio da
			 * solicitao, ser enviado por email a descrio
			 * tambm.
			 */
			EmpregadoDao empregadoDao = new EmpregadoDao();
			if (dtoAux != null && dtoAux.getIdTipoDemandaServico().intValue() == 3
					&& (ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ATIVAR_ENVIO_EMAIL_UPDATE_INCIDENTE, "N").equalsIgnoreCase("S") || ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ATIVAR_ENVIO_EMAIL_UPDATE_INCIDENTE, "N").equalsIgnoreCase("Y"))) {
				SolicitacaoServicoDTO aux = solicitacaoServicoDto;
				EmpregadoDTO empregatoDto = empregadoDao.restoreByIdEmpregado(aux.getIdSolicitante());
				String emailPara = "";
				if(empregatoDto!=null){
					emailPara = empregatoDto.getEmail();
				}

					List<String> anexosEmail = new ArrayList<>();
					if(null != solicitacaoServicoDto.getColArquivosUpload()){
						Collection<UploadDTO> anexos = solicitacaoServicoDto.getColArquivosUpload();

						for (UploadDTO upload : anexos) {
							anexosEmail.add(upload.getPath());
						}
					}

			String remetente = ParametroUtil.getValor(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao);
				if (remetente != null && emailPara!=null && StringUtils.isNotEmpty(emailPara) && StringUtils.isNotEmpty(remetente) && empregatoDto != null) {
					if(!mudancaDescricao){
						ModeloEmailDTO modeloEmailDto = new ModeloEmailDao().findByIdentificador("alterSolServDesc");
						if(modeloEmailDto!=null){
								MensagemEmail mensagem = new MensagemEmail(modeloEmailDto.getIdModeloEmail(), new IDto[] { aux }, anexosEmail);
							if(mensagem!=null){
									mensagem.setAttachment(anexosEmail);
								mensagem.envia(emailPara, null, remetente);
							}

						}
					}else{
						ModeloEmailDTO modeloEmailDto = new ModeloEmailDao().findByIdentificador("alterSolServico");
						if(modeloEmailDto!=null){
								MensagemEmail mensagem = new MensagemEmail(modeloEmailDto.getIdModeloEmail(), new IDto[] { aux }, anexosEmail);
							if(mensagem!=null){
									mensagem.setAttachment(anexosEmail);
								mensagem.envia(emailPara, null, remetente);
							}
						}

					}
				}
			}
		}

		//Evitar registros duplicados do controle de SLA
		//registrarExecucaoDaSolicitacaoDeServico(solicitacaoServicoDto, ControleSLA.EXECUTADO.getId(), tc);
		return solicitacaoServicoDto;
	}

	/**
	 * Faz a atualizacao dos anexos da solicitacao, mas nao altera as informacoes da soliciao.
	 *
	 * @param model
	 * @return
	 * @throws ServiceException
	 * @throws LogicException
	 */

	@Override
	public IDto updateInfoCollection(IDto model) throws ServiceException, LogicException {
		SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) model;

		return solicitacaoServicoDto;
	}

	@Override
	public void updateNotNull(IDto obj) throws Exception {
		this.getDao().updateNotNull(obj);

	}

	@Override
	public void updateNotNull(IDto obj, final TransactionControler tc) throws Exception {
		if (tc == null) {
			this.updateNotNull(obj);
		}else{
			SolicitacaoServicoDao solicitacaoServicoDao = new SolicitacaoServicoDao();
			solicitacaoServicoDao.setTransactionControler(tc);
			solicitacaoServicoDao.updateNotNull(obj);
		}
	}

	/**
	 * Faz a mudanca de SLA
	 *
	 * @param model
	 * @return
	 * @throws ServiceException
	 * @throws LogicException
	 */
	@Override
	public void updateSLA(IDto model) throws ServiceException, LogicException {
		SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) model;
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {
			tc.start();

			// Faz validacao, caso exista.
			validaUpdate(model);

			this.getDao().setTransactionControler(tc);
			solicitacaoServicoDto.setDataHoraInicioSLA(null);
			solicitacaoServicoDto.setDataHoraReativacao(null);

			if (solicitacaoServicoDto.getTempoDecorridoHH() == null) {
				solicitacaoServicoDto.setTempoDecorridoHH(new Integer(0));
			}
			if (solicitacaoServicoDto.getTempoDecorridoMM() == null) {
				solicitacaoServicoDto.setTempoDecorridoMM(new Integer(0));
			}

			if (solicitacaoServicoDto.getSlaACombinar().equalsIgnoreCase("S")) {
				solicitacaoServicoDto.setPrazoCapturaHH(0);
				solicitacaoServicoDto.setPrazoCapturaMM(0);
				solicitacaoServicoDto.setPrazoHH(0);
				solicitacaoServicoDto.setPrazoMM(0);
			} else {
				SolicitacaoServicoDTO solicitacaoAuxDto = new SolicitacaoServicoDTO();
				solicitacaoAuxDto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
				solicitacaoAuxDto = (SolicitacaoServicoDTO) solicitacaoServicoDao.restore(solicitacaoAuxDto);
				solicitacaoServicoDto.setDataHoraInicioSLA(solicitacaoAuxDto.getDataHoraInicioSLA());
				solicitacaoServicoDto.setDataHoraReativacaoSLA(solicitacaoAuxDto.getDataHoraReativacaoSLA());
				determinaPrazoLimite(solicitacaoServicoDto, solicitacaoServicoDto.getIdCalendario(), tc);
			}

			solicitacaoServicoDao.updateNotNull(model);
			solicitacaoServicoDao.limpaDataReativacao(solicitacaoServicoDto);

			String strOcorr = "\n" + i18nMessage("gerenciaservico.mudarsla.tiposla") + ": ";
			if (solicitacaoServicoDto.getSlaACombinar().equalsIgnoreCase("S")) {
				strOcorr += i18nMessage("citcorpore.comum.acombinar");
			} else {
				strOcorr += i18nMessage("citcorpore.comum.definicaonovotempo");
			}

			strOcorr += "\n " + i18nMessage("gerenciamento.mudarsla.prazoanterior");
			if (solicitacaoServicoDto.getPrazohhAnterior() != null) {
				strOcorr += solicitacaoServicoDto.getPrazohhAnterior() + "h ";
			}
			if (solicitacaoServicoDto.getPrazommAnterior() != null) {
				strOcorr += solicitacaoServicoDto.getPrazommAnterior() + "m ";
			}

			JustificativaSolicitacaoDTO justificativaDto = new JustificativaSolicitacaoDTO();
			justificativaDto.setIdJustificativa(solicitacaoServicoDto.getIdJustificativa());
			justificativaDto.setComplementoJustificativa(solicitacaoServicoDto.getComplementoJustificativa());

			UsuarioDTO usuarioDTO = new UsuarioDTO();
			usuarioDTO.setLogin(solicitacaoServicoDto.getRegistradoPor());
			OcorrenciaSolicitacaoServiceEjb.create(solicitacaoServicoDto, null, strOcorr, OrigemOcorrencia.OUTROS, OccurrenceCategory.SLA_CHANGE, null, OccurrenceCategory.SLA_CHANGE.getI18NKey(),
					usuarioDTO, 0, justificativaDto, tc);

			solicitacaoServicoDto.setIdStatusControleSla(ControleSLA.ALTERADOSLA.getId());
			fecharUltimoControleSlaECriarNovoRegistro(solicitacaoServicoDto, tc);

			tc.commit();

		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	private void fecharUltimoControleSlaECriarNovoRegistro(SolicitacaoServicoDTO solicitacaoServicoDTO, TransactionControler tc) {
		try {
			ControleSlaDTO controleSla = getControleSLAService().fechaUltimoControleSla(solicitacaoServicoDTO, tc);
			if (controleSla != null && controleSla.getIdControleSla() != null) {
				solicitacaoServicoDTO.setDataFinalUltimoControleSla(controleSla.getDataFinal());
				getControleSLAService().registraControleSla(solicitacaoServicoDTO, tc);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 *
	 * @author breno.guimaraes
	 */
	@Override
	public void updateSolicitacaoPai(int idSolicitacaoPai, int idSolicitacao) {
		try {
			getDao().updateSolicitacaoPai(idSolicitacao, idSolicitacaoPai);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void updateTimeAction(Integer idGrupoRedirect, Integer idPrioridadeRedirect, Integer idSolicitacaoServicoParm, TransactionControler tc) throws ServiceException, LogicException {

		ExecucaoSolicitacaoServiceEjb execucaoSolicitacaoService = new ExecucaoSolicitacaoServiceEjb();
		OcorrenciaSolicitacaoDao ocorrenciaSolicitacaoDao = new OcorrenciaSolicitacaoDao();

		if(tc == null) {
			tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		}

		try {
			if(!tc.isStarted()) {
			tc.start();
			}

			this.getDao().setTransactionControler(tc);
			ocorrenciaSolicitacaoDao.setTransactionControler(tc);

			List<SolicitacaoServicoDTO> listaSolicitacao = new ArrayList<SolicitacaoServicoDTO>();

			SolicitacaoServicoDTO solicitacaoAuxDto = new SolicitacaoServicoDTO();
			solicitacaoAuxDto.setIdSolicitacaoServico(idSolicitacaoServicoParm);

			listaSolicitacao = (List<SolicitacaoServicoDTO>) this.getDao().find(solicitacaoAuxDto);
			if (listaSolicitacao != null) {
				solicitacaoAuxDto = listaSolicitacao.get(0);
			}

			SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();

			solicitacaoServicoDto.setIdGrupoAtual(idGrupoRedirect);
			solicitacaoServicoDto.setIdPrioridade(idPrioridadeRedirect);
			solicitacaoServicoDto.setIdSolicitacaoServico(idSolicitacaoServicoParm);

			this.getDao().updateNotNull(solicitacaoServicoDto);
			execucaoSolicitacaoService.direcionaAtendimentoAutomatico(solicitacaoServicoDto, tc);
			String strOcorr = "\nEscalao automtica.";


			JustificativaSolicitacaoDTO justificativaDto = new JustificativaSolicitacaoDTO();
			justificativaDto.setIdJustificativa(solicitacaoServicoDto.getIdJustificativa());
			justificativaDto.setComplementoJustificativa(solicitacaoServicoDto.getComplementoJustificativa());

			UsuarioDTO usuarioDTO = new UsuarioDTO();
			usuarioDTO.setLogin("Automtico");

			OcorrenciaSolicitacaoServiceEjb.create(solicitacaoServicoDto, null, strOcorr, OrigemOcorrencia.OUTROS, OccurrenceCategory.UPDATE_STATUS, null,
					OccurrenceCategory.UPDATE_STATUS.getI18NKey(), usuarioDTO, 0, justificativaDto, tc);

			tc.commit();

		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
			throw new ServiceException(e);
		} finally {
			try {
				tc.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
		}
	}
	}

	@Override
	protected void validaCreate(Object arg0) throws Exception {
	}

	@Override
	protected void validaDelete(Object arg0) throws Exception {
	}

	@Override
	protected void validaFind(Object arg0) throws Exception {
	}

	@Override
	protected void validaUpdate(Object arg0) throws Exception {
	}

	@Override
	public boolean verificarExistenciaDeUnidade(Integer idUnidade) throws Exception {
		return this.getDao().verificarExistenciaDeUnidade(idUnidade);
	}

	@Override
	public boolean verificarExistenciaSolicitacaoFilho(Integer idSolicitacaoServicoPai) throws Exception {

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoFilho = new ArrayList<SolicitacaoServicoDTO>();

		listSolicitacaoServicoFilho = this.getDao().findByIdSolicitacaoPai(idSolicitacaoServicoPai);

		if (listSolicitacaoServicoFilho != null && !listSolicitacaoServicoFilho.isEmpty()) {

			return true;

		} else {

			return false;

		}
	}

	@Override
	public SolicitacaoServicoDTO verificaSituacaoSLA(SolicitacaoServicoDTO solicitacaoDto) throws Exception {
		return verificaSituacaoSLA(solicitacaoDto, null);
	}

	public SolicitacaoServicoDTO verificaSituacaoSLA(SolicitacaoServicoDTO solicitacaoDto, TransactionControler tc) throws Exception {
 		long atrasoSLA = 0;

		if (solicitacaoDto == null) {
			return null;
		}
		/**
		 * No calcula o atraso dos SLAs a combinar
		 */
		boolean slaACombinar = (solicitacaoDto.getPrazoHH() == null || solicitacaoDto.getPrazoHH() == 0) && (solicitacaoDto.getPrazoMM() == null || solicitacaoDto.getPrazoMM() == 0);

		if (solicitacaoDto.getDataHoraLimite() == null) {
			determinaPrazoLimite(solicitacaoDto, null, tc);
		}

		if (!slaACombinar && solicitacaoDto.getDataHoraLimite() != null && solicitacaoDto.getIdStatus() != null) {
			boolean bCalcula = true;
			Timestamp dataFimConsiderada = solicitacaoDto.getDataHoraFim() == null ? UtilDatas.getDataHoraAtual() : solicitacaoDto.getDataHoraFim();
			Timestamp dataHoraComparacao = null;

			/*
			 * Desenvolvedor: Euler Ramos, Joo Morais - Data: 22/06/2015 - Horrio: 15:45 - ID Citsmart: 190058 - Motivo/Comentrio: Evitar NullPointerException.
			 */
			if (ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoDto.getIdStatus()) && solicitacaoDto.getSituacaoSLA() != null && solicitacaoDto.getSituacaoSLA().equalsIgnoreCase("S") && solicitacaoDto.getDataHoraSuspensaoSLA() != null) {
				bCalcula = solicitacaoDto.getDataHoraSuspensaoSLA().compareTo(solicitacaoDto.getDataHoraLimite()) > 0;
				dataHoraComparacao = solicitacaoDto.getDataHoraSuspensaoSLA();
			} else if (ServiceRequestStatus.CANCELED.getId().equals(solicitacaoDto.getIdStatus())) {
				bCalcula = false;
			} else {
				bCalcula = dataFimConsiderada.compareTo(solicitacaoDto.getDataHoraLimite()) > 0;
				dataHoraComparacao = dataFimConsiderada;
			}

			if (bCalcula && dataHoraComparacao != null && dataHoraComparacao.compareTo(solicitacaoDto.getDataHoraLimite()) > 0) {
				atrasoSLA = UtilDatas.calculaDiferencaTempoEmMilisegundos(dataHoraComparacao, solicitacaoDto.getDataHoraLimite()) / 1000;
			}
		}

		solicitacaoDto.setAtrasoSLA(atrasoSLA);

		if (solicitacaoDto.getIdCalendario() == null) {
			determinaCalendario(solicitacaoDto);
		}
		return solicitacaoDto;
	}

	/**
	 * Mtodo que calcula o atraso das SLAs que no esto a combinar e com situao diferentes de suspensa e cancelada
	 *
	 * @param solicitacaoDto
	 * @param tc
	 * @return SolicitacaoServicoDTO
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	@Deprecated
	public SolicitacaoServicoDTO verificaSituacaoSLAsValidas(SolicitacaoServicoDTO solicitacaoDto, TransactionControler tc) throws Exception {
		long atrasoSLA = 0;

		if (solicitacaoDto == null) {
			return null;
		}

		boolean slaACombinar = (solicitacaoDto.getPrazoHH() == null || solicitacaoDto.getPrazoHH() == 0) && (solicitacaoDto.getPrazoMM() == null || solicitacaoDto.getPrazoMM() == 0);

		if (solicitacaoDto.getDataHoraLimite() == null) {
			determinaPrazoLimite(solicitacaoDto, null, tc);
		}

		if (solicitacaoDto.getDataHoraLimite() != null && !slaACombinar && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoDto.getIdStatus()) && !ServiceRequestStatus.CANCELED.getId().equals(solicitacaoDto.getIdStatus())) {
			boolean bCalcula = true;
			if (solicitacaoDto.getSituacaoSLA() != null && solicitacaoDto.getSituacaoSLA().equalsIgnoreCase("S")) {
				bCalcula = solicitacaoDto.getDataHoraSuspensaoSLA().compareTo(solicitacaoDto.getDataHoraLimite()) > 0;
			}
			if (bCalcula) {
				Timestamp dataHoraLimite = solicitacaoDto.getDataHoraLimite();
				Timestamp dataHoraComparacao = UtilDatas.getDataHoraAtual();
				if (solicitacaoDto.encerrada()) {
					dataHoraComparacao = solicitacaoDto.getDataHoraFim();
				}
				if (dataHoraComparacao != null) {
					if (dataHoraComparacao.compareTo(dataHoraLimite) > 0) {
						atrasoSLA = UtilDatas.calculaDiferencaTempoEmMilisegundos(dataHoraComparacao, dataHoraLimite) / 1000;
					}
				}
			}
		}

		solicitacaoDto.setAtrasoSLA(atrasoSLA);
		return solicitacaoDto;
	}

	@Override
	public Collection incidentesPorContrato(Integer idContrato) throws Exception {
		return this.getDao().incidentesPorContrato(idContrato);

	}

	public void atualizaInformacoesQuestionario(SolicitacaoServicoDTO solicitacaoServicoDto, TransactionControler tc) throws Exception {
		ControleQuestionariosDao controleQuestionariosDao = new ControleQuestionariosDao();
		SolicitacaoServicoQuestionarioDao solicitacaoServicoQuestionarioDao = new SolicitacaoServicoQuestionarioDao();
		RespostaItemQuestionarioDao respostaItemDao = new RespostaItemQuestionarioDao();
		RespostaItemQuestionarioServiceBean respostaItemQuestionarioServiceBean = new RespostaItemQuestionarioServiceBean();

		controleQuestionariosDao.setTransactionControler(tc);
		solicitacaoServicoQuestionarioDao.setTransactionControler(tc);
		respostaItemDao.setTransactionControler(tc);

		SolicitacaoServicoQuestionarioDTO solicitacaoServicoQuestionarioDto = solicitacaoServicoDto.getSolicitacaoServicoQuestionarioDTO();
		if (solicitacaoServicoQuestionarioDto.getIdSolicitacaoQuestionario() != null && solicitacaoServicoQuestionarioDto.getIdSolicitacaoQuestionario().intValue() > 0) {
			solicitacaoServicoQuestionarioDto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
			solicitacaoServicoQuestionarioDto.setDataHoraGrav(UtilDatas.getDataHoraAtual());
			solicitacaoServicoQuestionarioDao.updateNotNull(solicitacaoServicoQuestionarioDto);

			respostaItemDao.deleteByIdIdentificadorResposta(solicitacaoServicoQuestionarioDto.getIdSolicitacaoQuestionario());
			respostaItemQuestionarioServiceBean.processCollection(tc, solicitacaoServicoQuestionarioDto.getColValores(), solicitacaoServicoQuestionarioDto.getColAnexos(),
					solicitacaoServicoQuestionarioDto.getIdSolicitacaoQuestionario(), null);
		} else {
			ControleQuestionariosDTO controleQuestionariosDto = new ControleQuestionariosDTO();
			controleQuestionariosDto = (ControleQuestionariosDTO) controleQuestionariosDao.create(controleQuestionariosDto);

			solicitacaoServicoQuestionarioDto.setIdSolicitacaoServico(solicitacaoServicoDto.getIdSolicitacaoServico());
			solicitacaoServicoQuestionarioDto.setIdResponsavel(solicitacaoServicoDto.getUsuarioDto().getIdEmpregado());
			solicitacaoServicoQuestionarioDto.setIdTarefa(solicitacaoServicoDto.getIdTarefa());
			if (solicitacaoServicoQuestionarioDto.getDataQuestionario() == null) {
				solicitacaoServicoQuestionarioDto.setDataQuestionario(UtilDatas.getDataAtual());
			}
			solicitacaoServicoQuestionarioDto.setSituacao("E");
			solicitacaoServicoQuestionarioDto.setIdSolicitacaoQuestionario(controleQuestionariosDto.getIdControleQuestionario());
			solicitacaoServicoQuestionarioDto.setDataHoraGrav(UtilDatas.getDataHoraAtual());
			SolicitacaoServicoQuestionarioDTO solQuestionariosDTO = (SolicitacaoServicoQuestionarioDTO) solicitacaoServicoQuestionarioDao.create(solicitacaoServicoQuestionarioDto);

			Integer idIdentificadorResposta = solQuestionariosDTO.getIdSolicitacaoQuestionario();
			respostaItemQuestionarioServiceBean.processCollection(tc, solQuestionariosDTO.getColValores(), solQuestionariosDTO.getColAnexos(), idIdentificadorResposta, null);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriteriosPaginado(PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, String paginacao, Integer pagAtual,
			Integer pagAtualAux, Integer totalPag, Integer quantidadePaginator, String campoPesquisa) throws Exception {
		try {
			return this.getDao().findByIdContratoPaginada(pesquisaSolicitacaoServicoDto, paginacao, pagAtual, pagAtualAux, totalPag, quantidadePaginator, campoPesquisa);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriteriosPaginado(PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, String paginacao, Integer pagAtual,
			Integer pagAtualAux, Integer totalPag, Integer quantidadePaginator, String campoPesquisa, Collection<UnidadeDTO> unidadesColaborador) throws Exception {
		try {
			return this.getDao().findByIdContratoPaginada(pesquisaSolicitacaoServicoDto, paginacao, pagAtual, pagAtualAux, totalPag, quantidadePaginator, campoPesquisa, unidadesColaborador);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}


	@Override
	public String calculaSLA(SolicitacaoServicoDTO solicitacaoServicoDto, HttpServletRequest request) throws Exception {
		Integer prazoHH = 0;
		Integer prazoMM = 0;

		TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
		AcordoNivelServicoDao acordoNivelServicoDao = new AcordoNivelServicoDao();
		AcordoServicoContratoDao acordoServicoContratoDao = new AcordoServicoContratoDao();
		PrioridadeServicoUnidadeDao prioridadeServicoUnidadeDao = new PrioridadeServicoUnidadeDao();
		EmpregadoDao empregadoDao = new EmpregadoDao();
		MatrizPrioridadeDAO matrizPrioriDao = new MatrizPrioridadeDAO();
		ServicoContratoDao servicoContratoDao = new ServicoContratoDao();
		PrioridadeServicoUsuarioDao prioridadeServicoUsuarioDao = new PrioridadeServicoUsuarioDao();
		PrioridadeAcordoNivelServicoDao prioridadeAcordoNivelServicoDao = new PrioridadeAcordoNivelServicoDao();
		TempoAtendimentoEmpregadoDao tempoAtendimentoEmpregadoDao = new TempoAtendimentoEmpregadoDao();
		TempoAtendimentoUnidadeDao tempoAtendimentoUnidadeDao = new TempoAtendimentoUnidadeDao();

		TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		if (tc != null) {
			try {
			tc.start();

			tempoAcordoNivelServicoDao.setTransactionControler(tc);
			acordoNivelServicoDao.setTransactionControler(tc);
			acordoServicoContratoDao.setTransactionControler(tc);
			prioridadeServicoUnidadeDao.setTransactionControler(tc);
			empregadoDao.setTransactionControler(tc);
			matrizPrioriDao.setTransactionControler(tc);
			servicoContratoDao.setTransactionControler(tc);
			prioridadeServicoUsuarioDao.setTransactionControler(tc);
			prioridadeAcordoNivelServicoDao.setTransactionControler(tc);

		Integer idPrioridade = null;

		ServicoContratoDTO servicoContratoDto = servicoContratoDao.findByIdContratoAndIdServico(solicitacaoServicoDto.getIdContrato(), solicitacaoServicoDto.getIdServico());
		if(servicoContratoDto != null) {
			Integer idServicoContrato = servicoContratoDto.getIdServicoContrato();

			if (solicitacaoServicoDto.getIdSolicitante() != null) {
				EmpregadoDTO empregadoDTO = null;
				empregadoDTO = empregadoDao.restoreByIdEmpregado(solicitacaoServicoDto.getIdSolicitante());
				if (empregadoDTO != null && empregadoDTO.getIdUnidade() != null) {
					PrioridadeServicoUnidadeDTO prioridadeServicoUnidadeDto = prioridadeServicoUnidadeDao.restore(idServicoContrato, empregadoDTO.getIdUnidade());
					if (prioridadeServicoUnidadeDto != null) {
						idPrioridade = prioridadeServicoUnidadeDto.getIdPrioridade();
					}
				}
			}

			String calcularDinamicamente = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE, "N");

			if (!calcularDinamicamente.trim().equalsIgnoreCase("S")) {
				if (idPrioridade == null) {
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 5;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 4;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 3;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 4;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 3;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 2;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 3;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 2;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 1;
					}
				}
			} else {
				String siglaImpacto = solicitacaoServicoDto.getImpacto();
				String siglaUrgencia = solicitacaoServicoDto.getUrgencia();
				Integer valorPrioridade = matrizPrioriDao.consultaValorPrioridade(siglaImpacto.trim().toUpperCase(), siglaUrgencia.trim().toUpperCase());
				idPrioridade = valorPrioridade;
			}

			AcordoNivelServicoDTO acordoNivelServicoDto = acordoNivelServicoDao.findAtivoByIdServicoContrato(idServicoContrato, "T");
			if (acordoNivelServicoDto == null) {
				acordoNivelServicoDto = new AcordoNivelServicoDTO();
				AcordoServicoContratoDTO acordoServicoContratoDTO = acordoServicoContratoDao.findAtivoByIdServicoContrato(idServicoContrato, "T");
				if (acordoServicoContratoDTO != null) {
					acordoNivelServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
				}
						// Consulta prioridade do usurio de acordo com sla
						// global
				PrioridadeServicoUsuarioDTO prioridadeServicoUsuarioDTO = prioridadeServicoUsuarioDao.findByIdAcordoNivelServicoAndIdUsuario(acordoNivelServicoDto.getIdAcordoNivelServico(),
						solicitacaoServicoDto.getIdSolicitante());
				if (prioridadeServicoUsuarioDTO != null && prioridadeServicoUsuarioDTO.getIdPrioridade() != null) {
					idPrioridade = prioridadeServicoUsuarioDTO.getIdPrioridade();
				}
						// Consulta prioridade da unidade do usurio de acordo
						// com sla global
				PrioridadeAcordoNivelServicoDTO prioridadeAcordoNivelServicoDTO = prioridadeAcordoNivelServicoDao.findByIdAcordoNivelServicoAndIdUnidade(acordoNivelServicoDto.getIdAcordoNivelServico(),
						solicitacaoServicoDto.getIdUnidade());
				if (prioridadeAcordoNivelServicoDTO != null && prioridadeAcordoNivelServicoDTO.getIdPrioridade() != null) {
					idPrioridade = prioridadeAcordoNivelServicoDTO.getIdPrioridade();
				}
			}
			if (idPrioridade == null) {
				idPrioridade = acordoNivelServicoDto.getIdPrioridadePadrao();
			}
			
			// Determina a prioridade de unidade e/ou empregado adicionado no tempo de atendimento
			// Sempre ser definido a maior prioridade, seja unidade vinculada, empregado unidade ou impacto/urgncia
			// Incio
			TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregadoDTO;
			TempoAtendimentoUnidadeDTO tempoAtendimentoUnidadeDTO;
			if (solicitacaoServicoDto.getIdSolicitante() != null) {
				tempoAtendimentoEmpregadoDTO = tempoAtendimentoEmpregadoDao.restoreByIdEmpregadoIdANS(solicitacaoServicoDto.getIdSolicitante(), acordoNivelServicoDto.getIdAcordoNivelServico());
			} else {
				tempoAtendimentoEmpregadoDTO = tempoAtendimentoEmpregadoDao.restoreByIdAcordoNivelServico(acordoNivelServicoDto.getIdAcordoNivelServico());
			}

			if (solicitacaoServicoDto.getIdUnidade() != null) {
				tempoAtendimentoUnidadeDTO = tempoAtendimentoUnidadeDao.restoreByIdUnidadeIdANS(solicitacaoServicoDto.getIdUnidade(), acordoNivelServicoDto.getIdAcordoNivelServico());
			} else {
				tempoAtendimentoUnidadeDTO = tempoAtendimentoUnidadeDao.restoreByIdAcordoNivelServico(acordoNivelServicoDto.getIdAcordoNivelServico());
			}
			List<Integer> listPrioridade = new ArrayList();

			listPrioridade.add(idPrioridade);

			if (tempoAtendimentoEmpregadoDTO != null && tempoAtendimentoEmpregadoDTO.getPrioridade() != null) {
				listPrioridade.add(tempoAtendimentoEmpregadoDTO.getPrioridade());
			}
			if (tempoAtendimentoUnidadeDTO != null && tempoAtendimentoUnidadeDTO.getPrioridade() != null) {
				listPrioridade.add(tempoAtendimentoUnidadeDTO.getPrioridade());
			}

			Integer majorPriority = Integer.MAX_VALUE;

			if (listPrioridade != null && !listPrioridade.isEmpty()) {
				for (Integer key : listPrioridade) {
					if (key < majorPriority) {
						majorPriority = key;
					}
				}
			} else {
				majorPriority = solicitacaoServicoDto.getIdPrioridade();
			}
			solicitacaoServicoDto.setIdPrioridade(majorPriority);
			//FIM
			
			Collection<TempoAcordoNivelServicoDTO> colTempos = tempoAcordoNivelServicoDao.findByIdAcordoAndIdPrioridade(acordoNivelServicoDto.getIdAcordoNivelServico(), solicitacaoServicoDto.getIdPrioridade());
			if (colTempos != null) {
				for (TempoAcordoNivelServicoDTO tempoAcordoDto : colTempos) {
					if (tempoAcordoDto.getTempoHH() != null) {
						prazoHH += tempoAcordoDto.getTempoHH().intValue();
					}
					if (tempoAcordoDto.getTempoMM() != null) {
						prazoMM += tempoAcordoDto.getTempoMM().intValue();
					}
				}
				while(prazoMM >= 60){
					prazoHH = prazoHH + 1;
					prazoMM = prazoMM - 60;
				}
					}
			if (prazoHH.equals(0) && prazoMM.equals(0)) {
				return UtilI18N.internacionaliza(request, "citcorpore.comum.aCombinar");
			} else {
				String hh = prazoHH.toString();
				String mm = prazoMM.toString();

				if (hh.length() == 1) {
					hh = "0" + hh;
				}
				if (mm.length() == 1) {
					mm = "0" + mm;
				}

				return hh + ":" + mm;
			}
		}
			} catch (PersistenceException e) {
				e.printStackTrace();
			} finally {
				try {
					tc.close();
				} catch (PersistenceException e) {
					e.printStackTrace();
				}
			}
		}

		return "";
	}

	@Override
	public String calculaSLAMultinivel(SolicitacaoServicoDTO solicitacaoServicoDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		Integer prazoHH = 0;
		Integer prazoMM = 0;

		TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();
		EmpregadoDao empregadoDao = new EmpregadoDao();
		UnidadeDao unidadeDao = new UnidadeDao();
		MatrizPrioridadeDAO matrizPrioriDao = new MatrizPrioridadeDAO();
		ServicoContratoDao servicoContratoDao = new ServicoContratoDao();
		AcordoServicoContratoDao acordoServicoContratoDao = new AcordoServicoContratoDao();
		TempoAtendimentoEmpregadoDao tempoAtendimentoEmpregadoDao = new TempoAtendimentoEmpregadoDao();
		TempoAtendimentoUnidadeDao tempoAtendimentoUnidadeDao = new TempoAtendimentoUnidadeDao();

		Integer idPrioridade = null;

		ServicoContratoDTO servicoContratoDto = servicoContratoDao.findByIdContratoAndIdServico(solicitacaoServicoDto.getIdContrato(), solicitacaoServicoDto.getIdServico());
		EmpregadoDTO empregadoDTO = null;
		UnidadeDTO unidadeDTO = null;
		if (servicoContratoDto != null && servicoContratoDto.getIdServicoContrato() != null) {
			Integer idServicoContrato = servicoContratoDto.getIdServicoContrato();
			Integer idAcordoNivelServico = null;

			// final AcordoServicoContratoDTO acordoServicoContratoDTO = acordoServicoContratoDao.findAtivoByIdServicoContrato(idServicoContrato, "T");
			final AcordoNivelServicoDTO acordoNivelServicoDTO = this.getAcordoNivelServicoService().findANSIncReqProcByIdServicoContrato(idServicoContrato);

			if (acordoNivelServicoDTO != null && acordoNivelServicoDTO.getIdAcordoNivelServico() != null) {
				idAcordoNivelServico = acordoNivelServicoDTO.getIdAcordoNivelServico();

			} else {
				final AcordoServicoContratoDTO acordoServicoContratoDTO = acordoServicoContratoDao.getANSGlobalClienteHierarquicoByIdServicoContrato(idServicoContrato);
				idAcordoNivelServico = acordoServicoContratoDTO.getIdAcordoNivelServico();
			}

			if (idAcordoNivelServico != null && idAcordoNivelServico > 0) {
				solicitacaoServicoDto.setIdServicoContrato(idServicoContrato);
				if (solicitacaoServicoDto.getIdSolicitante() != null) {
					empregadoDTO = empregadoDao.restoreByIdEmpregado(solicitacaoServicoDto.getIdSolicitante());
				}
				if (solicitacaoServicoDto.getIdUnidade() != null) {
					unidadeDTO = new UnidadeDTO();
					unidadeDTO.setIdUnidade(solicitacaoServicoDto.getIdUnidade());
					unidadeDTO = (UnidadeDTO) unidadeDao.restore(unidadeDTO);
				}
				String calcularDinamicamente = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE, "N");

				if (!calcularDinamicamente.trim().equalsIgnoreCase("S")) {
					if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 5;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 4;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("B") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 3;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 4;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 3;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("M") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 2;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("B")) {
						idPrioridade = 3;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("M")) {
						idPrioridade = 2;
					} else if (solicitacaoServicoDto.getUrgencia().equalsIgnoreCase("A") && solicitacaoServicoDto.getImpacto().equalsIgnoreCase("A")) {
						idPrioridade = 1;
					}
				} else {
					String siglaImpacto = solicitacaoServicoDto.getImpacto();
					String siglaUrgencia = solicitacaoServicoDto.getUrgencia();
					Integer valorPrioridade = matrizPrioriDao.consultaValorPrioridade(siglaImpacto.trim().toUpperCase(), siglaUrgencia.trim().toUpperCase());
					idPrioridade = valorPrioridade;
				}

				TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregadoDTO;
				TempoAtendimentoUnidadeDTO tempoAtendimentoUnidadeDTO;
				if (solicitacaoServicoDto.getIdSolicitante() != null) {
					tempoAtendimentoEmpregadoDTO = tempoAtendimentoEmpregadoDao.restoreByIdEmpregadoIdANS(solicitacaoServicoDto.getIdSolicitante(), idAcordoNivelServico);
				} else {
					tempoAtendimentoEmpregadoDTO = tempoAtendimentoEmpregadoDao.restoreByIdAcordoNivelServico(idAcordoNivelServico);
				}

				if (solicitacaoServicoDto.getIdUnidade() != null) {
					tempoAtendimentoUnidadeDTO = tempoAtendimentoUnidadeDao.restoreByIdUnidadeIdANS(solicitacaoServicoDto.getIdUnidade(), idAcordoNivelServico);
				} else {
					tempoAtendimentoUnidadeDTO = tempoAtendimentoUnidadeDao.restoreByIdAcordoNivelServico(idAcordoNivelServico);
				}
				List<Integer> listPrioridade = new ArrayList();

				listPrioridade.add(idPrioridade);

				if (tempoAtendimentoEmpregadoDTO != null && tempoAtendimentoEmpregadoDTO.getPrioridade() != null) {
					listPrioridade.add(tempoAtendimentoEmpregadoDTO.getPrioridade());
				}
				if (tempoAtendimentoUnidadeDTO != null && tempoAtendimentoUnidadeDTO.getPrioridade() != null) {
					listPrioridade.add(tempoAtendimentoUnidadeDTO.getPrioridade());
				}

				Integer majorPriority = Integer.MAX_VALUE;

				if (listPrioridade != null && !listPrioridade.isEmpty()) {
					for (Integer key : listPrioridade) {
						if (key < majorPriority) {
							majorPriority = key;
						}
					}
				} else {
					majorPriority = solicitacaoServicoDto.getIdPrioridade();
				}
				solicitacaoServicoDto.setIdPrioridade(majorPriority);

				Collection<TempoAcordoNivelServicoDTO> colTempos = new ArrayList<>();

				//TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = this.getTempoAtendimento(empregadoDTO, unidadeDTO, solicitacaoServicoDto);

				//if (tempoAcordoNivelServicoDTO != null && tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() != null){
				colTempos = tempoAcordoNivelServicoDao.findByIdAcordoAndIdPrioridade(idAcordoNivelServico, solicitacaoServicoDto.getIdPrioridade());

				AcordoNivelServicoDao acordoNivelServicoDao = new AcordoNivelServicoDao();
				AcordoNivelServicoDTO ans = new AcordoNivelServicoDTO();
				ans.setIdAcordoNivelServico(idAcordoNivelServico);
				ans = acordoNivelServicoDao.findByIdAcordoNivelServico(idAcordoNivelServico);
				if(ans!=null && ans.getIdAcordoNivelServico()!=null && ans.getTituloSLA()!=null){
					document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "tempoAtendimento.tempoAtendimentoDefinido")+"', '"+ans.getTituloSLA()+"')");
				}
				//}

				if (colTempos != null && !colTempos.isEmpty()) {
					for (TempoAcordoNivelServicoDTO tempoAcordoDto : colTempos) {
						if (tempoAcordoDto.getTempoHH() != null) {
							prazoHH += tempoAcordoDto.getTempoHH().intValue();
						}
						if (tempoAcordoDto.getTempoMM() != null) {
							prazoMM += tempoAcordoDto.getTempoMM().intValue();
						}
					}
					while (prazoMM >= 60) {
						prazoHH = prazoHH + 1;
						prazoMM = prazoMM - 60;
					}

					if (prazoHH.equals(0) && prazoMM.equals(0)) {
						return UtilI18N.internacionaliza(request, "citcorpore.comum.aCombinar");
					} else {
						String hh = prazoHH.toString();
						String mm = prazoMM.toString();

						if (hh.length() == 1) {
							hh = "0" + hh;
						}
						if (mm.length() == 1) {
							mm = "0" + mm;
						}

						return hh + ":" + mm;
					}
				}
			}
		}

		return "";
	}

	private TempoAcordoNivelServicoDTO getTempoAtendimento(EmpregadoDTO empregadoDto, UnidadeDTO unidadeDto, SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		TempoAcordoNivelServicoDao tempoAcordoNivelServicoDao = new TempoAcordoNivelServicoDao();

		// Por Requisio/Incidente
		TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTARequisicaoIncidenteComEmpregadoSemUnidade(empregadoDto, solicitacaoServicoDto);
		if (tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null) {
			tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTARequisicaoIncidenteComEmpregadoComUnidade(empregadoDto, unidadeDto, solicitacaoServicoDto);
			if (tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null) {
				tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTARequisicaoIncidenteSemEmpregadoComUnidade(unidadeDto, solicitacaoServicoDto);
				if (tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null) {
					tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTARequisicaoIncidenteSemEmpregadoSemUnidade(solicitacaoServicoDto);
					if (tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null) {

						//Por cliente
						tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTAClienteComEmpregadoSemUnidade(empregadoDto, solicitacaoServicoDto);
						if(tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null){
							tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTAClienteComEmpregadoComUnidade(empregadoDto, unidadeDto, solicitacaoServicoDto);
							if(tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null){
								tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTAClienteSemEmpregadoComUnidade(unidadeDto, solicitacaoServicoDto);
								if(tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null){
									tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTAClienteSemEmpregadoSemUnidade(solicitacaoServicoDto);

									//Global
									if (tempoAcordoNivelServicoDTO == null || tempoAcordoNivelServicoDTO.getIdAcordoNivelServico() == null) {
										tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) tempoAcordoNivelServicoDao.listTempoAtendimentoGlobal(solicitacaoServicoDto);

									}
								}
							}
						}
					}
				}
			}
		}



		return tempoAcordoNivelServicoDTO;
	}

	@Override
	public SolicitacaoServicoDTO findByIdSolicitacaoServico(Integer idSolicitacaoServico) throws Exception {
		try {
			return this.getDao().findByIdSolicitacaoServico(idSolicitacaoServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupo(Integer idGrupo) throws Exception {
		try {
			return this.getDao().findByIdGrupo(idGrupo);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataBaixa(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataBaixa(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataMedia(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataMedia(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAlta(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataAlta(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasBaixa(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataAtendidasBaixa(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasMedia(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataAtendidasMedia(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasAlta(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataAtendidasAlta(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataTotal(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataTotal(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataSuspensasTotal(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataSuspensasTotal(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdPessoaEDataAtendidas(Integer idGrupo, String login, String nome, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdPessoaEDataAtendidas(idGrupo, login, nome, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdPessoaEData(Integer idGrupo, String login, String nome, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdPessoaEData(idGrupo, login, nome, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdPessoaEDataNaoAtendidas(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).findByIdPessoaEDataNaoAtendidas(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<RelatorioSolicitacaoPorExecutanteDTO> listaSolicitacaoPorExecutante(RelatorioSolicitacaoPorExecutanteDTO relatorioSolicitacaoPorExecutanteDto) throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaSolicitacaoPorExecutante(relatorioSolicitacaoPorExecutanteDto);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtendidasTotal(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataAtendidasTotal(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByIdGrupoEDataAtrasadasTotal(Integer idGrupo, Date dataInicio, Date dataFim) throws Exception {
		try {
			return this.getDao().findByIdGrupoEDataAtrasadasTotal(idGrupo, dataInicio, dataFim);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO> listaServicoPorSolicitacaoServico(RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO relatorioAnaliseServicoDto) throws Exception {

		final Collection<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO> listFinal = new ArrayList<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO>();
		final Collection<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO> listAux = getDao(relatorioAnaliseServicoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null)
				.listaServicoPorSolicitacaoServico(relatorioAnaliseServicoDto);

		Collection<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO> listaSolicitacaoServicoProblema = new ArrayList<RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO>();

		if (listAux != null && !listAux.isEmpty()) {
			for (RelatorioQuantitativoSolicitacaoProblemaPorServicoDTO relatorioAnaliseServico : listAux) {
				listaSolicitacaoServicoProblema = getDao(relatorioAnaliseServicoDto.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).listaSolicitacaoServicoProblemaPorServico(relatorioAnaliseServico);
				relatorioAnaliseServico.setListaSolicitacaoServicoProblema(listaSolicitacaoServicoProblema);
				listFinal.add(relatorioAnaliseServico);
			}
			return listFinal;
		}
		return listAux;
	}

	@Override
	public boolean permissaoGrupoExecutorServico(int idGrupoExecutor, int idTipoFluxoSolicitacaoServico) throws Exception {
		boolean resultado = false;

		PermissoesFluxoService permissoesFluxoService = (PermissoesFluxoService) ServiceLocator.getInstance().getService(PermissoesFluxoService.class, null);

		resultado = permissoesFluxoService.permissaoGrupoExecutorLiberacaoServico(idGrupoExecutor, idTipoFluxoSolicitacaoServico);

		return resultado;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaSolicitacoesPorIdEmpregado(Integer pgAtual, Integer qtdPaginacao, GerenciamentoServicosDTO gerenciamentoBean, Collection<ContratoDTO> listContratoUsuarioLogado) throws Exception {
		try {

			return this.getDao().listaSolicitacoesPorIdEmpregado(pgAtual, qtdPaginacao, gerenciamentoBean, listContratoUsuarioLogado);

		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaSolicitacoesDoPortal(Integer pgAtual, Integer qtdPaginacao, GerenciamentoServicosDTO gerenciamentoBean, String vinculaColaboradorContrato) throws Exception {
		try {

			return this.getDao().listPesquisaPortalPaginada(pgAtual, qtdPaginacao, gerenciamentoBean, vinculaColaboradorContrato);

		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	public Collection<SolicitacaoServicoDTO> resumoSolicitacoesServico(Collection<TarefaFluxoDTO> listTarefas, Integer idTipoDemandaServico, Integer idPrioridade) throws Exception {
		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDto = new ArrayList();
		HashMap hashMap = new HashMap();
		Integer qtdEmAndamento = 0;
		Integer qtdCancelada = 0;
		Integer qtdSuspensa = 0;
		Integer qtdPrazoVencido = 0;

		listSolicitacaoServicoDto = listByTarefas(listTarefas, new TransactionControlerImpl(br.com.citframework.util.Constantes.getValue("DATABASE_ALIAS")));

		if (listTarefas != null && !listTarefas.isEmpty() && listSolicitacaoServicoDto != null && !listSolicitacaoServicoDto.isEmpty()) {
			for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacaoServicoDto) {
				if (ServiceRequestStatus.IN_PROGRESS.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdEmAndamento++;
				}
				if (ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdCancelada++;
				}
				if (ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdSuspensa++;
				}

				solicitacaoServicoDTO.setDataHoraLimiteStr(solicitacaoServicoDTO.getDataHoraLimiteStr());
				solicitacaoServicoDTO.setDataHoraInicioSLA(solicitacaoServicoDTO.getDataHoraInicioSLA());

				solicitacaoServicoDTO.setNomeServico(solicitacaoServicoDTO.getServico());
				if (solicitacaoServicoDTO.getNomeUnidadeSolicitante() != null && !solicitacaoServicoDTO.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
					solicitacaoServicoDTO.setSolicitanteUnidade(solicitacaoServicoDTO.getSolicitante() + " (" + solicitacaoServicoDTO.getNomeUnidadeSolicitante() + ")");
				}

				if (solicitacaoServicoDTO.getNomeUnidadeResponsavel() != null && !solicitacaoServicoDTO.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
					solicitacaoServicoDTO.setResponsavel(solicitacaoServicoDTO.getResponsavel() + " (" + solicitacaoServicoDTO.getNomeUnidadeResponsavel() + ")");
				}
				this.verificaSituacaoSLA(solicitacaoServicoDTO);
				if (solicitacaoServicoDTO.getAtrasoSLA() > 0 && !ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdPrazoVencido++;
				}
			}
		}

		hashMap.put("Em Andamento", qtdEmAndamento);
		hashMap.put("Cancelada", qtdCancelada);
		hashMap.put("Suspensa", qtdSuspensa);

		hashMap.put("Prazo Vencido", qtdPrazoVencido);

		return listSolicitacaoServicoDto;
	}

	@Override
	public Map<String, Integer> resumoTipoDemandaServico(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		 Map<String, Integer> mapResumoTipoDemandaServico = new HashMap<>();

		Integer qtdeItens = 0;
		List<ServiceDemandType> listTipoDemandaServico = ServiceDemandType.valuesWithoutOS();

		if (listSolicitacoes != null && !listSolicitacoes.isEmpty() && listTipoDemandaServico != null && !listTipoDemandaServico.isEmpty()) {
			for (ServiceDemandType tipoDemandaServico : listTipoDemandaServico) {
				for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacoes) {
					if (solicitacaoServicoDTO.getIdTipoDemandaServico().intValue() == tipoDemandaServico.getId().intValue()) {
						qtdeItens++;
					}
				}
				mapResumoTipoDemandaServico.put(tipoDemandaServico.getI18NKey(), qtdeItens);
				qtdeItens = 0;
			}
		}
		return mapResumoTipoDemandaServico;
	}

	@Override
	public Collection<PrioridadeDTO> resumoPrioridade(final List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		Collection<PrioridadeDTO> colPrioridade = new ArrayList<PrioridadeDTO>();
		PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		Integer qtdeItens = 0;

		Collection<PrioridadeDTO> colPrioridadeService = prioridadeService.list();

		if (listSolicitacoes != null && !listSolicitacoes.isEmpty() && colPrioridadeService != null && !colPrioridadeService.isEmpty()) {
			for (PrioridadeDTO prioridadeDTO : colPrioridadeService) {
				PrioridadeDTO dto = new PrioridadeDTO();
				for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacoes) {
					if (prioridadeDTO.getIdPrioridade().intValue() == solicitacaoServicoDTO.getIdPrioridade().intValue()) {
						qtdeItens++;
					}
				}
				dto.setNomePrioridade(prioridadeDTO.getNomePrioridade());
				dto.setQuantidade(qtdeItens);
				colPrioridade.add(dto);
				qtdeItens = 0;
			}
		}
		return colPrioridade;
	}

	@Override
	public HashMap resumoPorPrazoLimite(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		Integer qtdPrazoVencido = 0;
		Integer qtdPrazoAVencer = 0;
		Integer qtdPrazoNormal = 0;
		HashMap<String, Integer> hashMap = new HashMap<String, Integer>();

		if (listSolicitacoes != null) {
			for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacoes) {
				solicitacaoServicoDTO.setDataHoraLimiteStr(solicitacaoServicoDTO.getDataHoraLimiteStr());
				solicitacaoServicoDTO.setDataHoraInicioSLA(solicitacaoServicoDTO.getDataHoraInicioSLA());

				if (SimNao.SIM.getValorStr().equalsIgnoreCase(solicitacaoServicoDTO.getAtrasoSLAStr())) {
								qtdPrazoVencido++;
				} else if (solicitacaoServicoDTO.getFalta1Hora()) {
						qtdPrazoAVencer++;
					} else {
						qtdPrazoNormal++;
					}
				}
			}

		hashMap.put("Prazo Normal", qtdPrazoNormal);
		hashMap.put("Prazo a Vencer", qtdPrazoAVencer);
		hashMap.put("Prazo Vencido", qtdPrazoVencido);

		return hashMap;
	}

	@Override
	public HashMap resumoPorSituacao(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		Integer qtdEmAndamento = 0;
		Integer qtdReaberta = 0;
		Integer qtdSuspensa = 0;
		Integer qtdResolvida = 0;
		Integer qtdCancelada = 0;
		Integer qtdReclassificada = 0;
		Integer qtdFechada = 0;
		HashMap<ServiceRequestStatus, Integer> hashMap = new HashMap<ServiceRequestStatus, Integer>();
		if (listSolicitacoes != null && !listSolicitacoes.isEmpty()) {
			for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacoes) {
				if (ServiceRequestStatus.IN_PROGRESS.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdEmAndamento++;
				} else if (ServiceRequestStatus.REOPENED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdReaberta++;
				} else if (ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdSuspensa++;
				} else if (ServiceRequestStatus.SOLVED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdResolvida++;
				} else if (ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdCancelada++;
				} else if (ServiceRequestStatus.RECLASSIFIED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdReclassificada++;
				} else if (ServiceRequestStatus.CLOSED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					qtdFechada++;
				}
			}
		}

		hashMap.put(ServiceRequestStatus.IN_PROGRESS, qtdEmAndamento);
		hashMap.put(ServiceRequestStatus.REOPENED, qtdReaberta);
		hashMap.put(ServiceRequestStatus.SUSPENDED, qtdSuspensa);
		hashMap.put(ServiceRequestStatus.SOLVED, qtdResolvida);
		hashMap.put(ServiceRequestStatus.CANCELED, qtdCancelada);
		hashMap.put(ServiceRequestStatus.RECLASSIFIED, qtdReclassificada);
		hashMap.put(ServiceRequestStatus.CLOSED, qtdFechada);

		return hashMap;
	}

	@Override
	public Collection<RelatorioQuantitativoRetornoDTO> listaServicosRetorno(SolicitacaoServicoDTO solicitacaoServicoDTO, String grupoRetorno) throws Exception {
		return getSolicitacaoServicoDao().listaServicosRetorno(solicitacaoServicoDTO, grupoRetorno);
	}

	@Override
	public Collection<RelatorioQuantitativoRetornoDTO> listaServicosRetornoNomeResponsavel(RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception {
		return getSolicitacaoServicoDao().listaServicosRetornoNomeResponsavel(relatorioQuantitativoRetornoDTO);
	}

	@Override
	public SolicitacaoServicoDTO listaIdItemTrabalho(Integer idInstancia) throws Exception {
		return getSolicitacaoServicoDao().listaIdItemTrabalho(idInstancia);
	}

	@Override
	public RelatorioQuantitativoRetornoDTO servicoRetorno(RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception {
		return getSolicitacaoServicoDao().servicoRetorno(relatorioQuantitativoRetornoDTO);
	}

	@Override
	public boolean validaQuantidadeRetorno(RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception {
		return getSolicitacaoServicoDao().validaQuantidadeRetorno(relatorioQuantitativoRetornoDTO);
	}

	@Override
	public RelatorioQuantitativoRetornoDTO retornarIdEncerramento(String encerramento, RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO) throws Exception {
		return getSolicitacaoServicoDao().retornarIdEncerramento(encerramento, relatorioQuantitativoRetornoDTO);
	}

	@Override
	public boolean confirmaEncerramento(RelatorioQuantitativoRetornoDTO relatorioQuantitativoRetornoDTO, Integer idElemento) throws Exception {
		return getSolicitacaoServicoDao().confirmaEncerramento(relatorioQuantitativoRetornoDTO, idElemento);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findByCodigoExterno(String codigoExterno) throws Exception {
		return getSolicitacaoServicoDao().findByCodigoExterno(codigoExterno);
	}

	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, Integer qtdAtual, Integer qtdAPaginacao,TransactionControler tc) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}
		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDto = new ArrayList();

		listSolicitacaoServicoDto = this.getDao().listByTarefas(listTarefas, qtdAtual, qtdAPaginacao);

		if (listSolicitacaoServicoDto != null && !listSolicitacaoServicoDto.isEmpty()) {

			for (SolicitacaoServicoDTO solicitacaoDto : listSolicitacaoServicoDto) {

				if (solicitacaoDto != null) {
					solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());
					solicitacaoDto.setDataHoraInicioSLA(solicitacaoDto.getDataHoraInicioSLA());

					solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
					if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
					}

					if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
					}

					solicitacaoDto = this.verificaSituacaoSLA(solicitacaoDto, tc);
				}
			}
		}
		return listSolicitacaoServicoDto;
	}

	@Override
	public boolean existeSolicitacaoServico(SolicitacaoServicoDTO solicitacaoservico) throws Exception {
		return this.getDao().existeSolicitacaoServico(solicitacaoservico);
	}

	/**
	 * Retorna a Lista de TarefaDTO com SolicitacaoServidoDTO de acordo com o Login, Lista de Contratos do Usurio Logado e os Filtros Selecionados na Tela de Gerenciamento de Servios.
	 *
	 * @param pgAtual
	 * @param qtdAPaginacao
	 * @param login
	 * @param gerenciamentoBean
	 * @param listContratoUsuarioLogado
	 * @return
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 05.11.2013
	 */
	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, Integer qtdAtual, Integer qtdAPaginacao, GerenciamentoServicosDTO gerenciamentoBean,
			Collection<ContratoDTO> listContratoUsuarioLogado, TransactionControler tc) throws Exception {

		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDto = this.getDao().listByTarefas(listTarefas, qtdAtual, qtdAPaginacao, gerenciamentoBean, listContratoUsuarioLogado);

		if (listSolicitacaoServicoDto != null && !listSolicitacaoServicoDto.isEmpty()) {

			for (SolicitacaoServicoDTO solicitacaoDto : listSolicitacaoServicoDto) {

				if (solicitacaoDto != null) {
					solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());
					solicitacaoDto.setDataHoraInicioSLA(solicitacaoDto.getDataHoraInicioSLA());

					solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
					if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
					}

					if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
					}

					solicitacaoDto = this.verificaSituacaoSLA(solicitacaoDto, tc);
				}
			}
		}

		return listSolicitacaoServicoDto;
	}

	/**
	 * Utilizado para a RENDERIZAO do GRFICO, pois no Grfico no  necessrio a utilizao de Paginao. Esta consulta considera o Login do Usurio Logado, os Contratos em que est inserido e os
	 * Filtros Selecionados na tela de Gerenciamento de
	 * Servios.
	 *
	 * @param listTarefas
	 * @param gerenciamentoBean
	 * @return
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 05.11.2013
	 */
	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, GerenciamentoServicosDTO gerenciamentoBean, Collection<ContratoDTO> listContratoUsuarioLogado, TransactionControler tc)
			throws Exception {

		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}

		Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDto = new ArrayList();

		listSolicitacaoServicoDto = this.getDao().listByTarefas(listTarefas, gerenciamentoBean, listContratoUsuarioLogado);

		if (listSolicitacaoServicoDto != null && !listSolicitacaoServicoDto.isEmpty()) {

			for (SolicitacaoServicoDTO solicitacaoDto : listSolicitacaoServicoDto) {

				System.out.println(solicitacaoDto.getIdSolicitacaoServico());

				if (solicitacaoDto != null) {
					solicitacaoDto.setDataHoraLimiteStr(solicitacaoDto.getDataHoraLimiteStr());
					solicitacaoDto.setDataHoraInicioSLA(solicitacaoDto.getDataHoraInicioSLA());

					solicitacaoDto.setNomeServico(solicitacaoDto.getServico());
					if (solicitacaoDto.getNomeUnidadeSolicitante() != null && !solicitacaoDto.getNomeUnidadeSolicitante().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setSolicitanteUnidade(solicitacaoDto.getSolicitante() + " (" + solicitacaoDto.getNomeUnidadeSolicitante() + ")");
					}

					if (solicitacaoDto.getNomeUnidadeResponsavel() != null && !solicitacaoDto.getNomeUnidadeResponsavel().trim().equalsIgnoreCase("")) {
						solicitacaoDto.setResponsavel(solicitacaoDto.getResponsavel() + " (" + solicitacaoDto.getNomeUnidadeResponsavel() + ")");
					}

					solicitacaoDto = this.verificaSituacaoSLA(solicitacaoDto, tc);
				}
			}
		}
		return listSolicitacaoServicoDto;
	}

	public SolicitacaoServicoDTO restoreInfoEmails(Integer idSolicitacaoServico, TransactionControler tc) throws Exception{
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}
		SolicitacaoServicoDTO solicitacaoDto = null;
		try {
			solicitacaoDto = this.getDao().restoreInfoEmails(idSolicitacaoServico);
		} catch (Exception e) {
			throw new Exception(i18nMessage("solicitacaoservico.erro.recuperardadosolicitacao") + " " + idSolicitacaoServico);
		}

		return solicitacaoDto;
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listarSolicitacoesAbertasEmAndamentoPorGrupo(int idGrupoAtual, String situacaoSla) throws Exception {
		 return this.getDao().listarSolicitacoesAbertasEmAndamentoPorGrupo(idGrupoAtual, situacaoSla);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listarSolicitacoesMultadasSuspensasPorGrupo(int idGrupoAtual, String situacaoSla) throws Exception {
		 return this.getDao().listarSolicitacoesMultadasSuspensasPorGrupo(idGrupoAtual, situacaoSla);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaServicosPorResponsavelNoPeriodo(RelatorioKpiProdutividadeDTO relatorioKpiProdutividadeDTO) throws Exception {
		 return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaServicosPorResponsavelNoPeriodo(relatorioKpiProdutividadeDTO);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaServicosPorSolicitanteNoPeriodoEnviadosAoteste(Date dataIncio, Date dataFim, int idFuncionario , boolean mostrarIncidentes, boolean mostrarRequisicoes) throws Exception {
		 return this.getDao().listaServicosPorSolicitanteNoPeriodoEnviadosAoteste(dataIncio, dataFim, idFuncionario , mostrarIncidentes, mostrarRequisicoes);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaServicosPorAbertosParaDocumentacao(Date dataIncio, Date dataFim, boolean mostrarIncidentes, boolean mostrarRequisicoes) throws Exception {
		 return this.getDao().listaServicosPorAbertosParaDocumentacao(dataIncio, dataFim, mostrarIncidentes, mostrarRequisicoes);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaServicosPorResponsavelNoPeriodoDocumentacao(Date dataIncio, Date dataFim, int idFuncionario , boolean mostrarIncidentes, boolean mostrarRequisicoes) throws Exception {
		 return this.getDao().listaServicosPorResponsavelNoPeriodoDocumentacao(dataIncio, dataFim, idFuncionario , mostrarIncidentes, mostrarRequisicoes);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaServicosPorResponsavelNoPeriodoDocumentacaoPorServico(Date dataIncio, Date dataFim, int idFuncionario , boolean mostrarIncidentes, boolean mostrarRequisicoes, String listaIdsServicosHomologacaoDocumentacao) throws Exception {
		 return this.getDao().listaServicosPorResponsavelNoPeriodoDocumentacaoPorServico(dataIncio, dataFim, idFuncionario , mostrarIncidentes, mostrarRequisicoes, listaIdsServicosHomologacaoDocumentacao);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listaServicosPorAbertosPelotesteParaValidacao(Date dataIncio, Date dataFim, boolean mostrarIncidentes, boolean mostrarRequisicoes) throws Exception {
		 return this.getDao().listaServicosPorAbertosPelotesteParaValidacao(dataIncio, dataFim, mostrarIncidentes, mostrarRequisicoes);
	}

	public void verificaSituacaoSLA(List<SolicitacaoServicoDTO> solicitacaoDto) throws Exception {
		for (SolicitacaoServicoDTO solicitacaoServicoDTO : solicitacaoDto) {
			verificaSituacaoSLA(solicitacaoServicoDTO);
		}

	}

	@Override
	public SolicitacaoServicoDTO buscarNumeroItemTrabalhoPorNumeroSolicitacao(int idSolicitacao) throws Exception {
		 return  this.getDao().buscarNumeroItemTrabalhoPorNumeroSolicitacao(idSolicitacao);
	}


	@Override
	public Collection<RelatorioEficaciaTesteDTO> listaSolicitacaoPorServicosAbertosNoPerido(Date dataIncio, Date dataFim,List<ServicoDTO> listaServicos) throws Exception {
		 return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaSolicitacaoPorServicosAbertosNoPerido(dataIncio, dataFim, listaServicos);
	}

	@Override
	public Collection<RelatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodoDTO> listaQtdSolicitacoesCanceladasFinalizadasporServicoNoPeriodo(Date dataIncio, Date dataFim,List<ServicoDTO> listaServicos) throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaQtdSolicitacoesCanceladasFinalizadasporServicoNoPeriodo(dataIncio, dataFim, listaServicos);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findSolicitacoesNaoResolvidasNoPrazoKPI(RelatorioIncidentesNaoResolvidosDTO relatorioIncidentesNaoResolvidosDTO)throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).findSolicitacoesNaoResolvidasNoPrazoKPI(relatorioIncidentesNaoResolvidosDTO);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> findSolicitacoesNaoResolvidasEntrePrazoKPI(RelatorioIncidentesNaoResolvidosDTO relatorioIncidentesNaoResolvidosDTO)throws Exception {
		 return this.getDao().findSolicitacoesNaoResolvidasEntrePrazoKPI(relatorioIncidentesNaoResolvidosDTO);
	}

	@Override
	public Collection<RelatorioKpiProdutividadeDTO> listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito(RelatorioKpiProdutividadeDTO relatorioKpiProdutividadeDto) throws Exception {

		Collection<RelatorioKpiProdutividadeDTO> listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito = new ArrayList();
		listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito = this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito(relatorioKpiProdutividadeDto);

		if(listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito!=null){

			for(RelatorioKpiProdutividadeDTO relatorioKpiProdutividadeDTO : listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito){
				if(relatorioKpiProdutividadeDTO.getQtdeencaminhadas() > 0 ){
					Double porcentagemExecutadaExito ;
					porcentagemExecutadaExito = 100 *  ( relatorioKpiProdutividadeDTO.getQtdeexito().doubleValue() / relatorioKpiProdutividadeDTO.getQtdeencaminhadas().doubleValue());
					relatorioKpiProdutividadeDTO.setPorcentagemExecutadaExito(porcentagemExecutadaExito);

				}else{
					relatorioKpiProdutividadeDTO.setQtdeExecutada(0);

				}
			}

			return listaQuantitativaEmpregadoSolicitacoesEmcaminhaExito;
		}

		return null;
	}

	public Collection<SolicitacaoServicoDTO> listSolicitacoesFilhasFiltradas(GerenciamentoServicosDTO gerenciamentoBean, Collection<ContratoDTO> listContratoUsuarioLogado, TransactionControler tc) throws Exception {
		SolicitacaoServicoDao solicitacaoServicoDao = this.getDao();
		if (tc != null) {
			solicitacaoServicoDao.setTransactionControler(tc);
		}
		return solicitacaoServicoDao.listSolicitacoesFilhasFiltradas(gerenciamentoBean, listContratoUsuarioLogado);
	}

	@Override
	public boolean verificaPermGestorSolicitanteRH(Integer idSolicitante) throws PersistenceException {
		return this.getDao().verificaPermGestorSolicitanteRH(idSolicitante);
    }

	@Override
	public Collection<RelatorioCausaSolucaoDTO> listaCausaSolicitacao(RelatorioCausaSolucaoDTO relatorioCausaSolicitacao) throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaCausaSolicitacao(relatorioCausaSolicitacao);
	}

	@Override
	public Collection<RelatorioCausaSolucaoDTO> listaSolucaoSolicitacao(RelatorioCausaSolucaoDTO relatorioCausaSolicitacao) throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaSolucaoSolicitacao(relatorioCausaSolicitacao);
	}

	@Override
	public Collection<RelatorioCausaSolucaoDTO> listaCausaSolucaoAnalitico(RelatorioCausaSolucaoDTO relatorioCausaSolicitacao) throws Exception {
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaCausaSolucaoAnalitico(relatorioCausaSolicitacao);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacoesFilhasFiltradas(
			GerenciamentoServicosDTO gerenciamentoBean,
			Collection<ContratoDTO> listContratoUsuarioLogado) throws Exception {
		return listSolicitacoesFilhasFiltradas(gerenciamentoBean,listContratoUsuarioLogado, null);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listSolicitacoesFilhas() throws Exception {
		return listSolicitacoesFilhas(null);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, TipoSolicitacaoServico[] tiposSolicitacao) throws Exception {
		return listByTarefas(listTarefas, tiposSolicitacao, null);
	}

	public Collection<SolicitacaoServicoDTO> listByTarefas(Collection<TarefaFluxoDTO> listTarefas, Integer qtdAtual, Integer qtdAPaginacao, GerenciamentoServicosDTO gerenciamentoBean,
			Collection<ContratoDTO> listContratoUsuarioLogado) throws Exception {
		return listByTarefas(listTarefas, qtdAtual, qtdAPaginacao, gerenciamentoBean, listContratoUsuarioLogado, null);
	}

	@Override
	public void determinaPrazoLimite(SolicitacaoServicoDTO solicitacaoDto, Integer idCalendario, TransactionControler tc) throws Exception {
		solicitacaoDto.setIdCalendario(idCalendario);
		this.determinaPrazoLimite(solicitacaoDto, tc);
	}

	@Override
	public void determinaPrazoLimite(SolicitacaoServicoDTO solicitacaoDto, TransactionControler tc) throws Exception {
		if (solicitacaoDto.getDataHoraInicioSLA() == null) {
			return;
		}

		determinaCalendario(solicitacaoDto);

		if (solicitacaoDto.getPrazoHH() == null) {
			solicitacaoDto.setPrazoHH(0);
		}
		if (solicitacaoDto.getPrazoMM() == null) {
			solicitacaoDto.setPrazoMM(0);
		}

		CalculoJornadaDTO calculoDto = null;
		Integer prazoHH = 0;
		Integer prazoMM = 0;

		double tempoExecucaoESuspensaoDentroCalendario = this.getControleSLAService().obtenTempoSlaNaoContabilizado(solicitacaoDto.getIdSolicitacaoServico(), solicitacaoDto.getDataHoraInicioSLA());
		if (tempoExecucaoESuspensaoDentroCalendario>0){
			tempoExecucaoESuspensaoDentroCalendario += (solicitacaoDto.getPrazoHH()*3600) + (solicitacaoDto.getPrazoMM()*60);
			prazoHH = new Integer(Util.getHoraHHMMSS(tempoExecucaoESuspensaoDentroCalendario));
			prazoMM = new Integer(Util.getMinutoHHMMSS(tempoExecucaoESuspensaoDentroCalendario));
		} else {
			prazoHH = solicitacaoDto.getPrazoHH();
			prazoMM = solicitacaoDto.getPrazoMM();
		}
		
		calculoDto = new CalculoJornadaDTO(solicitacaoDto.getIdCalendario(), solicitacaoDto.getDataHoraInicioSLA(), prazoHH, prazoMM);
		calculoDto = new CalendarioServiceEjb().calculaDataHoraFinal(calculoDto, true, tc);

		solicitacaoDto.setDataHoraLimite(calculoDto.getDataHoraFinal());
	}

	@Override
	public Integer numeroSolicitacoesForaPeriodo(RelatorioIncidentesNaoResolvidosDTO relatorioIncidentesNaoResolvidosDTO) throws PersistenceException, ServiceException {
		return getSolicitacaoServicoDao().numeroSolicitacoesForaPeriodo(relatorioIncidentesNaoResolvidosDTO);
	}

	/**
	 * Novos mtodos para paginao
	 *
	 * @author thyen.chang
	 *
	 * @param pesquisaSolicitacaoServicoDto
	 * @return
	 * @throws Exception
	 */
	@Override
	public Long listaRelatorioGetQuantidadeRegistros(PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, final boolean isDetalhado) throws Exception {
		return getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaRelatorioGetQuantidadeRegistros(pesquisaSolicitacaoServicoDto, isDetalhado);
	}

	@Override
	public List<SolicitacaoServicoDTO> listPesquisaAvancadaPaginada(PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDTO, Integer paginaAtual, Integer quantidadePorPagina)
			throws Exception {
		return getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listPesquisaAvancadaPaginada(pesquisaSolicitacaoServicoDTO, paginaAtual, quantidadePorPagina);
	}

	@Override
    public List<SolicitacaoServicoDTO> listPesquisaAvancadaRelatorio(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDTO) throws Exception {
		return getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listPesquisaAvancadaRelatorio(pesquisaSolicitacaoServicoDTO);
	}

	@Override
	public ItemTrabalhoFluxoDTO restauraItemTrabalhoFluxoAtualDaSolicitacao(Integer idSolicitcaoServico) {
		ItemTrabalhoFluxoDTO itemTrabalhoFluxoDTOAtual = null;

		if (!Objects.equals(idSolicitcaoServico, null)) {
			try {
				Collection<ExecucaoSolicitacaoDTO> colExecucao = new ExecucaoSolicitacaoDao().listByIdSolicitacao(idSolicitcaoServico);

				if (CollectionUtils.isNotEmpty(colExecucao)) {
					ItemTrabalhoFluxoDao itemTrabalhoFluxoDao = new ItemTrabalhoFluxoDao();
					for (ExecucaoSolicitacaoDTO execucaoSolicitacaoDto : colExecucao) {
						Collection<ItemTrabalhoFluxoDTO> col_itemTrabalhoAtual_apenasUm = itemTrabalhoFluxoDao.findDisponiveisByIdInstancia(execucaoSolicitacaoDto.getIdInstanciaFluxo());

						if (CollectionUtils.isNotEmpty(col_itemTrabalhoAtual_apenasUm)) {
							itemTrabalhoFluxoDTOAtual = col_itemTrabalhoAtual_apenasUm.iterator().next();
							break;
						}
					}
				}
			} catch (PersistenceException perExc) {
				perExc.printStackTrace();
				itemTrabalhoFluxoDTOAtual = null;
			} catch (Exception exc) {
				exc.printStackTrace();
				itemTrabalhoFluxoDTOAtual = null;
			}
		}

		return itemTrabalhoFluxoDTOAtual;
	}

	@Override
	public Collection<AtribuicaoFluxoDTO> findTarefasDisponiveis(SolicitacaoServicoDTO solicitacao, TransactionControler tc) throws Exception {
		ExecucaoSolicitacaoDao execucaoSolicitacaoDao = new ExecucaoSolicitacaoDao();
		if (tc != null) {
			execucaoSolicitacaoDao.setTransactionControler(tc);
		}

		ExecucaoSolicitacaoDTO execucaoSolicitacao = execucaoSolicitacaoDao.findBySolicitacaoServico(solicitacao);
		if (execucaoSolicitacao != null) {
			AtribuicaoFluxoDao atribuicaoFluxoDao = new AtribuicaoFluxoDao();
			if (tc != null) {
				atribuicaoFluxoDao.setTransactionControler(tc);
			}
			return atribuicaoFluxoDao.findDisponiveisByIdInstancia(execucaoSolicitacao.getIdInstanciaFluxo());
		} else {
			return null;
		}
	}

	@Override
	public Collection<RelatorioIncidenteRequisicaoPorServicoDTO> listaRelatorioQuantitativoServicoCatalogo(
			RelatorioIncidenteRequisicaoPorServicoDTO dto) throws ParseException, PersistenceException {
		return getDao().listaRelatorioQuantitativoServicoCatalogo(dto);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> consultarIncidentesMajorAbertosEAprovados(Integer idUsuario, Integer idContinuidade){
		return getDao().consultarIncidentesMajorAbertosEAprovados(idUsuario, idContinuidade);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> consultarProcedimentosRelacionadosAoIncidenteMajor(Integer idUsuario){
		return getDao().consultarProcedimentosRelacionadosAoIncidenteMajor(idUsuario);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> consultarProcedimentosRelacionadosAoIncidenteMajor(SolicitacaoServicoDTO solicitacaoServicoDTO, Integer idUsuario){
		return getDao().consultarProcedimentosRelacionadosAoIncidenteMajor(solicitacaoServicoDTO, idUsuario);
	}

	@Override
	public Collection<SolicitacaoServicoDTO> consultarProcedimentosRelacionadosAoIncidenteMajor(SolicitacaoServicoDTO solicitacaoServicoDTO){
		return getDao().consultarProcedimentosRelacionadosAoIncidenteMajor(solicitacaoServicoDTO);
	}

	public Boolean existeSolicitacoesFilhas(TransactionControler tc, SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
		if (tc != null) {
			this.getDao().setTransactionControler(tc);
		}

		Collection<SolicitacaoServicoDTO> solicitacoesFilhas = this.getDao().findByIdSolicitacaoPai(solicitacaoServicoDTO.getIdSolicitacaoServico());

		if(solicitacoesFilhas != null && !solicitacoesFilhas.isEmpty()){
			return true;
		} else {
			return false;
		}
	}

	/**
	 * @throws PersistenceException
	 *
	 */
	@Override
	public Collection<SolicitacaoServicoDTO> consultarSeProcedimentosEstaCriadoParaIncidenteMajor(SolicitacaoServicoDTO solicitacaoServicoDTO) throws PersistenceException{
		return getDao().consultarSeProcedimentosEstaCriadoParaIncidenteMajor(solicitacaoServicoDTO);
	}

	@Override
	public SolicitacaoServicoDTO consultarSolicitacaoServico(Integer idSolicitacao){
		return getDao().consultarSolicitacaoServicoVinculadaComContinuidade(idSolicitacao);
	}

	/**
	 * Calcula o tempo restante do SLA, a partir do calendrio.
	 *
	 * @author euler.ramos
	 * @return String - formato HH:MM:SS
	 * @throws Exception
	 * @since 18.04.2016
	 */
	@Override
	public String calculaTempoRestante(Timestamp dataHoraLimite, Integer idCalendario) throws Exception {
		CalculoJornadaDTO calculoJornadaDTO;

		Timestamp dataHoraInicial = UtilDatas.getDataHoraAtual();
		if (dataHoraLimite == null) {
			return "00:00:00";
		}

		if (dataHoraLimite.compareTo(dataHoraInicial) >= 0) {
			calculoJornadaDTO = this.calculaTempoRestante(dataHoraInicial, dataHoraLimite, idCalendario);
			return String.format("%02d", calculoJornadaDTO.getTempoDecorridoHH()) + ":" + String.format("%02d", calculoJornadaDTO.getTempoDecorridoMM()) + ":" + String.format("%02d", calculoJornadaDTO.getTempoDecorridoSS());
		} else {
			return "00:00:00";
		}

	}

	/**
	 * Calcula o tempo de SLA compreendido entre duas datas, a partir do calendrio.
	 *
	 * @author euler.ramos
	 * @return CalculoJornadaDTO
	 * @throws Exception
	 * @since 18.04.2016
	 */
	public CalculoJornadaDTO calculaTempoRestante(Timestamp dataHoraInicial, Timestamp dataHoraLimite, Integer idCalendario) throws Exception {
		CalculoJornadaDTO calculoJornadaDTO = new CalculoJornadaDTO(idCalendario, dataHoraInicial);
		if (dataHoraLimite != null && dataHoraLimite.compareTo(dataHoraInicial) >= 0) {
			CalendarioService calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
			calculoJornadaDTO = calendarioService.calculaPrazoDecorridoComSegundos(calculoJornadaDTO, dataHoraLimite, null);
		}
		return calculoJornadaDTO;
	}

	@Override
	public Long retornaQtdeSolicitacoesDoSolicitante(final Integer idEmpregado) throws Exception {
		return getSolicitacaoServicoDao().retornaQtdeSolicitacoesDoSolicitante(idEmpregado);
	}

	@Override
	public Page<SolicitacaoServicoDTO> findSolicitacoesSolicitante(Integer idEmpregado, Integer idStatus, String campoBusca, Pageable pageable, Boolean isTotalizacao) throws Exception {
		if (idStatus == null || idStatus == 0) {
			idStatus = ServiceRequestStatus.IN_PROGRESS.getId();
		}
		return getSolicitacaoServicoDao().findSolicitacoesSolicitante(idEmpregado, idStatus, campoBusca, pageable, isTotalizacao);
	}

	@Override
	public SolicitacaoServicoDTO restoreSolicitacaoServicoWithIdTarefa(final Integer idSolicitacaoServico) throws Exception {
		try {
			return this.getSolicitacaoServicoDao().restoreSolicitacaoServicoWithIdTarefa(idSolicitacaoServico);
		} catch (Exception e) {
			throw e;
		}
	}

	@Override
	public Page<SolicitacaoServicoDTO> paginacaoPortal(GerenciamentoServicosDTO gerenciamentoBean, Pageable pageable, String vinculaColaboradorContrato) throws Exception {
		return getSolicitacaoServicoDao().paginacaoPortal(gerenciamentoBean, pageable, vinculaColaboradorContrato);
	}

	private void determinaCalendario(SolicitacaoServicoDTO solicitacaoServicoDto, ServicoContratoDTO servicoContratoDto) throws LogicException, ServiceException {
		Integer idCalendario = this.obtenIdCalendarioDaUnidade(solicitacaoServicoDto);
		if (idCalendario==null||idCalendario.intValue()<=0){
			if (servicoContratoDto == null) {
				throw new LogicException("Servio no localizado para o contrato");
			}
			idCalendario = servicoContratoDto.getIdCalendario();
		}
		solicitacaoServicoDto.setIdCalendario(idCalendario);
	}

	@Override
	public void determinaCalendario(SolicitacaoServicoDTO solicitacaoServicoDto) throws Exception {
		Integer idCalendario = solicitacaoServicoDto.getIdCalendario();
		if (idCalendario==null||idCalendario.intValue()<=0){
			idCalendario = this.obtenIdCalendarioDaUnidade(solicitacaoServicoDto);
			if (idCalendario==null||idCalendario.intValue()<=0){
				ServicoContratoDTO servicoContratoDto = new ServicoContratoDao().findByIdContratoAndIdServico(solicitacaoServicoDto.getIdContrato(), solicitacaoServicoDto.getIdServico());
				if (servicoContratoDto == null) {
					throw new LogicException("Servio no localizado para o contrato");
				}
				idCalendario = servicoContratoDto.getIdCalendario();
			}
			solicitacaoServicoDto.setIdCalendario(idCalendario);
		}
	}

	private Integer obtenIdCalendarioDaUnidade(SolicitacaoServicoDTO solicitacaoServicoDto) throws LogicException, ServiceException {
		if (solicitacaoServicoDto.getIdUnidade()!=null){
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			UnidadeDTO unidadeDTO = new UnidadeDTO();
			unidadeDTO.setIdUnidade(solicitacaoServicoDto.getIdUnidade());
			unidadeDTO = unidadeService.restore(unidadeDTO);
			if (unidadeDTO!=null){
				return unidadeDTO.getIdCalendario();
			}
		}
		return null;
	}


	@Override
	public Long getQtdSolicitacoesEmAndamentoPorCpf(String cpf) throws Exception{
		EmpregadoDTO empregado = getEmpregadoDao().restoreByCPF(cpf);
		if(empregado == null || empregado.getIdEmpregado() <= 0){
			return null;
		} else{
			return getSolicitacaoServicoDao().retornaQtdeSolicitacoesDoSolicitante(empregado.getIdEmpregado());
		}
	}

	@Override
	public SolicitacaoServicoDTO getSolicitacaoDeServicoEmAndamentoPorCpf(Integer idSolicitacaoServico, String cpf) throws Exception{
		EmpregadoDTO empregado = getEmpregadoDao().restoreByCPF(cpf);
		if(empregado == null || empregado.getIdEmpregado() <= 0){
			return null;
		} else{
			SolicitacaoServicoDTO solicitacao = getSolicitacaoServicoDao().restoreAll(idSolicitacaoServico);
			if(solicitacao != null && solicitacao.getIdSolicitante() != null && solicitacao.getIdSolicitante().equals(empregado.getIdEmpregado())){
				return solicitacao;
			} else {
				return null;
			}
		}
	}

	@Override
	public ArrayList<SolicitacaoServicoDTO> obterSolicitacoesDeServicoEmAndamentoPorCpf(String cpf) throws PersistenceException, ServiceException{
		EmpregadoDTO empregado = getEmpregadoDao().restoreByCPF(cpf);
		if(empregado == null || empregado.getIdEmpregado() <= 0){
			return null;
		} else{
			ArrayList<SolicitacaoServicoDTO> listaSolicitacao = getSolicitacaoServicoDao().obterSolicitacoesDeServicoEmAndamentoPorSolicitante(empregado.getIdEmpregado());
			return listaSolicitacao;
		}
	}

	@Override
	public ArrayList<CtrlTelefoniaDTO> obterItensTrabalhoParaExecucaoSolicitacaoServico(Integer idSolicitacaoServico, Integer idUsuario) throws PersistenceException{
		return this.getDao().obterItensTrabalhoParaExecucaoSolicitacaoServico(idSolicitacaoServico, idUsuario);
	}

	@Override
	public ArrayList<CtrlTelefoniaDTO> obterItensTrabalhoParaVisualizacaoSolicitacaoServico(Integer idSolicitacaoServico, Integer idUsuario) throws PersistenceException{
		return this.getDao().obterItensTrabalhoParaVisualizacaoSolicitacaoServico(idSolicitacaoServico, idUsuario);
	}

	@Override
	public boolean verificaContSolAndamento(Integer idContrato) throws Exception {
		return this.getDao().verificaContSolAndamento(idContrato);
	}

	@Override
	public List<SolicitacaoServicoDTO> recuperaSolicitacoesPorUsuario(UsuarioDTO usuario) throws Exception {
		return this.getDao().recuperaSolicitacoesPorUsuarioComFiltro(usuario, null, null);
	}

	@Override
	public List<SolicitacaoServicoDTO> recuperaSolicitacoesPorUsuarioComFiltro(UsuarioDTO usuario, Collection<ContratoDTO> listContratoUsuarioLogado, GerenciamentoServicosDTO gerenciamentoServicosDTO) throws Exception {
		return this.getDao().recuperaSolicitacoesPorUsuarioComFiltro(usuario, listContratoUsuarioLogado, gerenciamentoServicosDTO);
	}

	@Override
	public void atualizarTemposDeAtendimento(Integer idSolicitacaoServico, double prazo, TransactionControler tc) {
		this.getDao().atualizarTempoDeAtendimentoSolicitacaoServico(idSolicitacaoServico, prazo, tc);
	}

	@Override
	public void atualizarDataHoraLimiteETempoDeAtrasoDaSolicitacaoServico(Integer idSolicitacaoServico, double tempoAtraso, Timestamp dataHoraLimiteSla, TransactionControler tc) {
		this.getDao().atualizarDataHoraLimiteETempoDeAtrasoDaSolicitacaoServico(idSolicitacaoServico, tempoAtraso, dataHoraLimiteSla, tc);
	}

	@Override
	public void atualizarTempoDeAtrasoDaSolicitacaoServico(Integer idSolicitacaoServico, double tempoAtraso, TransactionControler tc) {
		this.getDao().atualizarTempoDeAtrasoDaSolicitacaoServico(idSolicitacaoServico, tempoAtraso, tc);
	}

	private ControleSlaService getControleSLAService() throws Exception {
		if (controleSLAService == null) {
			controleSLAService = (ControleSlaService) ServiceLocator.getInstance().getService(ControleSlaService.class, null);
		}
		return controleSLAService;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws Exception {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}
}