package br.com.centralit.citcorpore.negocio;

import br.com.centralit.citcorpore.bean.GerenciamentoRotasDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.bean.result.GerenciamentoRotasResultDTO;
import br.com.centralit.citcorpore.util.Enumerados.TipoSolicitacaoServico;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudService;

/**
 * Servios para as consultas de {@link SolicitacaoServicoDTO} realizadas pelo mobile V2
 *
 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
 * @since 09/10/2014
 *
 */
public interface SolicitacaoServicoServiceForMobileV2 extends CrudService {

    /**
     * Lista {@link SolicitacaoServicoDTO} de acordo com a mais recente presente no APP
     *
     * @param newestNumber
     *            nmero de solicitao mais recente presente no mobile
     * @param usuario
     *            usurio que est solicitando a listagem
     * @param tiposSolicitacao
     *            tipos de solicitao a serem consideradas na listagem
     * @param aprovacao
     *            identificador de se a solicitao est ou no em aprovao
     * @return {@link Page} contendo os registros resultantes da consulta
     * @throws ServiceException
     */
    Page<SolicitacaoServicoDTO> listNewest(final Integer newestNumber, final UsuarioDTO usuario, final TipoSolicitacaoServico[] tiposSolicitacao, final String aprovacao, final int ordem)
            throws ServiceException;

    /**
     * Lista {@link SolicitacaoServicoDTO} de acordo com a mais antiga presente no APP
     *
     * @param oldestNumber
     *            nmero de solicitao mais antiga presente no mobile
     * @param usuario
     *            usurio que est solicitando a listagem
     * @param tiposSolicitacao
     *            tipos de solicitao a serem consideradas na listagem
     * @param aprovacao
     *            identificador de se a solicitao est ou no em aprovao
     * @return {@link Page} contendo os registros resultantes da consulta
     * @throws ServiceException
     */
    Page<SolicitacaoServicoDTO> listOldest(final Integer oldestNumber, final UsuarioDTO usuario, final TipoSolicitacaoServico[] tiposSolicitacao, final String aprovacao, final int ordem)
            throws ServiceException;

    /**
     * Lista {@link SolicitacaoServicoDTO} de acordo com o posicionamento geogrfico do usurio
     *
     * @param latitude
     *            latitude do posicionamento do usurio
     * @param longitude
     *            longitude do posicionamento do usurio
     * @param usuario
     *            usurio que est solicitando a listagem
     * @param tiposSolicitacao
     *            tipos de solicitao a serem consideradas na listagem
     * @param aprovacao
     *            identificador de se a solicitao est ou no em aprovao
     * @param pageable
     *            informao sobre paginao
     * @return {@link Page} contendo os registros resultantes da consulta
     * @throws ServiceException
     */
    Page<SolicitacaoServicoDTO> listByCoordinates(final Double latitude, final Double longitude, final UsuarioDTO usuario, final TipoSolicitacaoServico[] tiposSolicitacao,
            final String aprovacao, final Pageable pageable) throws ServiceException;

    /**
     * Lista solicitaes de servios para roteirizao
     *
     * @param filter
     *            informaes para filtro
     * @param pageable
     *            informaes para paginao
     * @return {@link Page} contendo os registros resultantes da consulta
     * @throws ServiceException
     * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
     * @date 17/11/2014
     */
    Page<GerenciamentoRotasResultDTO> listSolicitacoesParaRoteirizacao(final GerenciamentoRotasDTO filter, final Pageable pageable) throws ServiceException;

    /**
     * Busca lista de {@link SolicitacaoServicoDTO} de acordo com o texto passado como parmetro. Campos da busca:
     * 
     * - Nome do Contrato;
     * - Nmero da solicitao;
     * - Nome da Unidade;
     * - Grupo executor.
     *
     * @param newestNumber
     *            nmero de solicitao mais recente presente no mobile
     * @param usuario
     *            usurio que est solicitando a listagem
     * @param tiposSolicitacao
     *            tipos de solicitao a serem consideradas na listagem
     * @param aprovacao
     *            identificador de se a solicitao est ou no em aprovao
     * @param textoBusca
     * 			  texto enviado utilizado para a busca dos campos
     * @return {@link Page} contendo os registros resultantes da consulta
     * @throws ServiceException
     * @author thyen.chang
     * @date 07/01/2016
     */
    Page<SolicitacaoServicoDTO> buscaSolicitacao(final Integer newestNumber, final UsuarioDTO usuario, final TipoSolicitacaoServico[] tiposSolicitacao, final String aprovacao, final String textoBusca, final String listaSolicitacoes)
            throws ServiceException;
    
    Page<SolicitacaoServicoDTO> listNotificationByNumberAndUser(final Integer number, final UsuarioDTO user) throws ServiceException;

}
