package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import br.com.citframework.service.CrudService;
import br.com.centralit.citcorpore.bean.TabFederacaoDadosDTO;
import br.com.citframework.integracao.TransactionControler;

import br.com.citframework.excecao.PersistenceException;
public interface TabFederacaoDadosService extends CrudService {
	public Collection findByNomeTabela(String parm) throws Exception;
	public void deleteByNomeTabela(String parm) throws Exception;
	public Collection findByChaveFinal(String parm) throws Exception;
	public void deleteByChaveFinal(String parm) throws Exception;
	public Collection findByChaveOriginal(String parm) throws Exception;
	public void deleteByChaveOriginal(String parm) throws Exception;
	public Collection findByOrigem(String parm) throws Exception;
	public void deleteByOrigem(String parm) throws Exception;
	
	public TabFederacaoDadosDTO create(TabFederacaoDadosDTO federacaoDados, TransactionControler tc) throws Exception;
	public void update(TabFederacaoDadosDTO federacaoDados, TransactionControler tc) throws Exception;
	public TabFederacaoDadosDTO createOrUpdate(TabFederacaoDadosDTO federacaoDados, TransactionControler tc) throws Exception;
	public Collection find(String origem, String nomeTab, String chaveOrig, String chaveFinal) throws Exception;
	public Collection findByChaveOriginal(String origem, String tabela, String chaveOriginal) throws Exception;
}
