package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.TempoAtendimentoEmpregadoDTO;
import br.com.centralit.citcorpore.integracao.TempoAtendimentoEmpregadoDao;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @author rodrigo.guilherme
 * @since 19.11.2015
 */

@SuppressWarnings("unchecked")
public class TempoAtendimentoEmpregadoServiceEjb extends CrudServiceImpl implements TempoAtendimentoEmpregadoService {

	private TempoAtendimentoEmpregadoDao dao;

	@Override
	protected TempoAtendimentoEmpregadoDao getDao() {
		if (dao == null) {
			dao = new TempoAtendimentoEmpregadoDao();
		}
		return dao;
	}

	@Override
	public Collection<TempoAtendimentoEmpregadoDTO> findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		return this.getDao().findByIdAcordoNivelServico(idAcordoNivelServico);
	}
	

	@Override
	public Collection<TempoAtendimentoEmpregadoDTO> findByIdEmpregado(Integer idEmpregado) throws Exception{
		return this.getDao().findByIdEmpregado(idEmpregado);
	}

	@Override
	public ArrayList<TempoAtendimentoEmpregadoDTO> listEmpregadosByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		return this.getDao().listEmpregadosByIdAcordoNivelServico(idAcordoNivelServico);
	}

	@Override
	public TempoAtendimentoEmpregadoDTO restoreByIdEmpregadoIdANS(Integer idEmpregado, Integer idAcordoNivelServico) throws Exception {
		return this.getDao().restoreByIdEmpregadoIdANS(idEmpregado, idAcordoNivelServico);
	}
}
