package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.TempoAtendimentoUnidadeDTO;
import br.com.centralit.citcorpore.integracao.TempoAtendimentoUnidadeDao;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @author rodrigo.guilherme
 * @since 19.11.2015
 */

@SuppressWarnings("unchecked")
public class TempoAtendimentoUnidadeServiceEjb extends CrudServiceImpl implements TempoAtendimentoUnidadeService {

	private TempoAtendimentoUnidadeDao dao;
	
	@Override
	protected TempoAtendimentoUnidadeDao getDao() {
		if (dao == null) {
			dao = new TempoAtendimentoUnidadeDao();
		}
		return dao;
	}

	@Override
	public Collection<TempoAtendimentoUnidadeDTO> findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		return this.getDao().findByIdAcordoNivelServico(idAcordoNivelServico);
	}
	
	@Override
	public Collection<TempoAtendimentoUnidadeDTO> findByIdUnidade(Integer idUnidade) throws Exception{
		return this.getDao().findByIdUnidade(idUnidade);
	}

	@Override
	public ArrayList<TempoAtendimentoUnidadeDTO> listUnidadesByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		return this.getDao().listUnidadesByIdAcordoNivelServico(idAcordoNivelServico);
	}

	@Override
	public TempoAtendimentoUnidadeDTO restoreByIdUnidadeIdANS(Integer idUnidade, Integer idAcordoNivelServico) throws Exception {
		return this.getDao().restoreByIdUnidadeIdANS(idUnidade, idAcordoNivelServico);
	}
}
