package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.Map;

import br.com.centralit.citcorpore.bean.TipoDemandaServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudService;

public interface TipoDemandaServicoService extends CrudService {

    Collection<TipoDemandaServicoDTO> listSolicitacoes() throws Exception;
    Collection<TipoDemandaServicoDTO> listSolicitacoesServico() throws Exception;

    /**
     * Metodo responsavel por validar se existe vinculo entre o Tipo de Demanda e Servico
     *
     * @param mapFields
     * @return <p>
     *         Boolean
     *         </p>
     *
     * @author Ezequiel
     */
    boolean existeCadastroServicoVinculado(final Map mapFields) throws Exception;

	public Collection<TipoDemandaServicoDTO> findByClassificacao(String classificacao) throws PersistenceException;

	/**
	 * Metodo reponsavel por buscar os tipos de demandas dos servios que esto
	 * ativos
	 * 
	 * @author rodrigo.guilherme
	 * @date 2015-08-20
	 */
	public Collection<TipoDemandaServicoDTO> getAtivos() throws PersistenceException, Exception;
	
	public Collection<TipoDemandaServicoDTO> findRequisicaoIncidente() throws PersistenceException;
}
