package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import br.com.centralit.citcorpore.bean.TipoDemandaServicoDTO;
import br.com.centralit.citcorpore.integracao.TipoDemandaServicoDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

public class TipoDemandaServicoServiceEjb extends CrudServiceImpl implements TipoDemandaServicoService {

    private TipoDemandaServicoDao dao;

    @Override
    protected TipoDemandaServicoDao getDao() {
        if (dao == null) {
            dao = new TipoDemandaServicoDao();
        }
        return dao;
    }

    @Override
    public Collection<TipoDemandaServicoDTO> listSolicitacoes() throws Exception {
        return this.getDao().listSolicitacoes();
    }
    
    @Override
    public Collection<TipoDemandaServicoDTO> listSolicitacoesServico() throws Exception {
        return this.getDao().listSolicitacoesServico();
    }

    /**
     * @see br.com.centralit.citcorpore.negocio.TipoDemandaService#validarExclusaoVinculada(HashMap)
     *
     * @author Ezequiel
     */
    @Override
    public boolean existeCadastroServicoVinculado(final Map mapFields) throws Exception {
    	if("".equals(mapFields.get("IDTIPODEMANDASERVICO"))){
    		return false;
    	}
        final List resultado = this.getDao().validarExclusaoVinculada(mapFields);

        final TipoDemandaServicoDTO tp = (TipoDemandaServicoDTO) resultado.get(0);

        return tp.getQuantidade() != null && tp.getQuantidade() > 0;
    }

	@Override
	public Collection<TipoDemandaServicoDTO> findByClassificacao(String classificacao) throws PersistenceException {
		return this.getDao().findByClassificacao(classificacao);
	}

	/**
	 * @author rodrigo.guilherme
	 * @throws PersistenceException
	 * @since 20/08/2015
	 */
	@Override
	public Collection<TipoDemandaServicoDTO> getAtivos() throws PersistenceException, Exception {
		return this.getDao().getAtivos();
	}

	@Override
	public Collection<TipoDemandaServicoDTO> findRequisicaoIncidente() throws PersistenceException {
		return this.getDao().findRequisicaoIncidente();
	}
}
