/**
 * CentralIT - CITSmart.
 */
package br.com.centralit.citcorpore.negocio;

import java.text.ParseException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.TipoItemConfiguracaoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Service de TipoItemConfiguracao.
 * 
 * @author valdoilo.damasceno
 * 
 */
public interface TipoItemConfiguracaoService extends CrudService {

	/**
	 * Cria novo TipoItemConfiguracao.
	 * 
	 * @param tipo
	 * @param request
	 * @return IDto
	 * @throws LogicException
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 */
	public IDto create(IDto tipo, HttpServletRequest request) throws LogicException, ServiceException;

	/**
	 * Restaura GRID de Caracterstica.
	 * 
	 * @param document
	 *            - DocumentHTML
	 * @param caracteristicas
	 *            - Collection
	 * @author valdoilo.damasceno
	 */
	public void restaurarGridCaracteristicas(DocumentHTML document, Collection<CaracteristicaDTO> caracteristicas);

	/**
	 * Restura GRID de caractersticas do Item de Configurao Filho selecionado na tela de Patrimnio.
	 * 
	 * @param document
	 *            - DocumentHTML
	 * @param caracteristicas
	 *            -Collection
	 * @author valdoilo.damasceno
	 */
	public void restaurarGridCaracteristicasItemConfiguracaoFilho(DocumentHTML document, Collection<CaracteristicaDTO> caracteristicas);

	/**
	 * Verifica se Tipo Item Configurao informada existe.
	 * 
	 * @param tipoItemConfiguracao
	 * @return
	 * @throws PersistenceException
	 * @author Thays.araujo
	 */
	public boolean verificarSeTipoItemConfiguracaoExiste(TipoItemConfiguracaoDTO tipoItemConfiguracao) throws PersistenceException;
	
	/**
	 * Verifica se o Tipo Item Configurao est associado a algum Item Configurao
	 * @param tipoItemConfiguracao
	 * @return
	 * @throws PersistenceException
	 * @author thyen.chang 
	 */
	public boolean verificaAssociacaoItemConfiguracao(TipoItemConfiguracaoDTO tipoItemConfiguracao) throws PersistenceException;

	/**
	 * Busca os Tipos de Item de Configurao do tipo SISTEMA.
	 * 
	 * @param tipoItemConfiguracao
	 * @return
	 * @throws PersistenceException
	 * @author Cleziomar.Egidio
	 */
	public Collection<TipoItemConfiguracaoDTO> listTipoDeItensDeConfiguracaoDeSistema() throws Exception;

	/**
	 * Retorna os tipos de item de configurao dos itens relacionados do item configurao pai.
	 * 
	 * @param idItemConfiguracaoPai
	 * @return
	 * @throws PersistenceException
	 * @throws ParseException
	 * @author rodrigo.acorse
	 */
	public Collection<TipoItemConfiguracaoDTO> findTipoItemConfiguracaoItensRelacionados(Integer idItemConfiguracaoPai) throws PersistenceException, ParseException;

}
