package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.TipoMudancaDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.service.CrudService;

public interface TipoMudancaService extends CrudService {

	Collection<TipoMudancaDTO> findByIdTipoMudanca(final Integer parm) throws Exception;

	Collection<TipoMudancaDTO> findByNomeTipoMudanca(final Integer parm) throws Exception;

	Collection<TipoMudancaDTO> tiposAtivosPorNome(final String nome);

	boolean verificarTipoMudancaAtivos(final TipoMudancaDTO obj) throws Exception;

	Collection<TipoMudancaDTO> encontrarPorNomeTipoMudanca(final TipoMudancaDTO obj) throws Exception;

	Collection<TipoMudancaDTO> getAtivos() throws Exception;

	boolean isTipoMudancaComFluxoNormal(Integer idTipoMudanca) throws Exception;

	boolean isTipoMudancaComFluxoPadraoOuEmergencial(Integer idTipoMudanca) throws Exception;

	void updateNotNull(IDto obj) throws Exception;

	boolean isTipoMudancaComFaseProposta(Integer idTipoMudanca) throws Exception;

	boolean isTipoMudancaComFaseAprovacao(Integer idTipoMudanca) throws Exception;

	boolean isTipoMudancaComFaseAprovacaoOuProposta(Integer idTipoMudanca) throws Exception;
}
