package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.TipoMudancaDTO;
import br.com.centralit.citcorpore.integracao.TipoMudancaDAO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class TipoMudancaServiceEjb extends CrudServiceImpl implements TipoMudancaService {

	private TipoMudancaDAO dao;

	@Override
	protected TipoMudancaDAO getDao() {
		if (dao == null) {
			dao = new TipoMudancaDAO();
		}
		return dao;
	}

	@Override
	public Collection<TipoMudancaDTO> findByIdTipoMudanca(final Integer parm) throws Exception {
		try {
			return this.getDao().findByIdTipoMudanca(parm);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<TipoMudancaDTO> findByNomeTipoMudanca(final Integer parm) throws Exception {
		return this.getDao().findByNomeTipoMudanca(parm);
	}

	@Override
	public Collection<TipoMudancaDTO> tiposAtivosPorNome(final String nome) {
		final List<Condition> condicoes = new ArrayList<Condition>();
		condicoes.add(new Condition("nomeTipoMudanca", nome));
		condicoes.add(new Condition("datafim", Condition.NOT_EQUALS, null));
		try {
			return this.getDao().findByCondition(condicoes, null);
		} catch (final Exception e) {
			e.printStackTrace();
		}
		return new ArrayList<>();
	}

	@Override
	public boolean verificarTipoMudancaAtivos(final TipoMudancaDTO obj) throws Exception {
		return this.getDao().verificarTipoMudancaAtivos(obj);
	}

	@Override
	public Collection<TipoMudancaDTO> encontrarPorNomeTipoMudanca(final TipoMudancaDTO obj) throws Exception {
		return this.getDao().encontrarPorNomeTipoMudanca(obj);
	}

	@Override
	public Collection<TipoMudancaDTO> getAtivos() throws Exception {
		return this.getDao().getAtivos();
	}

	@Override
	public boolean isTipoMudancaComFluxoNormal(Integer idTipoMudanca) throws Exception {
		return this.getDao().isTipoMudancaComFluxoNormal(idTipoMudanca);
	}

	@Override
	public boolean isTipoMudancaComFluxoPadraoOuEmergencial(Integer idTipoMudanca) throws Exception {
		return this.getDao().isTipoMudancaComFluxoPadraoOuEmergencial(idTipoMudanca);
	}

	@Override
	public void updateNotNull(IDto obj) throws Exception {
		this.getDao().updateNotNull(obj);
	}

	@Override
	public boolean isTipoMudancaComFaseProposta(Integer idTipoMudanca) throws Exception {
		return this.getDao().isTipoMudancaComFaseProposta(idTipoMudanca);
	}

	@Override
	public boolean isTipoMudancaComFaseAprovacao(Integer idTipoMudanca) throws Exception {
		return this.getDao().isTipoMudancaComFaseAprovacao(idTipoMudanca);
	}

	@Override
	public boolean isTipoMudancaComFaseAprovacaoOuProposta(Integer idTipoMudanca) throws Exception {
		return this.getDao().isTipoMudancaComFaseAprovacaoOuProposta(idTipoMudanca);
	}

}
