package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citcorpore.bean.TipoServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudService;

/**
 * @author leandro.viana
 * 
 */
public interface TipoServicoService extends CrudService {

	/**
	 * Verifica se tipo servio.
	 * 
	 * @param tipoServicoDTO
	 * @return true - existe; false - no existe;
	 * @throws PersistenceException
	 */
	public boolean verificarSeTipoServicoExiste(TipoServicoDTO tipoServicoDto) throws PersistenceException, br.com.citframework.excecao.ServiceException;

	/**
	 * Metodo responsavel por verificar se existe vinculo entre o tipo de servio e cadastro de servio
	 * 
	 * @param idTipoServico
	 * @author Ezequiel
	 * @data  25/11/2014
	 */
	public boolean existeVinculadoCadastroServico(final Integer idTipoServico) throws PersistenceException, Exception;
	
	public void substituiNomeTipoServicoQuandoBlank(final TipoServicoDTO tipoServicoDTO, final HttpServletRequest request);

	/**
	 * Metodo reponsavel por buscar osd tipos de negocio que esto ativos
	 * 
	 * @author rodrigo.guilherme
	 * @date 2015-08-20
	 */
	public Collection<TipoServicoDTO> getAtivos() throws PersistenceException, Exception;

}
