package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citcorpore.bean.TipoServicoDTO;
import br.com.centralit.citcorpore.integracao.TipoServicoDao;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings("rawtypes")
public class TipoServicoServiceEjb extends CrudServiceImpl implements TipoServicoService {

    private TipoServicoDao dao;

    @Override
    protected TipoServicoDao getDao() {
        if (dao == null) {
            dao = new TipoServicoDao();
        }
        return dao;
    }

    public Collection list(final List ordenacao) throws LogicException, ServiceException {
        return null;
    }

    public Collection list(final String ordenacao) throws LogicException, ServiceException {
        return null;
    }

    @Override
    public boolean verificarSeTipoServicoExiste(final TipoServicoDTO tipoServicoDto) throws PersistenceException, ServiceException {
        return this.getDao().verificarSeTipoServicoExiste(tipoServicoDto);
    }

    /**
     * Metodo responsavel por verificar se existe vinculo entre o tipo de servio e cadastro de servio
     *
     * @param idTipoServico
     * @author Ezequiel
     * @throws Exception
     * @throws PersistenceException
     * @throws Exception
     * @data 25/11/2014
     */
    @Override
    public boolean existeVinculadoCadastroServico(final Integer idTipoServico) throws PersistenceException, Exception {
        return this.getDao().existeVinculadoCadastroServico(idTipoServico);
    }
    
    /**
     * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
     * @param TipoServicoDTO
     * @since 01/07/2015
     */
    @Override
	public void substituiNomeTipoServicoQuandoBlank(final TipoServicoDTO tipoServicoDTO, final HttpServletRequest request) {
        try {
            if (StringUtils.isBlank(tipoServicoDTO.getNomeTipoServico())) {
                tipoServicoDTO.setNomeTipoServico(UtilI18N.internacionaliza(request, "comum.SemTitulo"));
            }
        } catch (IllegalArgumentException illegArgExc) {
            illegArgExc.printStackTrace();
        }
    }

	/**
	 * @author rodrigo.guilherme
	 * @throws PersistenceException
	 * @since 19/08/2015
	 */
	@Override
	public Collection<TipoServicoDTO> getAtivos() throws PersistenceException, Exception {
		return this.getDao().getAtivos();
	}

}
