package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.RelatorioTop10IncidentesRequisicoesDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.Top10IncidentesRequisicoesDTO;
import br.com.centralit.citcorpore.integracao.Top10IncidentesRequisicoesDAO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class Top10IncidentesRequisicoesServiceEjb extends CrudServiceImpl implements Top10IncidentesRequisicoesService {

    private Top10IncidentesRequisicoesDAO dao;
    private Top10IncidentesRequisicoesDAO daoReports;

    @Override
    protected Top10IncidentesRequisicoesDAO getDao() {
        if (dao == null) {
            dao = new Top10IncidentesRequisicoesDAO();
        }
        return dao;
    }
    
    /**
	 * Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:00 - ID Citsmart: 176362 -
	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
	private Top10IncidentesRequisicoesDAO getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (daoReports == null) {
				daoReports = new Top10IncidentesRequisicoesDAO(databaseAlias);
			}
			return daoReports;
		}
		return this.getDao();
	}

    @Override
    public ArrayList<Top10IncidentesRequisicoesDTO> listSolicitantesMaisAbriramIncSol(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:00 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listSolicitantesMaisAbriramIncSol(relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> listDetalheSolicitanteMaisAbriuIncSol(final Integer idSolicitante,
            final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:15 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
		return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listDetalheSolicitanteMaisAbriuIncSol(idSolicitante,
				relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public ArrayList<Top10IncidentesRequisicoesDTO> listGruposMaisResolveramIncSol(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:24 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listGruposMaisResolveramIncSol(relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> listDetalheGruposMaisResolveramIncSol(final Integer idGrupo,
            final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:25 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listDetalheGruposMaisResolveramIncSol(idGrupo, relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public ArrayList<Top10IncidentesRequisicoesDTO> listReqIncMaisSolicitados(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:25 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listReqIncMaisSolicitados(relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> listDetalheReqIncMaisSolicitados(final Integer idTipoDemanda, final Integer idServico,
            final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:25 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listDetalheReqIncMaisSolicitados(idTipoDemanda, idServico, relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public ArrayList<Top10IncidentesRequisicoesDTO> listUnidadesMaisAbriramReqInc(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:27 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listUnidadesMaisAbriramReqInc(relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> listDetalheUnidadesMaisAbriramReqInc(final Integer id,
            final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:27 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listDetalheUnidadesMaisAbriramReqInc(id, relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public ArrayList<Top10IncidentesRequisicoesDTO> listLocMaisAbriramReqInc(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:26 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listLocMaisAbriramReqInc(relatorioTop10IncidentesRequisicoesDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> listDetalheLocMaisAbriramReqInc(final Integer id, final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 10:26 - ID Citsmart: 176362 -
		// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO,
		// citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listDetalheLocMaisAbriramReqInc(id, relatorioTop10IncidentesRequisicoesDTO);
    }

}
