package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ADUserDTO;
import br.com.centralit.citcorpore.bean.LoginDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.bean.result.ItemQuantidadeDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

public interface UsuarioService extends CrudService {

	/**
	 * Restaura Usurio por Login.
	 *
	 * @param login
	 * @return
	 * @throws ServiceException
	 * @throws LogicException
	 */
	public UsuarioDTO restoreByLogin(String login) throws ServiceException, LogicException;

	public UsuarioDTO restoreByID(Integer id) throws ServiceException, LogicException;

	public UsuarioDTO restoreByLogin(String login, String senha) throws ServiceException, LogicException;

	public void deleteByIdEmpregado(Integer idEmpregado) throws ServiceException, Exception;

	public UsuarioDTO restoreByIdEmpregado(Integer idEmpregado) throws ServiceException, Exception;

	public IDto createFirs(IDto model) throws ServiceException, LogicException;

	public UsuarioDTO listStatus(UsuarioDTO obj) throws Exception;

	public UsuarioDTO listLogin(UsuarioDTO obj) throws Exception;

	public UsuarioDTO listUsuarioExistente(UsuarioDTO obj) throws Exception;

	public boolean listSeVazio() throws Exception;

	void updateNotNull(IDto dto);

	/**
	 * Sincroniza Usurio que logou no sistema.
	 *
	 * @param usuarioAd
	 * @param login
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void sincronizaUsuarioAD(ADUserDTO usuarioAd, LoginDTO login, Boolean isImport) throws ServiceException, Exception;

	/**
	 * Sincroniza Usurio pela rotina de Schedule.
	 *
	 * @param usuarioAd
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void sincronizaUsuarioAD(ADUserDTO usuarioAd, Integer idGrupoSolicitante) throws ServiceException, Exception;

	public UsuarioDTO restoreByIdEmpregadosDeUsuarios(Integer idEmpregado) throws Exception;

	/**
	 * Verifica se usurio informado  um usurio do AD.
	 *
	 * @param usuarioDto
	 * @return true - Usurio do AD; false - Usurio cadastrado pelo sistema.
	 * @throws Exception
	 */
	public boolean usuarioIsAD(UsuarioDTO usuarioDto) throws Exception;

	/**
	 * Gera carga de Usurios do AD atravs de Arquivo .csv
	 *
	 * @param arquivo
	 * @throws IOException
	 * @author Vadoilo Damasceno
	 */
	public void gerarCarga(File arquivo) throws IOException;

	@SuppressWarnings("rawtypes")
	public Collection listAtivos() throws Exception;

	public Collection<UsuarioDTO> consultarUsuarioPorNomeAutoComplete(String nome) throws Exception;

	public Collection<UsuarioDTO> getUsuariosDosGruposDoUsuarioLogado(Integer idUsuario, String txtFiltro) throws Exception;

	public Collection<UsuarioDTO> getUsuariosDosGruposDoUsuarioLogado(Integer idUsuario, String txtFiltro, int limite) throws Exception;

	/**
	 * Retorna a quantidade de usurios ativos no sistema
	 *
	 * @return Long
	 * @throws Exception
	 * @author renato.jesus
	 */
	public Long retornaQuantidadeUsuariosAtivos() throws Exception;

	/**
	 * Consulta utilizada para Autocomplete de Responsvel na tela de Gerenciamento de Servios opo Mais Filtros.
	 *
	 * @param nome
	 *            - Nome do usurio.
	 * @param idContrato
	 *            - Identificador nico do contrato selecionado.
	 * @param idUnidade
	 *            - Identificador nico da unidade selecionada.
	 * @return Collection<UsuarioDTO> com os atributos idEmpregado, nome e idUsuario preenchidos.
	 * @author valdoilo.damasceno
	 * @since 27.02.2015
	 */
	public Collection<UsuarioDTO> findUsuarioByNomeAndIdContratoAndIdUnidade(String nome, Integer idContrato, Integer idUnidade) throws PersistenceException;

	/**
	 * Consulta utilizada para Autocomplete de Responsvel na tela de Gerenciamento de Servios opo Mais Filtros.
	 *
	 * @param nome
	 *            - Nome do usurio.
	 * @return Collection<UsuarioDTO> com os atributos idEmpregado, nome e idUsuario preenchidos.
	 * @author valdoilo.damasceno
	 * @since 27.02.2015
	 */
	public Collection<UsuarioDTO> findUsuarioByNome(String nome) throws PersistenceException;

	/**
	 * Count users by status (active or not)
	 *
	 * @author douglas.japiassu
	 * @since 26.10.2016
	 */
	public List<ItemQuantidadeDTO> countByStatus() throws Exception;

}
