package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.VinculoHabilidadeColaboradorDTO;
import br.com.centralit.citcorpore.integracao.VinculoHabilidadeColaboradorDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public class VinculoHabilidadeColaboradorServiceEjb extends CrudServiceImpl implements VinculoHabilidadeColaboradorService {

	private VinculoHabilidadeColaboradorDao vinculoHabilidadeColaboradorDao;

	@Override
	protected VinculoHabilidadeColaboradorDao getDao() {
		if(vinculoHabilidadeColaboradorDao == null){
			vinculoHabilidadeColaboradorDao = new VinculoHabilidadeColaboradorDao();
		}
		return vinculoHabilidadeColaboradorDao;
	}

	@Override
	public IDto create(final IDto model) throws ServiceException, LogicException {
		VinculoHabilidadeColaboradorDTO vinculoHabilidadeColaboradorDTO = (VinculoHabilidadeColaboradorDTO) model;

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {
			this.validaCreate(model);

			this.getDao().setTransactionControler(tc);

			tc.start();

			vinculoHabilidadeColaboradorDTO = (VinculoHabilidadeColaboradorDTO) this.getDao().create(vinculoHabilidadeColaboradorDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}

		}
		return vinculoHabilidadeColaboradorDTO;
	}

	@Override
	public void delete(final IDto model) throws ServiceException, LogicException {
		final VinculoHabilidadeColaboradorDTO vinculoHabilidadeColaboradorDTO = (VinculoHabilidadeColaboradorDTO) model;

		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		try {

			this.getDao().setTransactionControler(tc);

			tc.start();

			vinculoHabilidadeColaboradorDTO.setDataFim(UtilDatas.getDataAtual());
			this.getDao().update(vinculoHabilidadeColaboradorDTO);

			tc.commit();

		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}

		}
	}

	@Override
	public Collection<VinculoHabilidadeColaboradorDTO> findByIdHabilidade(Integer idHabilidade) throws PersistenceException{
		return this.getDao().findByIdHabilidade(idHabilidade);
	}

	@Override
	public void deleteAllVinculosHabilidade(Integer idHabilidade) throws PersistenceException{
		this.getDao().deleteAllVinculosHabilidade(idHabilidade);
	}
}
