package br.com.centralit.citcorpore.negocio;

import br.com.centralit.citcorpore.integracao.VinculoServicoProprietariosDao;

import java.util.Collection;
import br.com.centralit.citcorpore.bean.VinculoServicoProprietariosDTO;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @since 20.01.2016 
 * @author gustavo.gomes
 */
@SuppressWarnings({"rawtypes", "unchecked"})
public class VinculoServicoProprietariosServiceEjb extends CrudServiceImpl implements VinculoServicoProprietariosService {
	private VinculoServicoProprietariosDao dao;
	
	
	public VinculoServicoProprietariosDao getDao(){
		if (dao == null) {
            dao = new VinculoServicoProprietariosDao();
        }
        return dao;
	}

	public Collection<VinculoServicoProprietariosDTO> findProprietariosByServico(Integer idServico, String Like) throws Exception{
		try{
			return this.getDao().findProprietariosByServico(idServico,Like);
		}catch(Exception e){
			throw new Exception(e);
		}
		
	}
	
	public void deletaVinculo(Integer idVinculo) throws Exception{
		try{
			this.getDao().deletaVinculo(idVinculo);
		}catch(Exception e){
			throw new Exception(e);
		}
	}
	
	public boolean existeVinculo(Integer idServico, Integer idVinculado, Integer tipo) throws Exception{
		try{
			return this.getDao().existeVinculo(idServico, idVinculado, tipo);
		}catch(Exception e){
			throw new Exception(e);
		}
	}

}