package br.com.centralit.citcorpore.negocio.alcada;
import br.com.centralit.citcorpore.bean.RequisicaoProdutoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bpm.negocio.ExecucaoRequisicaoProduto;
import br.com.centralit.citcorpore.bpm.negocio.ExecucaoSolicitacao;
import br.com.centralit.citcorpore.util.Enumerados.TipoAlcada;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.TransactionControler;

public class AlcadaCompras extends AlcadaImpl {

	@Override
	protected TipoAlcada getTipoAlcada() {
		return TipoAlcada.Compras;
	}

	@Override
	protected ExecucaoSolicitacao getExecucaoSolicitacao() {
		return new ExecucaoRequisicaoProduto();
	}

	@Override
	protected String getFinalidade(IDto objetoNegociotDto) {
		return ((RequisicaoProdutoDTO) objetoNegociotDto).getFinalidade();
	}

	@Override
	protected double getValorParaAprovacao(IDto objetoNegociotDto, TransactionControler tc) throws Exception {
		SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) objetoNegociotDto;

    	return this.getExecucaoSolicitacao().calculaValorParaAprovacao(solicitacaoServicoDto, tc);
	}

}
