package br.com.centralit.citcorpore.negocio.alcada;

import br.com.centralit.citcorpore.bean.RequisicaoViagemDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bpm.negocio.ExecucaoRequisicaoViagem;
import br.com.centralit.citcorpore.bpm.negocio.ExecucaoSolicitacao;
import br.com.centralit.citcorpore.util.Enumerados.TipoAlcada;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.TransactionControler;

public class AlcadaRequisicaoViagem  extends AlcadaImpl {

	@Override
	protected TipoAlcada getTipoAlcada() {
		return TipoAlcada.Viagem;
	}

	@Override
	protected ExecucaoSolicitacao getExecucaoSolicitacao() {
		return new ExecucaoRequisicaoViagem();
	}

	@Override
	protected String getFinalidade(IDto objetoNegociotDto) {
		return ((RequisicaoViagemDTO) objetoNegociotDto).getFinalidade();
	}

	@Override
	protected double getValorParaAprovacao(IDto objetoNegociotDto, TransactionControler tc) throws Exception {
		SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) objetoNegociotDto;
		
    	return this.getExecucaoSolicitacao().calculaValorParaAprovacao(solicitacaoServicoDto, tc);
	}
	
}
