package br.com.centralit.citcorpore.negocio.alcada;

import java.util.List;

import br.com.centralit.citcorpore.bean.AlcadaDTO;
import br.com.centralit.citcorpore.bean.CentroResultadoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.TransactionControler;

public interface IAlcada {
	public AlcadaDTO determinaAlcada(IDto objetoNegocioDto, CentroResultadoDTO centroCustoDto, TransactionControler tc) throws Exception;

	public AlcadaDTO registraAprovacao(IDto objetoNegocioDto, CentroResultadoDTO centroCustoDto, UsuarioDTO aprovador, Integer identificador, double valorAprovado, TransactionControler tc) throws Exception;

	public void registraAprovacoes(IDto objetoNegocioDto, CentroResultadoDTO centroCustoDto, List<Integer> identificadores, double valor, TransactionControler transacao) throws Exception;
	
	public void aprova(UsuarioDTO aprovador, Integer identificador, double valorAprovado, TransactionControler tc) throws Exception;

	public void cancelaAprovacao(Integer identificador,TransactionControler tc) throws Exception;

	public AlcadaDTO recupera(Integer identificador, TransactionControler tc) throws Exception;

}
