package br.com.centralit.citcorpore.quartz.job;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import br.com.centralit.citcorpore.bean.PesquisaSatisfacaoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.integracao.PesquisaSatisfacaoDAO;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoDao;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

public class AvaliarSolicitacoesNaoRespondidas implements Job  {
	
	 private static final Logger LOGGER = Logger.getLogger(AvaliarSolicitacoesNaoRespondidas.class.getName());

	@Override
	public void execute(JobExecutionContext arg0) throws JobExecutionException {
		
		String avaliacaoAutomatica = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.AVALIAO_AUTOMATICA, "");
		
		if(avaliacaoAutomatica.equalsIgnoreCase("S")){
			try {
				LOGGER.log(Level.INFO, "Disparando Avaliao automtica...");
				
				PesquisaSatisfacaoDTO pesquisaSatisfacaoDTO;
				PesquisaSatisfacaoDAO pesquisaSatisfacaoDAO = new PesquisaSatisfacaoDAO();
				SolicitacaoServicoDao solicitacaoServicoDao = new SolicitacaoServicoDao();
	
				// Nota padro para avaliao automtica do atendimento de solicitaes
				Enumerados.Nota nota = null;
				String notaAvaliacaoAutomatica = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.NOTA_AVALIAO_AUTOMATICA, "");
				if(notaAvaliacaoAutomatica.equals("BOM")){
					nota = Enumerados.Nota.BOM;
				}else if(notaAvaliacaoAutomatica.equals("OTIMO")){
					nota = Enumerados.Nota.OTIMO;
				}else if(notaAvaliacaoAutomatica.equals("REGULAR")){
					nota = Enumerados.Nota.REGULAR;
				}else if(notaAvaliacaoAutomatica.equals("RUIM")){
					nota = Enumerados.Nota.RUIM;
				}
				
				// Calculando a data limite para resposta do usurio
				Integer pQtdeDias = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.QTDE_DIAS_RESP_PESQ_SASTISFACAO, "7"));
	
				java.sql.Date dataLimite = UtilDatas.getSqlDate(UtilDatas.incrementaDiasEmData(Util.getDataAtual(), -(new Integer(pQtdeDias))));
				
				String idiomaPadrao = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.IDIOMAPADRAO, "pt");
				String comentario = UtilI18N.internacionaliza(idiomaPadrao, "pesquisasatisfacao.respostaAutomatica");
	
				// As Solicitaes no respondidas e que foram concludas at a data limite sero respondidas automaticamente pelo sistema
				// Trazer as Solicitaes no respondidas
				Collection<SolicitacaoServicoDTO> listaIdSolicitacoesNResp = solicitacaoServicoDao.listaIDSolicitacaoNaoRespondida(dataLimite);
				for (SolicitacaoServicoDTO solicitacaoServicoDTO : listaIdSolicitacoesNResp) {
					// Gravar pesquisa para Cada Solicitao de Servios no avaliada
					pesquisaSatisfacaoDTO = new PesquisaSatisfacaoDTO();
					pesquisaSatisfacaoDTO.setIdSolicitacaoServico(solicitacaoServicoDTO.getIdSolicitacaoServico());
					pesquisaSatisfacaoDTO.setNota(nota.getNota());
					pesquisaSatisfacaoDTO.setComentario(comentario);
					pesquisaSatisfacaoDAO.create(pesquisaSatisfacaoDTO);
				}
				
				LOGGER.log(Level.INFO, "Finalizando Avaliao automtica...");
				
			} catch (Exception e) {
				LOGGER.log(Level.WARNING, "Erro na Avaliao automtica de solicitaes: " + e.getMessage(), e);
			}
		}
	}
}