package br.com.centralit.citcorpore.regras;

import java.util.Calendar;

import br.com.centralit.citcorpore.bean.ProgramacaoAtividadeDTO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.util.UtilDatas;

public class RegraProgramacaoAtividade_D extends RegraProgramacaoAtividade {
    
    @Override
	public java.util.Date calculaProximaExecucao(ProgramacaoAtividadeDTO programacaoAtividadeDto, java.util.Date dataRef) throws Exception {
        java.util.Date proximaExecucao = null;        
        java.util.Date dataExecucao = programacaoAtividadeDto.getProximaExecucao();                
        if (dataExecucao == null)  
            dataExecucao = programacaoAtividadeDto.getDataInicio();
        if (dataExecucao.compareTo(dataRef) <= 0 && (programacaoAtividadeDto.getDataFim() == null || programacaoAtividadeDto.getDataFim().compareTo(dataRef) >= 0)) {
            while (dataExecucao.compareTo(dataRef) < 0) 
                dataExecucao = UtilDatas.alteraData(dataExecucao, programacaoAtividadeDto.getPeriodicidadeDiaria().intValue(), Calendar.DAY_OF_MONTH);
            proximaExecucao = dataExecucao;
        }
        return proximaExecucao;
    }
    
    @Override
	public void valida(ProgramacaoAtividadeDTO programacaoAtividadeDto) throws Exception {
        if (programacaoAtividadeDto.getPeriodicidadeDiaria() == null)
			throw new LogicException("gerenciaContratos.atividadePeriodica.regraProgramacaoAtividadeD.valida.periodicidade");
    } 
    
    @Override
	public String getDetalhamento(ProgramacaoAtividadeDTO programacaoAtividadeDto) throws Exception {
        String descricao = "";      
        if (programacaoAtividadeDto.getPeriodicidadeDiaria().intValue() == 1)
			descricao = "citcorpore.comum.todoDiaAs# " + programacaoAtividadeDto.getHoraInicio();
        else
			descricao = "citcorpore.comum.as# " + programacaoAtividadeDto.getHoraInicio() + " #citcorpore.comum.aCada# " + programacaoAtividadeDto.getPeriodicidadeDiaria().intValue() + " #citcorpore.texto.tempo.dias";
        return descricao;
    }
    
}
