package br.com.centralit.citcorpore.tld;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

/**
 * @since 21.10.2015
 * @author douglas.japiassu
 */
public class UploadComDescricaoControl  extends BodyTagSupport {
	private static final long serialVersionUID = -5662280543745344068L;
	private String id;
	private String style;
	private String title;
	private String form;
	private String action;
	private String disabled;

	@Override
	public int doStartTag() throws JspException {
		try {
			final StringBuilder urlIframe = new StringBuilder();
			try {
				urlIframe.append(br.com.citframework.util.Constantes.getValue("SERVER_ADDRESS"));
				urlIframe.append(((HttpServletRequest) this.pageContext.getRequest()).getContextPath());
				urlIframe.append("/pages/refresh");
				urlIframe.append(this.getId());
				urlIframe.append("/refresh");
				urlIframe.append(this.getId());
				urlIframe.append(".load");
			} catch (final Exception e1) {
				throw new JspException(e1);
			}

			this.montarSaidaHtmlDaListaDeApresentacao(urlIframe);
		} catch (final IOException e) {
			throw new JspException(e);
		}

		return SKIP_BODY;
	}

	private void montarSaidaHtmlDaListaDeApresentacao(final StringBuilder urlIframe) throws IOException, JspException {
		final JspWriter out = this.pageContext.getOut();
		out.println("<div style='border:none !important; height: 300px !important;' id='divUpload_".concat(this.getId()).concat("'>\n"));
		out.println("<div id='divMostraUpload_".concat(this.getId()).concat(" '>"));
		out.println("<div class=\"separator\"></div>");
		if (!UtilStrings.nullToVazio(this.disabled).equalsIgnoreCase("true")){
			out.println("<div class='row-fluid'>");

			out.println("<div class='span4'>");
			out.println("<input type='text' required='true' id='campoDescricao_".concat(this.getId()).concat("' name='campoDescricao_").concat(this.getId()).concat("' class='span12' placeholder='")
					.concat(UtilI18N.internacionaliza((HttpServletRequest) this.pageContext.getRequest(), "citcorpore.comum.descricaoDoAnexo")).concat("'/>\n"));
			out.println("</div>\n");

			out.println("<div class='span8'>");
			out.println("	<button type='button' class='btn btn-primary btn-icon glyphicons folder_open' onclick="
					.concat("\"clickAdicionar_".concat(this.getId()).concat("();\""))
					.concat("><i></i>")
					.concat(UtilI18N.internacionaliza((HttpServletRequest) this.pageContext.getRequest(), "citcorpore.comum.adicionarArquivo")).concat("</button>"));

			out.println("<input style='display: none;' type='file' name='file_"
					.concat(this.getId()).concat( "'")
					.concat("id='file_").concat(this.getId()).concat("' ")
					.concat("onchange='change_").concat(this.getId()).concat("(this)'/>"));

			out.println("</div>");
			out.println("<div class='separator'></div>");
			out.println("</div>");
		}

		this.montarHtmlDoFrameDeUploads(urlIframe, out);
		this.montarScriptControleDaListaDeArquivos(urlIframe, out);
	}

	private void montarHtmlDoFrameDeUploads(final StringBuilder urlIframe, final JspWriter out) throws IOException {
		out.println("</div>\n");
		out.println("<div style='display:none;background:#E3F0FD;' id='divMostraResultadoUpload_".concat(this.getId()).concat("'></div>\n"));
		out.println("<iframe name='fraUpload_".concat(this.getId())
				.concat("' id='fraUpload_").concat(this.getId()).concat("' style='")
				.concat(this.getStyle()).concat("; border: none;' src='")
				.concat(urlIframe.toString()).concat("'></iframe>\n"));
		out.println("</div>\n");
	}

	private void montarScriptControleDaListaDeArquivos(final StringBuilder urlIframe, final JspWriter out) throws IOException, JspException {
		out.println("<script>");
		out.println("function clickAdicionar_".concat(this.getId()).concat("(){ "));
		out.println("	if ($(\"#campoDescricao_".concat(this.getId()).concat("\").val() == \"\") { "));
		out.println("		notificacaoI18N(\"citcorpore.comum.campo_obrigatorio\", \"citcorpore.comum.descricaoDoAnexo\"); ");
		out.println("		return;");
		out.println("	} ");
		out.println("	$(\"#file_".concat(this.getId()).concat("\").trigger('click');"));
		out.println("}; ");
		out.println("function change_".concat(this.getId()).concat("(){ "));

		String actionControle;
		try {
			actionControle = br.com.citframework.util.Constantes.getValue("SERVER_ADDRESS").concat(
			((HttpServletRequest) this.pageContext.getRequest()).getContextPath())
			.concat(this.getAction());
		} catch (final Exception e) {
			throw new JspException(e);
		}
		out.println("uploadArquivo(".concat(this.getForm()).concat(", '")
				.concat(actionControle)
				.concat("', 'divMostraResultadoUpload_")
				.concat(this.getId())
				.concat("', '<b><font color=\"red\">")
				.concat(UtilI18N.internacionaliza((HttpServletRequest) this.pageContext.getRequest(), "citcorpore.ged.enviandoarquivo"))
				.concat("...</font></b>', '<b><font color=\"red\">")
				.concat(UtilI18N.internacionaliza((HttpServletRequest) this.pageContext.getRequest(), "citcorpore.ged.msg.errocarregar"))
				.concat("</font></b>', 'fraUpload_")
				.concat(this.getId())
				.concat("', 'file_")
				.concat(this.getId())
				.concat("');"));
		out.println("	$(\"#campoDescricao_".concat(this.getId()).concat("\").val('');"));
		out.println("}");

		out.println("function ".concat(this.getId()).concat("() {}"));
		out.println(this.getId().concat(".refresh = function(){"));
		out.println("document.getElementById('fraUpload_"
				.concat(this.getId())
				.concat("').src = '")
				.concat(urlIframe.toString())
				.concat("';"));
		out.println("};");

		out.println(this.getId().concat(".clear = function(){"));
		out.println("try{document.getElementById('file').text = '';}catch(e){}");
		out.println("document.getElementById('fraUpload_".concat(this.getId()).concat("').src = 'about:blank';"));
		out.println("};");
		out.println("</script>");
	}

	@Override
	public String getId() {
		return this.id;
	}

	@Override
	public void setId(final String id) {
		this.id = id;
	}

	public String getStyle() {
		return this.style;
	}

	public void setStyle(final String style) {
		this.style = style;
	}

	public String getTitle() {
		return this.title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getForm() {
		return this.form;
	}

	public void setForm(final String form) {
		this.form = form;
	}

	public String getAction() {
		return this.action;
	}

	public void setAction(final String action) {
		this.action = action;
	}

	public String getDisabled() {
		return this.disabled;
	}

	public void setDisabled(final String disabled) {
		this.disabled = disabled;
	}
}
