package br.com.centralit.citcorpore.util;

import java.util.Comparator;

import br.com.centralit.citcorpore.bean.PesquisaRequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;

public class ComparatorUtil {

	public static Comparator<UsuarioDTO> getComparatorPorLogin() {
		return new Comparator<UsuarioDTO>() {
			@Override
			public int compare(UsuarioDTO u1, UsuarioDTO u2) {
				return u1.getLogin().toUpperCase().compareTo(u2.getLogin().toUpperCase());
			}
		};
	}
	
	public static Comparator<ServicoContratoDTO> getComparatorPorNomeServico() {
		return new Comparator<ServicoContratoDTO>() {
			@Override
			public int compare(ServicoContratoDTO servCont1, ServicoContratoDTO servCont2) {
				return servCont1.getNomeServico().toUpperCase().compareTo(servCont2.getNomeServico().toUpperCase());
			}
		};
	}

	public static Comparator<PesquisaRequisicaoMudancaDTO> getComparatorRequisicaoMudancaPorStatus() {
		return new Comparator<PesquisaRequisicaoMudancaDTO>() {
			@Override
			public int compare(PesquisaRequisicaoMudancaDTO o1, PesquisaRequisicaoMudancaDTO o2) {
				if(o1.getDescrStatus() == null) {
					return -1;
				}

				if(o1.getDescrStatus().compareTo(o2.getDescrStatus()) > 0) {
					return 1;
				}

				return -1;
			}
		};
	}
}
