package br.com.centralit.citcorpore.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class Enumerados implements Serializable {

	private static final long serialVersionUID = -523719211080468112L;

	static final String DATA = "Date";
	static final String HORA = "Hora";
	static final String CNPJ = "CNPJ";
	static final String CPF = "CPF";
	static final String NUMERO = "Numero";
	static final String MOEDA = "MOEDA";
	static final String TEXTO = "Texto";
	static final String BOOLEAN = "Boolean";
	static final String EMAIL = "Email";
	static final String CEP = "CEP";
	static final String TELEFONE = "Telefone";
	static final String SENHA = "Senha";

	public enum TipoAgendamento {

		D(1, "citcorpore.texto.frequencia.diariamente"),
		S(2, "citcorpore.texto.frequencia.semanalmente"),
		M(3, "citcorpore.texto.frequencia.mensalmente"),
		U(4, "citcorpore.texto.frequencia.umaVez");

		private final String descricao;
		private final Integer identificador;

		private TipoAgendamento(final Integer identificador, final String descricao) {
			this.descricao = descricao;
			this.identificador = identificador;
		}

		public static TipoAgendamento fromIdentificador(Integer id) {
			TipoAgendamento retorno = null;

			for (TipoAgendamento tipoAgendamento : TipoAgendamento.values()) {
				if (tipoAgendamento.getIdentificador().equals(id)) {
					return tipoAgendamento;
				}
			}

			return retorno;
		}

		public String getDescricao() {
			return descricao;
		}

		public Integer getIdentificador() {
			return identificador;
		}

	}

    public enum OrigemBaseConhecimento {

        CONHECIMENTO(1, "citcorpore.comum.origemBaseConhecimento.conhecimento"),
        EVENTO(2, "citcorpore.comum.origemBaseConhecimento.evento"),
		MUDANCA(3, "citcorpore.comum.origemBaseConhecimento.mudana"),
        INCIDENTE(4, "citcorpore.comum.origemBaseConhecimento.incidente"),
		SERVICO(5, "citcorpore.comum.origemBaseConhecimento.servio"),
        PROBLEMA(6, "citcorpore.comum.origemBaseConhecimento.problema");

        private final Integer identificador;
        private final String chave;

        private OrigemBaseConhecimento(final Integer identificador, final String chave) {
            this.identificador = identificador;
            this.chave = chave;
        }

        public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

        public static String getChaveOrigemById(final Integer identificador) {
            final OrigemBaseConhecimento[] origens = OrigemBaseConhecimento.values();
            for (final OrigemBaseConhecimento origem : origens) {
                if (origem.getIdentificador().equals(identificador)) {
                    return origem.getChave();
                }
            }
			throw new IllegalArgumentException(String.format("Chave Origem Base Conhecimento no encontrado para o identificador '%d'", identificador));
        }
    }

	public enum ServiceRequestStatus {

		IN_PROGRESS(1, true, "citcorpore.comum.emandamento"),
		SUSPENDED(2, true, "citcorpore.comum.suspensa"),
		CANCELED(3, true, "citcorpore.comum.cancelada"),
		SOLVED(4, true, "citcorpore.comum.resolvida"),
		REOPENED(5, false, "citcorpore.comum.reaberta"),
		CLOSED(6, false, "citcorpore.comum.fechada"),
		RECLASSIFIED(7, false, "citcorpore.comum.reclassificada");

        private final Integer id;
        private final boolean isToMobile;
		private final String I18NKey;

		private ServiceRequestStatus(final Integer id, final boolean isToMobile, String I18NKey) {
            this.id = id;
            this.isToMobile = isToMobile;
			this.I18NKey = I18NKey;
        }

        public Integer getId() {
            return id;
        }

        public boolean isToMobile() {
            return isToMobile;
        }

		public String getI18NKey() {
			return I18NKey;
		}

		public static String getChaveFromId(Integer id) {
			String retorno = "N/A";
			for (ServiceRequestStatus status : ServiceRequestStatus.values()) {
				if (status.getId().equals(id)) {
					retorno = status.getI18NKey();
				}
			}

			return retorno;
		}

        /**
		 * Recupera uma {@link ServiceRequestStatus} de acordo com seu id
		 *
		 * @param id
		 *            id a ser verificado se h uma {@link ServiceRequestStatus}
		 * @return {@link ServiceRequestStatus} caso encontre. {@link IllegalArgumentException}, caso contrrio
		 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
		 * @since 30/09/2014
		 */
		public static ServiceRequestStatus fromId(final Integer id) {
			final ServiceRequestStatus[] situacoes = ServiceRequestStatus.values();
			for (final ServiceRequestStatus situacao : situacoes) {
                if (situacao.getId().equals(id)) {
                    return situacao;
                }
            }
            throw new IllegalArgumentException(String.format("SituacaoSolicitacaoServico not found for id '%s'", id));
        }

        /**
		 * Recupera a lista de {@link ServiceRequestStatus} que podem ser usadas como situao no Mobile
		 *
		 * @return {@code List<SituacaoSolicitacaoServico>}
		 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
		 * @since 30/09/2014
		 */
		public static List<ServiceRequestStatus> getSituacoesSolicitacaoServicoToMobile() {
			final List<ServiceRequestStatus> result = new ArrayList<>();
			final ServiceRequestStatus[] situacoes = ServiceRequestStatus.values();
			for (final ServiceRequestStatus situacao : situacoes) {
                if (situacao.isToMobile()) {
                    result.add(situacao);
                }
            }
            return result;
        }

    }

    /**
	 * Enumerado que representa a situao de uma solicitao em uma rota de atendimento
	 *
	 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
	 * @date 26/11/2014
	 *
	 */
    public enum SituacaoSolicitacaoServicoNaRota {

        ATENDIDA_FINALIZADA(1, "gestao.forca.atendimento.status.atendimento.atendido.finalizado"),
        NAO_ATENDIDA(2, "gestao.forca.atendimento.status.atendimento.nao.atendido"),
        EM_ATENDIMENTO(3, "gestao.forca.atendimento.status.atendimento.atendendo"),
        ATENDIDA_COM_PENDENCIA (4, "gestao.forca.atendimento.status.atendimento.pendencia");

        private final Integer id;
        private final String description;

        private SituacaoSolicitacaoServicoNaRota(final Integer id, final String description) {
            this.id = id;
            this.description = description;
        }

        public Integer getId() {
            return id;
        }

        public String getDescription() {
            return description;
        }

        /**
		 * Recupera uma {@link SituacaoSolicitacaoServicoNaRota} de acordo com seu id
		 *
		 * @param id
		 *            id a ser verificado se h uma {@link SituacaoSolicitacaoServicoNaRota}
		 * @return {@link SituacaoSolicitacaoServicoNaRota} caso encontre. {@link IllegalArgumentException}, caso contrrio
		 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
		 * @since 26/11/2014
		 */
        public static SituacaoSolicitacaoServicoNaRota fromId(final Integer id) {
            final SituacaoSolicitacaoServicoNaRota[] situacoes = SituacaoSolicitacaoServicoNaRota.values();
            for (final SituacaoSolicitacaoServicoNaRota situacao : situacoes) {
                if (situacao.getId().equals(id)) {
                    return situacao;
                }
            }
            throw new IllegalArgumentException(String.format("SituacaoSolicitacaoServico not found for id '%s'", id));
        }

    }

    public enum ParametroSistema {

        ORIGEM_SISTEMA(0, "parametro.0", TEXTO),

        //Removido. Gilberto Nery Ticket Redmine: 1157
        //CaminhoArquivoNetMap(1, "parametro.1", TEXTO),
        //Removido. Gilberto Nery Ticket Redmine: 1158
        //FaixaIp(2, "parametro.2", TEXTO),

        NoPesquisa(3, "parametro.3", TEXTO),
        Atributo(4, "parametro.4", TEXTO),
        CaminhoBaseItemCfg(5, "parametro.5", TEXTO),

        //Removido. Gilberto Nery Ticket Redmine: 1159
        //DiretorioXmlAgente(6, "parametro.6", TEXTO),

        DiasInventario(7, "parametro.7", NUMERO),

        //Removido. Gilberto Nery Ticket Redmine: 1160
        //CaminhoNmap(8, "parametro.8", TEXTO),

        ID_GRUPO_PADRAO_NIVEL1(9, "parametro.9", NUMERO),
        SMTP_ENVIO_RemetenteNotificacoesSolicitacao(10, "parametro.10", TEXTO),
        SMTP_ENVIO_Autenticacao(11, "parametro.11", BOOLEAN),
        SMTP_ENVIO_Usuario(12, "parametro.12", TEXTO),
        SMTP_ENVIO_Senha(13, "parametro.13", SENHA),
        SMTP_ENVIO_Servidor(14, "parametro.14", TEXTO),
        GedInterno(15, "parametro.15", BOOLEAN),
        GedInternoBD(16, "parametro.16", BOOLEAN),
        GedExternoClasse(17, "parametro.17", TEXTO),
        GedDiretorio(18, "parametro.18", TEXTO),
        EMPRESA_Nome(19, "parametro.19", TEXTO),
        METODO_AUTENTICACAO_Pasta(22, "parametro.22", TEXTO),
        SMTP_LEITURA_Servidor(23, "parametro.23", TEXTO),
		SMTP_LEITURA_Usuario(24, "parametro.24", TEXTO),
        SMTP_LEITURA_Senha(25, "parametro.25", SENHA),
        SMTP_LEITURA_Provider(26, "parametro.26", TEXTO),
        SMTP_LEITURA_Porta(27, "parametro.27", TEXTO),
        SMTP_LEITURA_Pasta(28, "parametro.28", TEXTO),
        NomeFluxoPadraoServicos(29, "parametro.29", TEXTO),
        IDFaseExecucaoServicos(30, "parametro.30", NUMERO),
        EnviaEmailFluxo(31, "parametro.31", BOOLEAN),
        DB_SCHEMA(32, "parametro.32", TEXTO),
        URL_Sistema(33, "parametro.33", TEXTO),
        LDAP_URL(34, "parametro.34", TEXTO),
        DOMINIO_AD(35, "parametro.35", TEXTO),
        DOMINIO_EMAIL(36, "parametro.36", TEXTO),
        LOGIN_AD(37, "parametro.37", TEXTO),
        SENHA_AD(38, "parametro.38", SENHA),
        ID_PERFIL_ACESSO_DEFAULT(39, "parametro.39", TEXTO),
        CONTROLE_ACC_UNIDADE_INC_SOLIC(40, "parametro.40", BOOLEAN),
        COLABORADORES_VINC_CONTRATOS(41, "parametro.41", BOOLEAN),
        PAGE_CADADTRO_SOLICITACAOSERVICO(42, "parametro.42", TEXTO),
        LDAD_SUFIXO_DOMINIO(43, "parametro.43", TEXTO),
        DISKFILEUPLOAD_REPOSITORYPATH(44, "parametro.44", TEXTO),
        ID_GRUPO_PADRAO_LDAP(45, "parametro.45", TEXTO),
        LOGIN_PORTAL(46, "parametro.46", BOOLEAN), // valores S ou N
        FLUXO_PADRAO_MUDANCAS(47, "parametro.47", TEXTO),
        VALIDAR_BOTOES(48, "parametro.48", BOOLEAN), // valores S ou N
        LDAP_SN_LAST_NAME(49, "parametro.49", BOOLEAN),
        OS_VALOR_ZERO(50, "parametro.50", BOOLEAN),
        FORMULA_CALCULO_GLOSA_OS(51, "parametro.51", NUMERO),
        USE_LOG(52, "parametro.52", TEXTO),
        TIPO_LOG(53, "parametro.53", TEXTO),
        PATH_LOG(54, "parametro.54", TEXTO),
        FILE_LOG(55, "parametro.55", TEXTO),
        EXT_LOG(56, "parametro.56", TEXTO),
        ID_MODELO_EMAIL_GRUPO_DESTINO(57, "parametro.57", NUMERO),
        NOTIFICAR_GRUPO_RECEPCAO_SOLICITACAO(58, "parametro.58", BOOLEAN),
        PATRIMONIO_IDTIPOITEMCONFIGURACAO(59, "parametro.59", NUMERO),
        NOME_GRUPO_ITEM_CONFIG_NOVOS(60, "parametro.60", TEXTO),
        UNIDADE_VINC_CONTRATOS(61, "parametro.61", BOOLEAN),
        SERVICO_PADRAO_SOLICITACAO(62, "parametro.62", NUMERO),
        PAGE_CADASTRO_SOLICITACAOSERVICO_PORTAL(63, "parametro.63", TEXTO),
        LDAP_ATRIBUTO(64, "parametro.64", TEXTO),
        ORIGEM_PADRAO_SOLICITACAO(65, "parametro.65", NUMERO),
        IDIOMAPADRAO(66, "parametro.66", TEXTO),
        LDAP_FILTRO(67, "parametro.67", TEXTO),
        LDAP_MOSTRA_BOTAO(68, "parametro.68", BOOLEAN),
        CAMPOS_OBRIGATORIO_SOLICITACAOSERVICO(69, "parametro.69", BOOLEAN),
        MOSTRAR_BOTOES_IMPORTACAO_XML_CADASTRO_MENU(70, "parametro.70", BOOLEAN),
        LER_ARQUIVO_PADRAO_XML_MENUS(71, "parametro.71", BOOLEAN),
        SMTP_LEITURA_LIMITE_(72, "parametro.72", TEXTO),
        AVISAR_DATAEXPIRACAO_LICENCA(73, "parametro.73", NUMERO),
        ENVIAR_EMAIL_DATAEXPIRACAO(74, "parametro.74", NUMERO),
        ID_MODELO_EMAIL_EXPIRACAO_LICENCA(75, "parametro.75", NUMERO),
        DOMINIO_REDE(76, "parametro.76", TEXTO),
        AVISAR_DATAEXPIRACAO_BASECONHECIMENTO(78, "parametro.78", NUMERO),
        ID_MODELO_EMAIL_AVISAR_CRIACAO_PASTA(79, "parametro.79", NUMERO),
        ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_PASTA(80, "parametro.80", NUMERO),
        ID_MODELO_EMAIL_AVISAR_EXCLUSAO_PASTA(81, "parametro.81", NUMERO),
        ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO(82, "parametro.82", NUMERO),
        ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO(83, "parametro.83", NUMERO),
        ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO(84, "parametro.84", NUMERO),
        ITEM_CONFIGURACAO_MUDANCA(85, "parametro.85", BOOLEAN),
        MOSTRAR_CATEGORIA_SERVICO_EM_INCIDENTE(86, "parametro.86", BOOLEAN),
        ID_MODELO_EMAIL_AVISAR_CRIACAO_IC(87, "parametro.87", NUMERO),
        ID_MODELO_EMAIL_AVISAR_ALTERACAO_IC(88, "parametro.88", NUMERO),
        ID_MODELO_EMAIL_AVISAR_ALTERACAO_IC_GRUPO(89, "parametro.89", NUMERO),
        ENVIO_PADRAO_EMAIL_IC(90, "parametro.90", NUMERO),
        SMTP_GMAIL(91, "parametro.91", BOOLEAN),
        CICLO_DE_VIDA_IC_DESENVOLVIMENTO(92, "parametro.92", TEXTO),
        CICLO_DE_VIDA_IC_PRODUCAO(93, "parametro.93", TEXTO),
        CICLO_DE_VIDA_IC_HOMOLOGACAO(94, "parametro.94", TEXTO),
        NOME_INVENTARIO(95, "parametro.95", TEXTO),
        ID_GRUPO_PADRAO_IC_DESENVOLVIMENTO(96, "parametro.96", NUMERO),
        ID_GRUPO_PADRAO_IC_PRODUCAO(97, "parametro.97", NUMERO),
        ID_GRUPO_PADRAO_IC_HOMOLOGACA0(98, "parametro.98", NUMERO),
        ID_GRUPO_PADRAO_IC_INVENTARIO(99, "parametro.99", NUMERO),
        ID_GRUPO_PADRAO_REQ_PRODUTOS(100, "parametro.100", NUMERO),
        PERC_MAX_VAR_PRECO_COTACAO(101, "parametro.101", TEXTO),
        NUMERO_COLABORADORES_CONSULTA_AD(102, "parametro.102", NUMERO),
        ID_MODELO_EMAIL_AVISAR_ALTERACAO_SERVICO(103, "parametro.103", NUMERO),
        CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE(104, "parametro.104", BOOLEAN),
        ORIGEM_PADRAO(105, "parametro.105", NUMERO),
        DETERMINA_URGENCIA_IMPACTO_REQPROD(106, "parametro.106", BOOLEAN),
        COTACAO_PESO_PRECO(107, "parametro.107", NUMERO),
        COTACAO_PESO_PRAZO_ENTREGA(108, "parametro.108", NUMERO),
        COTACAO_PESO_PRAZO_PAGTO(109, "parametro.109", NUMERO),
        COTACAO_PESO_GARANTIA(110, "parametro.110", NUMERO),
        COTACAO_PESO_JUROS(111, "parametro.111", NUMERO),
        PATH_NAGIOS_STATUS(112, "parametro.112", TEXTO),
        ID_MODELO_EMAIL_ESCALACAO_AUTOMATICA(113, "parametro.113", NUMERO),
        PEMITE_REQUISICAO_EMPREGADO_COMPRAS(114, "parametro.114", BOOLEAN),
        TIRAR_VINCULO_LOCALIDADE_UNIDADE(115, "parametro.115", BOOLEAN),
        ID_MODELO_EMAIL_ALTERACAO_SENHA(116, "parametro.116", NUMERO),
        INFORMAR_CAMINHO_EXECUCAO_BACKUP_LOGDADOS(117, "parametro.117", TEXTO),
        CONTRATO_PADRAO(118, "parametro.118", NUMERO),
        TIPO_CAPTURA_SOLICITACOES(119, "parametro.119", NUMERO),
        ID_MODELO_EMAIL_GRUPO_COMITE_REQUISICAOMUDANCA(120, "parametro.120", NUMERO),
        LDAP_OPEN_LDAP(121, "parametro.121", BOOLEAN),
        ID_MODELO_EMAIL_GRUPO_DESTINO_REQUISICAOMUDANCA(122, "parametro.122", NUMERO),
        NomeFluxoPadraoProblema(123, "parametro.123", TEXTO),
        ID_MODELO_EMAIL_CRIACAO_PROBLEMA(124, "parametro.124", NUMERO),
        ID_MODELO_EMAIL_ANDAMENTO_PROBLEMA(125, "parametro.125", NUMERO),
        ID_MODELO_EMAIL_FINALIZADO_PROBLEMA(126, "parametro.126", NUMERO),
        ID_MODELO_EMAIL_GRUPO_DESTINO_PROBLEMA(127, "parametro.127", NUMERO),
        ID_MODELO_EMAIL_PRAZO_SOLUCAO_CONTORNO_PROBLEMA_EXPIRADO(128, "parametro.128", NUMERO),
        NOTIFICAR_RESPONSAVEL_GRUPO_PRAZO_SOLUCAO_CONTORNO_PROBLEMA_EXPIRADO(129, "parametro.129", BOOLEAN),
        LIBERAR_ORDEM_SERVICO_DATA_ANTERIOR(130, "parametro.130", BOOLEAN),
        QUANT_RETORNO_PESQUISA(131, "parametro.131", NUMERO),
		QUANT_RETORNO_PESQUISA_ORDEM_SERVICO(132, "parametro.132", TEXTO), // No esta sendo usado
        ID_MODELO_EMAIL_AVISAR_REUNIAO_MARCADA(133, "parametro.133", NUMERO),
        ID_GRUPO_PADRAO_REQ_RH(134, "parametro.134", NUMERO),
        ID_PERFIL_ACESSO_ADMINISTRADOR(135, "parametro.135", NUMERO),
        URL_LOGO_PADRAO_RELATORIO(136, "parametro.136", TEXTO),
        ID_MODELO_EMAIL_AVISAR_PESQUISA_SATISFACAO_RUIM_OU_REGULAR(137, "parametro.137", NUMERO),
        ID_GRUPO_PADRAO_AVISAR_PESQUISA_SATISFACAO_RUIM_OU_REGULAR(138, "parametro.138", NUMERO),
        QTDE_DIAS_RESP_PESQ_SASTISFACAO(139, "parametro.139", NUMERO),
        ID_GRUPO_PADRAO_IC_DESENVOLVIMENTO_PADRAO(140, "parametro.140", NUMERO),
        ID_GRUPO_PADRAO_IC_HOMOLOGACAO_PADRAO(141, "parametro.141", NUMERO),
        ID_GRUPO_PADRAO_IC_PRODUCAO_PADRAO(142, "parametro.142", NUMERO),
        NOME_GRUPO_PADRAO_DESENVOLVIMENTO(143, "parametro.143", TEXTO),
        NOME_GRUPO_PADRAO_HOMOLOGACAO(144, "parametro.144", TEXTO),
        NOME_GRUPO_PADRAO_PRODUCAO(145, "parametro.145", TEXTO),
        TEMPLATE_QUESTIONARIO(146, "parametro.146", NUMERO),
        LUCENE_DIR_BASECONHECIMENTO(147, "parametro.147", TEXTO),
        LUCENE_DIR_PALAVRAGEMEA(148, "parametro.148", TEXTO),
        LUCENE_DIR_ANEXOBASECONHECIMENTO(149, "parametro.149", TEXTO),
        LUCENE_REFAZER_INDICES(150, "parametro.150", BOOLEAN),
		AVALIAO_AUTOMATICA(151, "parametro.151", BOOLEAN),
		NOTA_AVALIAO_AUTOMATICA(152, "parametro.152", TEXTO),
        PONTUACAO_PRODUTIVIDADE_BAIXA_DENTRO_DO_PRAZO(153, "parametro.153", NUMERO),
        PONTUACAO_PRODUTIVIDADE_BAIXA_RETRABALHO(154, "parametro.154", NUMERO),
        PONTUACAO_PRODUTIVIDADE_BAIXA_FORA_DO_PRAZO(155, "parametro.155", NUMERO),
        PONTUACAO_PRODUTIVIDADE_BAIXA_RETRABALHADO_PRAZO_ESTOURADO(156, "parametro.156", NUMERO),
        PONTUACAO_PRODUTIVIDADE_MEDIA_DENTRO_DO_PRAZO(157, "parametro.157", NUMERO),
        PONTUACAO_PRODUTIVIDADE_MEDIA_RETRABALHO(158, "parametro.158", NUMERO),
        PONTUACAO_PRODUTIVIDADE_MEDIA_FORA_DO_PRAZO(159, "parametro.159", NUMERO),
        PONTUACAO_PRODUTIVIDADE_MEDIA_RETRABALHADO_PRAZO_ESTOURADO(160, "parametro.160", NUMERO),
        PONTUACAO_PRODUTIVIDADE_ALTA_DENTRO_DO_PRAZO(161, "parametro.161", NUMERO),
        PONTUACAO_PRODUTIVIDADE_ALTA_RETRABALHO(162, "parametro.162", NUMERO),
        PONTUACAO_PRODUTIVIDADE_ALTA_FORA_DO_PRAZO(163, "parametro.163", NUMERO),
        PONTUACAO_PRODUTIVIDADE_ALTA_RETRABALHADO_PRAZO_ESTOURADO(164, "parametro.164", NUMERO),
        NIVEL_EXCELENCIA_EXIGIDO(165, "parametro.165", NUMERO),
        ID_GRUPO_PADRAO_TESTE(166, "parametro.166", NUMERO),
        ID_GRUPO_PADRAO_EXECUTOR(167, "parametro.167", NUMERO),
        FILTRO_FLUXO_NOME(168, "parametro.168", TEXTO),
        FILTRO_FLUXO_ENCERRAMENTO(169, "parametro.169", TEXTO),
        ID_GRUPO_PADRAO_REQ_VIAGEM_EXECUCAO(170, "parametro.170", NUMERO),
        DIAS_LIMITE_REABERTURA_INCIDENTE_REQUISICAO(171, "parametro.171", NUMERO),
        MOSTRAR_GERENCIA_RECURSOS_HUMANOS(172, "parametro.172", BOOLEAN),
        MOSTRAR_COMPRAS(173, "parametro.173", BOOLEAN),
        ID_GRUPO_PADRAO_RESPONSAVEL_COTACAO_VIAGEM(174, "parametro.174", NUMERO),
        ID_GRUPO_PADRAO_RESPONSAVEL_ADIANTAMENTO_VIAGEM(175, "parametro.175", NUMERO),
        ID_GRUPO_PADRAO_RESPONSAVEL_CONFERENCIA_VIAGEM(176, "parametro.176", NUMERO),
        SERVASTERISKATIVAR(177, "parametro.177", BOOLEAN),
        SERVASTERISKIP(178, "parametro.178", TEXTO),
        SERVASTERISKLOGIN(179, "parametro.179", TEXTO),
        SERVASTERISKSENHA(180, "parametro.180", SENHA),
		SERVASTERISKINTERVALO(181, "parametro.181", NUMERO), // No  mais utilizado
        PASTA_SALVA_DESCRICAO_RESPOSTA_DE_SOLICITACAOSERVICO_EM_BASECONHECIMENTO(182, "parametro.182", TEXTO),
        HABILITA_MONITORAMENTO_NAGIOS(183, "parametro.183", BOOLEAN),
        IP_SERVIDOR_INVENTARIO(184, "parametro.184", TEXTO),
        INVENTARIO_PROCESSAMENTO_ATIVO(185, "parametro.185", BOOLEAN),
        INVENTARIO_SNMP_COMMUNITY(186, "parametro.186", TEXTO),
        FAIXA_DISCOVERY_IP(187, "parametro.187", TEXTO),
        ID_MODELO_EMAIL_SOFTWARE_LISTA_NEGRA(188, "parametro.188", NUMERO),
        ID_GRUPO_PADRAO_RESPONSAVEL_SOFTWARE_LISTA_NEGRA(189, "parametro.189", NUMERO),
        HABILITA_REGRA_ESCALONAMENTO(190, "parametro.190", BOOLEAN),
        ATIVA_NOVO_LAYOUT(191, "parametro.191", BOOLEAN),
        MOSTRAR_GRAVAR_BASE_CONHECIMENTO(192, "parametro.192", BOOLEAN),
		HABILITA_ESCALONAMENTO_MUDANA(193, "parametro.193", BOOLEAN),
        HABILITA_ESCALONAMENTO_PROBLEMA(194, "parametro.194", BOOLEAN),
        ID_MODELO_EMAIL_PRAZO_VENCENDO(195, "parametro.195", NUMERO),
        ID_MODELO_EMAIL_PRESTACAO_CONTAS_NAO_APROVADA(196, "parametro.196", NUMERO),
        LOGIN_USUARIO_ENVIO_EMAIL_AUTOMATICO(197, "parametro.197", TEXTO),
        PATH_ARQ_BANCO_LOG(198, "parametro.198", TEXTO),
        SMTP_ENVIO_StartTLS(199, "parametro.199", BOOLEAN),
        HABILITA_ROTINA_DE_LEITURA_EMAIL(200, "parametro.200", BOOLEAN),
        HABILITA_BOTAO_ORDEMSERVICO(201, "parametro.201", BOOLEAN),
        DISCOVERY_QTDE_THREADS(202, "parametro.202", NUMERO),
        CAMINHOEXPORTACAOMANUALBICITSMART(203, "parametro.203", TEXTO),
        BICITSMART_EXECUTAR_ROTINA_AUTOMATICA(204, "parametro.204", BOOLEAN),
        BICITSMART_NOTIFICAR_ERRO_IMPORTACAO_POR_EMAIL(205, "parametro.205", BOOLEAN),
        BICITSMART_EMAIL_NOTIFICACAO_GERAL(206, "parametro.206", TEXTO),
        BICITSMART_ID_MODELO_EMAIL_ERRO_AGEND_EXCECAO(207, "parametro.207", NUMERO),
        BICITSMART_ID_MODELO_EMAIL_ERRO_AGEND_ESPECIFICO(208, "parametro.208", NUMERO),
        BICITSMART_ID_MODELO_EMAIL_ERRO_AGEND_PADRAO(209, "parametro.209", NUMERO),
        BICITSMART_ID_MODELO_EMAIL_ERRO_PARAMETRO(210, "parametro.210", NUMERO),
        BICITSMART_ID_MODELO_EMAIL_ERRO_EXCECUCAO(211, "parametro.211", NUMERO),
        BICITSMART_ID_CONEXAO(212, "parametro.212", NUMERO),
        GRUPO_PERMISSAO_DELEGAR_PRESTACAO_VIAGEM(213, "parametro.213", NUMERO),
        LDAP_SUBDOMINIO(214, "parametro.214", TEXTO),
        RECEBER_NOTIFICACAO_ENCERRAR_ESCALONAR_SOLICITACOES_VINCULADAS(215, "parametro.215", BOOLEAN),
        ID_MODELO_EMAIL_CRIACAO_GRUPO_EXECUTOR_SOLICITACAO_RELACIONADA(216, "parametro.216", NUMERO),
        ID_MODELO_EMAIL_ACOES_GRUPO_EXECUTOR_SOLICITACAO_RELACIONADA(217, "parametro.217", NUMERO),
        ID_MODELO_EMAIL_ENCERRAMENTO_GRUPO_EXECUTOR_SOLICITACAO_RELACIONADA(218, "parametro.218", NUMERO),
        HABILITAR_MIGRACAO_DE_DADOS_AUTOMATICA(219, "parametro.219", TEXTO),
        ID_USUARIO_CANDIDATO_EXTERNO(220, "parametro.220", NUMERO),
        SERVICO_TIPO_REQUISICAO_TESTE(221, "parametro.221", TEXTO),
        SERVICO_VALIDACAO_DOCUMENTACAO(222, "parametro.222", TEXTO),
        CONFIGURACAO_EMAIL_SUPORTE(223, "parametro.223", TEXTO),
        CONFIGURACAO_TELEFONE_SUPORTE(224, "parametro.224", TEXTO),
        CONFIGURACAO_EMAIL_SUPORTE_TELA_LOGIN(225, "parametro.225", TEXTO),
        CONFIGURACAO_TELEFONE_SUPORTE_TELA_LOGIN(226, "parametro.226", TEXTO),
        BPM_ELEMENTO_EXECUCAO(227, "parametro.227", TEXTO),
        VALOR_ALCADA_SEM_NESSIDADE_AUTORIZACAO(228, "parametro.228", NUMERO),
        RECONFIGURAR_FORMULASOS_DASATIVIDADES(229, "parametro.229", TEXTO),
        PermiteDataInferiorHoje(230, "parametro.230", TEXTO),
        ATIVAR_ENVIO_EMAIL_UPDATE_INCIDENTE(231, "parametro.231", TEXTO),
        ERROCONHECIDO_ARQUIVAR_AO_CONCLUIR_MUDANCA(232, "parametro.232", BOOLEAN),
        NAGIOS_CONEXOES_LIVESTATUS(233, "parametro.233", TEXTO),
        NAGIOS_TIPO_ACESSO(234, "parametro.234", NUMERO),
        UNIDADE_AUTOCOMPLETE(235, "parametro.235", BOOLEAN),
        SELENIUM_USUARIO_TESTE(236, "parametro.236", TEXTO),
        SELENIUM_SENHA_TEST(237, "parametro.237", SENHA),
        SELENIUM_NAVEGADOR_TESTE(238, "parametro.238", TEXTO),
        SELENIUM_URL_TESTE(239, "parametro.239", TEXTO),
        SELENIUM_URL_CLIENTE_TESTE(240, "parametro.240", TEXTO),
        SELENIUM_CAMINHO_COMPLETO_DRIVER_IE(241, "parametro.241", TEXTO),
        SELENIUM_CAMINHO_COMPLETO_DRIVER_CHROME(242, "parametro.242", TEXTO),
        ATIVAR_ASSINATURA_PERSONALIZADA_REL_OS(243, "parametro.243", BOOLEAN),
        MENSAGEM_TELA_LOGIN(244, "parametro.244", TEXTO),
        HABILITA_PRECO_CARRINHO_PORTAL(245, "parametro.245", BOOLEAN),
        OCULTAR_BTN_NOVA_SOLICITACAO_PORTAL(246, "parametro.246", BOOLEAN),
        DESMARCAR_SERVICOS_CARRINHO_PORTAL(247, "parametro.247", BOOLEAN),
        MONITORAMENTO_ATIVOS_ID_MODELO_EMAIL_NOTIFICACAO(248, "parametro.248", NUMERO),
        MONITORAMENTO_ATIVOS_NUMERO_THREADS(249, "parametro.249", NUMERO),
        EXIBIR_NOME_ITEM_CONFIGURACAO_TREE(250, "parametro.250", BOOLEAN),
        ID_MODELO_EMAIL_NOTIFICAR_SOLICITANTE(251, "parametro.251", NUMERO),
        REGISTRAR_OCORRENCIA_PELO_PORTAL(252, "parametro.252", TEXTO),
        ID_EMAIL_REGISTRO_OCORRENCIA_PELO_PORTAL(253, "parametro.253", NUMERO),
        GOOGLE_API_KEY_WEB(254, "parametro.254", TEXTO),
        MOBILE_RANGE_ACTION(255, "parametro.255", NUMERO),
        MOBILE_LOCATION_INTERVAL(256, "parametro.256", NUMERO),
        REST_SERVICES_DEFAULT_PAGE_SIZE(257, "parametro.257", NUMERO),
        PERIODO_MAXIMO_DIAS_LISTAGEM(258, "parametro.258", NUMERO),
        GOOGLE_API_KEY_WEB_FOR_WORK(259, "parametro.259", TEXTO),
        TIPO_HIERARQUIA_UNIDADE(260, "parametro.260", NUMERO),
        QUANTIDADE_REGISTROS_PESQUISA_AVANCADA(261, "parametro.261", NUMERO),
        ID_CATEGORIA_REGISTRA_OCORRENCIA_PORTAL(262, "parametro.262", NUMERO),
        ID_ORIGEM_REGISTRA_OCORRENCIA_PORTAL(263, "parametro.263", NUMERO),
        FILTRAR_SOLICITACAO_ANDAMENTO(264, "parametro.264", BOOLEAN),
		SERVASTERISKALGORITMOCAPTURA(265, "parametro.265", NUMERO), // No  mais utilizado
        ID_CALENDARIO_PADRAO(266, "parametro.266", NUMERO),
		REST_SERVICES_DEFAULT_PAGE_SIZE_V1(267, "parametro.267", NUMERO),
		ID_MODELO_EMAIL_ENCERRAMENTO_GRUPO_EXECUTOR_MUDANCA(268, "parametro.268", NUMERO),
		SMTP_ENVIO_Porta(269, "parametro.269", TEXTO),
		SERVASTERISKFILA(270,"parametro.270", TEXTO),
		CIDADE_LOCALIDADE(271,"parametro.271", TEXTO),
		//Parmetro exclusivo para configurao do citsmart mobile
		MOBILE_NOTIFICACAO_SEM_RESPONSAVEL(272,"parametro.272", TEXTO),
		PASTA_PADRAO_CONHECIMENTOS_OCORRENCIAS_EVENTOS(273, "parametro.273", TEXTO),
		SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO(274, "parametro.274", BOOLEAN),
		DEFAULT_LANGUAGE_ENGLISH(275, "parametro.275", BOOLEAN),
		URL_PENTAHO(276, "parametro.276", SENHA),
		PERMITE_CADASTRO_EMPREGADO_MESMO_NOME(277, "parametro.277", BOOLEAN),
		TAMANHO_MAXIMO_ARQUIVO_UPLOAD(278, "parametro.278", NUMERO),
		FLUXO_NORMAL_MUDANCAS(279, "parametro.279", TEXTO),
		FLUXO_EMERGENCIAL_MUDANCAS(280, "parametro.280", TEXTO),
		ATIVAR_WEBSERVICE_TELEFONIA(281, "parametro.281", BOOLEAN),
		TELEFONIA_LANCAR_SOLICITACAO_REQUISICAO_INFORMACAO(282, "parametro.282", BOOLEAN),
		TELEFONIA_ID_SERVICO_SOLICITACAO_REQUISICAO_INFORMACAO(283, "parametro.283", BOOLEAN),

		//Parmetros exclusivos para configurao do citsmart mobile
    	MOBILE_CONTRATO_PADRAO(284, "parametro.284", NUMERO),
    	MOBILE_SERVICO_PADRAO_SOLICITACAO(285, "parametro.285", NUMERO),
		MOBILE_ORIGEM_PADRAO_SOLICITACAO(286, "parametro.286", NUMERO),
		HABILITAR_NOVO_PORTAL(287, "parametro.287", BOOLEAN);

        private final int id;
        private final String campo;
        private final String tipoCampo;

        public int id() {
            return id;
        }

        public String campo() {
            return campo;
        }

        public String getCampoParametroInternacionalizado(final HttpServletRequest request) {
            return UtilI18N.internacionaliza(request, campo);
        }

        public String tipoCampo() {
            return tipoCampo;
        }

        private ParametroSistema(final int id, final String campo, final String tipoCampo) {
            this.id = id;
            this.campo = campo;
            this.tipoCampo = tipoCampo;
        }

    }

    /**
	 * ENUM Tipo Demanda Servio.
	 *
	 * @author valdoilo.damasceno
	 *
	 */
    public enum TipoDemandaServico {

		REQUISICAO("R", "Requisio", "requisitosla.requisicao"),
		INCIDENTE("I", "Incidente", "requisitosla.incidente"),
		OS("O", "Ordem de Servio", "requisitosla.ordem_servico"),
		PROCEDIMENTO("P", "Procedimento", "gerenciaContinuidade.implementacao.planosContinuidade.procedimento");

        private final String classificacao;
        private final String campo;
		private final String chave;

		private TipoDemandaServico(final String classificacao, final String campo, final String chave) {
            this.classificacao = classificacao;
            this.campo = campo;
			this.chave = chave;
        }

        public String getClassificacao() {
            return classificacao;
        }

        public String getCampo() {
            return campo;
        }

		public String getChave() {
			return chave;
    }

		public static String getChaveFromCampo(String campo) {
			for (TipoDemandaServico tipoDemandaServico : TipoDemandaServico.values()) {
				if (tipoDemandaServico.campo.equalsIgnoreCase(campo)) {
					return tipoDemandaServico.getChave();
				}
			}

			return campo;
		}
    }

    /**
     *
     * @author breno.guimaraes
     */
    public enum OrigemOcorrencia {

        EMAIL("Email", 'E'),
        FONE_FAX("Fone/Fax", 'F'),
        VOICE_MAIL("Voice Mail", 'V'),
        PESSOALMENTE("Pessoalmente", 'P'),
        OUTROS("Outros", 'O');

        private final String descricao;
        private final Character sigla;

        private OrigemOcorrencia(final String descricao, final Character sigla) {
            this.descricao = descricao;
            this.sigla = sigla;
        }

        public String getDescricao() {
            return descricao;
        }

        public Character getSigla() {
            return sigla;
        }

        public static OrigemOcorrencia find(final String name) {
        	if (!UtilStrings.isNullOrEmpty(name) && name.trim().length() == 1) {
	        	for (OrigemOcorrencia origem : OrigemOcorrencia.values()) {
					if (origem.getSigla() == name.charAt(0)) {
						return origem;
    }
				}
        	}
        	return null;
        }

    }

	public enum OccurrenceCategory {

		CREATION(1, "citcorpore.comum.registroDaSolicitacao"),
		MONITORING_CUSTOMER(2, "citcorpore.comum.acompanhamentoCliente"),
		UPDATE_STATUS(3, "citcorpore.comum.atualizacaoStatus"),
		DIAGNOSTIC(4, "problema.diagnostico"),
		INVESTIGATION(5, "citcorpore.comum.investigacao"),
		MEMO(6, "citcorpore.comum.memorando"),
		INFORMATION_REQUEST(7, "citcorpore.comum.pedidoInformacao"),
		CUSTOMER_FEEDBACK(8, "citcorpore.comum.retornoCliente"),
		PROBLEM_SYMPTON(9, "citcorpore.comum.sintomaProblema"),
		WORKAROUND(10, "problema.solucao_contorno"),
		REGISTRATION_EXECUTION(11, "solicitacaoServico.registroExecucao"),
		SLA_CHANGE(12, "citcorpore.comum.mudanaSLA"),
		RECLASSIFICATION(13, "citcorpore.comum.reclassificacao"),
		ACTIVITY_SCHEDULE(14, "citcorpore.comum.agendamentoAtividade"),
		REQUEST_SUSPENSION(15, "citcorpore.comum.suspensaoSolicitacao"),
		REQUEST_REACTIVATION(16, "citcorpore.comum.reativacaoSolicitacao"),
		REQUEST_CLOSING(17, "citcorpore.comum.encerramentoSolicitacao"),
		REQUEST_REOPENING(18, "citcorpore.comum.reaberturaSolicitacao"),
		REQUEST_DIRECTION(19, "citcorpore.comum.direcionamentoSolicitacao"),
		TASK_SHARING(20, "citcorpore.comum.compartilhamentoTarefa"),
		TASK_CANCELLATION(21, "citcorpore.comum.cancelamentoTarefa"),
		SLA_START(22, "citcorpore.comum.inicioSLA"),
		SLA_SUSPENSION(23, "citcorpore.comum.suspensaoSLA"),
		RELEASE_RELEASE_REQUEST(24, "citcorpore.comum.liberacaoRequisicaoLiberacao"),
		SLA_REACTIVATION(25, "citcorpore.comum.reativacaoSLA"),
		OTHERS(26, "citcorpore.comum.outrasCategorias");

		private final Integer id;
		private final String I18NKey;

		private OccurrenceCategory(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
        }

		public static OccurrenceCategory fromId(final Integer id) {
			OccurrenceCategory retorno = null;

			for (final OccurrenceCategory categoriaOcorrencia : OccurrenceCategory.values()) {
				if (categoriaOcorrencia.getId().equals(id)) {
					retorno = categoriaOcorrencia;
					break;
				}
			}

			return retorno;
		}

		public Integer getId() {
			return id;
        }

		public String getI18NKey() {
			return I18NKey;
        }

		public static String chaveFromId(Integer id) {
			for (OccurrenceCategory occurrenceCategory : OccurrenceCategory.values()) {
				if (occurrenceCategory.getId().equals(id)) {
					return occurrenceCategory.getI18NKey();
        }
        }

			throw new IllegalArgumentException(String.format("OccurrenceCategory not found for id '%s'", id));
				}

		}

    /**
	 * ENUM para listar as Notas da Pesquisa de Satisfao.
	 *
	 * @author valdoilo
	 */
    public enum Nota {

		OTIMO(4, "timo", "citcorpore.comum.otimo"),
        BOM(3, "Bom", "citcorpore.comum.bom"),
        REGULAR(2, "Regular", "citcorpore.comum.regular"),
        RUIM(1, "Ruim", "citcorpore.comum.ruim");

        private final Integer nota;
        private final String descricao;
        private final String chaveInternacionalizacao;

        private Nota(final Integer nota, final String descricao, final String chaveInternacionalizacao) {
            this.nota = nota;
            this.descricao = descricao;
            this.chaveInternacionalizacao = chaveInternacionalizacao;
        }

        public Integer getNota() {
            return nota;
        }

        public String getDescricao() {
            return descricao;
        }

        public String getChaveInternacionalizacao() {
            return chaveInternacionalizacao;
        }

        public static String getNotaChaveInternacionalizada(Integer nota) {
            String descrNota = "";
        	if (nota!=null){
        		for (Nota notaElement : Nota.values()) {
        			if (nota.equals(notaElement.getNota())){
        				descrNota = notaElement.getChaveInternacionalizacao();
        			}
        		}
        	}
        	return descrNota;
        }

    }

	public enum ChangeRequestPhase {

		REGISTERED(1, "citcorpore.comum.registrada", ChangeRequestStatus.REGISTERED),
		PROPOSAL(2, "citcorpore.comum.proposta", ChangeRequestStatus.PROPOSAL),
		APPROVAL(3, "citcorpore.comum.aprovacao", ChangeRequestStatus.APPROVED),
		PLANNING(4, "requisitosla.planejamento", ChangeRequestStatus.PLANNED),
		EXECUTION(5, "citcorpore.comum.execucao", ChangeRequestStatus.EXECUTED),
		EVALUATION(6, "pedidoCompra.avaliacao", ChangeRequestStatus.CONCLUDED);

		private final Integer id;
		private final String I18NKey;
		private final ChangeRequestStatus status;

		private ChangeRequestPhase(final Integer id, final String I18NKey, final ChangeRequestStatus situacao) {
			this.id = id;
			this.I18NKey = I18NKey;
			this.status = situacao;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public ChangeRequestStatus getStatus() {
			return status;
	}

		public static ChangeRequestPhase fromId(Integer idPhase) {
			for (ChangeRequestPhase phase : ChangeRequestPhase.values()) {
				if (phase.getId().equals(idPhase)) {
					return phase;
				}
			}

			return null;
		}

		public static String chaveFromId(Integer idPhase) {
			String chave = "N/A";
			ChangeRequestPhase phase = fromId(idPhase);
			if (idPhase != null) {
				chave = phase.getI18NKey();
		}

			return chave;
		}

				}

	public enum ChangeRequestStatus {

		REGISTERED(1, "citcorpore.comum.registrada"),
		PROPOSAL(2, "gerenciamentoservico.aguardandoAprovacao"),
		APPROVED(3, "citcorpore.comum.aprovacao"),
		PLANNED(4, "citcorpore.comum.planejada"),
		IN_EXECUTION(5, "citcorpore.comum.emExecucao"),
		EXECUTED(6, "perfil.executada"),
		SUSPENDED(7, "citcorpore.comum.suspensa"),
		CANCELED(8, "citcorpore.comum.cancelada"),
		REJECTED(9, "citcorpore.comum.rejeitada"),
		SOLVED(10, "citcorpore.comum.resolvida"),
		REOPENED(11, "citcorpore.comum.reaberta"),
		CONCLUDED(12, "citcorpore.comum.concluida");

		private final Integer id;
		private final String I18NKey;

		private ChangeRequestStatus(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public static String chaveFromId(Integer idStatus) {
			String chave = "N/A";
			for (ChangeRequestStatus sit : ChangeRequestStatus.values()) {
				if (sit.getId().equals(idStatus)) {
					chave = sit.getI18NKey();
					break;
				}
			}

			return chave;
		}

	}

	public enum ReleaseRequestStatus {

		REGISTERED(1, "citcorpore.comum.registrada"),
		UNSOLVED(2, "requisicaoLiberacao.naoResolvida"),
		APPROVED(3, "citcorpore.comum.aprovacao"),
		PLANNED(4, "citcorpore.comum.planejada"),
		IN_EXECUTION(5, "citcorpore.comum.emExecucao"),
		EXECUTED(6, "perfil.executada"),
		SUSPENDED(7, "citcorpore.comum.suspensa"),
		CANCELED(8, "citcorpore.comum.cancelada"),
		REJECTED(9, "citcorpore.comum.rejeitada"),
		SOLVED(10, "citcorpore.comum.resolvida"),
		REOPENED(11, "citcorpore.comum.reaberta"),
		CLOSED(12, "citcorpore.comum.fechada"),
		CONCLUDED(13, "citcorpore.comum.concluida");

		private final Integer id;
		private final String I18NKey;

		private ReleaseRequestStatus(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
				}

		public static String chaveFromId(Integer id) {
			for (ReleaseRequestStatus sitReqLiberacao : ReleaseRequestStatus.values()) {
				if (sitReqLiberacao.getId().equals(id)) {
					return sitReqLiberacao.getI18NKey();
		}
				}

			return "N/A";
		}
	}

	public enum ProblemRequestPhase {

		REGISTERED(1, ProblemRequestStatus.REGISTERED, "citcorpore.comum.registrada"),
		APPROVED(2, ProblemRequestStatus.APPROVED, "citcorpore.comum.aprovacao"),
		PLANNING(3, ProblemRequestStatus.PLANNED, "requisitosla.planejamento"),
		EXECUTION(4, ProblemRequestStatus.EXECUTED, "citcorpore.comum.execucao"),
		EVALUATION(5, ProblemRequestStatus.CONCLUDED, "relatoriopesquisasatisfacao.nota"),
		IN_INVESTIGATION(6, ProblemRequestStatus.IN_INVESTIGATION, "gerenciamentoProblema.emInvestigacao"),
		WORKAROUND(7, ProblemRequestStatus.WORKAROUND, "problema.solucao_contorno"),
		REVIEWED(8, ProblemRequestStatus.REVIEWED, "problema.revisado"),
		RESOLUTION(9, ProblemRequestStatus.RESOLUTION, "pesquisaProblema.resolucao"),
		CLOSURE(10, ProblemRequestStatus.CLOSURE, "grupo.encerramento"),
		REVIEW(11, ProblemRequestStatus.REVIEW, "gerenciamentoProblema.revisar"),
		KNOWN_ERROR_RECORD(12, ProblemRequestStatus.KNOWN_ERROR_RECORD, "problema.registroErroConhecido");

		private final Integer id;
		private final ProblemRequestStatus status;
		private final String I18NKey;

		private ProblemRequestPhase(final Integer id, final ProblemRequestStatus status, final String I18NKey) {
			this.id = id;
			this.status = status;
			this.I18NKey = I18NKey;
		}

		public ProblemRequestStatus getStatus() {
			return status;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public static ProblemRequestPhase fromId(Integer idPhase) {
			for (ProblemRequestPhase phase : ProblemRequestPhase.values()) {
				if (phase.getId().equals(idPhase)) {
					return phase;
				}
			}

			throw new IllegalArgumentException(String.format("ProblemRequestPhase not found for id '%s'", idPhase));
		}

		public static String chaveFromId(Integer idPhase) {
			ProblemRequestPhase problemRequestPhase = fromId(idPhase);
			return problemRequestPhase.getI18NKey();
		}
	}

	public enum ProblemRequestStatus {

		REGISTERED(1, "citcorpore.comum.registrada"),
		IN_PROGRESS(2, "citcorpore.comum.emandamento"),
		APPROVED(3, "citcorpore.comum.aprovacao"),
		PLANNED(4, "citcorpore.comum.planejada"),
		IN_EXECUTION(5, "citcorpore.comum.emExecucao"),
		EXECUTED(6, "perfil.executada"),
		SUSPENDED(7, "citcorpore.comum.suspensa"),
		CANCELED(8, "citcorpore.comum.cancelada"),
		REJECTED(9, "citcorpore.comum.rejeitada"),
		SOLVED(10, "citcorpore.comum.resolvida"),
		REOPENED(11, "citcorpore.comum.reaberta"),
		RECLASSIFIED(12, "citcorpore.comum.reclassificada"),
		CLOSED(13, "citcorpore.comum.fechada"),
		CONCLUDED(14, "problemrequeststatus.concluida"),
		IN_INVESTIGATION(15, "gerenciamentoProblema.emInvestigacao"),
		WORKAROUND(16, "problema.solucao_contorno"),
		REVIEWED(17, "problema.revisado"),
		RESOLUTION(18, "pesquisaProblema.resolucao"),
		CLOSURE(19, "grupo.encerramento"),
		REVIEW(20, "gerenciamentoProblema.revisar"),
		KNOWN_ERROR_RECORD(21, "problema.registroErroConhecido");

		private final Integer id;
		private final String I18NKey;

		private ProblemRequestStatus(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static String chaveFromId(final Integer id) {
			for (ProblemRequestStatus problemRequestStatus : ProblemRequestStatus.values()) {
				if (problemRequestStatus.getId().equals(id)) {
					return problemRequestStatus.getI18NKey();
				}
			}

			return "";
		}

		public Integer getId() {
			return id;
				}

		public String getI18NKey() {
			return I18NKey;
		}

		}

    /**
     * Enum armazena os Tipos de Carga do Sistema.
     *
     * @author Vadoilo Damasceno
     *
     */
    public enum TipoCargaSmart {

        Empregado("Colaboradores");

        private final String descricao;

        private TipoCargaSmart(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    /**
	 * @author ibimon.morais
	 *         Date: 18/09/2015
	 *
	 *         citcorpore.comum.complexidadeAlta = Alta
	 *         citcorpore.comum.complexidadeBaixa = Baixa
	 *         citcorpore.comum.complexidadeEspecialista = Especialista
	 *         citcorpore.comum.complexidadeIntermediaria = Intermediria
	 *         citcorpore.comum.complexidadeMediana = Mediana
	 */
    public enum Complexidade {
        BAIXA("B", "citcorpore.comum.complexidadeBaixa"),
        INTERMEDIARIA("I", "citcorpore.comum.complexidadeIntermediaria"),
        MEDIANA("M", "citcorpore.comum.complexidadeMediana"),
        ALTA("A", "citcorpore.comum.complexidadeAlta"),
        ESPECIALISTA("E", "citcorpore.comum.complexidadeEspecialista");

		private final String identificador;
		private final String chave;

		/**
		 * @param identificador
		 * @param chave
		 * @author ibimon.morais
		 */
		private Complexidade(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		/**
		 * br.com.centralit.citcorpore.util.Enumerados.java_(fromTipo)
		 * @18/09/2015
		 *
		 * @author ibimon.morais
		 */
		public static Complexidade getComplexidade(final String chaveIdentificacao) {
			Complexidade retorno = null;
			for (final Complexidade variavelComplexidade : Complexidade.values()) {
				if (variavelComplexidade.getIdentificador().equalsIgnoreCase(chaveIdentificacao)) {
					retorno = variavelComplexidade;
					break;
        }
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
        }

		public String getChave() {
			return chave;
        }
    }

    /**
	 * @author ibimon.morais
	 *         Date: 30/09/2015
	 *
	 *         citcorpore.comum.contrato = Contrato
	 *         citcorpore.comum.acordo.nivelOperacional = Acordo de Nvel Operacional
	 *         citcorpore.comum.contratoDeApoio = Contrato Subjacente
	 */
    public enum TipoAcordoContrato {
		CONTRATO("C", "citcorpore.comum.contrato", "citcorpore.comum.contratos"),
		ACORDO_NIVEL_OPERACIONAL("A", "citcorpore.comum.acordo.nivelOperacional", "citcorpore.comum.acordos.nivelOperacional"),
		CONTRATO_APOIO("U", "citcorpore.comum.contratoDeApoio", "citcorpore.comum.contratosDeApoio");

		private final String identificador;
		private final String chave;
		private final String chavePlural;

		/**
		 * @param identificador
		 * @param chave
		 * @author ibimon.morais
		 */
		private TipoAcordoContrato(final String identificador, final String chave, String chavePlural) {
			this.identificador = identificador;
			this.chave = chave;
			this.chavePlural = chavePlural;
		}

		/**
		 * br.com.centralit.citcorpore.util.Enumerados.java_(fromTipo)
		 * @30/09/2015
		 *
		 * @author ibimon.morais
		 */
		public static TipoAcordoContrato getTipoAcordoContrato(final String tipo) {
			TipoAcordoContrato retorno = null;
			for (final TipoAcordoContrato tipoAcordo : TipoAcordoContrato.values()) {
				if (tipoAcordo.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoAcordo;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

		public String getChavePlural() {
			return chavePlural;
		}
    }

    public enum PeriodoFormula {

        MENSAL(1, "Mensal"),
        SEMANAL(2, "Semanal"),
		DIARIO(3, "Dirio"),
		DIAS_UTEIS(4, "Dias teis");

        private final int index;
        private final String descricao;

        private PeriodoFormula(final int index, final String descricao) {
            this.index = index;
            this.descricao = descricao;
        }

        public int getIndex() {
            return index;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum StatusIC {

        ATIVADO(1, "Ativado", "baseItemConfiguracao.Ativado", "label-success"),
        DESATIVADO(2, "Desativado", "baseItemConfiguracao.Desativado", "label-important"),
		EM_MANUTENCAO(3, "Em Manuteno", "baseItemConfiguracao.Em_Manuteno", "label-warning"),
		IMPLANTACAO(4, "Implantao", "baseItemConfiguracao.Implantao", "label-warning"),
		HOMOLOGACAO(5, "Homologao", "baseItemConfiguracao.Homologao", "label-warning"),
        EM_DESENVOLVIMENTO(6, "Em Desenvolvimento", "baseItemConfiguracao.Em_Desenvolvimento", "label-warning"),
        ARQUIVADO(7, "Arquivado", "baseItemConfiguracao.Arquivado", "label-success"),
        VALIDAR(8, "Validar Item", "baseItemConfiguracao.Validar_Item", "label-important");

        private final Integer item;
        private final String descricao;
        private final String chaveInternacionalizacao;
        private final String label;

        private StatusIC(final Integer item, final String descricao, final String chaveInternacionalizacao, final String label) {
            this.item = item;
            this.descricao = descricao;
            this.chaveInternacionalizacao = chaveInternacionalizacao;
            this.label = label;
        }

        public Integer getItem() {
            return item;
        }

        public String getDescricao() {
            return descricao;
        }

        public String getChaveInternacionalizacao() {
            return chaveInternacionalizacao;
        }

        public String getLabel() {
        	return label;
        }

        public static StatusIC getStatus(final Integer id) {
            if (id == null) {
                return null;
            }

            StatusIC result = null;
            for (final StatusIC status : StatusIC.values()) {
                if (status.getItem().intValue() == id.intValue()) {
                    result = status;
                    break;
                }
            }
            return result;
        }

    }

	public enum CriticidadeIC {

		CRITICA(1, "citcorpore.comum.critica"),
		ALTA(2, "citcorpore.comum.alta"),
		MEDIA(3, "citcorpore.comum.media"),
		BAIXA(4, "citcorpore.comum.baixa"),
		PLANEJADA(5, "citcorpore.comum.planejada");

		private final Integer item;
		private final String descricao;

		private CriticidadeIC(final Integer item, final String descricao) {
			this.item = item;
			this.descricao = descricao;

		}

		public static CriticidadeIC fromItem(Integer item) {
			CriticidadeIC retorno = null;

			for (CriticidadeIC criticidade : CriticidadeIC.values()) {
				if (criticidade.getItem().equals(item)) {
					return criticidade;
				}
			}

			return retorno;
		}

		public static String getChavefromItem(Integer item) {
			String retorno = "N/A";
			CriticidadeIC criticidade = fromItem(item);

			if (!Util.isNullOrEmpty(criticidade)) {
				retorno = criticidade.getDescricao();
			}

			return retorno;
		}

		public Integer getItem() {
			return item;
		}

		public String getDescricao() {
			return descricao;
		}

	}

	public enum Impacto {
		ALTA("A", "citcorpore.comum.alta"),
		MEDIA("M", "citcorpore.comum.media"),
		BAIXA("B", "citcorpore.comum.baixa");

		private final String item;
		private final String descricao;

		private Impacto(final String item, final String descricao) {
			this.item = item;
			this.descricao = descricao;

		}

		public static Impacto fromItem(String item) {
			Impacto retorno = null;

			for (Impacto impacto : Impacto.values()) {
				if (impacto.getItem().equals(item)) {
					return impacto;
				}
			}

			return retorno;
		}

		public static String getChavefromItem(String item) {
			String retorno = "N/A";
			Impacto impacto = fromItem(item);

			if (!Util.isNullOrEmpty(impacto)) {
				retorno = impacto.getDescricao();
			}

			return retorno;
		}

		public String getItem() {
			return item;
		}

		public String getDescricao() {
			return descricao;
		}

	}

    /**
	 * Enum utilizado para listar as Permisses de Acesso s Pasta de Base de Conhecimento.
	 *
	 */
    public enum PermissaoAcessoPasta {

        SEMPERMISSAO("SEMPERMISSAO"),
        LEITURA("LEITURA"),
        LEITURAGRAVACAO("LEITURAGRAVACAO");

        private final String permissao;

        private PermissaoAcessoPasta(final String permissao) {
            this.permissao = permissao;
        }

        public String getPermissao() {
            return permissao;
        }

    }

    /**
	 * Enum utilizado para listar as Permisses de Acesso s Pasta de Base de Conhecimento.
	 *
	 */
    public enum TipoNotificacao {

        ServTodasAlt("tipoNotificacao.ocorrerQualquerAlteracaoServico", "T"),
        ServADICIONADOS("tipoNotificacao.novosServicosForemAdicionados", "C"),
        ServALTERADOS("tipoNotificacao.servicosForemAlterados", "A"),
        ServEXCLUIDOS("tipoNotificacao.servicosForemExcluidos", "E");

        private final String descricao;
        private final String tipoNotificacao;

        private TipoNotificacao(final String descricao, final String tipoNotificacao) {
            this.descricao = descricao;
            this.tipoNotificacao = tipoNotificacao;
        }

        public String getTipoNotificacao() {
            return tipoNotificacao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    /**
	 * Enum com os Graus de Importncia do Conhecimento.
	 *
	 * @author Vadoilo Damasceno
	 *
	 */
    public enum EnumGrauImportanciaConhecimento {

        BAIXO("Baixo"),
		MEDIO("Mdio"),
        ALTO("Alto");

        private final String grauImportancia;

        private EnumGrauImportanciaConhecimento(final String grauImportancia) {
            this.grauImportancia = grauImportancia;
        }

        public String getGrauImportancia() {
            return grauImportancia;
        }

    }

    /*
	 * Enumerador para situao de FAQ - Frequently Asked Questions
	 */
    public enum SituacaoFAQ {

        PUBLICADO("Publicado"),
		NAO_PUBLICADO("No Publicado");

        private final String descricao;

        private SituacaoFAQ(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    /*
	 * Enumerador para situao de SIM e NAO
	 */
    public enum Situacao {

        SIM("Sim"),
		NAO("No");

        private final String descricao;

        private Situacao(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum CategoriaTipoItemConfiguracao {

        HARDWARE(1, "Hardware"),
        SOFTWARE(2, "Software"),
        BIOS(3, "Bios");

        private final Integer item;
        private final String descricao;

        private CategoriaTipoItemConfiguracao(final Integer item, final String descricao) {
            this.item = item;
            this.descricao = descricao;

        }

        public Integer getItem() {
            return item;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum SituacaoItemRequisicaoProduto {

		AguardandoValidacao("Aguardando validao", AcaoItemRequisicaoProduto.Criacao),
		RejeitadoCompras("Requisio rejeitada", AcaoItemRequisicaoProduto.Validacao),
		AlteradoCompras("Alterado pela rea de compras", AcaoItemRequisicaoProduto.Validacao),
        Inviabilizado("Inviabilizado", AcaoItemRequisicaoProduto.Validacao),
		AguardandoAutorizacaoCompra("Aguardando autorizao", AcaoItemRequisicaoProduto.Validacao),
        AlteradoAutorizador("Alterado pelo autorizador",AcaoItemRequisicaoProduto.Autorizacao),
		RejeitadoAutorizador("Requisio rejeitada", AcaoItemRequisicaoProduto.Autorizacao),
		CompraNaoAutorizada("Compra no autorizada", AcaoItemRequisicaoProduto.Autorizacao),
		AguardandoCotacao("Aguardando cotao", AcaoItemRequisicaoProduto.Autorizacao),
		AguardandoAprovacaoCotacao("Aguardando aprovao da cotao", AcaoItemRequisicaoProduto.Publicacao),
		CotacaoNaoAprovada("Cotao no aprovada", AcaoItemRequisicaoProduto.Aprovacao),
        AguardandoPedido("Aguardando pedido de compra", AcaoItemRequisicaoProduto.Aprovacao),
        AguardandoEntrega("Aguardando entrega", AcaoItemRequisicaoProduto.Pedido),
		AguardandoInspecao("Aguardando inspeo", AcaoItemRequisicaoProduto.Entrega),
		AguardandoInspecaoGarantia("Aguardando inspeo", AcaoItemRequisicaoProduto.Garantia),
		InspecaoRejeitada("Inspeo rejeitada", AcaoItemRequisicaoProduto.Inspecao),
        Cancelado("Cancelado", AcaoItemRequisicaoProduto.Cancelamento),
        Finalizado("Finalizado", AcaoItemRequisicaoProduto.Inspecao);

        private final String descricao;
        private final AcaoItemRequisicaoProduto acaoPadrao;

        private SituacaoItemRequisicaoProduto(final String descricao, final AcaoItemRequisicaoProduto acaoPadrao) {
            this.descricao = descricao;
            this.acaoPadrao = acaoPadrao;
        }

        public String getDescricao() {
            return descricao;
        }

        public AcaoItemRequisicaoProduto getAcaoPadrao() {
            return acaoPadrao;
        }

    }

    public enum AcaoItemRequisicaoProduto {

		Criacao("Criao da requisio"),
		Alteracao("Alterao da requisio"),
		Validacao("Validao pela rea de compras"),
		Autorizacao("Autorizao da compra"),
		Publicacao("Publicao dos resultados"),
		Aprovacao("Aprovao da cotao"),
		Reabertura("Reabertura das coletas de preo"),
		Pedido("Gerao do pedido"),
        Entrega("Entrega do pedido"),
        Garantia("Retorno de garantia"),
		Inspecao("Inspeo do solicitante"),
		Cancelamento("Excluso/Cancelamento do item"),
		ExclusaoPedido("Excluso do pedido"),
		ExclusaoItemCotacao("Excluso do item de cotao"),
		EncerramentoCotacao("Encerramento da cotao");

        private final String descricao;

        private AcaoItemRequisicaoProduto(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum TipoAlcada {

		Compras("Autorizao de compras"),
		Pessoal("Requisio de pessoal"),
        Viagem("Requisicao de Viagem");

        private final String descricao;

        private TipoAlcada(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum SituacaoCotacao {

        EmAndamento("Em andamento"),
        Calculada("Resultado calculado"),
        Publicada("Resultado publicado"),
        Pedido("Pedido(s) gerado(s)"),
        Entrega("Pedido(s) entregue(s)"),
        Finalizada("Finalizada"),
        Cancelada("Cancelada");

        private final String descricao;

        private SituacaoCotacao(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum SituacaoCotacaoItemRequisicao {

		AguardaAprovacao("Aguardando aprovao"),
		PreAprovado("Pr aprovado"),
        Aprovado("Aprovado"),
		NaoAprovado("No aprovado"),
		Cancelado("No aprovado");

        private final String descricao;

        private SituacaoCotacaoItemRequisicao(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum OrigemNotificacao {

		B("Notificao de base de conhecimento"),
		P("Notificao de Pasta"),
		S("Notificao de servio de contrato");

        private final String descricao;

        private OrigemNotificacao(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum ResultadoValidacao {

        V("Validado"),
        A("Aviso"),
		E("Erro no impeditivo"),
        I("Erro impeditivo");

        private final String descricao;

        private ResultadoValidacao(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum SituacaoPedidoCompra {

        Efetivado("Efetivado"),
		Analise("Aguardando anlise de crdito"),
		Aprovacao("Aguardando aprovao do pagamento"),
        Aprovado("Pagamento aprovado"),
		Transportadora("Entregue  transportadora"),
        Transporte("Em rota de entrega"),
        Entregue("Entregue");

        private final String descricao;

        private SituacaoPedidoCompra(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum SituacaoEntregaItemRequisicao {

		Aguarda("Aguardando inspeo"),
        Aprovada("Entrega aprovada"),
        AprovadaPrazo("Aprovada por decurso de prazo"),
        NaoAprovada("Entrega nao aprovada");

        private final String descricao;

        private SituacaoEntregaItemRequisicao(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum SituacaoSLA {

		N("No iniciado", "citcorpore.comum.naoIniciado"),
        S("Suspenso", "citcorpore.comum.suspenso"),
		M("Multiplo", "citcorpore.comum.multiplo"), // M = Solicitaes suspensas atravs da tela de Suspenso/Reativao de Mltiplas Solicitaes por Grupo.
        A("Em andamento", "requisitosla.andamento");

        private final String descricao;
        private final String chave;

        private SituacaoSLA(final String descricao, final String chave) {
            this.descricao = descricao;
            this.chave = chave;
        }

        public String getDescricao() {
            return descricao;
        }

        public String getChave() {
            return chave;
        }

        public static SituacaoSLA fromNameIgnoreCase(final String name) {
            final String nameUpper = name.toUpperCase();
            return SituacaoSLA.valueOf(nameUpper);
        }

    }

    public enum Moeda {

        UST("UST"),
        REAL("Real");

        private final String descricao;

        private Moeda(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    /**
     * Identifica qual modulo que faz referencia.
     *
	 * @author maycon.fernandes
     */
	public enum RequestType {

		RELEASE(1, "modulosistema.liberacao"),
		CHANGE(2, "modulosistema.mudanca"),
		SERVICE_REQUEST(3, "modulosistema.gerencservicos"),
		PROBLEM(4, "modulosistema.problema");

        private final Integer id;
		private final String I18NKey;

		private RequestType(final Integer id, final String I18NKey) {
            this.id = id;
			this.I18NKey = I18NKey;
        }

        public Integer getId() {
            return id;
        }

		public String getI18NKey() {
			return I18NKey;
        }
    }

    /**
	 * Enumerado para definir qual aba ser vinculano na requisio.<br>
	 *
	 * Ex: Mdulo Liberao aba TesteLiberao. onde o iframe ir abri.<br>
	 *
	 * No criar outro enumerado adicionar novas abas.
	 *
	 * @author maycon.fernandes
	 *
	 */
    public enum Aba {

		LIBERCAOTESTE(1, "Teste Liberao"),
		LIBERACAOETAPAS(2, "Liberao Etapas"),
		LIBERACAOITEMCONFIGUACAO(3, "Liberao Item Configurao"),
		LIBERACAOSERVICO(4, "Liberao Servio"),
		MUDANCAGENERICO(5, "Questionrio Mudana");

        private final Integer id;
        private final String aba;

        private Aba(final Integer id, final String aba) {
            this.id = id;
            this.aba = aba;
        }

        public Integer getId() {
            return id;
        }

        public String getAba() {
            return aba;
        }

    }

    public enum TipoEntrevista {

        RH("Entrevista com RH"),
        Gestor("Entrevista com Gestor");

        private final String descricao;

        private TipoEntrevista(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum ResultadoEntrevista {

		N("No avaliada"),
        A("Entrevista com RH"),
        R("Reprovado"),
		S("2 Oportunidade"),
        D("Descarte");

        private final String descricao;

        private ResultadoEntrevista(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    /**
	 * Enumerados do tipo de movimentao financeira do mdulo de viagens.
	 *
	 * @author ronnie.lopes
	 */
    public enum TipoMovFinViagem {

        D("requisicaoViagem.itemReferente", 1),
        R("requisicaoViagem.ressarcimento", 2);

        private final String descricao;
        private final Integer id;

        private TipoMovFinViagem(final String descricao, final Integer id) {
            this.descricao = descricao;
            this.id = id;
        }

        public String getDescricao() {
            return descricao;
        }

        public Integer getId() {
            return id;
        }

    }

    /**
	 * Enumerados da classificao de movimentao financeira do mdulo de viagens.
	 *
	 * @author ronnie.lopes
	 */
    public enum ClassificacaoMovFinViagem {

        Passagem("Passagem", 1),
        Hospedagem("Hospedagem", 2),
		LocacaoVeiculo("Locao Veculo", 3),
		Diaria("Diria", 4),
        DespesaExtra("Despesa Extra", 5);

        private final String descricao;
        private final Integer id;

        private ClassificacaoMovFinViagem(final String descricao, final Integer id) {
            this.descricao = descricao;
            this.id = id;
        }

        public String getDescricao() {
            return descricao;
        }

        public Integer getId() {
            return id;
        }

    }

    public enum TipoSolicitacaoServico {

        COMPRA(1, "Compra"),
        VIAGEM(2, "Viagem"),
		RH(3, "Requisio de pessoal"),
        INCIDENTE(4, "Incidente"),
		REQUISICAO(5, "Requisio");

        private final Integer identifier;
        private final String descricao;

        private TipoSolicitacaoServico(final Integer identifier, final String descricao) {
            this.identifier = identifier;
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

        public Integer getIdentifier() {
            return identifier;
        }

        /**
		 * Recupera uma {@link TipoSolicitacaoServico} de acordo com seu identificador
		 *
		 * @param identifier
		 *            id a ser verificado se h uma {@link TipoSolicitacaoServico}
		 * @return {@link TipoSolicitacaoServico} caso encontre. {@link IllegalArgumentException}, caso contrrio
		 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
		 * @since 08/10/2014
		 */
        public static TipoSolicitacaoServico fromIdentifier(final Integer identifier) {
            final TipoSolicitacaoServico[] tipos = TipoSolicitacaoServico.values();
            for (final TipoSolicitacaoServico tipo : tipos) {
                if (tipo.getIdentifier().equals(identifier)) {
                    return tipo;
                }
            }
            throw new IllegalArgumentException(String.format("TipoSolicitacaoServico not found for identifier '%s'", identifier));
        }

    }

	// Mrio Jnior - 25/10/2013 19:40 Para Ordem em SolicitaoServio
    public enum OrdemSolicitacaoServico {

        PRAZOLIMITE("dataHoraLimite", "solicitacaoServico.prazoLimite"),
        DATACRIADA("dataHoraInicio", "visao.dataCriacao"),
        SOLICITANTE("solicitanteUnidade", "solicitacaoServico.solicitante"),
        CRIADOPOR("responsavel", "requisitosla.criador"),
        ATRASO("atrasoSLAStr", "tarefa.atraso"),
        GRUPOEXECUTOR("grupoAtual", "tipoLiberacao.nomeGrupoExecutor"),
        PRIORIDADE("prioridade", "solicitacaoServico.prioridade"),
        SERVICO("nomeServico", "servico.servico"),
        NUMEROSOLICITACAO("idSolicitacaoServico", "solicitacaoServico.numerosolicitacao"),
        CONTRATO("idContrato", "requisitosla.contrato"),
        SITUACAO("situacao", "requisitosla.situacao");

        private final String ordem;
        private final String valor;

        private OrdemSolicitacaoServico(final String ordem, final String valor) {
            this.ordem = ordem;
            this.valor = valor;
        }

        public String getOrdem() {
            return ordem;
        }

        public String getValor() {
            return valor;
        }

    }

    public enum ItensPorPagina {

        CINCO(5),
        DEZ(10),
        QUIZE(15),
        VINTE(20),
        CINQUENTA(50),
        CEM(100),
        DUZENTOS(200),
        QUINHETOS(500);

        private final Integer valor;

        private ItensPorPagina(final Integer valor) {
            this.valor = valor;
        }

        public Integer getValor() {
            return valor;
        }

    }

    /**
     * Enumerado para armazenar os Tipos de Data.
     *
     * <pre>
     * DATE_DEFAULT: dd/MM/yyyy ou MM/dd/yyyy,
     * TIMESTAMP_DEFAULT: dd/MM/yyyy HH:mm ou MM/dd/yyyy HH:mm,
     * TIMESTAMP_WITH_SECONDS: dd/MM/yyyy HH:mm:ss ou MM/dd/yyyy HH:mm:ss,
     * FORMAT_DATABASE: yyyy-MM-dd
     * </pre>
     *
     * @author valdoilo.damasceno
     * @since 04.02.2013
     */
    public enum TipoDate {

        DATE_DEFAULT("DATE_DEFAULT"),
        TIMESTAMP_DEFAULT("TIMESTAMP_DEFAULT"),
        TIMESTAMP_WITH_SECONDS("TIMESTAMP_WITH_SECONDS"),
        FORMAT_DATABASE("FORMAT_DATABASE"),
        FORMAT_DATABASE_WITH_HOUR_AND_SECOND("FORMAT_DATABASE_WITH_HOUR_AND_SECOND");

        private final String tipoData;

        private TipoDate(final String tipoDate) {
            tipoData = tipoDate;
        }

        public String getTipoDate() {
            return tipoData;
        }

		public static TipoDate fromTipoData(String tipoData) {
			TipoDate retorno = null;

			for (TipoDate tipoDate : TipoDate.values()) {
				if (tipoDate.getTipoDate().equals(tipoData)) {
					return tipoDate;
				}
			}

			return retorno;
		}

    }

    /**
     * Enumerado para armazenar os Tipos de Origem na leitura de e-mail.
     *
     * @author rodrigo.acorse
     * @since 02.06.2014
     */
    public enum TipoOrigemLeituraEmail {

        SOLICITACAO_SERVICO("SOLICITACAO_SERVICO"),
        PROBLEMA("PROBLEMA");

        private final String tipoOrigemLeituraEmail;

        private TipoOrigemLeituraEmail(final String tipoOrigemLeituraEmail) {
            this.tipoOrigemLeituraEmail = tipoOrigemLeituraEmail;
        }

        public String getTipoOrigemLeituraEmail() {
            return tipoOrigemLeituraEmail;
        }

    }

    public enum MotivoRejeicaoAlcada {

		LimiteValor("Fora dos limites de aprovao"),
		HierarquiaAutoridade("Nvel de hierarquia abaixo da hierarquia do solicitante"),
		PermissaoAutoridade("Autoridade no tem permisso para aprovar as prprias solicitaes"),
		RegrasProcesso("Regras do processo de negcio"),
		UsuarioNaoExiste("No existe um usurio ativo associado ao empregado autorizador"),
		PertenceGrupoAdministrador("Solicitante pertence ao grupo administrador do processo de negcio");

        private final String descricao;

        private MotivoRejeicaoAlcada(final String descricao) {
            this.descricao = descricao;
        }

        public String getDescricao() {
            return descricao;
        }

    }

    public enum TopListEnum {

        TOP10(10, "citcorpore.comum.topList10"),
        TOP20(20, "citcorpore.comum.topList20"),
        TOP50(50, "citcorpore.comum.topList50"),
        TOP100(100, "citcorpore.comum.topList100"),
        TOP200(200, "citcorpore.comum.topList200"),
        TOP500(500, "citcorpore.comum.topList500"),
        TOPTODOS(0, "citcorpore.comum.todos");

        private final Integer valorTopList;
        private final String nomeTopList;

        private TopListEnum(final Integer valorTopList, final String nomeTopList) {
            this.nomeTopList = nomeTopList;
            this.valorTopList = valorTopList;
        }

        public Integer getValorTopList() {
            return valorTopList;
        }

        public String getNomeTopList() {
            return nomeTopList;
        }

    }

	/**
	 * Enumerados com os Tipos de Item Configurao Default de um XML de Inventrio.
	 *
	 * @author valdoilo.damasceno
	 * @since 19.01.2014
	 */
	public enum TagTipoItemConfiguracaoDefault {

		ACCOUNTS("ACCOUNTS"),
		BIOS("BIOS"),
		CAPTION("CAPTION"),
		DESCRIPTION("DESCRIPTION"),
		DISKSIZE("DISKSIZE"),
		ENVIRONMENTS("ENVIRONMENTS"),
		HARDWARE("HARDWARE"),
		MACADDR("MACADDR"),
		MEMORIES("MEMORIES"),
		NAME("NAME"),
		NETWORKS("NETWORKS"),
		PRODUCT("PRODUCT"),
		PRODUCTID("PRODUCTID"),
		INPUTS("INPUTS"),
		SERVICES("SERVICES"),
		STORAGES("STORAGES"),
		SOFTWARES("SOFTWARES"),
		OFFICEPACK("OFFICEPACK"),
		TYPE("TYPE"),
		VERSION("VERSION"),
		PORTS("PORTS"),
		CONTROLLERS("CONTROLLERS"),
		SLOTS("SLOTS"),
		SOUNDS("SOUNDS"),
		DRIVES("DRIVES"),
		VIDEOS("VIDEOS"),
		MONITORS("MONITORS"),
		PRINTERS("PRINTERS");

		private final String tagTipoItemConfiguracao;

		private TagTipoItemConfiguracaoDefault(final String tagTipoItemConfiguracao) {
			this.tagTipoItemConfiguracao = tagTipoItemConfiguracao;
}

		public String getTagTipoItemConfiguracao() {
			return tagTipoItemConfiguracao;
		}
	}

	/**
	 * Enumerado com os Nomes de Caractersticas de Identificao.
	 *
	 * @author valdoilo.damasceno
	 * @since 19.01.2014
	 */
	public enum CaracteristicaIdentificacao {

		CAPTION("CAPTION"),
		CAPACITY("CAPACITY"),
		DESCRIPTION("DESCRIPTION"),
		DEVICEID("DEVICEID"),
		DISKSIZE("DISKSIZE"),
		DOMAIN("DOMAIN"),
		IPADDR("IPADDR"),
		MACADDR("MACADDR"),
		NAME("NAME"),
		PRODUCT("PRODUCT"),
		PRODUCTID("PRODUCTID"),
		SMANUFACTURER("SMANUFACTURER"),
		SSN("SSN"),
		SERIALNUMBER("SERIALNUMBER"),
		STARTMODE("STARTMODE"),
		TYPE("TYPE"),
		USERNAME("USERNAME"),
		VERSION("VERSION"),
		MANUFACTURER("MANUFACTURER"),
		LETTER("LETTER"),
		TOTAL("TOTAL"),
		MEMORY("MEMORY"),
		SERIAL("SERIAL"),
		DRIVER("DRIVER");

		private CaracteristicaIdentificacao(final String nomeCaracteristica) {
			this.nomeCaracteristica = nomeCaracteristica;
		}

		final String nomeCaracteristica;

		public String getNomeCaracteristica() {
			return nomeCaracteristica;
		}

	}

	/**
	 * Enumerados que contm o nome da sigla de datas em ingls e em portugus para que seja realizado a converso
	 *
	 * @author thyen.chang
	 * @since 11/03/2015
	 */
	public enum DiaData{
		SEGUNDA("Mon", "Seg"),
		TERCA("Tue", "Ter"),
		QUARTA("Wed", "Qua"),
		QUINTA("Thu", "Qui"),
		SEXTA("Fri", "Sex"),
		SABADO("Sat", "Sab"),
		DOMINGO("Sun", "Dom");

		final String diaEn, diaPt;

		private DiaData(final String diaEn, final String diaPt){
			this.diaEn = diaEn;
			this.diaPt = diaPt;
		}

		public String getDiaEn(){
			return this.diaEn;
		}

		public String getDiaPt(){
			return this.diaPt;
		}
	}

	//Este enumerado foi criado para contornar o problema de se ter mais de um encoding para as telas do citsmart
	//com este enumerado podemos setar encodings diferentes para a tela de upload.
	public enum CampoUpload {

		UPLOADANEXOS("DESCUPLOADFILE_UPLOADANEXOS","","UTF-8"),
		UPLOADANEXOSDOCSGERAIS("DESCUPLOADFILE_UPLOADANEXOSDOCSGERAIS","","ISO-8859-1"),
		UPLOADANEXOSDOCSLEGAIS("DESCUPLOADFILE_UPLOADANEXOSDOCSLEGAIS","","ISO-8859-1"),
		UPLOADPLANODEREVERSAO("DESCUPLOADFILE_UPLOADPLANODEREVERSAO","","ISO-8859-1"),
		UPLOADPLANODEREVERSAOLIBERACAO("descUploadFile_uploadPlanoDeReversaoLiberacao","","ISO-8859-1"),
		UPLOADREQUISICAOLIBERACAO("DESCUPLOADFILE_UPLOADREQUISICAOLIBERACAO","","ISO-8859-1"),
		UPLOADREQUISICAOMUDANCA("DESCUPLOADFILE_UPLOADREQUISICAOMUDANCA","","ISO-8859-1"),
		UPLOADREQUISICAOPROBLEMA("DESCUPLOADFILE_UPLOADREQUISICAOPROBLEMA", "", "UTF-8"),
		UPLOADREQUISITOSNIVELSERVICO("CAMPOSELECT_UPLOADREQUISITOSNIVELSERVICO","colUploadRequisitosNivelServicoGED","UTF-8"),
		UPLOADCASODENEGOCIO("CAMPOSELECT_UPLOADCASODENEGOCIO","colUploadCasoDeNegocioGED","UTF-8"),
		UPLOADESQUEMADADOS("CAMPODESCRICAO_UPLOADESQUEMADADOS","colUploadEsquemaDadosGED","UTF-8"),
		UPLOADSERVICONEGOCIO("CAMPODESCRICAO_UPLOADSERVICONEGOCIO","colUploadServicoNegocioGED","UTF-8"),
		UPLOADINICIACAOPOLITICA("CAMPODESCRICAO_UPLOADINICIACAOPOLITICA", "colUploadIniciacaoPoliticaGED","UTF-8"),
		UPLOADINICIACAOESCOPO("CAMPODESCRICAO_UPLOADINICIACAOESCOPO", "colUploadIniciacaoEscopoGED", "UTF-8"),
		UPLOADFUNCAOVITAL("CAMPODESCRICAO_UPLOADFUNCAOVITAL", "colUploadFuncaoVitalGED", "UTF-8"),
		UPLOADCONSCIENTIZACAOREGISTRO("CAMPODESCRICAO_UPLOADCONSCIENTIZACAOREGISTRO", "colUploadConscientizacaoRegistroGED", "UTF-8"),
		UPLOADPLANOCONTINUIDADE("CAMPODESCRICAO_UPLOADPLANOCONTINUIDADE", "colUploadPlanoContinuidadeGED", "UTF-8"),
		UPLOADESTRATEGIACONTINUIDADEMEDIDARECUPERACAO("CAMPODESCRICAO_UPLOADESTRATEGIACONTINUIDADEMEDIDARECUPERACAO", "colUploadEstrategiaContinuidadeMedidaRecuperacaoGED", "UTF-8"),
		UPLOADIMPLEMENTACAOESTRATEGIATESTES("CAMPODESCRICAO_UPLOADIMPLEMENTACAOESTRATEGIATESTES", "colUploadImplementacaoEstrategiaTestesGED", "UTF-8"),
		UPLOADPLANOTESTE("CAMPODESCRICAO_UPLOADPLANOTESTE", "colUploadPlanoTesteGED", "UTF-8"),
		UPLOADCONTRATO("CAMPODESCRICAO_UPLOADCONTRATO","colUploadContratoGED","UTF-8");

		private final String nome;
		private final String colUploadGED;
		private final String encoding;

		private CampoUpload(String nome, String colUploadGED, String encoding){
			this.nome = nome;
			this.colUploadGED = colUploadGED;
			this.encoding = encoding;
		}

		public String getNome() {
			return nome;
		}

		public String getColUploadGED() {
			return colUploadGED;
		}

		public String getEncoding() {
			return encoding;
		}

		public static String buscaEncoding(final String nome){
			String encoding = null;
			CampoUpload[] campos = CampoUpload.values();
			for (CampoUpload campoUpload : campos) {
				if(campoUpload.getNome().equalsIgnoreCase(nome)){
					encoding = campoUpload.getEncoding();
					break;
				}
			}
			return encoding;
		}
	}

	/**
	 * Enumerado com as opes de Perodos da Base de Conhecimento. Lista utilizada no relatrio de Base Conhecimento.
	 *
	 * @author valdoilo.damasceno
	 * @since 27.03.2015
	 */
	public enum TipoPeriodoBaseConhecimento {

		PERIODO_CRIACAO("relatorioBaseConhecimento.periodoCriacaoBaseConhecimento"),
		PERIODO_PUBLICACAO("relatorioBaseConhecimento.periodoPublicacaoBaseConhecimento"),
		PERIODO_EXPIRACAO("relatorioBaseConhecimento.periodoExpiracaoBaseConhecimento"),
		PERIODO_ACESSO("relatorioBaseConhecimento.periodoAcessoBaseConhecimento");

		private final String nomePeriodo;

		private TipoPeriodoBaseConhecimento(String nomePeriodo) {
			this.nomePeriodo = nomePeriodo;
		}

		public String getNomePeriodo() {
			return nomePeriodo;
		}
	}

	public enum HttpMethodEnum {
		GET(),
		POST();

		private HttpMethodEnum() {

		}
	}

	public enum RestParameterTypeEnum {
		JSON(),
		XML();

		private RestParameterTypeEnum() {

		}
	}

	public enum MobileOrdemEnum {
		NUMERO_SOLICITACAO(1),
		SEM_RESPONSAVEL(2),
		DATA_CRIACAO(3),
		SLA(4);

		private int ordem;

		private MobileOrdemEnum(int ordem){
			this.ordem = ordem;
		}

		public int getOrdem(){
			return this.ordem;
		}
	}

	/**
	 * <pre>
	 * Requisitos do Gerenciamento de Portflio - Classificao do Servio em tipos:
	 * - Servio de Negcio
	 * - Servio de Apoio
	 * - Servio de Requisio
	 * - Servio de Incidente
	 * </pre>
	 *
	 * @author douglas.japiassu
	 */
	public enum TipoServico {

		SERVICO_NEGOCIO("N", "gerenciaportfolio.servicoNegocio"),
		SERVICO_APOIO("A", "gerenciaportfolio.servicoApoio"),
		SERVICO_REQUISICAO("R", "gerenciaportfolio.servicoRequisicao"),
		SERVICO_INCIDENTE("I", "gerenciaportfolio.servicoIncidente"),
		SERVICO_ORDEM_SERVICO("O", "gerenciaportfolio.servicoOrdemServico"),
		SERVICO_PROCEDIMENTO("P", "gerenciaContinuidade.implementacao.planosContinuidade.procedimento");

		private final String identificador;
		private final String chave;

		private TipoServico(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoServico fromTipo(String tipo) {
			TipoServico retorno = null;

			for (final TipoServico tipoServico : TipoServico.values()) {
				if (tipoServico.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoServico;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Requisitos do Gerenciamento de Portflio - Classificao do Servio em fases: <br>
	 * - Fase de definio <br>
	 * - Fase de anlise <br>
	 * - Fase de aprovao <br>
	 * - Fase de termo de abertura
	 *
	 * @author douglas.japiassu
	 */
	public enum FaseServico {

		DEFINIR("D", "gerenciaportfolio.fase.definir", "#5b5094"),
		ANALISAR("AN", "gerenciaportfolio.fase.analisar", "#506d94"),
		APROVAR("AP", "gerenciaportfolio.fase.aprovar", "#509491"),
		TERMO_ABERTURA("C", "gerenciaportfolio.fase.termoAbertura", "#509468");

		private final String identificador;
		private final String chave;
		private final String cor;

		private FaseServico(String identificador, String chave, String cor) {
			this.identificador = identificador;
			this.chave = chave;
			this.cor = cor;
}

		public static FaseServico fromTipo(String fase) {
			FaseServico retorno = null;

			for (final FaseServico faseServico : FaseServico.values()) {
				if (faseServico.getIdentificador().equalsIgnoreCase(fase)) {
					retorno = faseServico;
					break;
				}
			}

			return retorno;
		}

		public static String getChavefromTipo(String tipo) {
			String retorno = "N/A";
			FaseServico fase = fromTipo(tipo);

			if (!Util.isNullOrEmpty(fase)) {
				retorno = fase.getChave();
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

		public String getCor() {
			return cor;
		}
	}

	public enum TipoElementoInventario {
		GRUPO("GRUPO", "Grupo"),
		ITEMCONFIGURACAO("IC", "Item de Configurao");

		private final String codigo;
		private final String nome;

		private TipoElementoInventario(String codigo, String nome) {
			this.codigo = codigo;
			this.nome = nome;
		}

		public String getCodigo() {
			return codigo;
		}

		public String getNome() {
			return nome;
		}
	}

	/**
	 * Tipo de situao do contrato: <br>
	 * - Ativo <br>
	 * - Cancelado <br>
	 * - Finalizado <br>
	 * - Paralisado <br>
	 * - Proposta
	 *
	 * @author ibimon.morais
	 */
	public enum SituacaoContrato {
		ATIVO("A", "citcorpore.comum.ativo"),
		CANCELADO("C", "citcorpore.comum.situacaoCancelado"),
		FINALIZADO("F", "citcorpore.comum.situacaoFinalizado"),
		PARALISADO("P", "citcorpore.comum.situacaoParalisado"),
		PROPOSTA("T", "citcorpore.comum.contratoProposta");

		// Chaves
		private final String identificador;
		private final String chave;

		/**
		 * @param identificador
		 * @param chave
		 */
		private SituacaoContrato(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		/**
		 * br.com.centralit.citcorpore.util.Enumerados.java_(fromTipo)
		 * @18/09/2015
		 *
		 * @author ibimon.morais
		 */
		public static SituacaoContrato fromTipo(final String situacao) {
			SituacaoContrato retorno = null;

			for (final SituacaoContrato itemSituacao :  SituacaoContrato.values()) {
				if (itemSituacao.getIdentificador().equalsIgnoreCase(situacao)) {
					retorno = itemSituacao;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Requisitos do Gerenciamento de Portflio - Classificao da Categoria em tipos: <br>
	 * - Categoria de Negcio <br>
	 * - Categoria de Apoio <br>
	 * - Categoria de Requisio <br>
	 * - Categoria de Incidente <br>
	 * - Categoria de Ordem de Servio <br>
	 * - Categoria de Procedimento
	 *
	 * @author douglas.japiassu
	 */
	public enum TipoCategoria {

		CATEGORIA_NEGOCIO("N", "categoriaServico.categoriaNegocio"),
		CATEGORIA_APOIO("A", "categoriaServico.categoriaApoio"),
		CATEGORIA_INCIDENTE_REQUISICAO("I", "categoriaServico.categoriaIncidenteRequisicao"),
		CATEGORIA_ORDEM_SERVICO("O", "categoriaServico.categoriaOrdemServico"),
		CATEGORIA_PROCEDIMENTO("P", 	"categoriaServico.categoriaProcedimento");

		private final String identificador;
		private final String chave;

		private TipoCategoria(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoCategoria fromTipo(String tipo) {
			TipoCategoria retorno = null;

			for (final TipoCategoria tipoCategoria : TipoCategoria.values()) {
				if (tipoCategoria.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoCategoria;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum SimNao {
		SIM("S", "Y", 1, "citcorpore.comum.sim"),
		NAO("N", "N", 2, "citcorpore.comum.nao");

		private final String valorStr;
		private final String valorStrEn;
		private final Integer valorUmDois;
		private final String chave;

		private SimNao(String valorStr, String valorStrEn, Integer valorUmDois, String chave) {
			this.valorStr = valorStr;
			this.valorStrEn = valorStrEn;
			this.valorUmDois = valorUmDois;
			this.chave = chave;
		}

		public static SimNao fromValorStr(String valorStr) {
			SimNao retorno = null;

			for (final SimNao simNao : SimNao.values()) {
				if (simNao.getValorStr().equalsIgnoreCase(valorStr)) {
					retorno = simNao;
					break;
				}
			}

			return retorno;
		}

		public String getValorStr() {
			return valorStr;
		}

		public String getValorStrEn() {
			return valorStrEn;
		}

		public Integer getValorUmDois() {
			return valorUmDois;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Requisitos do Gerenciamento de Portflio - Classificao do Servio em status, dependentes da fase: <br>
	 * - Requisitos <br>
	 * - Definio <br>
	 * - Anlise <br>
	 * - Aprovado <br>
	 * - Termo de Abertura <br>
	 * - Desenho <br>
	 * - Desenvolvimento <br>
	 * - Construo <br>
	 * - Teste <br>
	 * - Liberao <br>
	 * - Produo <br>
	 * - Aposentando <br>
	 * - Aposentado
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.FaseServico
	 * @author douglas.japiassu
	 */
	public enum StatusServico {

		REQUISITOS("RQSTS", "gerenciaportfolio.statusServico.requisitos", FaseServico.DEFINIR, "#6d639f"),
		DEFINICAO("DFNC", "gerenciaportfolio.statusServico.definicao", FaseServico.DEFINIR, "#463e73"),
		ANALISE("ANLS", "gerenciaportfolio.statusServico.analise", FaseServico.ANALISAR, "#3e5473"),
		APROVADO("APRV", "gerenciaportfolio.statusServico.aprovado", FaseServico.APROVAR, "#3e7370"),
		TERMO_DE_ABERTURA("TDA", "gerenciaportfolio.statusServico.termoDeAbertura", FaseServico.TERMO_ABERTURA, "#8ab79a"),
		DESENHO("DSNH", "gerenciaportfolio.statusServico.desenho", FaseServico.TERMO_ABERTURA, "#76ab89"),
		DESENVOLVIMENTO("DSNV", "gerenciaportfolio.statusServico.desenvolvimento", FaseServico.TERMO_ABERTURA, "#639f78"),
		CONSTRUCAO("CNST", "gerenciaportfolio.statusServico.construcao", FaseServico.TERMO_ABERTURA, "#47835c"),
		TESTE("TST", "gerenciaportfolio.statusServico.teste", FaseServico.TERMO_ABERTURA, "#3e7350"),
		LIBERACAO("LBRC", "gerenciaportfolio.statusServico.liberacao", FaseServico.TERMO_ABERTURA, "#356245"),
		PRODUCAO("PRD", "gerenciaportfolio.statusServico.producao", FaseServico.TERMO_ABERTURA, "#2c5239"),
		APOSENTANDO("APSTN", "gerenciaportfolio.statusServico.aposentando", FaseServico.TERMO_ABERTURA, "#23412e"),
		APOSENTADO("APSTD", "gerenciaportfolio.statusServico.aposentado", FaseServico.TERMO_ABERTURA, "#1a3122");

		private final String identificador;
		private final String chave;
		private final FaseServico fase;
		private final String cor;

		private StatusServico(String identificador, String chave, FaseServico fase, String cor) {
			this.identificador = identificador;
			this.chave = chave;
			this.fase = fase;
			this.cor = cor;
		}

		public static StatusServico fromTipo(String status) {
			StatusServico retorno = null;

			for (final StatusServico statusServico : StatusServico.values()) {
				if (statusServico.getIdentificador().equalsIgnoreCase(status)) {
					retorno = statusServico;
					break;
				}
			}

			return retorno;
		}

		public static String getChavefromTipo(String tipo) {
			String retorno = "N/A";
			StatusServico status = fromTipo(tipo);

			if (!Util.isNullOrEmpty(status)) {
				retorno = status.getChave();
			}

			return retorno;
		}

		public static Vector<StatusServico> fromFase(FaseServico fase) {
			Vector<StatusServico> status = new Vector<StatusServico>();

			for(final StatusServico statusServico : StatusServico.values()) {
				if (statusServico.getFase().equals(fase)) {
					status.add(statusServico);
				}
			}

			return status;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

		public FaseServico getFase() {
			return fase;
		}

		public String getCor(){
			return cor;
		}
	}

	/**
	 * Requisitos do Gerenciamento de Portflio - Classificao do Portflio em categorias: <br>
	 * - Funil de Servios <br>
	 * - Catlogo de Servios <br>
	 * - Servios Obsoletos
	 *
	 * @author douglas.japiassu
	 */
	public enum CategoriaPortfolio {

		FUNIL_SERVICOS("F", "gerenciaportfolio.funilServicos"),
		CATALOGO_SERVICOS("C", "gerenciaportfolio.catalogoServicos"),
		SERVICOS_OBSOLETOS("O", "gerenciaportfolio.servicosObsoletos");

		private final String identificador;
		private final String chave;

		private CategoriaPortfolio(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static CategoriaPortfolio fromTipo(String tipo) {
			CategoriaPortfolio retorno = null;

			for (final CategoriaPortfolio categoriaPortfolio : CategoriaPortfolio.values()) {
				if (categoriaPortfolio.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = categoriaPortfolio;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Tipos de Anexos que poderao ser inclusos na Business Case.<br>
	 * - Business Case
	 *
	 * @author ibimon.morais
	 */
	public enum TipoAnexoCasoNegocio {

		DESCRICAO_SUMARIO_EXECUTIVO("S","gerenciaportfolio.businessCase.sumario"),
		CENARIOS("C","gerenciaportfolio.businessCase.cenarios"),
		PROBLEMA_OPORTUNIDADE("B","gerenciaportfolio.businessCase.problemaOportunidade"),
		PROPOSTA_SOLUCAO("P","gerenciaportfolio.businessCase.propostaSolucao"),
		ANALISE_FINANCEIRA("F","gerenciaportfolio.businessCase.analiseFinanceira"),
		ANALISE_RISCO("R","gerenciaportfolio.businessCase.analiseRisco"),
		VIABILIDADE_TECNICA("T","gerenciaportfolio.businessCase.viabilidadeTecnica"),
		CONCLUSAO("L","gerenciaportfolio.businessCase.conclusao");

		private final String identificador;
		private final String chave;

		private TipoAnexoCasoNegocio(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoAnexoCasoNegocio fromTipo(final String tipo) {
			TipoAnexoCasoNegocio retorno = null;

			for (final TipoAnexoCasoNegocio caso : TipoAnexoCasoNegocio.values()) {
				if (caso.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = caso;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Tipos de Anexos que poderao ser inclusos nos Requisitos de Nvel de Servio.
	 *
	 * @author douglas.japiassu
	 * @since 19.10.2015
	 */
	public enum TipoAnexoRequisitosNivelServico {

		ESPECIFICACAO("ESPEC","gerenciaportfolio.requisitosNivelServico.especificacao"),
		CONTEXTO("CONT","gerenciaportfolio.requisitosNivelServico.contexto"),
		FUNCIONALIDADES_ESSENCIAIS("FUNCESSEN","gerenciaportfolio.requisitosNivelServico.funcionalidadesEssenciais"),
		SEGURANCA("SEG","gerenciaportfolio.requisitosNivelServico.seguranca"),
		DISPONIBILIDADE("DISP","gerenciaportfolio.requisitosNivelServico.disponibilidade"),
		CAPACIDADE("CAP","gerenciaportfolio.requisitosNivelServico.capacidade"),
		CONTINUIDADE_DO_NEGOCIO("CONTNEG","gerenciaportfolio.requisitosNivelServico.continuidadeDoNegocio"),
		PERFORMANCE_DESEMPENHO("PERFDES","gerenciaportfolio.requisitosNivelServico.performanceDesempenho"),
		INTERRUPCOES_PLANEJADAS("INTEPLA","gerenciaportfolio.requisitosNivelServico.interrupcoesPlanejadas"),
		GESTAO_DE_INCIDENTES("GESTINC","gerenciaportfolio.requisitosNivelServico.gestaoDeIncidentes"),
		GESTAO_DE_PROBLEMAS("GESTPRO","gerenciaportfolio.requisitosNivelServico.gestaoDeProblemas"),
		GESTAO_DE_MUDANCAS("GESTMUD","gerenciaportfolio.requisitosNivelServico.gestaoDeMudancas"),
		CONFORMIDADE_INTERNA("CONFEXT","gerenciaportfolio.requisitosNivelServico.conformidadeInterna"),
		CONFORMIDADE_EXTERNA("CONFINT","gerenciaportfolio.requisitosNivelServico.conformidadeExterna");

		private final String identificador;
		private final String chave;

		private TipoAnexoRequisitosNivelServico(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoAnexoRequisitosNivelServico fromTipo(final String tipo) {
			TipoAnexoRequisitosNivelServico retorno = null;

			for (final TipoAnexoRequisitosNivelServico tipoAnexo : TipoAnexoRequisitosNivelServico.values()) {
				if (tipoAnexo.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoAnexo;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Requisitos do Gerenciamento de Portflio - Processos de Iniciao de um Servio
	 * - Gerenciamento Estratgico
	 * - Gerenciamento de Relacionamento de Negcio
	 * - Melhoria Contnua de Servio (MCS)
	 * - Outros Processos de Gerenciamento de Servios
	 * </pre>
	 *
	 * @author douglas.japiassu
	 */
	public enum ProcessoDeIniciacao {

		GERENCIAMENTO_ESTRATEGICO("GE", "gerenciaportfolio.processoDeIniciacao.gerenciamentoEstrategico"),
		GERENCIAMENTO_RELACIONAMENTO_NEGOCIO("GRM", "gerenciaportfolio.processoDeIniciacao.gerenciamentoRelacionamentoNegocio"),
		MELHORIA_CONTINUA_SERVICO("MCS", "gerenciaportfolio.processoDeIniciacao.melhoriaContinuaServico"),
		OUTROS_PROCESSOS_GERENCIAMENTO_SERVICOS("OPGS", "gerenciaportfolio.processoDeIniciacao.outrosProcessosGerenciamentoServicos");

		private final String identificador;
		private final String chave;

		private ProcessoDeIniciacao(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static ProcessoDeIniciacao fromTipo(String tipo) {
			ProcessoDeIniciacao retorno = null;

			for (final ProcessoDeIniciacao processoDeIniciacao : ProcessoDeIniciacao.values()) {
				if (processoDeIniciacao.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = processoDeIniciacao;
					break;
				}
			}

			return retorno;
		}

		public static String getChavefromTipo(String tipo) {
			String retorno = "N/A";
			ProcessoDeIniciacao processo = fromTipo(tipo);

			if (!Util.isNullOrEmpty(processo)) {
				retorno = processo.getChave();
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Requisitos do Gerenciamento de Portflio - Tipos de Investimento
	 * - Transform the Business (TTB)
	 * - Grow the Business (GTB)
	 * - Run the Business (RTB)
	 * </pre>
	 *
	 * @author douglas.japiassu
	 */
	public enum TipoDeInvestimento {

		TRANSFORMAR_NEGOCIO("TTB", "gerenciaportfolio.tipoDeInvestimento.transformarNegocio"),
		AUMENTAR_NEGOCIO("GTB", "gerenciaportfolio.tipoDeInvestimento.aumentarNegocio"),
		MANTER_NEGOCIO("RTB", "gerenciaportfolio.tipoDeInvestimento.manterNegocio");

		private final String identificador;
		private final String chave;

		private TipoDeInvestimento(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoDeInvestimento fromTipo(String tipo) {
			TipoDeInvestimento retorno = null;

			for (final TipoDeInvestimento tipoDeInvestimento : TipoDeInvestimento.values()) {
				if (tipoDeInvestimento.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoDeInvestimento;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Detalha os tipos de fornecedores possiveis.
	 * - Provedor de Servio
	 * - Fornecedor Interno
	 * - Fornecedor Externo
	 * </pre>
	 *
	 * @author ibimon.morais
	 */
	public enum TipoFornecedor {
		PROVEDOR_SERVICO("P","fornecedor.tipoFonecedor.provedorServico"),
		INTERNO("I","fornecedor.tipoFonecedor.interno"),
		EXTERNO("E","fornecedor.tipoFonecedor.externo");

		private final String identificador;
		private final String chave;

		private TipoFornecedor(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoFornecedor fromTipo(final String tipo) {
			TipoFornecedor retorno = null;

			for (final TipoFornecedor caso : TipoFornecedor.values()) {
				if (caso.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = caso;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipo de situao do contrato:
	 * - Ativo
	 * - Inativo
	 * </pre>
	 *
	 * @author ibimon.morais
	 */
	public enum SituacaoAtivoInativo {
		ATIVO("A", "citcorpore.comum.ativo"),
		INATIVO("I", "citcorpore.comum.inativo");

		// Chaves
		private final String identificador;
		private final String chave;

		/**
		 * @param identificador
		 * @param chave
		 */
		private SituacaoAtivoInativo(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		/**
		 * br.com.centralit.citcorpore.util.Enumerados.java_(fromTipo)
		 *
		 * @see 30/10/2015
		 * @author ibimon.morais
		 */
		public static SituacaoAtivoInativo fromTipo(final String situacao) {
			SituacaoAtivoInativo retorno = null;

			for (final SituacaoAtivoInativo itemSituacao :  SituacaoAtivoInativo.values()) {
				if (itemSituacao.getIdentificador().equalsIgnoreCase(situacao)) {
					retorno = itemSituacao;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipo de catlogo de servio:
	 * - Negcio
	 * - Tcnico
	 * </pre>
	 *
	 * @author douglas.japiassu
	 */
	public enum TipoCatalogoServico {
		SERVICO_NEGOCIO("N", "solicitacaoServico.filtros.catalogoServicoNegocio"),
		SERVICO_TECNICO("A", "solicitacaoServico.filtros.catalogoServicoTecnico");

		private final String identificador;
		private final String chave;

		private TipoCatalogoServico(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoCatalogoServico fromTipo(final String tipo) {
			TipoCatalogoServico retorno = null;

			for (final TipoCatalogoServico tipoCatalogoServico :  TipoCatalogoServico.values()) {
				if (tipoCatalogoServico.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoCatalogoServico;
					break;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Enum para combo de Tipo da tela de GerenciamentoAnsMultinivel
	 *
	 * @author thyen.chang
	 */
	public enum TipoAnsMultinivel {
		GLOBAL("global", "Global"),
		CLIENTE("cliente", "Cliente"),
		REQUISICAO("requisicao-incidente", "Requisio / Incidente");

		private final String chave;
		private final String valor;

		private TipoAnsMultinivel(final String chave, final String valor){
			this.chave = chave;
			this.valor = valor;
		}

		public String getChave(){
			return chave;
		}

		public String getValor(){
			return valor;
		}
	}

	/**
	 * <pre>
	 * Tipos de Cliente:
	 * - Interno
	 * - Externo
	 *</pre>
	 *
	 * @author douglas.japiassu
	 */
	public enum TipoCliente {
		INTERNO("I","cliente.tipoCliente.interno"),
		EXTERNO("E","cliente.tipoCliente.externo");

		private final String identificador;
		private final String chave;

		private TipoCliente(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoCliente fromTipo(final String tipo) {
			TipoCliente retorno = null;

			for (final TipoCliente tipoCliente : TipoCliente.values()) {
				if (tipoCliente.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoCliente;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipos de exibio de relatrios:
	 * - Geral
	 * - Especfico (ser gerado para cada item)
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 25.11.2015
	 */
	public enum TipoExibicaoRelatorio {
		NENHUM("N", "construtorConsultas.tipoExibicao.nenhum"),
		GERAL("G", "construtorConsultas.tipoExibicao.geral"),
		ESPECIFICO("E", "construtorConsultas.tipoExibicao.especifico");

		private final String identificador;
		private final String chave;

		private TipoExibicaoRelatorio(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoExibicaoRelatorio fromTipo(final String tipo) {
			TipoExibicaoRelatorio retorno = null;

			for (final TipoExibicaoRelatorio tipoExibicao : TipoExibicaoRelatorio.values()) {
				if (tipoExibicao.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = tipoExibicao;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Mdulos de exibio dos relatrios:
	 * - Gerenciamento de Configurao
	 * - Gerenciamento de Incidentes/Requisies
	 * - Gerenciamento de Liberao
	 * - Gerenciamendo de Mudanas
	 * - Gerenciamento de Problemas
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 25.11.2015
	 */
	public enum ModuloExibicaoRelatorio {
		GERENCIAMENTO_CONFIGURACAO("GC", "construtorConsultas.moduloExibicao.gerenciamentoDeConfiguracao"),
		GERENCIAMENTO_INCIDENTE_REQUISICAO("GIR", "construtorConsultas.moduloExibicao.gerenciamentoDeIncidentesRequisicoes"),
		GERENCIAMENTO_LIBERACAO("GL", "construtorConsultas.moduloExibicao.gerenciamentoDeLiberacao"),
		GERENCIAMENTO_MUDANCA("GM", "construtorConsultas.moduloExibicao.gerenciamentoDeMudancas"),
		GERENCIAMENTO_PROBLEMA("GP", "construtorConsultas.moduloExibicao.gerenciamentoDeProblemas");

		private final String identificador;
		private final String chave;

		private ModuloExibicaoRelatorio(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static ModuloExibicaoRelatorio fromTipo(final String tipo) {
			ModuloExibicaoRelatorio retorno = null;

			for (final ModuloExibicaoRelatorio moduloExibicao : ModuloExibicaoRelatorio.values()) {
				if (moduloExibicao.getIdentificador().equalsIgnoreCase(tipo)) {
					retorno = moduloExibicao;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Enumerado com as opes de Tipo Financeiro.
	 *
	 * @author joao.morais
	 * @since 11.01.2016
	 */
	public enum PerfilFinanceiro {

		PERFIL_FINANCEIRO_CUSTO("gerenciaportfolio.atributosFinanceiros.custo", "C"),
		PERFIL_FINANCEIRO_RECEITA("gerenciaportfolio.atributosFinanceiros.receita", "R");

		private final String nomePerfil;
		private final String valorPerfil;

		private PerfilFinanceiro(String nomePerfil, String valorPerfil) {
			this.nomePerfil = nomePerfil;
			this.valorPerfil = valorPerfil;
		}

		public static PerfilFinanceiro fromIdentificador(final String identificador) {
			PerfilFinanceiro retorno = null;

			for (final PerfilFinanceiro perfilFinanceiro : PerfilFinanceiro.values()) {
				if (perfilFinanceiro.getValorPerfil().equalsIgnoreCase(identificador)) {
					retorno = perfilFinanceiro;
					break;
				}
			}
			return retorno;
		}

		public String getNomePerfil() {
			return nomePerfil;
		}

		public String getValorPerfil() {
			return valorPerfil;
		}
	}

	/**
	 * <pre>
	 * Categorias de Ocorrncias Servio
	 * - Geral
	 * - Detalhes do Servio
	 * - Requisitos de Nvel de Servio
	 * - Atributos Financeiros
	 * - Casos de Negcio
	 * - Desenhos do Mapa de Servio
	 * - Processos de Negcio
	 * - Servios de Apoio
	 * - Donos do Negcio
	 * - Usurios do Negcio
	 * - Requisio de Servios
	 * - Aplicaes
	 * - Esquema de Dados
	 * - Incidentes
	 * - Contratos
	 * - Proprietrios TI
	 * - Base de Conhecimento
	 * - Habilidade
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	public enum OcorrenciaServicoCategorias {
		GERAL("G", "citcorpore.comum.geral"),
		DETALHES_SERVICO("DS", "gerenciaportfolio.detalhes"),
		REQUISITOS_NIVEL_SERVICO("RNS", "gerenciaportfolio.requisitosNivelServico"),
		ATRIBUTOS_FINANCEIROS("AF", "gerenciaportfolio.atributosFinanceiros"),
		CASOS_NEGOCIO("CN", "gerenciaportfolio.businessCase.titulo"),
		DESENHO_MAPA_SERVICO("DMS", "gerenciaportfolio.mapaDesenhoNegocio"),
		PROCESSO_NEGOCIO("PN", "gerenciaportfolio.processosNegocio"),
		SERVICOS_APOIO("SA", "gerenciaportfolio.servicosApoio"),
		DONO_NEGOCIO("DN", "gerenciaportfolio.donoNegocio"),
		USUARIO_NEGOCIO("UN", "gerenciaportfolio.businessUser"),
		REQUISICAO_SERVICOS("RS", "gerenciaportfolio.servicosRequisicao"),
		APLICACOES("A", "portfolio.aplicacao.aplicacoes"),
		ESQUEMA_DADOS("ED", "gerenciaportfolio.esquemaDados"),
		INCIDENTES("I", "gerenciaportfolio.incidentes"),
		CONTRATOS("C", "gerenciaportfolio.contratos"),
		PROPRIETARIOS_TI("PTI", "gerenciaportfolio.proprietarios"),
		BASE_CONHECIMENTO("BC", "gerenciaportfolio.conhecimento"),
		HABILIDADE("H", "gerenciaportfolio.habilidadeRecurso"),
		INDICADOR_CAPACIDADE("CAP", "menu.nome.gerenciacapacidade.indicadorescapacidade"),
		ATRIBUTO_DEMANDA("DEM", "menu.nome.gerenciademanda.atributodemanda"),
		PROCEDIMENTO("P", "gerenciaContinuidade.implementacao.planosContinuidade.procedimento");

		private final String identificador;
		private final String chave;

		private OcorrenciaServicoCategorias(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static OcorrenciaServicoCategorias fromIdentificador(final String identificador) {
			OcorrenciaServicoCategorias retorno = null;

			for (final OcorrenciaServicoCategorias ocorrenciaServicoCategorias : OcorrenciaServicoCategorias.values()) {
				if (ocorrenciaServicoCategorias.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = ocorrenciaServicoCategorias;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * Tipos de dono de negocio do servio no portfolio
	 *
	 * @author gilmar.junior
	 * @since 22.01.2016
	 */
	public enum DonoNegocioTipo {
		EMPREGADO(1, "gerenciaportfolio.donoNegocio.tipoEmpregado"),
		GRUPO(2, "gerenciaportfolio.donoNegocio.tipoGrupo");

		private final Integer identificador;
		private final String chave;

		private DonoNegocioTipo(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static DonoNegocioTipo fromIdentificador(final Integer identificador) {
			DonoNegocioTipo retorno = null;

			for (final DonoNegocioTipo donoNegocioTipo : DonoNegocioTipo.values()) {
				if (donoNegocioTipo.getIdentificador().equals(identificador)) {
					retorno = donoNegocioTipo;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum MatrizPrioridade {
		BB("B", "B", 5, "#017301"),
		BM("B", "M", 4, "#017301"),
		MB("M", "B", 4, "#017301"),
		BA("B", "A", 3, "#D0D016"),
		MM("M", "M", 3, "#D0D016"),
		AB("A", "B", 3, "#D0D016"),
		MA("M", "A", 2, "#D0D016"),
		AM("A", "M", 2, "#D0D016"),
		AA("A", "A", 1, "#AB0505");

		private String urgencia;
		private String impacto;
		private Integer prioridade;
		private String cor;

		private MatrizPrioridade(String urgencia, String impacto, Integer prioridade, String cor) {
			this.urgencia = urgencia;
			this.impacto = impacto;
			this.prioridade = prioridade;
			this.cor = cor;
		}

		public String getUrgencia() {
			return urgencia;
		}

		public String getImpacto() {
			return impacto;
		}

		public Integer getPrioridade() {
			return prioridade;
		}

		public String getCor() {
			return cor;
		}

		public static MatrizPrioridade getMatrizPrioridade(String urgencia, String impacto) {
			for (final MatrizPrioridade matrizPrioridade : MatrizPrioridade.values()) {
				if (matrizPrioridade.getUrgencia().equalsIgnoreCase(urgencia) && matrizPrioridade.getImpacto().equalsIgnoreCase(impacto)) {
					return matrizPrioridade;
				}
			}

			return null;
		}

		public static MatrizPrioridade getMatrizPrioridadeByPrioridade(Integer prioridade) {
			for (final MatrizPrioridade matrizPrioridade : MatrizPrioridade.values()) {
				if (matrizPrioridade.getPrioridade().equals(prioridade)) {
					return matrizPrioridade;
				}
			}

			return null;
		}
	}

	/**
	 * <pre>
	 * Tipos de Usurios do Negcio
	 * - Usurio
	 * - Grupo de Usurios
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public enum BusinessUserTipo {
		USUARIO(1, "citcorpore.comum.usuario"),
		GRUPO_USUARIO(2, "gerenciaportfolio.businessUserGrupoUsuario");

		private final Integer identificador;
		private final String chave;

		private BusinessUserTipo(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static BusinessUserTipo fromIdentificador(final Integer identificador) {
			BusinessUserTipo retorno = null;

			for (final BusinessUserTipo businessUserTipo : BusinessUserTipo.values()) {
				if (businessUserTipo.getIdentificador().equals(identificador)) {
					retorno = businessUserTipo;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum Permissao {
		GRAVAR("GRAVAR"),
		PESQUISAR("PESQUISAR"),
		EXCLUIR("EXCLUIR");

		private String identificador;

		private Permissao(String identificador) {
			this.identificador = identificador;
		}

		public String getIdentificador() {
			return identificador;
		}

		public void setIdentificador(String identificador) {
			this.identificador = identificador;
		}
	}

	/**
	 * Gerenciamento de Portflio - Demanda do Servio do Negcio
	 *
	 * @author gilmar.junior
	 * @since 28.01.2016
	 */
	public enum DemandaServicoNegocio {

		SERVICO_POPULAR(1, "gerenciaportfolio.demandaServico.servicoPopular"),
		SERVICO_VIAVEL(2, "gerenciaportfolio.demandaServico.servicoViavel"),
		SERVICO_A_SER_RETIRADO(3, "gerenciaportfolio.demandaServico.servicoASerRetirado");

		private final Integer identificador;
		private final String chave;

		private DemandaServicoNegocio(Integer identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static DemandaServicoNegocio fromIdentificador(final Integer identificador) {
			DemandaServicoNegocio retorno = null;

			for (final DemandaServicoNegocio demandaServicoNegocio : DemandaServicoNegocio.values()) {
				if (demandaServicoNegocio.getIdentificador().equals(identificador)) {
					retorno = demandaServicoNegocio;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum RetornoFinanceiroServico {

		ALTO(1, "gerenciaportfolio.retornoFinanceiroServico.alto"),
		MEDIO(2, "gerenciaportfolio.retornoFinanceiroServico.medio"),
		BAIXO(3, "gerenciaportfolio.retornoFinanceiroServico.baixo");

		private final Integer identificador;
		private final String chave;

		private RetornoFinanceiroServico(Integer identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static RetornoFinanceiroServico fromIdentificador(final Integer identificador) {
			RetornoFinanceiroServico retorno = null;

			for (final RetornoFinanceiroServico retornoFinanceiroServico : RetornoFinanceiroServico.values()) {
				if (retornoFinanceiroServico.getIdentificador().equals(identificador)) {
					retorno = retornoFinanceiroServico;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum ClassificacaoTipoFinanceiro {
		CAPEXOPEX(1, "gerenciaportfolio.tipofinanceiro.classificacao.capexopex"),
		DIRETOINDIRETO(2, "gerenciaportfolio.tipofinanceiro.classificacao.diretoindireto"),
		FIXOVARIAVEL(3, "gerenciaportfolio.tipofinanceiro.classificacao.fixovariavel"),
		CUSTOUNITARIO(4, "gerenciaportfolio.tipofinanceiro.classificacao.custounitario");

		private Integer idClassificacaoTipoFinanceiro;
		private String nomeClassificacaoTipoFinanceiro;

		private ClassificacaoTipoFinanceiro(Integer idClassificacaoTipoFinanceiro, String nomeClassificacaoTipoFinanceiro){
			this.idClassificacaoTipoFinanceiro = idClassificacaoTipoFinanceiro;
			this.nomeClassificacaoTipoFinanceiro = nomeClassificacaoTipoFinanceiro;
		}

		public static ClassificacaoTipoFinanceiro fromId(final Integer id) {
			ClassificacaoTipoFinanceiro retorno = null;

			for (final ClassificacaoTipoFinanceiro classificacaoTipoFinanceiro : ClassificacaoTipoFinanceiro.values()) {
				if (classificacaoTipoFinanceiro.getIdClassificacaoTipoFinanceiro().equals(id)) {
					retorno = classificacaoTipoFinanceiro;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdClassificacaoTipoFinanceiro() {
			return idClassificacaoTipoFinanceiro;
		}

		public void setIdClassificacaoTipoFinanceiro(Integer idClassificacaoTipoFinanceiro) {
			this.idClassificacaoTipoFinanceiro = idClassificacaoTipoFinanceiro;
		}

		public String getNomeClassificacaoTipoFinanceiro() {
			return nomeClassificacaoTipoFinanceiro;
		}

		public void setNomeClassificacaoTipoFinanceiro(String nomeClassificacaoTipoFinanceiro) {
			this.nomeClassificacaoTipoFinanceiro = nomeClassificacaoTipoFinanceiro;
		}

	}

	/**
	 * <pre>
	 * Tipos de Proprietrios do Negcio
	 * - Empregado
	 * - Grupo
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 29.01.2016
	 */
	public enum ProprietariosTipo {
		EMPREGADO(1, "citcorpore.comum.usuario"),
		GRUPO(2, "citcorpore.comum.grupo");

		private final Integer identificador;
		private final String chave;

		private ProprietariosTipo(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static ProprietariosTipo fromIdentificador(final Integer identificador) {
			ProprietariosTipo retorno = null;

			for (final ProprietariosTipo proprietariosTipo : ProprietariosTipo.values()) {
				if (proprietariosTipo.getIdentificador().equals(identificador)) {
					retorno = proprietariosTipo;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipos de itens do desenho de mapa do servio
	 * - Servio de Apoio
	 * - Item de Configurao
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 03.02.2016
	 */
	public enum TipoItemMapaServico {
		SERVICO_APOIO("SA", "gerenciaportfolio.ocorrenciasServico.servicoApoio"),
		ITEM_CONFIGURACAO("IC", "gerenciaportfolio.ocorrenciasServico.itemConfiguracao");

		private final String identificador;
		private final String chave;

		private TipoItemMapaServico(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoItemMapaServico fromIdentificador(final String identificador) {
			TipoItemMapaServico retorno = null;

			for (final TipoItemMapaServico tipoItemMapaServico : TipoItemMapaServico.values()) {
				if (tipoItemMapaServico.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = tipoItemMapaServico;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum GrupoPesquisaAgendamentoAtividadePeriodica {
		TODOS(0),
		INCIDENTE(1),
		MUDANCA(2),
		LIBERACAO(3),
		PROBLEMA(4);

		private Integer idGrupoPesquisa;

		private GrupoPesquisaAgendamentoAtividadePeriodica(Integer idGrupoPesquisa){
			this.idGrupoPesquisa = idGrupoPesquisa;
		}

		public Integer getIdGrupoPesquisa() {
			return idGrupoPesquisa;
		}

		public void setIdGrupoPesquisa(Integer idGrupoPesquisa) {
			this.idGrupoPesquisa = idGrupoPesquisa;
		}

	}

	/**
	 * <pre>
	 * Categorias da Trilha de Auditoria dos Eventos
	 * -> Geral
	 * -> Citstamart Event Monitor - Gerente Nagios
	 * -> Citstamart Event Monitor - Gerente Zabbix
	 * -> Citstamart Event Monitor - Gerente Inventory
	 * -> Citstamart Event Monitor - Gerente Eventos Correlacionados
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 10.02.2016
	 */
	public enum AuditoriaEventoCategorias {
		GERAL("G", "citcorpore.comum.geral"),
		CITSMART_EVENTO_MONITOR_GERENTE_NAGIOS("CEMGN", "evm.auditoriaEventos.categorias.citsmartEventMonitorGerenteNagios"),
		CITSMART_EVENTO_MONITOR_GERENTE_ZABBIX("CEMGZ", "evm.auditoriaEventos.categorias.citsmartEventMonitorGerenteZabbix"),
		CITSMART_EVENTO_MONITOR_GERENTE_INVENTORY("CEMGI", "evm.auditoriaEventos.categorias.citsmartEventMonitorGerenteInventory"),
		CITSMART_EVENTO_MONITOR_GERENTE_GENERICO_NAGIOS("CEMGGN", "evm.auditoriaEventos.categorias.citsmartEventMonitorGerenteGenericoNagios"),
		CITSMART_EVENTO_MONITOR_GERENTE_EVENTOS_CORRELACIONADOS("CEMGEV", "evm.auditoriaEventos.categorias.citsmartEventMonitorGerenteEventosCorrelacionados");

		private final String identificador;
		private final String chave;

		private AuditoriaEventoCategorias(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static AuditoriaEventoCategorias fromIdentificador(final String identificador) {
			AuditoriaEventoCategorias retorno = null;

			for (final AuditoriaEventoCategorias auditoriaEventoCategorias : AuditoriaEventoCategorias.values()) {
				if (auditoriaEventoCategorias.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = auditoriaEventoCategorias;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipos da Trilha de Auditoria dos Eventos:
	 * - Manual
	 * - Automtico
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 10.02.2016
	 */
	public enum AuditoriaEventoTipos {
		MANUAL("M", "gerenciaportfolio.ocorrenciasServico.manual"),
		AUTOMATICO("A", "gerenciaportfolio.ocorrenciasServico.automatico");

		private final String identificador;
		private final String chave;

		private AuditoriaEventoTipos(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static AuditoriaEventoTipos fromIdentificador(final String identificador) {
			AuditoriaEventoTipos retorno = null;

			for (final AuditoriaEventoTipos auditoriaEventoTipos : AuditoriaEventoTipos.values()) {
				if (auditoriaEventoTipos.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = auditoriaEventoTipos;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Evento Monitor - Tipos de Gerentes:
	 * - Nagios
	 * - Zabbix
	 * - Inventory
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 11.02.2016
	 */
	public enum EventMonitorGerenteTipos {
		NAGIOS("N", "evm.auditoriaEventos.nagios"),
		ZABBIX("Z", "evm.auditoriaEventos.zabbix"),
		INVENTORY("I", "evm.auditoriaEventos.inventory"),
		GENERICO_NAGIOS("G", "evm.auditoriaEventos.genericoNagios");

		private final String identificador;
		private final String chave;

		private EventMonitorGerenteTipos(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static EventMonitorGerenteTipos fromIdentificador(final String identificador) {
			EventMonitorGerenteTipos retorno = null;

			for (final EventMonitorGerenteTipos eventMonitorGerenteTipos : EventMonitorGerenteTipos.values()) {
				if (eventMonitorGerenteTipos.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = eventMonitorGerenteTipos;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Aes da Auditoria de Eventos
	 * - Criado
	 * - Alterado
	 * - Excludo
	 * - Adicionado
	 * - Removido
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 11.02.2016
	 */
	public enum AuditoriaEventosAcoes {
		CRIADO("C", "evm.auditoriaEventos.acoes.criado"),
		ALTERADO("A", "evm.auditoriaEventos.acoes.alterado"),
		EXCLUIDO("E", "evm.auditoriaEventos.acoes.excluido"),
		ADICIONADO("I", "evm.auditoriaEventos.acoes.adicionado"),
		REMOVIDO("R", "evm.auditoriaEventos.acoes.removido"),
		DESATIVADO("D", "evm.auditoriaEventos.acoes.desativado"),
		ATIVADO("T", "evm.auditoriaEventos.acoes.ativado");

		private final String identificador;
		private final String chave;

		private AuditoriaEventosAcoes(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static AuditoriaEventosAcoes fromIdentificador(final String identificador) {
			AuditoriaEventosAcoes retorno = null;

			for (final AuditoriaEventosAcoes auditoriaEventosAcoes : AuditoriaEventosAcoes.values()) {
				if (auditoriaEventosAcoes.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = auditoriaEventosAcoes;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Aes da Auditoria de Eventos
	 * - Crtica
	 * - Alta
	 * - Mdia
	 * - Baixa
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 12.02.2016
	 */
	public enum Niveis {

		CRITICA("C", "citcorpore.comum.critica"),
		ALTA("A", "citcorpore.comum.alta"),
		MEDIA("M", "citcorpore.comum.media"),
		BAIXA("B", "citcorpore.comum.baixa");

		private final String identificador;
		private final String chave;

		private Niveis(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static Niveis fromIdentificador(final String identificador) {
			Niveis retorno = null;

			for (final Niveis niveis : Niveis.values()) {
				if (niveis.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = niveis;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * ENUM Situacao Servico.
	 *
	 *	@author gilberto.nery
	 */
    public enum SituacaoServico {

		ATIVO("A", "Ativo", "citcorpore.comum.ativo"),
		INATIVO("I", "Inativo", "citcorpore.comum.inativo"),
		EMCRIACAO("C", "Em criao", "perfil.criacao"),
		EMDESENHO("D", "Em desenho", "baseconhecimento.emdesenho"),
		SLAACOMBINAR("S", "SLA  COMBINAR", "citcorpore.comum.SLAaCombinar"),
		EMANALISE("N", "Em Anlise", "avaliacaoContrato.emAnalise");

        private final String sigla;
        private final String descricao;
		private final String chave;

		private SituacaoServico(final String sigla, final String descricao, final String chave) {
            this.sigla = sigla;
            this.descricao = descricao;
			this.chave = chave;
        }

        public String getSigla() {
            return sigla;
        }

        public String getDescricao() {
            return descricao;
        }

		public String getChave() {
			return chave;
		}

		public static String getChaveFromDescricao(String descricao) {
			for (SituacaoServico situacaoServico : SituacaoServico.values()) {
				if (situacaoServico.descricao.equalsIgnoreCase(descricao)) {
					return situacaoServico.getChave();
				}
			}
			return "";
		}
    }

    public enum FuncaoVitalPrioridadeEnum {

		BAIXA(2, "baseconhecimento.grauimportancia.baixo"),
        MEDIA(1, "baseconhecimento.grauimportancia.medio"),
		ALTA(0, "baseconhecimento.grauimportancia.alto");

		private final Integer value;
        private final String text;

		private FuncaoVitalPrioridadeEnum(final Integer value, final String text) {
            this.value = value;
            this.text = text;
        }

		public static FuncaoVitalPrioridadeEnum fromValue(final Integer value) {
			FuncaoVitalPrioridadeEnum retorno = null;

			for (final FuncaoVitalPrioridadeEnum funcaoVitalPrioridadeEnum : FuncaoVitalPrioridadeEnum.values()) {
				if (funcaoVitalPrioridadeEnum.getValue().equals(value)) {
					retorno = funcaoVitalPrioridadeEnum;
					break;
				}
			}
			return retorno;
		}

		public Integer getValue() {
            return value;
        }

        public String getText() {
            return text;
        }

    }

	public enum TipoAmeaca {

		GENERICA("G", "citcorpore.comum.generica"),
		ESPECIFICA("E", "citcorpore.comum.especifica");

		private final String identificador;
		private final String chave;

		private TipoAmeaca(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoAmeaca fromIdentificador(final String identificador) {
			TipoAmeaca retorno = null;

			for (final TipoAmeaca niveis : TipoAmeaca.values()) {
				if (niveis.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = niveis;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum ClasseNegocio {
		BASECONHECIMENTO("BASECONHECIMENTO", "baseConhecimento.baseConhecimento"),
		SERVICO("SERVICO", "citcorpore.comum.servico");

		private final String identificador;
		private final String descricao;

		private ClasseNegocio(String identificador, String descricao) {
			this.identificador = identificador;
			this.descricao = descricao;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getDescricao() {
			return descricao;
		}
	}

	/**
	 * Status possveis do Evento de Notificao
	 *
	 * @author euler.ramos
	 */
	public enum StatusEventoNotificacao{
		INICIADO("Iniciado","citcorpore.comum.iniciado"),
		CONFIRMADO("Confirmado","citcorpore.comum.confirmado"),
		FALHOU("Falhou","citcorpore.comum.falhou");

		private final String identificador;
		private final String descricao;

		private StatusEventoNotificacao(String identificador, String descricao){
			this.identificador = identificador;
			this.descricao = descricao;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getDescricao() {
			return descricao;
		}

	}

	/**
	 * Tipos de Ocorrncias de Notificao
	 *
	 * @author euler.ramos
	 */
	public enum TipoOcorrenciaNotificacao{
		INICIAL("Inicial","tipoOcorrenciaNotificacao.notificacaoInicial"),
		ALERTA("Alerta","tipoOcorrenciaNotificacao.notificacaoAlerta"),
		ESCALONAMENTO("Escalonamento","tipoOcorrenciaNotificacao.notificacaoEscalonamento"),
		FALHA("Falha","citcorpore.comum.falha");

		private final String identificador;
		private final String descricao;

		private TipoOcorrenciaNotificacao(String identificador, String descricao){
			this.identificador = identificador;
			this.descricao = descricao;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getDescricao() {
			return descricao;
		}

	}

	public enum ObjetosNegocio {

		OCORRENCIA_DE_EVENTO("OcorrenciaDeEvento", "br.com.centralit.citsmart.rest.schema.OcorrenciaDeEvento"),
		SOLICITACAO_SERVICO("SolicitacaoServico", "br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO"),
		REQUISICAO_MUDANCA("RequisicaoMudanca", "br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO"),
		REQUISICAO_LIBERACAO("RequisicaoLiberacao", "br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO"),
		PROBLEMA("Problema", "br.com.centralit.citcorpore.bean.ProblemaDTO"),
		PLANO_CONTINUIDADE("PlanoContinuidade", "br.com.centralit.citcorpore.bean.PlanoContinuidadeDTO"),
		ITEM_CONFIGURACAO("ItemConfiguracao", "br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO"),
		INICIACAO_POLITICA("IniciacaoPolitica", "br.com.centralit.citcorpore.bean.IniciacaoPoliticaDTO"),
		INICIACAO_ESCOPO("IniciacaoEscopo", "br.com.centralit.citcorpore.bean.IniciacaoEscopoDTO"),
		FUNCAO_VITAL("FuncaoVital", "br.com.centralit.citcorpore.bean.FuncaoVitalDTO"),
		ANALISE_IMPACTO_NEGOCIO("AnaliseImpactoNegocio", "br.com.centralit.citcorpore.bean.AnaliseImpactoNegocioDTO"),
		ACORDO_NIVEL_SERVICO("AcordoNivelServico", "br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO"),
		INICIACAO_PROJETO("IniciacaoProjeto", "br.com.centralit.citcorpore.bean.IniciacaoProjetoDTO"),
		GERENCIAMENTO_CONTINUIDADE("GerenciamentoContinuidade", "br.com.centralit.citcorpore.bean.GerenciamentoContinuidadeDTO"),
		BASE_CONHECIMENTO("BaseConhecimento", "br.com.centralit.citcorpore.bean.BaseConhecimentoDTO"),
		SERVICO("Servico", "br.com.centralit.citcorpore.bean.ServicoDTO");

		private final String nomeObjeto;
		private final String caminhoObjeto;

		private ObjetosNegocio(String nomeObjeto, String caminhoObjeto) {
			this.nomeObjeto = nomeObjeto;
			this.caminhoObjeto = caminhoObjeto;
		}

		public String getNomeObjeto() {
			return nomeObjeto;
		}

		public String getCaminhoObjeto() {
			return caminhoObjeto;
		}

	}

	public enum TipoConhecimento {

		DOCUMENTO("D", "baseconhecimento.documento"),
		FAQ("F", "baseconhecimento.faq"),
		ERROS_CONHECIDOS("E", "baseConhecimento.erroConhecido"),
		EVIDENCIAS_DE_TESTE("T", "baseConhecimento.evidenciaTeste"),
		MEDIDA_RECUPERACAO("MR", "baseConhecimento.medidaRecuperacao"),
		PLANO_RESPOSTA_EMERGENCIA("PRE", "baseConhecimento.planoRespostaEmergencia"),
		PLANO_AVALIACAO_DANOS("PAD", "baseConhecimento.planoAvaliacaoDanos"),
		PLANO_RESGATE("PR", "baseConhecimento.planoResgaste"),
		PLANO_REGISTROS_VITAIS("PRV", "baseConhecimento.planoRegistrosVitais"),
		PLANO_GESTAO_CRISE_RELACOES_PUBLICAS("PCP", "baseConhecimento.planoGestaoCriseRelacoesPublicas"),
		PLANO_ACOMODACAO_SERVICOS("PAS", "baseConhecimento.planoAcomodacaoServicos"),
		PLANO_SEGURANCA("PS", "baseConhecimento.planoSeguranca"),
		PLANO_PESSOAL("PP", "baseConhecimento.planoPessoal"),
		PLANO_COMUNICACAO("PC", "baseConhecimento.planoComunicacao"),
		PLANO_ADMINISTRACAO_FINANCAS("PAF", "baseConhecimento.planoAdministracaoFinancas"),
		PLANO_QUALIDADE_SERVICOS("PQS", "baseConhecimento.planoQualidadeServicos"),
		PLANO_DISPONIBILIDADE("PD", "sla.baseConhecimento.planoDisponibilidade");

		private final String identificador;
		private final String chave;

		private TipoConhecimento(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Situaes da Linha Base do Projeto
	 * - Ativo
	 * - Em Execuo
	 * - Inativo
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 29.02.2016
	 */
	public enum SituacaoLinhaBaseProjeto {

		ATIVO("A", "citcorpore.comum.ativo"),
		EM_EXECUCAO("E", "citcorpore.comum.emExecucao"),
		INATIVO("I", "citcorpore.comum.inativo");

		private final String identificador;
		private final String chave;

		private SituacaoLinhaBaseProjeto(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static SituacaoLinhaBaseProjeto fromIdentificador(final String identificador) {
			SituacaoLinhaBaseProjeto retorno = null;

			for (final SituacaoLinhaBaseProjeto situacaoLinhaBaseProjeto : SituacaoLinhaBaseProjeto.values()) {
				if (situacaoLinhaBaseProjeto.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = situacaoLinhaBaseProjeto;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipos de Grupos do Planejamento Organizacional - Implementacao
	 * - Comissao Executiva
	 * - Coordenao
	 * - Equipes Recuperao
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 02.03.2016
	 */
	public enum PlanejamentoOrganizacionalTipoGrupo {

		COMISSAO_EXECUTIVA("CE", "implementacao.planejamentoOrganizacional.comissaoExecutiva"),
		COORDENACAO("C", "implementacao.planejamentoOrganizacional.coordenacao"),
		EQUIPES_RECUPERACAO("ER", "implementacao.planejamentoOrganizacional.equipesRecuperacao");

		private final String identificador;
		private final String chave;

		private PlanejamentoOrganizacionalTipoGrupo(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static PlanejamentoOrganizacionalTipoGrupo fromIdentificador(final String identificador) {
			PlanejamentoOrganizacionalTipoGrupo retorno = null;

			for (final PlanejamentoOrganizacionalTipoGrupo planejamentoOrganizacionalTipoGrupo : PlanejamentoOrganizacionalTipoGrupo.values()) {
				if (planejamentoOrganizacionalTipoGrupo.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = planejamentoOrganizacionalTipoGrupo;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum ImplementacaoPlanosContinuidade {

		CONTINUIDADE(0, "gerenciaContinuidade.implementacao.planosContinuidade.planosContinuidade"),
		AVALIACAO_DANOS(1, "gerenciaContinuidade.implementacao.planosContinuidade.planoAvaliacaoDanos"),
		RESGATE(2, "gerenciaContinuidade.implementacao.planosContinuidade.planoResgate"),
		REGISTROS_VITAIS(3, "gerenciaContinuidade.implementacao.planosContinuidade.planoRegistrosVitais"),
		GESTAO_DE_CRISES_E_RELACOES_PUBLICAS(4, "gerenciaContinuidade.implementacao.planosContinuidade.planoGestaoCrisesRelacoesPublicas"),
		ACOMODACOES_SERVICOS(5, "gerenciaContinuidade.implementacao.planosContinuidade.planoAcomodacaoServicos"),
		SEGURANCA(6, "gerenciaContinuidade.implementacao.planosContinuidade.planoSeguranca"),
		PESSOAL(7, "gerenciaContinuidade.implementacao.planosContinuidade.planoPessoal"),
		COMUNICACAO(8, "gerenciaContinuidade.implementacao.planosContinuidade.planoComunicacao"),
		ADMINISTRACAO_FINANCAS(9, "gerenciaContinuidade.implementacao.planosContinuidade.planoAdministracaoFinancas");

		private final Integer id;
		private final String chave;

		private ImplementacaoPlanosContinuidade(Integer id, String chave) {
			this.id = id;
			this.chave = chave;
		}

		public String getChave() {
			return chave;
		}

		public Integer getId() {
			return id;
		}
	}

	/**
	 * <pre>
	 * Tipos de Atividade de Conscientizao da Operao Contnua da Continuidade
	 * - Workshop
	 * - Treinamento Presencial
	 * - Treinamento EAD
	 * - Evento
	 * - Divulgacao Documentos
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 04.03.2016
	 */
	public enum ConscientizacaoTipoAtividade {
		WORKSHOP("W", "operacaoContinua.conscientizacao.tipoAtividade.workshop"),
		TREINAMENTO_PRESENCIAL("TP", "operacaoContinua.conscientizacao.tipoAtividade.treinamentoPresencial"),
		TREINAMENTO_EAD("TE", "operacaoContinua.conscientizacao.tipoAtividade.treinamentoEAD"),
		EVENTO("E", "operacaoContinua.conscientizacao.tipoAtividade.evento"),
		DIVULGACAO_DOCUMENTOS("DD", "operacaoContinua.conscientizacao.tipoAtividade.divulgacaoDocumentos");

		private final String identificador;
		private final String chave;

		private ConscientizacaoTipoAtividade(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static ConscientizacaoTipoAtividade fromIdentificador(final String identificador) {
			ConscientizacaoTipoAtividade retorno = null;

			for (final ConscientizacaoTipoAtividade conscientizacaoTipoAtividade : ConscientizacaoTipoAtividade.values()) {
				if (conscientizacaoTipoAtividade.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = conscientizacaoTipoAtividade;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Status dos Registros de Conscientizao da Operao Contnua da Continuidade
	 * - Criado
	 * - Autorizado
	 * - Agendado
	 * - Em_andamento
	 * - Realizado
	 * - Adiado
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 04.03.2016
	 */
	public enum ConscientizacaoStatus {
		CRIADO("W", "operacaoContinua.conscientizacao.status.criado"),
		AUTORIZADO("TP", "operacaoContinua.conscientizacao.status.autorizado"),
		AGENDADO("TE", "operacaoContinua.conscientizacao.status.agendado"),
		EM_ANDAMENTO("E", "operacaoContinua.conscientizacao.status.emAndamento"),
		REALIZADO("DD", "operacaoContinua.conscientizacao.status.realizado"),
		ADIADO("DD", "operacaoContinua.conscientizacao.status.adiado");

		private final String identificador;
		private final String chave;

		private ConscientizacaoStatus(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static ConscientizacaoStatus fromIdentificador(final String identificador) {
			ConscientizacaoStatus retorno = null;

			for (final ConscientizacaoStatus conscientizacaoStatus : ConscientizacaoStatus.values()) {
				if (conscientizacaoStatus.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = conscientizacaoStatus;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Tipos de alteracao em itens de configurao
	 * - Desativado
	 * - Criacao
	 * - Alteracao
	 * </pre>
	 *
	 * @author gustavo.gomes
	 * @since 23.03.2016
	 */
	public enum TipoAlteracao {
		Desativado("Desativado", "itemConfiguracao.tipoAlteracao.Desativado"),
		Criacao("Criao", "itemConfiguracao.tipoAlteracao.Criacao"),
		Alteracao("Alterao", "itemConfiguracao.tipoAlteracao.Alteracao");

		private final String identificador;
		private final String chave;

		private TipoAlteracao(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoAlteracao fromIdentificador(final String identificador) {
			TipoAlteracao retorno = null;

			for (final TipoAlteracao tipoAlteracao : TipoAlteracao.values()) {
				if (tipoAlteracao.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = tipoAlteracao;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum PlanoContinuidadeStatus {

		INICIADO(0, "citcorpore.comum.iniciado"),
		CONSTRUCAO(1, "gerenciaportfolio.statusServico.construcao"),
		PRONTO(2, "portfolio.aplicacao.pronto"),
		EM_EXECUCAO(3, "citcorpore.comum.emExecucao");

		private final Integer key;
		private final String value;

		private PlanoContinuidadeStatus(Integer key, String value) {
			this.key = key;
			this.value = value;
		}

		public Integer getKey() {
			return key;
		}

		public String getValue() {
			return value;
		}
	}

	public enum DriverJdbc {
		MYSQL("MySQL", "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource"),
		POSTGRES("PostgreSQL", "org.postgresql.xa.PGXADataSource"),
		ORACLE("Oracle", "oracle.jdbc.driver.OracleDriver"),
		SQLSERVER("Micrsoft SQL Server", "com.microsoft.sqlserver.jdbc.SQLServerDriver");

		private String databaseName;
		private String driverName;

		private DriverJdbc(String databaseName,String driverName){
			this.databaseName = databaseName;
			this.driverName = driverName;
		}

		public String getDatabaseName() {
			return databaseName;
		}

		public void setDatabaseName(String databaseName) {
			this.databaseName = databaseName;
		}

		public String getDriverName() {
			return driverName;
		}

		public void setDriverName(String driverName) {
			this.driverName = driverName;
		}

	}

	/**
	 * <pre>
	 * Tipos da Trilha de Auditoria:
	 * - Manual
	 * - Automtico
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 10.03.2016
	 */
	public enum AuditoriaTipos {
		MANUAL("M", "auditoria.tipos.manual"),
		AUTOMATICO("A", "auditoria.tipos.automatico");

		private final String identificador;
		private final String chave;

		private AuditoriaTipos(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static AuditoriaTipos fromIdentificador(final String identificador) {
			AuditoriaTipos retorno = null;

			for (final AuditoriaTipos auditoriaTipos : AuditoriaTipos.values()) {
				if (auditoriaTipos.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = auditoriaTipos;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Aes da Trilha de Auditoria:
	 * - Criado
	 * - Alterado
	 * - Excludo
	 * - Adicionado
	 * - Removido
	 * - Vinculado
	 * - Desvinculado
	 * - Desativado
	 * - Ativado
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 10.03.2016
	 */
	public enum AuditoriaAcoes {
		CRIADO("C", "auditoria.acoes.criado"),
		ALTERADO("A", "auditoria.acoes.alterado"),
		EXCLUIDO("E", "auditoria.acoes.excluido"),
		ADICIONADO("I", "auditoria.acoes.adicionado"),
		REMOVIDO("R", "auditoria.acoes.removido"),
		VINCULADO("V", "auditoria.acoes.vinculado"),
		DESVINCULADO("U", "auditoria.acoes.desvinculado"),
		DESATIVADO("D", "auditoria.acoes.desativado"),
		ATIVADO("T", "auditoria.acoes.ativado"),
		IMPORTADO("M", "auditoria.acoes.importado");

		private final String identificador;
		private final String chave;

		private AuditoriaAcoes(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static AuditoriaAcoes fromIdentificador(final String identificador) {
			AuditoriaAcoes retorno = null;

			for (final AuditoriaAcoes auditoriaAcoes : AuditoriaAcoes.values()) {
				if (auditoriaAcoes.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = auditoriaAcoes;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/**
	 * <pre>
	 * Categorias da Trilha de Auditoria de Continuidade:
	 * - Geral
	 * - Poltica
	 * - Escopo
	 * - Projeto
	 * - Funes Vitais
	 * - Anlise de Impacto do Negcio
	 * - Avaliao de Riscos
	 * - Estratgia de Continuidade de Servio de TI
	 * - Plano de Continuidade
	 * - Planejamento Organizacional
	 * - Estratgia de Testes
	 * - Conscientizao
	 * - Testes
	 * - Invocao
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 10.03.2016
	 */
	public enum AuditoriaContinuidadeCategorias {
		GERAL("G", "citcorpore.comum.geral"),
		POLITICA("POL", "gerenciaContinuidade.iniciacaoPolitica"),
		ESCOPO("ESC", "gerenciaContinuidade.iniciacaoEscopo"),
		PROJETO("PRO", "gerenciaContinuidade.iniciacaoProjeto"),
		FUNCOES_VITAIS("FV", "gerenciaContinuidade.requisitosEstrategia.funcoesVitais"),
		ANALISE_IMPACTO_NEGOCIO("AIN", "gerenciaContinuidade.requisitosEstrategia.analiseImpactoNegocio"),
		AVALIACAO_RISCO("AR", "gerenciaContinuidade.requisitosEstrategia.avaliacaoRiscos"),
		ESTRATEGIA_CONTINUIDADE("EC", "gerenciaContinuidade.requisitosEstrategia.estrategiaContinuidade"),
		PLANO_CONTINUIDADE("PC", "gerenciaContinuidade.implementacao.planosContinuidade"),
		PLANEJAMENTO_ORGANIZACIONAL("PO", "gerenciaContinuidade.implementacao.planejamentoOrganizacional"),
		ESTRATEGIA_TESTE("ET", "gerenciaContinuidade.implementacao.estrategiaContinuidade"),
		CONSCIENTIZACAO("CONS", "gerenciaContinuidade.operacaoContinua.conscientizacao"),
		TESTES("TES", "gerenciaContinuidade.operacaoContinua.testes"),
		INVOCACAO("INV", "gerenciaContinuidade.operacaoContinua.invocacao");

		private final String identificador;
		private final String chave;

		private AuditoriaContinuidadeCategorias(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static AuditoriaContinuidadeCategorias fromIdentificador(final String identificador) {
			AuditoriaContinuidadeCategorias retorno = null;

			for (final AuditoriaContinuidadeCategorias auditoriaContinuidadeCategorias : AuditoriaContinuidadeCategorias.values()) {
				if (auditoriaContinuidadeCategorias.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = auditoriaContinuidadeCategorias;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum TipoRecuperacaoMedida {

		MANUAL("MA", "gerenciaContinuidade.tipoRecuperacao.manual"),
		IMEDIATO("IM", "gerenciaContinuidade.tipoRecuperacao.imediato"),
		RAPIDO("RA", "gerenciaContinuidade.tipoRecuperacao.rapido"),
		INTERMEDIARIO("IN", "gerenciaContinuidade.tipoRecuperacao.intermediario"),
		GRADATIVO("GR", "gerenciaContinuidade.tipoRecuperacao.gradativo");

		private final String identificador;
		private final String chave;

		private TipoRecuperacaoMedida(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum TipoTemplateContinuidade {

		OPERACAO_CONTINUA_TESTE("OCT", "gerenciaContinuidade.tipoTemplate.operacaoContinuaTeste");

		private final String identificador;
		private final String chave;

		private TipoTemplateContinuidade(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum OcorrenciaProblema {
		NAO_SE_APLICA("no se aplica", "citcorpore.comum.naoaplica");

		private final String identificador;
		private final String chave;

		private OcorrenciaProblema(final String identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static OcorrenciaProblema fromIdentificador(final String identificador) {
			OcorrenciaProblema retorno = null;

			for (final OcorrenciaProblema ocorrenciaProblema : OcorrenciaProblema.values()) {
				if (ocorrenciaProblema.getIdentificador().equalsIgnoreCase(identificador)) {
					retorno = ocorrenciaProblema;
					break;
				}
			}
			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/***
	 * <pre>
	 * Criticidade do Servio:
	 * - Alta
	 * - Mdia
	 * - Baixa
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 19.03.2016
	 */
	public enum CriticidadeServico {
		ALTA(1, "citcorpore.comum.alta", "#AB0505"),
		MEDIA(2, "citcorpore.comum.media", "#D0D016"),
		BAIXA(3, "citcorpore.comum.baixa", "#017301");

		private final Integer identificador;
		private final String chave;
		private final String cor;

		private CriticidadeServico(final Integer identificador, final String chave, final String cor) {
			this.identificador = identificador;
			this.chave = chave;
			this.cor = cor;
		}

		public static CriticidadeServico fromItem(Integer item) {
			CriticidadeServico retorno = null;

			for (CriticidadeServico criticidade : CriticidadeServico.values()) {
				if (criticidade.getIdentificador().equals(item)) {
					return criticidade;
				}
			}

			return retorno;
		}

		public static String getChavefromItem(Integer item) {
			String retorno = "N/A";
			CriticidadeServico criticidade = fromItem(item);

			if (!Util.isNullOrEmpty(criticidade)) {
				retorno = criticidade.getChave();
			}

			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

		public String getCor() {
			return cor;
		}

	}

	/***
	 * <pre>
	 * Tipos de data na regra de escalonamento:
	 * - Data de criao
	 * - Data da ltima ocorrncia
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 27.03.2016
	 */
	public enum TipoDataEscalonamento {
		DATA_CRIACAO(1, "citcorpore.comum.dataCriacao"),
		DATA_ULTIMA_OCORRENCIA(2, "citcorpore.comum.dataUltimaOcorrencia");

		private final Integer identificador;
		private final String chave;

		private TipoDataEscalonamento(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoDataEscalonamento fromItem(Integer item) {
			TipoDataEscalonamento retorno = null;

			for (TipoDataEscalonamento tipoDataEscalonamento : TipoDataEscalonamento.values()) {
				if (tipoDataEscalonamento.getIdentificador().equals(item)) {
					return tipoDataEscalonamento;
				}
			}

			return retorno;
		}

		public static String getChavefromItem(Integer item) {
			String retorno = "N/A";
			TipoDataEscalonamento tipoDataEscalonamento = fromItem(item);

			if (!Util.isNullOrEmpty(tipoDataEscalonamento)) {
				retorno = tipoDataEscalonamento.getChave();
			}

			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

	}

	/***
	 * <pre>
	 * Tipos de gerenciamento de escalonamento:
	 * - Solicitao/Incidente
	 * - Problema
	 * - Mudana
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 28.03.2016
	 */
	public enum TipoGerenciamentoEscalonamento {
		SOLICITACAO_INCIDENTE(1, "citcorpore.comum.solicitacao"),
		PROBLEMA(2, "problema.problema"),
		DATA_ULTIMA_OCORRENCIA(3, "menu.relatorio.gerMudanca");

		private final Integer identificador;
		private final String chave;

		private TipoGerenciamentoEscalonamento(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoGerenciamentoEscalonamento fromItem(Integer item) {
			TipoGerenciamentoEscalonamento retorno = null;

			for (TipoGerenciamentoEscalonamento tipoGerenciamentoEscalonamento : TipoGerenciamentoEscalonamento.values()) {
				if (tipoGerenciamentoEscalonamento.getIdentificador().equals(item)) {
					return tipoGerenciamentoEscalonamento;
				}
			}

			return retorno;
		}

		public static String getChavefromItem(Integer item) {
			String retorno = "N/A";
			TipoGerenciamentoEscalonamento tipoGerenciamentoEscalonamento = fromItem(item);

			if (!Util.isNullOrEmpty(tipoGerenciamentoEscalonamento)) {
				retorno = tipoGerenciamentoEscalonamento.getChave();
			}

			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

	}

	/***
	 * <pre>
	 * Perfis de Acesso da Continuidade:
	 *
	 * - Iniciao
	 * - Iniciao Poltica
	 * - Iniciao Escopo
	 * - Iniciao Projeto
	 * - Requisitos e Estratgia
	 * - Requisitos e Estratgia Funes Vitais
	 * - Requisitos e Estratgia Anlise de Impacto no Negcio
	 * - Requisitos e Estratgia Avaliao de Riscos
	 * - Requisitos e Estratgia Estratgia de Continuidade
	 * - Implementao
	 * - Implementao Plano de Continuidade
	 * - Implementao Planejamento Organizacional
	 * - Implementao Estratgia de Testes
	 * - Operao Contnua
	 * - Operao Contnua Conscientizao
	 * - Operao Contnua Reviso e Auditoria
	 * - Operao Contnua Testes
	 * - Operao Contnua Invocao
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 29.03.2016
	 */
	public enum PagesContinuidade {
		INICIACAO("-", "gerenciaContinuidade.iniciacao", "/pages/gerenciamentoContinuidade/iniciacao/iniciacao.jsp"),
		INICIACAO_POLITICA("gerenciaContinuidade.iniciacaoPolitica", "gerenciaContinuidade.iniciacao", "/pages/gerenciamentoContinuidade/iniciacao/iniciacaoPolitica.jsp"),
		INICIACAO_ESCOPO("gerenciaContinuidade.iniciacaoEscopo", "gerenciaContinuidade.iniciacao", "/pages/gerenciamentoContinuidade/iniciacao/iniciacaoEscopo.jsp"),
		INICIACAO_PROJETO("gerenciaContinuidade.iniciacaoProjeto", "gerenciaContinuidade.iniciacao", "/pages/gerenciamentoContinuidade/iniciacao/iniciacaoProjeto.jsp"),
		REQUISITOS_ESTRATEGIA("-", "gerenciaContinuidade.requisitosEstrategia", "/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategia.jsp"),
		REQUISITOS_ESTRATEGIA_FUNCOES_VITAIS("gerenciaContinuidade.requisitosEstrategia.funcoesVitais", "gerenciaContinuidade.requisitosEstrategia", "/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaFuncoesVitais.jsp"),
		REQUISITOS_ESTRATEGIA_ANALISE_IMPACTO_NEGOCIO("gerenciaContinuidade.requisitosEstrategia.analiseImpactoNegocio", "gerenciaContinuidade.requisitosEstrategia", "/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaImpactoNegocio.jsp"),
		REQUISITOS_ESTRATEGIA_AVALIACAO_RISCOS("gerenciaContinuidade.requisitosEstrategia.avaliacaoRiscos", "gerenciaContinuidade.requisitosEstrategia", "/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaAvaliacaoRiscos.jsp"),
		REQUISITOS_ESTRATEGIA_ESTRATEGIA_CONTINUIDADE("gerenciaContinuidade.requisitosEstrategia.estrategiaContinuidade", "gerenciaContinuidade.requisitosEstrategia", "/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaEstrategiaContinuidade.jsp"),
		IMPLEMENTACAO("-", "gerenciaContinuidade.implementacao", "/pages/gerenciamentoContinuidade/implementacao/implementacao.jsp"),
		IMPLEMENTACAO_PLANO_CONTINUIDADE("gerenciaContinuidade.implementacao.planoContinuidade", "gerenciaContinuidade.implementacao", "/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanosContinuidade.jsp"),
		IMPLEMENTACAO_PLANEJAMENTO_ORGANIZACIONAL("gerenciaContinuidade.implementacao.planejamentoOrganizacional", "gerenciaContinuidade.implementacao", "/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanejamentoOrganizacional.jsp"),
		IMPLEMENTACAO_ESTRATEGIA_TESTES("gerenciaContinuidade.implementacao.estrategiaContinuidade", "gerenciaContinuidade.implementacao", "/pages/gerenciamentoContinuidade/implementacao/implementacaoEstrategiaTestes.jsp"),
		OPERACAO_CONTINUA("-", "gerenciaContinuidade.operacaoContinua", "/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinua.jsp"),
		OPERACAO_CONTINUA_CONSCIENTIZACAO("gerenciaContinuidade.operacaoContinua.conscientizacao", "gerenciaContinuidade.operacaoContinua", "/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaConscientizacao.jsp"),
		OPERACAO_CONTINUA_REVISAO_AUDITORIA("gerenciaContinuidade.operacaoContinua.revisaoAuditoria", "gerenciaContinuidade.operacaoContinua", "/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaRevisaoAuditoria.jsp"),
		OPERACAO_CONTINUA_TESTES("gerenciaContinuidade.operacaoContinua.testes", "gerenciaContinuidade.operacaoContinua", "/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaTestes.jsp"),
		OPERACAO_CONTINUA_INVOCACAO("gerenciaContinuidade.operacaoContinua.invocacao", "gerenciaContinuidade.operacaoContinua", "/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaInvocacao.jsp");

		private final String chave;
		private final String chaveFase;
		private final String caminho;

		private PagesContinuidade(final String chave, final String chaveFase, final String caminho) {
			this.chave = chave;
			this.chaveFase = chaveFase;
			this.caminho = caminho;
		}

		public static PagesContinuidade fromCaminho(final String caminho) {
			PagesContinuidade retorno = null;

			for (final PagesContinuidade pagesContinuidade : PagesContinuidade.values()) {
				if (pagesContinuidade.getCaminho().equals(caminho)) {
					retorno = pagesContinuidade;
					break;
				}
			}
			return retorno;
		}

		public String getChave() {
			return chave;
		}

		public String getChaveFase() {
			return chaveFase;
		}

		public String getCaminho() {
			return caminho;
		}
	}

	public enum Processos {
		GERENCIAMENTO_DE_PORTFOLIO(1, "menu.nome.gerenciamentoPortfolio"),
		CATALOGO_DE_SERVICOS(2, "menu.nome.catalogoServicos"),
		GESTAO_DE_MUDANCAS(3, "gerenciaportfolio.requisitosNivelServico.gestaoDeMudancas"),
		GERENCIAMENTO_DE_EVENTOS(4, "gerenciamentoDeEventos"),
		GESTAO_DE_INCIDENTES(5, "gerenciaportfolio.requisitosNivelServico.gestaoDeIncidentes"),
		BASE_DE_CONHECIMENTO(6, "baseConhecimento.baseConhecimento"),
		GESTAO_DE_PROBLEMAS(7, "gerenciaportfolio.requisitosNivelServico.gestaoDeProblemas"),
		GERENCIA_DE_NIVEIS_DE_SERVICO(8, "menu.nome.gerenciaNivelServico"),
		GERENCIA_DE_CONFIGURACOES(9, "menu.nome.gerenciaConfiguracao"),
		GERENCIA_DE_LIBERACOES(10, "menu.nome.gerenciaLiberacao"),
		GERENCIAMENTO_DE_CONTINUIDADE(11, "gerenciaContinuidade.gerenciamentoContinuidade"),
		CUMPRIMENTO_DE_REQUISICOES(12, "processos.cumprimentoRequisicoes"),
		REQUISICAO_VIAGEM(13, "processos.requisicaoViagem"),
		BI_CITSMART(14, "processos.biCitsmart");

		private final Integer key;
		private final String value;

		private Processos(final Integer key, final String value) {
			this.key = key;
			this.value = value;
		}

		public static Processos fromItem(Integer item) {
			for (Processos obj : Processos.values()) {
				if (obj.getKey().equals(item)) {
					return obj;
				}
			}
			return null;
		}

		public static String getValuefromItem(Integer item) {
			Processos obj = null;
			return !Util.isNullOrEmpty(item) && !Util.isNullOrEmpty(obj = fromItem(item)) ? obj.getValue() : "avaliacaoFonecedor.naoAvaliada";
		}

		public Integer getKey() {
			return key;
		}

		public String getValue() {
			return value;
		}

	}

	public enum FaseServicoFluxo {

		CAPTURA("Captura", "faseservico.captura"),
		EXECUCAO("Execuo", "faseservico.execucao");

		private final String identificador;
		private final String chave;

		private FaseServicoFluxo(String identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static FaseServicoFluxo fromIdentificador(String item) {
			FaseServicoFluxo retorno = null;

			for (FaseServicoFluxo faseservico : FaseServicoFluxo.values()) {
				if (faseservico.getIdentificador().equals(item)) {
					return faseservico;
				}
			}

			return retorno;
		}

		public String getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum CausaIncidente {

		SOFTWARE(1, "causaIncidente.software"),
		INSTALACAO_INEFICAZ(2, "causaIncidente.instalacaoineficaz"),
		CONFIGURACAO(3, "causaIncidente.configuracao"),
		FALTADETREINAMENTO(4, "causaIncidente.faltadetreinamento"),
		HARDWARE(5, "causaIncidente.hardware"),
		DEFEITO(6, "causaIncidente.defeito"),
		CONFIGURACAO2(7, "causaIncidente.configuracao"),
		USOINDEVIDO(8, "causaIncidente.usoindevido"),
		OUTROS(9, "causaIncidente.outros"),
		ERRONOAPLICATIVO(10, "causaIncidente.erronoaplicativo"),
		LENTIDAO(11, "causaIncidente.lentidao"),
		ERRONACONFIGURACAO(12, "causaIncidente.erronaconfiguracao"),
		ERRONACONFIGURACAO2(13, "causaIncidente.erronaconfiguracao"),
		MUDANCANAOPLANEJADA(14, "causaIncidente.mudancanaoplanejada");

		private final Integer identificador;
		private final String chave;

		private CausaIncidente(Integer identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static CausaIncidente fromIdentificador(Integer item) {
			CausaIncidente retorno = null;

			for (CausaIncidente causaIncidente : CausaIncidente.values()) {
				if (causaIncidente.getIdentificador().equals(item)) {
					return causaIncidente;
				}
			}

			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	public enum CategoriaSolucao {

		SOFTWARE(1, "categoriaSolucao.software"),
		AJUSTE_CONFIGURACAO_SOFTWARE(2, "categoriaSolucao.ajusteConfiguracaoSoftware"),
		NOVA_INSTALACAO(3, "categoriaSolucao.novaInsalacao"),
		REMOCAO_ARQUIVOS(4, "categoriaSolucao.remocaoArquivos"),
		AJUSTE_SISTEMA(5, "categoriaSolucao.ajusteSistema"),
		HARDWARE(6, "categoriaSolucao.hardware"),
		REPARO_HARDWARE(7, "categoriaSolucao.reparoHardware"),
		SUBSTITUICAO_HARDWARE(8, "categoriaSolucao.substituicaoHardware"),
		MANUTENCAO_PREVENTIVA(9, "categoriaSolucao.manutencaoPreventiva"),
		AJUSTE_CONFIGURACAO_APLICATIVO(10, "categoriaSolucao.ajusteConfiguracaoAplicativo"),
		AJUSTE_CONFIGURACAO_SISTEMA(11, "categoriaSolucao.ajusteConfiguracaoSistema"),
		ATUALIZACAO_SISTEMA_OPERACIONAL(12, "categoriaSolucao.atualizacaoSistemaOperacional"),
		APLICACAO_SERVICE_PACK(13, "categoriaSolucao.aplicacaoServicePack"),
		AJUSTE_CONFIGURACAO_BROWSER(14, "categoriaSolucao.ajusteConfiguracaoBrowser"),
		NOVAS_PARAMETRIZACOES(15, "categoriaSolucao.novasParametrizacoes"),
		RECONFIGURACAO(16, "categoriaSolucao.reconfiguracao"),
		LIBERACAO_FIREWALL(17, "categoriaSolucao.liberacaoFirewall"),
		ALTERACAO_FIREWALL(18, "categoriaSolucao.alteracaoFirewall"),
		EXCLUSAO_FIREWALL(19, "categoriaSolucao.exclusaoFirewall"),
		LIBERACAO_PROXY(20, "categoriaSolucao.liberacaoProxy"),
		CRIACAO_USUARIOS(21, "categoriaSolucao.criacaoUsuarios"),
		MUDANCA_PERFIL(22, "categoriaSolucao.mudancaPerfil"),
		BACKUP_RESTORE(23, "categoriaSolucao.backupRestore"),
		SOFTWARE2(24, "categoriaSolucao.software");

		private final Integer identificador;
		private final String chave;

		private CategoriaSolucao(Integer identificador, String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static CategoriaSolucao fromIdentificador(Integer item) {
			CategoriaSolucao retorno = null;

			for (CategoriaSolucao categoriaSolucao : CategoriaSolucao.values()) {
				if (categoriaSolucao.getIdentificador().equals(item)) {
					return categoriaSolucao;
				}
			}

			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/***
	 * <pre>
	 * Perfis de Acesso do Portflio:
	 *
	 * - Iniciao
	 * - Iniciao Poltica
	 * - Iniciao Escopo
	 * - Iniciao Projeto
	 * - Requisitos e Estratgia
	 * - Requisitos e Estratgia Funes Vitais
	 * - Requisitos e Estratgia Anlise de Impacto no Negcio
	 * - Requisitos e Estratgia Avaliao de Riscos
	 * - Requisitos e Estratgia Estratgia de Continuidade
	 * - Implementao
	 * - Implementao Plano de Continuidade
	 * - Implementao Planejamento Organizacional
	 * - Implementao Estratgia de Testes
	 * - Operao Contnua
	 * - Operao Contnua Conscientizao
	 * - Operao Contnua Reviso e Auditoria
	 * - Operao Contnua Testes
	 * - Operao Contnua Invocao
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 13.06.2016
	 */
	public enum PagesPortfolio {
		PORTFOLIO("-", "gerenciaportfolio.portfolio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp"),
		LISTA_SERVICO_NEGOCIO("-", "gerenciaportfolio.listaServicosNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoNegocio/gerenciamentoPortfolioServicoNegocio.jsp"),
		SERVICO_NEGOCIO("-", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoNegocio/gerenciamentoPortfolioInfoServicoNegocio.jsp"),
		SERVICO_NEGOCIO_DETALHES_SERVICO("gerenciaportfolio.detalhes", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp"),
		SERVICO_NEGOCIO_REQUISITOS_NIVEL_SERVICO("gerenciaportfolio.requisitosNivelServico", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioRNS/gerenciamentoPortfolioRNS.jsp"),
		SERVICO_NEGOCIO_ATRIBUTOS_FINANCEIROS("gerenciaportfolio.atributosFinanceiros", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributosFinanceiros/gerenciamentoPortfolioAtributosFinanceiros.jsp"),
		SERVICO_NEGOCIO_CASOS_NEGOCIO("gerenciaportfolio.businessCase.titulo", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCasoNegocio/gerenciamentoPortfolioCasoNegocio.jsp"),
		SERVICO_NEGOCIO_DESENHO_MAPA_SERVICO("gerenciaportfolio.mapaDesenhoNegocio", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoNegocio/gerenciamentoPortfolioMapaDesenhoNegocio.jsp"),
		SERVICO_NEGOCIO_PROCESSO_NEGOCIO("gerenciaportfolio.processosNegocio", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProcessoNegocio/gerenciamentoPortfolioProcessoNegocio.jsp"),
		SERVICO_NEGOCIO_SERVICO_APOIO("gerenciaportfolio.servicosApoio", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoio/gerenciamentoPortfolioServicoApoio.jsp"),
		SERVICO_NEGOCIO_DONO_NEGOCIO("gerenciaportfolio.donoNegocio", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioDonoNegocio/gerenciamentoPortfolioDonoNegocio.jsp"),
		SERVICO_NEGOCIO_USUARIO_NEGOCIO("gerenciaportfolio.businessUser", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioBusinessUser/gerenciamentoPortfolioBusinessUser.jsp"),
		SERVICO_NEGOCIO_REQUISICAO_SERVICO("gerenciaportfolio.servicosRequisicao", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoNegocio/gerenciamentoPortfolioServicoRequisicaoNegocio.jsp"),
		SERVICO_NEGOCIO_APLICACOES("portfolio.aplicacao.aplicacoes", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAplicacoes/gerenciamentoPortfolioAplicacoes.jsp"),
		SERVICO_NEGOCIO_ESQUEMA_DADOS("gerenciaportfolio.esquemaDados", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioEsquemaDados/gerenciamentoPortfolioEsquemaDados.jsp"),
		SERVICO_NEGOCIO_INICIDENTES("gerenciaportfolio.incidentes", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteNegocio/gerenciamentoPortfolioServicoIncidenteNegocio.jsp"),
		SERVICO_NEGOCIO_PROCEDIMENTOS("gerenciaportfolio.procedimentos", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoProcedimento/gerenciamentoPortfolioServicoProcedimento.jsp"),
		SERVICO_NEGOCIO_CONTRATO("gerenciaportfolio.contratos", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratos/gerenciamentoPortfolioContratos.jsp"),
		SERVICO_NEGOCIO_PROPRIETARIOS_TI("gerenciaportfolio.proprietarios", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProprietarios/gerenciamentoPortfolioProprietarios.jsp"),
		SERVICO_NEGOCIO_BASE_CONHECIMENTO("gerenciaportfolio.conhecimento", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioConhecimento/gerenciamentoPortfolioConhecimento.jsp"),
		SERVICO_NEGOCIO_HABILIDADE_RECURSO("gerenciaportfolio.habilidadeRecurso", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioHabilidade/gerenciamentoPortfolioHabilidade.jsp"),
		SERVICO_NEGOCIO_INDICADORES_CAPACIDADE_PERFORMANCE("menu.nome.gerenciacapacidade.indicadorescapacidade", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioIndicadorCapacidade/gerenciamentoPortfolioIndicadorCapacidade.jsp"),
		SERVICO_NEGOCIO_ATRIBUTO_DEMANDA("menu.nome.gerenciademanda.atributodemanda", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributoDemanda/gerenciamentoPortfolioAtributoDemanda.jsp"),
		SERVICO_NEGOCIO_AUDITORIA("gerenciaportfolio.auditoriaServico", "gerenciaportfolio.servicoNegocio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioOcorrenciasServico/gerenciamentoPortfolioOcorrenciasServico.jsp"),

		SERVICO_APOIO("-", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoApoio/gerenciamentoPortfolioInfoServicoApoio.jsp"),
		SERVICO_APOIO_DETALHES_SERVICO("gerenciaportfolio.detalhes", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp"),
		SERVICO_APOIO_ATIVOS_SERVICO("gerenciaportfolio.ativosServico", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp"),
		SERVICO_APOIO_SERVICOS_APOIO("gerenciaportfolio.servicosApoio", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoioApoio/gerenciamentoPortfolioServicoApoioApoio.jsp"),
		SERVICO_APOIO_REQUISICAO_SERVICOS("gerenciaportfolio.servicosRequisicao", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoApoio/gerenciamentoPortfolioServicoRequisicaoApoio.jsp"),
		SERVICO_APOIO_INCIDENTES("gerenciaportfolio.incidentes", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteApoio/gerenciamentoPortfolioServicoIncidenteApoio.jsp"),
		SERVICO_APOIO_CONTRATOS("gerenciaportfolio.contratos", "gerenciaportfolio.servicosApoio", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosApoio/gerenciamentoPortfolioContratosApoio.jsp"),

		CONTRATOS("-", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoContrato/gerenciamentoPortfolioInfoContrato.jsp"),
		CONTRATOS_DETALHES("gerenciaportfolio.detalhes", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosDetalhes/gerenciamentoPortfolioContratosDetalhes.jsp"),
		CONTRATOS_REQUISICAO_SERVICOS("gerenciaportfolio.servicosRequisicao", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoRequisicao/gerenciamentoPortfolioContratosServicoRequisicao.jsp"),
		CONTRATOS_INCIDENTES("gerenciaportfolio.incidentes", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoIncidente/gerenciamentoPortfolioContratosServicoIncidente.jsp"),
		CONTRATOS_PROCEDIMENTO("gerenciaportfolio.procedimentos", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoProcedimento/gerenciamentoPortfolioContratosServicoProcedimento.jsp"),
		CONTRATOS_CUSTO_DISPONIBILIDADE("gerenciaPortfolio.contrato.custoDisponibilidade", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCustoDisponibilidade/gerenciamentoPortfolioContratosCustoDisponibilidade.jsp"),
		CONTRATOS_SERVICO_CONTRATO_ANS("gerenciaPortfolio.contrato.acordoDisponibilidade", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoContratoANS/gerenciamentoPortfolioServicoContratoANS.jsp"),
		CONTRATOS_CALENDARIO("gerenciaPortfolio.contrato.calendario", "gerenciaportfolio.contratos", "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCalendario/gerenciamentoPortfolioContratosCalendario.jsp");

		private final String chave;
		private final String chaveFase;
		private final String caminho;

		private PagesPortfolio(final String chave, final String chaveFase, final String caminho) {
			this.chave = chave;
			this.chaveFase = chaveFase;
			this.caminho = caminho;
		}

		public static PagesPortfolio fromCaminho(final String caminho) {
			PagesPortfolio retorno = null;

			for (final PagesPortfolio pagesPortfolio : PagesPortfolio.values()) {
				if (pagesPortfolio.getCaminho().equals(caminho)) {
					retorno = pagesPortfolio;
					break;
				}
			}
			return retorno;
		}

		public String getChave() {
			return chave;
		}

		public String getChaveFase() {
			return chaveFase;
		}

		public String getCaminho() {
			return caminho;
		}
	}

	/***
	 * <pre>
	 * Tipos de Perfis de Acesso:
	 *
	 * - Continuidade
	 * - Portflio
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 13.06.2016
	 */
	public enum TipoPerfilAcesso {
		CONTINUIDADE(1, "gerenciaContinuidade.continuidade"),
		PORTFOLIO(2, "gerenciaportfolio.portfolio");

		private final Integer identificador;
		private final String chave;

		private TipoPerfilAcesso(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoPerfilAcesso fromIdentificador(final Integer identificador) {
			TipoPerfilAcesso retorno = null;

			for (final TipoPerfilAcesso tipoPerfilAcesso : TipoPerfilAcesso.values()) {
				if (tipoPerfilAcesso.getIdentificador().equals(identificador)) {
					retorno = tipoPerfilAcesso;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}

	}


	public enum EnumParameterType {
		INTEGER(1),
		STRING(2);

		private Integer id;

		private EnumParameterType(final Integer id) {
			this.id = id;
		}

		public Integer getId() {
			return id;
		}

	}

	public enum CommunicationMatrixRecordType {
		MEETING_MINUTES(1, "communicationMatrixRecordType.meetingMinutes"),
		REQUEST_RECORD(2, "communicationMatrixRecordType.requestRecord"),
		FORMS(3, "communicationMatrixRecordType.forms"),
		NON_CONFORMITIES_OR_CUSTOMER_COMPLAINTS(4, "communicationMatrixRecordType.nonConformitiesOrCustomerComplaints"),
		SYSTEM_FAILURES(5, "communicationMatrixRecordType.systemFailures");

		private Integer id;
		private String I18NKey;

		private CommunicationMatrixRecordType(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static String getChaveFromId(Integer id) {
			String retorno = "N/A";
			for (CommunicationMatrixRecordType recordType : CommunicationMatrixRecordType.values()) {
				if (recordType.getId().equals(id)) {
					retorno = recordType.getI18NKey();
				}
			}

			return retorno;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

	}

	public enum CommunicationMatrixContactType {
		EMAIL(1, "communicationMatrixContactType.email"),
		INTERNET(2, "communicationMatrixContactType.internet"),
		CITSMART_REQUEST(3, "communicationMatrixContactType.citsmartRequest"),
		PHONE(4, "communicationMatrixContactType.phone"),
		VIDEOCONFERENCE(5, "communicationMatrixContactType.videoconference");

		private Integer id;
		private String I18NKey;

		private CommunicationMatrixContactType(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static String getChaveFromId(Integer id) {
			String retorno = "N/A";
			for (CommunicationMatrixContactType recordType : CommunicationMatrixContactType.values()) {
				if (recordType.getId().equals(id)) {
					retorno = recordType.getI18NKey();
				}
			}

			return retorno;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

	}

	public enum CommunicationMatrixFrequencyType {
		PERIODICAL(1, "communicationMatrixFrequencyType.periodical"),
		DAILY(2, "communicationMatrixFrequencyType.daily"),
		WEEKLY(3, "communicationMatrixFrequencyType.weekly"),
		BIWEEKLY(4, "communicationMatrixFrequencyType.biweekly"),
		MONTHLY(5, "communicationMatrixFrequencyType.monthly"),
		QUATERLY(6, "communicationMatrixFrequencyType.quaterly"),
		SEMIANNUAL(7, "communicationMatrixFrequencyType.semiannual"),
		ANNUAL(7, "communicationMatrixFrequencyType.annual"),
		WHEN_EVENT_OCCURS(9, "communicationMatrixFrequencyType.whenEventOccurs");

		private Integer id;
		private String I18NKey;

		private CommunicationMatrixFrequencyType(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static String getChaveFromId(Integer id) {
			String retorno = "N/A";
			for (CommunicationMatrixFrequencyType recordType : CommunicationMatrixFrequencyType.values()) {
				if (recordType.getId().equals(id)) {
					retorno = recordType.getI18NKey();
				}
			}

			return retorno;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

	}

	public enum BatchProcessingType {
		JAVA_CLASS("C", "processamentoBatch.classeJava"),
		RHINOSCRIPT("R", "processamentoBatch.rhinoScript"),
		SQL("S", "processamentoBatch.sql");

		private String id;
		private String I18NKey;

		private BatchProcessingType(final String id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static String getChaveFromId(String id) {
			String retorno = "N/A";
			for (BatchProcessingType type : BatchProcessingType.values()) {
				if (type.getId().equalsIgnoreCase(id)) {
					retorno = type.getI18NKey();
				}
			}

			return retorno;
		}

		public String getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

	}

	public enum BusinessImportance {
		HIGH(4, "citcorpore.comum.alta"),
		MEDIUM(3, "citcorpore.comum.media"),
		LOW(1, "citcorpore.comum.baixa"),
		NORMAL(11, "citcorpore.comum.normal"),
		TOCOMBINE(10, "citcorpore.comum.aCombinar");

		private Integer id;
		private String I18NKey;

		private BusinessImportance(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public static String chaveFromId(final Integer id) {
			for (BusinessImportance businessImportance : BusinessImportance.values()) {
				if (businessImportance.getId().equals(id)) {
					return businessImportance.getI18NKey();
				}
			}

			return "N/A";
		}

	}

	public enum ServiceExecutionPlace {
		INTERNAL(1, "gerenciaportfolio.localExecucaoServico.interno"),
		EXTERNAL(2, "gerenciaportfolio.localExecucaoServico.externo"),
		INTERNAL_EXTERNAL(4, "gerenciaportfolio.localExecucaoServico.internoExterno");

		private Integer id;
		private String I18NKey;

		private ServiceExecutionPlace(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static String chaveFromId(final Integer id) {
			for (ServiceExecutionPlace serviceExecutionPlace : ServiceExecutionPlace.values()) {
				if (serviceExecutionPlace.getId().equals(id)) {
					return serviceExecutionPlace.getI18NKey();
				}
			}

			return "N/A";
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

	}

	/***
	 * <pre>
	 * Tipo de valor para a importao de carga
	 *
	 * - Em branco
	 * - Informado
	 * - Default
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 07.07.2016
	 */
	public enum TipoValorImportacaoCarga {
		EM_BRANCO(0, "citcorpore.comum.valorEmBranco"),
		INFORMADO(1, "citcorpore.comum.valorInformado"),
		DEFAULT(2, "citcorpore.comum.valorDefault");

		private final Integer identificador;
		private final String chave;

		private TipoValorImportacaoCarga(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static TipoValorImportacaoCarga fromIdentificador(final Integer identificador) {
			TipoValorImportacaoCarga retorno = null;

			for (final TipoValorImportacaoCarga tipoValorImportacaoCarga : TipoValorImportacaoCarga.values()) {
				if (tipoValorImportacaoCarga.getIdentificador().equals(identificador)) {
					retorno = tipoValorImportacaoCarga;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
		}
	}

	/***
	 * <pre>
	 * Valores default para a importao de carga do Servio no Portflio
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 13.07.2016
	 */
	public enum ValoresDefaultImportacaoCargaServicoPortfolio {
		SERVICO_DATA_IMPLANTACAO(0, "cargaPortfolioServico.dataAtual","cargaPortfolioServico.dataAtual"),
		SERVICO_FASE(1, FaseServico.DEFINIR.getIdentificador(), FaseServico.DEFINIR.getChave()),
		SERVICO_STATUS(2, StatusServico.REQUISITOS.getIdentificador(), StatusServico.REQUISITOS.getChave()),
		SERVICO_CRITICIDADE(3, CriticidadeServico.BAIXA.getIdentificador().toString(), CriticidadeServico.BAIXA.getChave()),
		INCIDENTE_REQUISICAO_SITUACAO(4, ServiceSituation.ACTIVE.getId().toString(), ServiceSituation.ACTIVE.getI18NKey()),
		INCIDENTE_REQUISICAO_DATA_IMPLANTACAO(5, "cargaPortfolioServico.dataAtual", "cargaPortfolioServico.dataAtual"),
		INCIDENTE_REQUISICAO_DIPONIVEL_PORTAL(6, SimNao.NAO.getValorStr(), SimNao.NAO.getChave());

		private final Integer identificador;
		private final String valor;
		private final String chave;

		private ValoresDefaultImportacaoCargaServicoPortfolio(final Integer identificador, final String valor, final String chave) {
				this.identificador = identificador;
			this.valor = valor;
				this.chave = chave;
			}

		public static ValoresDefaultImportacaoCargaServicoPortfolio fromIdentificador(final Integer identificador) {
			ValoresDefaultImportacaoCargaServicoPortfolio retorno = null;

			for (final ValoresDefaultImportacaoCargaServicoPortfolio valoresDefaultImportacaoCargaServicoPortfolio : ValoresDefaultImportacaoCargaServicoPortfolio.values()) {
				if (valoresDefaultImportacaoCargaServicoPortfolio.getIdentificador().equals(identificador)) {
					retorno = valoresDefaultImportacaoCargaServicoPortfolio;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getValor() {
			return valor;
		}

		public String getChave() {
			return chave;
		}
	}

	/***
	 * <pre>
	 * Campos de carga de Servio no Portflio
	 * 	- Nome do Portflio
	 * 	- Nome do Servio
	 * 	- Categoria do Servio
	 * 	- Data de Implantao do Servio
	 * 	- Fase do Servio
	 * 	- Status do Servio
	 * 	- Tipo de Investimento
	 * 	- Demanda
	 * 	- Retorno Financeiro
	 * 	- Nome do Servio de Incidente\Requisio
	 * 	- Situao do Servio de Incidente\Requisio
	 * 	- Data de Implantao do Servio de Incidente\Requisio
	 * 	- Tipo de Demanda do Servio de Incidente\Requisio
	 * 	- Categoria do Servio de Incidente\Requisio
	 * 	- Disponivel no Portal do Servio de Incidente\Requisio
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 13.07.2016
	 */
	public enum CamposCargaServicoPortfolio {
		PORTFOLIO_NOME(0, "gerenciaportfolio.portfolio"),
		SERVICO_NOME(1, "gerenciaportfolio.nomeServico"),
		SERVICO_CATEGORIA(2, "categoriaServico.categoriaNegocio"),
		SERVICO_DATA_IMPLANTACAO(3, "gerenciaportfolio.dataInicio"),
		SERVICO_FASE(4, "gerenciaportfolio.faseServico"),
		SERVICO_STATUS(5, "gerenciaportfolio.statusServico"),
		SERVICO_CLASSIFICACAO_CRITICIDADE(6, "gerenciaportfolio.servicoNegocio.criticidadeServico"),
		SERVICO_CLASSIFICACAO_TIPO_INVESTIMENTO(7, "gerenciaportfolio.tipoDeInvestimento"),
		SERVICO_CLASSIFICACAO_DEMANDA(8, "gerenciaportfolio.classificacao.demandaServico"),
		SERVICO_CLASSIFICACAO_RETORNO_FINANCEIRO(9, "gerenciaportfolio.classificacao.retornoFinanceiroServico"),
		SERVICO_INCREQ_NOME(10, "cargaPortfolioServico.nomeServicoIncidenteRequisicao"),
		SERVICO_INCREQ_SITUACAO(11, "cargaPortfolioServico.situacaoServicoIncidenteRequisicao"),
		SERVICO_INCREQ_DATA_IMPLANTACAO(12, "cargaPortfolioServico.dataInicioIncidenteRequisicao"),
		SERVICO_INCREQ_TIPO_DEMANDA(13, "gerenciaportfolio.tipoDemandaServico"),
		SERVICO_INCREQ_CATEGORIA(14, "cargaPortfolioServico.categoriaServicoIncidenteRequisicao"),
		SERVICO_INCREQ_DISP_PORTAL(15, "gerenciaportfolio.dispPortal");

		private final Integer identificador;
		private final String chave;

		private CamposCargaServicoPortfolio(final Integer identificador, final String chave) {
			this.identificador = identificador;
			this.chave = chave;
		}

		public static CamposCargaServicoPortfolio fromIdentificador(final Integer identificador) {
			CamposCargaServicoPortfolio retorno = null;

			for (final CamposCargaServicoPortfolio camposCargaServicoPortfolio : CamposCargaServicoPortfolio.values()) {
				if (camposCargaServicoPortfolio.getIdentificador().equals(identificador)) {
					retorno = camposCargaServicoPortfolio;
					break;
				}
			}
			return retorno;
		}

		public Integer getIdentificador() {
			return identificador;
		}

		public String getChave() {
			return chave;
				}
			}

	/***
	 * <pre>
	 * Causas do LogicException
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 21.07.2016
	 */
	public enum LogicExceptionCause {
		IMPORT_ERROR(0, "logicExceptionCause.msg.importError");

		private final Integer id;
		private final String I18NKey;

		private LogicExceptionCause(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static LogicExceptionCause fromIdStr(final String idStr) {
			try {
				Integer id = Integer.parseInt(idStr);
				return fromId(id);
			} catch (Exception e) {
				return null;
		}
		}

		public static LogicExceptionCause fromId(final Integer id) {
			LogicExceptionCause retorno = null;

			for (final LogicExceptionCause logicExceptionCause : LogicExceptionCause.values()) {
				if (logicExceptionCause.getId().equals(id)) {
					retorno = logicExceptionCause;
					break;
		}
			}
			return retorno;
		}

		public Integer getId() {
			return id;
		}

		public String getIdStr() {
			return id != null ? id.toString() : "";
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum ServiceSituation {
		ACTIVE(1, "service.situation.active"),
		ANALYZING(-999, "service.situation.analyzing"),
		CREATING(3, "service.situation.creating"),
		DESIGNING(4, "service.situation.designing"),
		INACTIVE(2, "service.situation.inactive");

		private Integer id;
		private String I18NKey;

		private ServiceSituation(final Integer id, final String i18NKey) {
			this.id = id;
			this.I18NKey = i18NKey;
		}

		public static String chaveFromId(Integer id) {
			for (ServiceSituation serviceSituation : ServiceSituation.values()) {
				if (serviceSituation.getId().equals(id)) {
					return serviceSituation.getI18NKey();
				}
			}

			return "N/A";
		}

		public static ServiceSituation fromId(Integer id) {
			ServiceSituation retorno = null;

			for (ServiceSituation serviceSituation : ServiceSituation.values()) {
				if (serviceSituation.getId().equals(id)) {
					return serviceSituation;
				}
			}
			return retorno;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum ServiceTypeEvent {
		EVENTUAL(1, "service.typeEvent.eventual"),
		DAILY(19, "service.typeEvent.daily"),
		WEEKLY(30, "service.typeEvent.weekly"),
		MONTHLY(31, "service.typeEvent.monthly"),
		SEMIANNUAL(32, "service.typeEvent.semiannual"),
		ANNUAL(33, "service.typeEvent.annual");

		private Integer id;
		private String I18NKey;

		private ServiceTypeEvent(final Integer id, final String i18NKey) {
			this.id = id;
			this.I18NKey = i18NKey;
		}

		public static String chaveFromId(Integer id) {
			for (ServiceTypeEvent serviceTypeEvent : ServiceTypeEvent.values()) {
				if (serviceTypeEvent.getId().equals(id)) {
					return serviceTypeEvent.getI18NKey();
				}
			}

			return "N/A";
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum ServiceLevelAgreementType {
		AVAILABILITY("D", "requisitosla.disponibilidade", "/imagens/servidorup.png"),
		REPETITIVE_FAILURES("F", "requisitosla.falhas_repetitivas", ""),
		OS_EXPECTED_RESULTS("R", "requisitosla.resultados_esperados", ""),
		TIME_IN_STAGES("T", "requisitosla.tempo_fases", "/imagens/relogio.png"),
		INFORMATION_FROM_OTHER_SOURCES("V", "requisitosla.informacoes_outras_fontes", "/imagens/outrasfontes.png");

		private String id;
		private String I18NKey;
		private String imgSrc;

		private ServiceLevelAgreementType(final String id, final String I18NKey, final String imgSrc) {
			this.id = id;
			this.I18NKey = I18NKey;
			this.imgSrc = imgSrc;
		}

		public String getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public String getImgSrc() {
			return imgSrc;
		}

		public static ServiceLevelAgreementType fromId(final String id) {
			for (ServiceLevelAgreementType serviceLevelAgreementType : ServiceLevelAgreementType.values()) {
				if (serviceLevelAgreementType.getId().equalsIgnoreCase(id)) {
					return serviceLevelAgreementType;
				}
			}

			throw new IllegalArgumentException(String.format("ServiceLevelAgreementType not found for id '%s'", id));
		}

		public static String chaveFromId(final String id) {
			return fromId(id).getI18NKey();
		}

	}

	/***
	 * <pre>
	 * ServiceDemandType
	 * 	- Analysis
	 * 	- Active
	 * 	- Inactive
	 * 	- Creation
	 * 	- Design
	 * </pre>
	 *
	 * @author deborah.ferreira
	 * @since 25.07.2016
	 */
	public enum ServiceDemandType {
		REQUEST(1, "gerenciaportfolio.tipoDemanda.requisicao", TipoServico.SERVICO_REQUISICAO.getIdentificador()),
		ORDER_SERVICE(2, "gerenciaportfolio.tipoDemanda.os", TipoServico.SERVICO_ORDEM_SERVICO.getIdentificador()),
		INCIDENT(3, "gerenciaportfolio.tipoDemanda.incidente", TipoServico.SERVICO_INCIDENTE.getIdentificador()),
		PROCEDURE(4, "gerenciaportfolio.tipoDemanda.procedimento", TipoServico.SERVICO_PROCEDIMENTO.getIdentificador());

		private Integer id;
		private String I18NKey;
		private String classification;

		private ServiceDemandType(final Integer id, final String I18NKey, final String classification) {
			this.id = id;
			this.I18NKey = I18NKey;
			this.classification = classification;
		}

		public static ServiceDemandType fromId(final Integer id) {
			ServiceDemandType retorno = null;
			for (ServiceDemandType serviceDemandType : ServiceDemandType.values()) {
				if (serviceDemandType.getId().equals(id)) {
					retorno = serviceDemandType;
					break;
				}
			}

			return retorno;
		}

		public static ServiceDemandType fromClassification(final String classification) {
			ServiceDemandType retorno = null;
			for (ServiceDemandType serviceDemandType : ServiceDemandType.values()) {
				if (serviceDemandType.getClassification().equals(classification)) {
					retorno = serviceDemandType;
					break;
				}
			}

			return retorno;
		}

		public static String chaveFromId(final Integer id) {
			for (ServiceDemandType serviceDemandType : ServiceDemandType.values()) {
				if (serviceDemandType.getId().equals(id)) {
					return serviceDemandType.getI18NKey();
				}
			}

			return "N/A";
		}

		public static List<ServiceDemandType> valuesWithoutOS() {
			List<ServiceDemandType> listRetorno = new ArrayList<>();
			for (ServiceDemandType serviceDemandType : ServiceDemandType.values()) {
				if (!serviceDemandType.equals(ServiceDemandType.ORDER_SERVICE)) {
					listRetorno.add(serviceDemandType);
				}
			}

			return listRetorno;
		}

		public static List<ServiceDemandType> valuesWithoutOSAndProcedure() {
			List<ServiceDemandType> listRetorno = new ArrayList<>();
			for (ServiceDemandType serviceDemandType : ServiceDemandType.values()) {
				if (!serviceDemandType.equals(ServiceDemandType.ORDER_SERVICE) && !serviceDemandType.equals(ServiceDemandType.PROCEDURE)) {
					listRetorno.add(serviceDemandType);
				}
			}

			return listRetorno;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public String getClassification() {
			return classification;
	}

	}

	public enum PermissaoAcessoPaginasRelacionadas{
		ATRIBUTOS_FINANCEIROS_IMPORTAR(1, "/pages/importarAtributosFinanceiros/importarAtributosFinanceiros.load", PagesPortfolio.SERVICO_NEGOCIO_ATRIBUTOS_FINANCEIROS.getCaminho()),
		CARGA_PORTFOLIO_SERVICO_IMPORTAR(2, "/pages/importarCargaPortfolioServico/importarCargaPortfolioServico.load", "/pages/cargaPortfolioServico/cargaPortfolioServico.load"),
		OPERACAO_CONTINUA_TESTES_CALENDARIO(3, "/pages/importarCargaPortfolioServico/importarCargaPortfolioServico.load", PagesContinuidade.OPERACAO_CONTINUA_TESTES.getCaminho());

		private Integer id;
		private String caminho;
		private String caminhoRelacionado;

		private PermissaoAcessoPaginasRelacionadas(final Integer id, final String caminho, final String caminhoRelacionado) {
			this.id = id;
			this.caminho = caminho;
			this.caminhoRelacionado = caminhoRelacionado;
		}

		public static PermissaoAcessoPaginasRelacionadas fromCaminho(final String caminho) {
			PermissaoAcessoPaginasRelacionadas retorno = null;

			for (final PermissaoAcessoPaginasRelacionadas paginasRelacionadas : PermissaoAcessoPaginasRelacionadas.values()) {
				if (paginasRelacionadas.getCaminho().equals(caminho)) {
					retorno = paginasRelacionadas;
					break;
				}
			}
			return retorno;
		}

		public Integer getId() {
			return this.id;
		}

		public String getCaminho() {
			return this.caminho;
		}

		public String getCaminhoRelacionado() {
			return this.caminhoRelacionado;
		}
	}

	
	public enum StatusInventario {
		INVENTARIADA(1, "inventario.status.inventariada"),
		IGNORADA(2, "inventario.status.ignorada"),
		INACESSIVEL(3, "inventario.status.inacessivel"),
		EMEXECUCAO(4, "citcorpore.comum.emExecucao"),
		NAOINVENTARIADA(5, "inventario.status.naoInventariada");

		private final Integer id;
		private final String chave;
	
		private StatusInventario(final Integer id, final String chave) {
			this.id = id;
			this.chave = chave;
		}
	
		public Integer getId() {
			return id;
		}
	
		public String getChave() {
			return chave;
		}

		public static StatusInventario fromId(final Integer id) {
			for (final StatusInventario statusInventario : StatusInventario.values()) {
				if (statusInventario.getId().equals(id)) {
					return statusInventario;
				}
			}

			return null;
		}
	}
	
	public enum DescricaoPrioridade {
		UM(1, "citcorpore.comum.alta"),
		DOIS(2, "citcorpore.comum.alta"),
		TRES(3, "citcorpore.comum.media"),
		QUATRO(4, "citcorpore.comum.baixa"),
		CINCO(5, "citcorpore.comum.baixa");

		private final Integer id;
		private final String chave;

		private DescricaoPrioridade(final Integer id, final String chave) {
			this.id = id;
			this.chave = chave;
		}

		public Integer getId() {
			return id;
		}

		public String getChave() {
			return chave;
		}

		public static DescricaoPrioridade fromId(final Integer id) {
			for (final DescricaoPrioridade descricaoPrioridade : DescricaoPrioridade.values()) {
				if (descricaoPrioridade.getId().equals(id)) {
					return descricaoPrioridade;
				}
			}

			return null;
		}
	}

	public enum ControleSLA {
		CRIADA(1, "citcorpore.comum.crida"),
		MANTER_TAREFA(2, "citcorpore.comum.manterTarefa"),
		ALTERADOSLA(3, "citcorpore.comum.alterarSLA"),
		SUSPENSO(4, "citcorpore.comum.suspenso"),
		REATIVO(5, "citcorpore.comum.reativar"),
		ATRIBUIDO(6, "solicitacaoServico.atribuidousuario"),
		RECLASSIFICADO(7, "citcorpore.comum.reclassificada"),
		FECHADO(8, "citcorpore.comum.fechada"),
		REABERTO(9, "citcorpore.comum.reaberta"),
		CANCELADO(10, "citcorpore.comum.cancelado"),
		EXECUTADO(11, "citcorpore.comum.executado"),
		DELEGADO(12, "citcorpore.comum.delegar"),
		DIRECIONADO(13, "citcorpore.comum.direcionamentoSolicitacao");
		
		private final Integer id;
		private final String chave;
	
		private ControleSLA(final Integer id, final String chave) {
			this.id = id;
			this.chave = chave;
		}
	
		public Integer getId() {
			return id;
		}
	
		public String getChave() {
			return chave;
		}

		public static ControleSLA fromId(final Integer id) {
			for (final ControleSLA controleSLA : ControleSLA.values()) {
				if (controleSLA.getId().equals(id)) {
					return controleSLA;
				}
			}

			return null;
		}
	}

	public enum ReportCategories {
		INCIDENTS_REQUESTS(1, "consultasRelatorios.categoria.incidentesRequisicoes", "warning"),
		ASSETS_AND_CONFIGURATION(2, "consultasRelatorios.categoria.ativosConfiguracao", "settings"),
		KNOWLEDGE_BASE(3, "consultasRelatorios.categoria.baseConhecimento", "book"),
		SERVICE_LEVELS(4, "consultasRelatorios.categoria.niveisServico", "access_time"),
		PROBLEMS(5, "consultasRelatorios.categoria.problemas", "error"),
		CHANGES(6, "consultasRelatorios.categoria.mudancas", "swap_horiz"),
		RELEASES(7, "consultasRelatorios.categoria.liberacao", "new_releases"),
		SERVICE_CATALOGS(8, "consultasRelatorios.categoria.catalogoServicos", "view_list"),
		PROJECTS(9, "consultasRelatorios.categoria.projetos", "developer_board");

		private Integer id;
		private String key;
		private String icon;

		private ReportCategories(Integer id, String key, String icon) {
			this.id = id;
			this.key = key;
			this.icon = icon;
		}

		public static String keyFromId(Integer id) {
			try {
				ReportCategories reportCategory = fromId(id);
				return reportCategory.getKey();
			} catch (Exception e) {
				return "-";
			}

		}

		public static ReportCategories fromId(Integer id) {
			if (id != null) {
				for (ReportCategories reportCategory : ReportCategories.values()) {
					if (reportCategory.getId().equals(id)) {
						return reportCategory;
					}
				}
			}

			throw new IllegalArgumentException(String.format("Report Category not found for id '%d'", id));
		}

		public Integer getId() {
			return id;
		}

		public String getKey() {
			return key;
		}

		public String getIcon() {
			return icon;
		}
	}

	/**
	 * Types of Query.
	 *
	 * <pre>
	 * - SQL
	 * - Rhino Script
	 * - Java Server Pages
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	public enum QueryTypes {
		SQL(1, "construtorconsultas.tipoConsulta.sql"),
		RHINOSCRIPT(2, "construtorconsultas.tipoConsulta.rhinoScript"),
		JSP(3, "construtorconsultas.tipoConsulta.jsp");

		private Integer id;
		private String key;

		private QueryTypes(Integer id, String key) {
			this.id = id;
			this.key = key;
		}

		public static String keyFromId(Integer id) {
			try {
				QueryTypes queryType = fromId(id);
				return queryType.getKey();
			} catch (Exception e) {
				return "-";
			}

		}

		public static QueryTypes fromId(Integer id) {
			if (id != null) {
				for (QueryTypes queryTypes : QueryTypes.values()) {
					if (queryTypes.getId().equals(id)) {
						return queryTypes;
					}
				}
			}

			throw new IllegalArgumentException(String.format("Query Type not found for id '%d'", id));
		}

		public Integer getId() {
			return id;
		}

		public String getKey() {
			return key;
		}
	}

	/**
	 * Types of report.
	 *
	 * <pre>
	 * - Template
	 * - Line Chart
	 * - Pie Chart
	 * - Bar Chart
	 * - Data Table
	 * - Cross References
	 * - HTML Return
	 * </pre>
	 *
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	public enum ReportTypes {
		TEMPLATE(1, "construtorconsultas.tipoRelatorio.template", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Bullets-128.png"),
		LINE_CHART(2, "construtorconsultas.tipoRelatorio.linha", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Graph-02-128.png"),
		PIE_CHART(3, "construtorconsultas.tipoRelatorio.pizza", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Pie-Chart-128.png"),
		BAR_CHART(4, "construtorconsultas.tipoRelatorio.barra", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Vertical-Align-Bottom-128.png"),
		DATA_TABLES(5, "construtorconsultas.tipoRelatorio.dataTable", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Table-128.png"),
		CROSS_REFERENCES(6, "construtorconsultas.tipoRelatorio.referenciasCruzadas", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Table-02-128.png"),
		HTML_RETURN(7, "construtorconsultas.tipoRelatorio.retornoHtml", CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Braces-01-128.png");

		private Integer id;
		private String key;
		private String image;

		private ReportTypes(Integer id, String key, String image) {
			this.id = id;
			this.key = key;
			this.image = image;
		}

		public static String keyFromId(Integer id) {
			try {
				ReportTypes reportTypes = fromId(id);
				return reportTypes.getKey();
			} catch (Exception e) {
				return "-";
			}
		}

		public static String imageFromId(Integer id) {
			try {
				ReportTypes reportTypes = fromId(id);
				return reportTypes.getImage();
			} catch (Exception e) {
				return "";
			}
		}

		public static ReportTypes fromId(Integer id) {
			if (id != null) {
				for (ReportTypes reportTypes : ReportTypes.values()) {
					if (reportTypes.getId().equals(id)) {
						return reportTypes;
					}
				}
			}

			throw new IllegalArgumentException(String.format("Report Type not found for id '%d'", id));
		}

		public Integer getId() {
			return id;
		}

		public String getKey() {
			return key;
		}

		public String getImage() {
			return image;
		}
	}

	public enum SmartDecisionsWidgets {
		DASHBOARD_PROCESSOS(1, "smartDecisions.dashboardProcessos.titulo", "smartDecisions.dashboardProcessos.descricao"),
		SOLICITACOES_POR_SERVICO(2, "smartDecisions.solicitacoesPorServico.titulo", "smartDecisions.solicitacoesPorServico.descricao"),
		EVENTOS_POR_TIPO(3, "smartDecisions.eventosPorTipo.titulo", "smartDecisions.eventosPorTipo.descricao"),
		ITENS_CONFIGURACAO_SOFTWARES(4, "smartDecisions.softwaresInstalados.titulo", "smartDecisions.softwaresInstalados.descricao"),
		DASHBOARD_SOLICITACOES(5, "smartDecisions.dashboardSolicitacoes.titulo", "smartDecisions.dashboardSolicitacoes.descricao");

		private SmartDecisionsWidgets(Integer id, String keyTitle, String keyDescription) {
			this.id = id;
			this.keyTitle = keyTitle;
			this.keyDescription = keyDescription;
		}

		private Integer id;
		private String keyTitle;
		private String keyDescription;

		public Integer getId() {
			return id;
		}

		public String getKeyTitle() {
			return keyTitle;
		}
		
		public String getKeyDescription() {
			return keyDescription;
		}

		public static SmartDecisionsWidgets fromId(Integer id) {
			if (id != null) {
				for (SmartDecisionsWidgets smartDecisionsWidgets : SmartDecisionsWidgets.values()) {
					if (smartDecisionsWidgets.getId().equals(id)) {
						return smartDecisionsWidgets;
					}
				}
			}

			throw new IllegalArgumentException(String.format("Widget not found for id '%d'", id));
		}
	}

	public enum SmartDecisionsPanels {
		FAST_ACCESS(1, "panel-acesso-rapido", "citcorpore.comum.acessoRapido"),
		SMART_DECISIONS(2, "panel-smart-decisions", "citcorpore.comum.smartDecisions");

		private Integer id;
		private String name;
		private String key;

		private SmartDecisionsPanels(Integer id, String name, String key) {
			this.id = id;
			this.name = name;
			this.key = key;
		}

		public static SmartDecisionsPanels fromId(Integer id) {
			if (id != null) {
				for (SmartDecisionsPanels smartDecisionsPanels : SmartDecisionsPanels.values()) {
					if (smartDecisionsPanels.getId().equals(id)) {
						return smartDecisionsPanels;
					}
				}
			}

			throw new IllegalArgumentException(String.format("Panel not found for id '%d'", id));
		}

		public static SmartDecisionsPanels fromName(String name) {
			if (UtilStrings.isNotVazio(name)) {
				for (SmartDecisionsPanels smartDecisionsPanels : SmartDecisionsPanels.values()) {
					if (smartDecisionsPanels.getName().equalsIgnoreCase(name)) {
						return smartDecisionsPanels;
					}
				}
			}

			throw new IllegalArgumentException(String.format("Panel not found for name '%s'", name));
		}

		public Integer getId() {
			return id;
		}

		public String getName() {
			return name;
		}

		public String getKey() {
			return key;
		}
	}
}