package br.com.centralit.citcorpore.util;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citcorpore.bean.MenuDTO;
import br.com.centralit.citcorpore.bean.PermissaoAcessoPaginaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.MenuService;
import br.com.centralit.citcorpore.negocio.PermissaoAcessoPaginaService;
import br.com.centralit.citcorpore.negocio.VersaoService;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({ "unchecked", "rawtypes", "unused" })
public class FiltroSegurancaCITSmart implements Filter {

	private static final int ACESSO_NEGADO = 403;
	private static Collection colLivres = new ArrayList();
	private static Boolean haVersoesSemValidacao = null;
	private static final String INTERROGACAO = "?";
	private static final int PROBLEMAS = 999;
	private static final String CIFRAO = "$";

	public static Boolean getHaVersoesSemValidacao() {
		try {
			if (haVersoesSemValidacao == null) {
				VersaoService service = (VersaoService) ServiceLocator.getInstance().getService(VersaoService.class, null);
				haVersoesSemValidacao = service.haVersoesSemValidacao();
			}
			return haVersoesSemValidacao;
		} catch (Exception e) {
			return true;
		}
	}

	public static void setHaVersoesSemValidacao(Boolean haVersoesSemValidacao) {
		FiltroSegurancaCITSmart.haVersoesSemValidacao = haVersoesSemValidacao;
	}

	@Override
	public void destroy() {
	}

	@Override
	public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) servletRequest;
		HttpServletResponse response = (HttpServletResponse) servletResponse;
		String path = getRequestedPath(request);

		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (path == null) {
			path = "";
		}

		if (isFilesLivres(path)) {
			String variavel_contexto = CIFRAO.concat(URLEncoder.encode("{ctx}", "UTF-8"));

			int ctx = path.indexOf(variavel_contexto);
			if (ctx > -1) {
				path = path.substring(ctx + variavel_contexto.length());
				request.getRequestDispatcher(path).forward(request, response);
			} else {
				chain.doFilter(request, response);
			}

			return;
		}
		if (isPaginaScript(path)) {
			chain.doFilter(request, response);
			return;
		}

		if(isPaginaSql(path) && usuario != null){
			chain.doFilter(request, response);
			return;
		}

		if (path.endsWith("/pages/smartPortal/smartPortal.load") || path.endsWith("/pages/portal/portal.load")) {
			if (usuario == null) {
				request.getSession(true).setAttribute("abrePortal", "S");
			} else {
				chain.doFilter(request, response);
				return;
			}
		}

		if (isRecursoLivre(path) && !getHaVersoesSemValidacao()) {
			if (path.endsWith("/pages/index/index.load")) {
				response.sendRedirect(Configuracoes.getCaminhoComContexto("/pages/smartDecisions/smartDecisions.load"));
			}
			chain.doFilter(request, response);
			return;
		}

		String CAMINHO_RELATIVO_PAGINA_LOGIN = Constantes.getValue("CAMINHO_RELATIVO_PAGINA_LOGIN");
		if (CAMINHO_RELATIVO_PAGINA_LOGIN == null || CAMINHO_RELATIVO_PAGINA_LOGIN.trim().equalsIgnoreCase("")) {
			CAMINHO_RELATIVO_PAGINA_LOGIN = Configuracoes.getCaminhoComContexto("/login/login.load");
		}

		if (path.equalsIgnoreCase("") || path.equalsIgnoreCase("/")) {
			response.sendRedirect(CAMINHO_RELATIVO_PAGINA_LOGIN);
			return;
		}

		if (usuario == null) {
			CharSequence s = new String(path);

			if (CAMINHO_RELATIVO_PAGINA_LOGIN.contains(s) || path.endsWith("/login.save") || path.endsWith("/login.event") || path.equalsIgnoreCase("/ActionServletMarcacao")) {
				chain.doFilter(request, response);
				return;
			}

			response.sendRedirect(CAMINHO_RELATIVO_PAGINA_LOGIN);
			return;
		}

		if ("N".equalsIgnoreCase(usuario.getAcessoCitsmart())) {
			if (!path.contains("/smartPortal/smartPortal.load") && !path.contains("/portal/portal.load")) {
				String habilitaNovoPortal = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.HABILITAR_NOVO_PORTAL, "S");

				if (habilitaNovoPortal.equalsIgnoreCase("S") || habilitaNovoPortal.equalsIgnoreCase("Y")) {
					response.sendRedirect(Configuracoes.getCaminhoComContexto("/pages/smartPortal/smartPortal.load"));
				} else {
					response.sendRedirect(Configuracoes.getCaminhoComContexto("/pages/portal/portal.load"));
				}
				return;
			}
		}

		String idPerfilAcessoAdministrador = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_PERFIL_ACESSO_ADMINISTRADOR, "1");
		boolean usuarioTemPerfilDeAdministrador = usuario.getIdPerfilAcessoUsuario() != null && usuario.getIdPerfilAcessoUsuario().toString().trim().equals(idPerfilAcessoAdministrador.trim());

		// O usuario "admin" ou "admin.centralit" tem acesso a tudo.
		if (usuario.getNomeUsuario().equalsIgnoreCase("administrador")
				|| usuario.getNomeUsuario().equalsIgnoreCase("admin.centralit")
				|| usuario.getNomeUsuario().equalsIgnoreCase("consultor")
				|| usuario.getNomeUsuario().equalsIgnoreCase("admin")
				|| usuarioTemPerfilDeAdministrador) {
			if (!getHaVersoesSemValidacao()) {
				chain.doFilter(request, response);
			} else {
				response.sendRedirect(Configuracoes.getCaminhoComContexto("/pages/scripts/scripts.load?upgrade=sim"));
			}
			return;
		}

		String SEGURANCA_HABILITADA = Constantes.getValue("SEGURANCA_HABILITADA");
		if (SEGURANCA_HABILITADA == null) {
			SEGURANCA_HABILITADA = "N";
		}

		// Se no estiver setada como "S" (Sim), ento est livre.
		if (!SEGURANCA_HABILITADA.equalsIgnoreCase("S")) {
			chain.doFilter(request, response);
			return;
		}

		try {
			if (isRecursoLivre(path)) {
				if (path.endsWith("/pages/index/index.load")) {
					response.sendRedirect(Configuracoes.getCaminhoComContexto("/pages/smartDecisions/smartDecisions.load"));
				}
				chain.doFilter(request, response);
				return;
			}
			Collection col = (Collection) request.getSession(true).getAttribute("acessosUsuario");
			// Caso ainda nao tenha carregado a colecao com as autorizaes, entao carrega.
			if (col == null) {
				Collection colPathsAutorizadosUsuario = new ArrayList();
				MenuService menuService = (MenuService) ServiceLocator.getInstance().getService(MenuService.class, null);
				Collection<MenuDTO> listaPermissao = menuService.listaMenuByUsr(usuario);
				if (listaPermissao != null && listaPermissao.size() > 0) {
					for (MenuDTO beanMenu : listaPermissao) {
						if (!"".equalsIgnoreCase(beanMenu.getLink())) {
							colPathsAutorizadosUsuario.add("/pages" + beanMenu.getLink());
						}
					}
				}

				PermissaoAcessoPaginaService permissaoAcessoPaginaService = (PermissaoAcessoPaginaService) ServiceLocator.getInstance().getService(PermissaoAcessoPaginaService.class, null);
				Collection<PermissaoAcessoPaginaDTO> paginas = permissaoAcessoPaginaService.getPaginasByUsuario(usuario, true);
				if (paginas != null && !paginas.isEmpty()) {
					for (PermissaoAcessoPaginaDTO pagina : paginas) {
						if (UtilStrings.isNotVazio(pagina.getCaminho())) {
							colPathsAutorizadosUsuario.add(pagina.getCaminho());
						}
					}
				}

				col = colPathsAutorizadosUsuario;
				request.getSession(true).setAttribute("acessosUsuario", col);
			}
			boolean bAutorizado = false;
			if (col != null) {
				bAutorizado = col.contains(path);
			}
			if (bAutorizado) {
				chain.doFilter(request, response);
				return;
			} else {

				/*
				 * Validao para verificar se o caminho possui um caminho relacionado que contenha as permisses
				 */
				if(Enumerados.PermissaoAcessoPaginasRelacionadas.fromCaminho(path) != null){
					path = Enumerados.PermissaoAcessoPaginasRelacionadas.fromCaminho(path).getCaminhoRelacionado();
					bAutorizado = col.contains(path);
				}

				if (bAutorizado) {
					chain.doFilter(request, response);
					return;
				}

				String endConteudo = "Conteudo.jsp";
				if (path.endsWith(endConteudo)) {
					String pathAut = path.substring(0, path.length() - endConteudo.length());
					pathAut += ".load";
					bAutorizado = col.contains(pathAut);
					if (bAutorizado) {
						chain.doFilter(request, response);
						return;
					}else{
						//Verifica se a URL possui "Conteudo" para construir uma nova URL
						//sem o bloco com "Conteudo" e realizar uma nova tentativa
						String newPath = "";
						String[] arrPath = pathAut.split("/");
						for(int k = 0; k < arrPath.length; k++){
							if(!arrPath[k].contains("Conteudo")){
								newPath = newPath.concat(arrPath[k]);
								if(k != arrPath.length-1){
									newPath = newPath.concat("/");
								}
							}
						}
						bAutorizado = col.contains(newPath);
						if(bAutorizado){
							chain.doFilter(request, response);
							return;
						}
					}
				}
				if (path.startsWith("/")) {
					path = path.substring(1);
					// Faz mais uma tentativa, mas agora sem a barra que havia.
					bAutorizado = col.contains(path);
					if (bAutorizado) {
						chain.doFilter(request, response);
						return;
					}
				}
				request.getSession(true).setAttribute("acessoSolicitado", path);
				sendError(ACESSO_NEGADO, "O usuario nao tem acesso ao recurso solicitado.", response);
			}
		} catch (Exception e) {
			System.out.println("CITSMART - Filtro de Seguranca: Problemas -> " + e.getMessage());
			e.printStackTrace();
			chain.doFilter(request, response);
		}
	}

	private String getRequestedPath(HttpServletRequest request) {
		String path = request.getRequestURI();
		path = path.substring(request.getContextPath().length());
		int index = path.indexOf(INTERROGACAO);
		if (index != -1) {
			path = path.substring(0, index);
		}
		return path;
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
		try {
			VersaoService service = (VersaoService) ServiceLocator.getInstance().getService(VersaoService.class, null);
			setHaVersoesSemValidacao(service.haVersoesSemValidacao());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private boolean isFilesLivres(String requestedPath) {
		if (requestedPath.endsWith(".old")) {
			return true;
		}
		if (requestedPath.endsWith(".json")) {
			return true;
		}
		if (requestedPath.endsWith(".zip")) {
			return true;
		}
		if (requestedPath.endsWith(".cab")) {
			return true;
		}
		if (requestedPath.endsWith(".smart")) {
			return true;
		}
		if (requestedPath.endsWith(".eot")) {
			return true;
		}
		if (requestedPath.endsWith(".extern")) {
			return true;
		}
		if (requestedPath.endsWith(".getFile")) {
			return true;
		}
		if (requestedPath.endsWith(".jar")) {
			return true;
		}
		if (requestedPath.endsWith(".swf")) {
			return true;
		}
		if (requestedPath.endsWith(".mp3")) {
			return true;
		}
		if (requestedPath.endsWith(".wav")) {
			return true;
		}
		if (requestedPath.endsWith(".woff")) {
			return true;
		}
		if (requestedPath.endsWith(".woff2")) {
			return true;
		}
		if (requestedPath.endsWith(".ico")) {
			return true;
		}
		if (requestedPath.endsWith(".manifest")) {
			return true;
		}
		if (requestedPath.endsWith("svg-editor.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("autoCompletePessoa.load")) {
			return true;
		}
		if (requestedPath.endsWith(".csv") || requestedPath.endsWith(".CSV")) {
			return true;
		}
		requestedPath = requestedPath.toUpperCase();
		if (requestedPath.endsWith(".JS")) {
			return true;
		}
		if (requestedPath.endsWith(".CSS")) {
			return true;
		}
		if (requestedPath.endsWith(".PDF")) {
			return true;
		}
		if (requestedPath.endsWith(".XML")) {
			return true;
		}
		if (requestedPath.endsWith(".JSON")) {
			return true;
		}
		if (requestedPath.endsWith(".XLS") || requestedPath.endsWith(".XLSX")) {
			return true;
		}
		if (requestedPath.endsWith(".DOC") || requestedPath.endsWith(".DOCX")) {
			return true;
		}
		if (requestedPath.endsWith(".GIF") || requestedPath.endsWith(".JPG") || requestedPath.endsWith(".PNG") || requestedPath.endsWith(".BMP") || requestedPath.endsWith(".DCM")
				|| requestedPath.endsWith(".DC3") || requestedPath.endsWith(".SVG")) {
			return true;
		}

		return false;
	}

	private boolean isPaginaSql(String requestedPath) {
		if (requestedPath.endsWith("/scripts/scripts.load")
				|| requestedPath.endsWith("/scripts/scripts.get")
				|| requestedPath.endsWith("/scripts/scripts.event")
				|| requestedPath.contains("/scripts_deploy/")) {
			return true;
		}

		return false;
	}

	private boolean isPaginaScript(String requestedPath) {
		if (requestedPath.endsWith("vazio.jsp")
				|| requestedPath.endsWith("/instalacao/instalacao.event")
				|| requestedPath.endsWith("/instalacao/instalacao.load")
				|| requestedPath.endsWith("/instalacao/instalacao.get")
				|| requestedPath.endsWith("/login/login.load")
				|| requestedPath.endsWith("/login/login.save")
				|| requestedPath.endsWith("/login/login.get")
				|| requestedPath.endsWith("/instalacao/termos/termos.html")
				|| requestedPath.endsWith("/instalacao/termos/termos_pt_BR.html")
				|| requestedPath.endsWith("/instalacao/termos/termos_en.html")
				|| requestedPath.endsWith("/instalacao/termos/termos_es.html")
				|| requestedPath.endsWith("/internacionalizar.load")
				|| requestedPath.endsWith("/internacionalizar.event")) {

			return true;
		}

		return false;
	}

	public boolean isRecursoLivre(String requestedPath) {
		return isRecursoLivre(requestedPath, true);
	}

	public boolean isRecursoLivre(String requestedPath, boolean validarEventos) {
		//System.out.println(requestedPath);

		if (validarEventos) {
			if (requestedPath.endsWith(".save") || requestedPath.endsWith(".find") || requestedPath.endsWith(".get") || requestedPath.endsWith(".restore") || requestedPath.endsWith(".event")
					|| requestedPath.endsWith(".complete") || requestedPath.endsWith(".dodelete") || requestedPath.endsWith(".doinsert") || requestedPath.endsWith(".doupdate")) {
				return true;
			}
		}

		if (requestedPath.contains("/smartDecisions/") || requestedPath.contains("/smartDecisions/")) {
			return true;
		}

		if (requestedPath.contains("webSocket") || requestedPath.contains("websocket")) {
			return true;
		}

		if (requestedPath.contains("upload") || requestedPath.contains("Upload") || requestedPath.contains("UPLOAD")) {
			return true;
		}

		if (requestedPath.endsWith("/login.save")) {
			return true;
		}

		if (requestedPath.contains("refreshupload") && requestedPath.endsWith(".load")) {
			return true;
		}

		if (requestedPath.contains("novoLayout/common/")) {
			return true;
		}

		if (requestedPath.contains("servicoQuestionario.load")) {
			return true;
		}

		if (requestedPath.endsWith("/validarChaveSeguranca.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pesquisaRequisicaoLiberacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/login.load")) {
			return true;
		}
		if (requestedPath.endsWith("/modalCurriculo/modalCurriculo.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteParceiro.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteFuncionario.load")) {
			return true;
		}

		if (requestedPath.endsWith("/ActionServlet")) {
			return true;
		}
		if (requestedPath.endsWith("/CertDisplay")) {
			return true;
		}
		if (requestedPath.endsWith("/CertVerifier")) {
			return true;
		}
		if (requestedPath.indexOf("/applet/") > -1) {
			return true;
		}
		if (requestedPath.indexOf("/services/") > -1) {
			return true;
		}
		if (requestedPath.indexOf("/mobile/") > -1) {
			return true;
		}
		if (requestedPath.indexOf("/citsmartEVM/") > -1) {
			return true;
		}
		if (requestedPath.indexOf("/citsmartInventory/") > -1) {
			return true;
		}
		if (requestedPath.indexOf("/certificadodigital/") > -1) {
			return true;
		}
		if (requestedPath.endsWith("/ActionServletLogin")) {
			return true;
		}
		if (requestedPath.endsWith("dataManagerObjects.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/solicitacaoServicoQuestionario/solicitacaoServicoQuestionario.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/liberacaoQuestionario/liberacaoQuestionario.load")) {
			return true;
		}
		if (requestedPath.endsWith("vazio.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("cithelp/index.html")) {
			return true;
		}
		if (requestedPath.endsWith("/cithelp/toc.html")) {
			return true;
		}
		if (requestedPath.endsWith("/cithelp/1Introduo.html")) {
			return true;
		}
		if (requestedPath.endsWith("lookup.load")) {
			return true;
		}
		if (requestedPath.endsWith("tableSearch.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/index/index.load")) {
			return true;
		}
		if (requestedPath.endsWith("citHelp/index.html")) {
			return true;
		}
		if (requestedPath.endsWith("sair.load")) {
			return true;
		}
		if (requestedPath.startsWith("/fckeditor/")) {
			return true;
		}
		if (requestedPath.endsWith("pages/index/index.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("topReportControl.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("eventos.load")) {
			return true;
		}
		if (requestedPath.endsWith("delegacaoTarefa.load")) {
			return true;
		}
		if (requestedPath.endsWith("dinamicViews.load")) {
			return true;
		}
		if (requestedPath.endsWith("solicitacaoServico.load")) {
			return true;
		}
		if (requestedPath.endsWith("problema.load")) {
			return true;
		}
		if (requestedPath.endsWith("internacionalizacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("eventMonitor.load")) {
			return true;
		}
		if (requestedPath.endsWith("requisicaoMudanca.load")) {
			return true;
		}

		/*
		 * if (requestedPath.endsWith("requisicaoMudanca.event")) { return true; }
		 */

		if (requestedPath.endsWith("requisicaoLiberacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("planoMelhoriaTreeView.load")) {
			return true;
		}
		if (requestedPath.endsWith("suspensaoSolicitacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/baseConhecimentoView/modalBaseConhecimento.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/osSetSituacao/osSetSituacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("mudarSLA.load")) {
			return true;
		}
		if (requestedPath.endsWith("copiarSLA.load")) {
			return true;
		}
		if (requestedPath.endsWith("agendarAtividade.load")) {
			return true;
		}
		if (requestedPath.endsWith("opiniao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/listaServicosContrato/listaServicosContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/visualizarNotificacoes/visualizarNotificacoes.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/informacaoItemConfiguracao/informacaoItemConfiguracao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/contratosAnexos/contratosAnexos.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/informacoesContratoQuestionario/informacoesContratoQuestionario.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/informacoesContrato/informacoesContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/listaOSContrato/listaOSContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/contratoQuestionarios/respostaPadraoFechar.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/contratoQuestionarios/respostaPadraoFechar.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/contratoQuestionarios/contratoQuestionarios.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/visualizarDesempenhoServicosContrato/visualizarDesempenhoServicosContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/programacaoAtividade/programacaoAtividade.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/testeCITSmart/testeCITSmart.load")) {
			return true;
		}
		if (requestedPath.endsWith("/os.load")) {
			return true;
		}
		if (requestedPath.endsWith("listaFaturasContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("fatura.load")) {
			return true;
		}
		if (requestedPath.endsWith("tableSearchVinc.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/alterarSenha/menu.html")) {
			return true;
		}
		if (requestedPath.endsWith("pages/alterarSenha/alterarSenha.load")) {
			return true;
		}
		if (requestedPath.endsWith("pesquisaSatisfacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/portal/portal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/categoriaPost/categoriaPost.load")) {
			return true;
		}
		if (requestedPath.endsWith("/post/post.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pesquisa/pesquisa.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/cargaParametroCorpore/cargaParametroCorpore.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/cadastroFluxo/cadastroFluxo.load")) {
			return true;
		}
		if (requestedPath.startsWith("/pages/pesquisaSolicitacoesServicos/pesquisaSolicitacoesServicos.event") || requestedPath.startsWith("/printPDF/printPDF.jsp")) {
			return true;
		}
		if (requestedPath.startsWith("/pages/pesquisaRequisicaoLiberacao/pesquisaRequisicaoLiberacao.load") || requestedPath.startsWith("/printPDF/printPDF.jsp")) {
			return true;
		}
		if (requestedPath.startsWith("/pages/pesquisaRequisicaoMudanca/pesquisaRequisicaoMudanca.load") || requestedPath.startsWith("/printPDF/printPDF.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/pesquisaSolicitacoesServicosPortal/pesquisaSolicitacoesServicosPortal.load") || requestedPath.startsWith("/printPDF/printPDF.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("listagemConsultas.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraInfoPivotTable.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraTemplateReport.load")) {
			return true;
		}
		if (requestedPath.endsWith("getFileConfig.load")) {
			return true;
		}
		if (requestedPath.endsWith("logJboss.load")) {
			return true;
		}
		if (requestedPath.endsWith("baseConhecimentoView.load")) {
			return true;
		}
		if (requestedPath.endsWith("/agendarAtividadeProblema.load")) {
			return true;
		}
		if (requestedPath.endsWith("/suspensaoProblema.load")) {
			return true;
		}
		if (requestedPath.endsWith("/validacaoRequisicaoProblema.load")) {
			return true;
		}
		if (requestedPath.endsWith("agendarReuniaoRequisicaoMudanca.load")) {
			return true;
		}
		if (requestedPath.endsWith("delegacaoLiberacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("agendarAtividadeRequisicaoLiberacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("suspensaoLiberacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("agendarAtividadeRequisicaoMudanca.load")) {
			return true;
		}
		if (requestedPath.endsWith("suspensaoMudanca.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/galeriaImagens/galeriaImagens.load")) {
			return true;
		}
		if (requestedPath.endsWith("/galeriaImagens/galeriaImagens.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/visualizacaoQuestionario/visualizacaoQuestionario.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/template/template.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/alterarSenha2/alterarSenha2.load")) {
			return true;
		}

		if (requestedPath.endsWith("/solicitacaoServicoMultiContratosPortal2/solicitacaoServicoMultiContratosPortal2.load")) {
			return true;
		}

		/*
		 * ######################################### INICIO FILTRO DE COMPRAS
		 */

		if (requestedPath.endsWith("/requisicaoProduto/requisicaoProduto.load")) {
			return true;
		}
		if (requestedPath.endsWith("/requisicaoQuestionario/requisicaoQuestionario.load")) {
			return true;
		}
		if (requestedPath.endsWith("/validacaoRequisicaoProduto/validacaoRequisicaoProduto.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autorizacaoCotacao/autorizacaoCotacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/aprovacaoCotacao/aprovacaoCotacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/itemCotacao/itemCotacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/fornecedorCotacao/fornecedorCotacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/coletaPreco/coletaPreco.load")) {
			return true;
		}
		if (requestedPath.endsWith("/inspecaoEntregaItem/inspecaoEntregaItem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/resultadoCotacao/resultadoCotacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/consultaAprovacaoCotacao/consultaAprovacaoCotacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pedidoCompra/pedidoCompra.load")) {
			return true;
		}
		if (requestedPath.endsWith("/entregaPedido/entregaPedido.load")) {
			return true;
		}
		if (requestedPath.endsWith("/acompRequisicaoProduto/acompRequisicaoProduto.load")) {
			return true;
		}
		if (requestedPath.endsWith("/informacaoItemConfiguracao/informacaoItemConfiguracao.load")) {
			return true;
		}

		/*
		 * ############################## FIM FILTRO DE COMPRAS
		 */

		/*
		 * ######################################### INICIO FILTRO DE RH
		 */
		if (requestedPath.endsWith("/triagemRequisicaoPessoal/triagemRequisicaoPessoal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/solicitacaoCargo/solicitacaoCargo.load")) {
			return true;
		}
		if (requestedPath.endsWith("/requisicaoPessoal/requisicaoPessoal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/entrevistaRequisicaoPessoal/entrevistaRequisicaoPessoal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/analiseSolicitacaoCargo/analiseSolicitacaoCargo.load")) {
			return true;
		}
		if (requestedPath.endsWith("/analiseRequisicaoPessoal/analiseRequisicaoPessoal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/curriculo/curriculo.load")) {
			return true;
		}
		if (requestedPath.endsWith("/entrevistaCandidato/entrevistaCandidato.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/entrevistaRequisicaoPessoal/entrevistaRequisicaoPessoal.load")) {
			return true;
		}

		if (requestedPath.endsWith("pages/entrevistaCandidato/entrevistaCandidato.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/requisicaoPessoal/requisicaoPessoal.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/classificacaoRequisicaoPessoal/classificacaoRequisicaoPessoal.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/movimentacaoColaborador/movimentacaoColaborador.load")) {
			return true;
		}

		if (requestedPath.endsWith("pages/triagemRequisicaoPessoal/triagemRequisicaoPessoal.load")) {
			return true;
		}

		if (requestedPath.endsWith("pages/templatePesquisaCurriculo/templatePesquisaCurriculo.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/pesquisaCurriculo/pesquisaCurriculo.load")) {
			return true;
		}
		if (requestedPath.endsWith("/historicoAcaoCurriculo/historicoAcaoCurriculo.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/historicoCandidato/historicoCandidato.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/visualizarHistoricoFuncional/visualizarHistoricoFuncional.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/blackList/blackList.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/itemHistoricoFuncional/itemHistoricoFuncional.load")) {
			return true;
		}

		/*
		 * ######################################### INICIO FILTRO LAYOUT NOVO
		 */

		if (requestedPath.endsWith("/gerenciamentoServicos/gerenciamentoServicos.load")) {
			return true;
		}

		if (requestedPath.endsWith("/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteServico/autoCompleteServico.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteSolicitante/autoCompleteSolicitante.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteTarefaAtual/autoCompleteTarefaAtual.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteCidade/autoCompleteCidade.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteEmpregado/autoCompleteEmpregado.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteNaoEmpregado/autoCompleteNaoEmpregado.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteFornecedor/autoCompleteFornecedor.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteFormacaoAcademica/autoCompleteFormacaoAcademica.load")) {
			return true;
		}

		if (requestedPath.endsWith("/evmGerenciamentoEventos/evmGerenciamentoEventos.load")) {
			return true;
		}

		if (requestedPath.endsWith("/evmOpcoesOcorrenciaEvento/evmOpcoesOcorrenciaEvento.load")) {
			return true;
		}

		if (requestedPath.endsWith("pages/evmGrupoCategoriaOcorrencia/evmGrupoCategoriaOcorrencia.load")) {
			return true;
		}

		if (requestedPath.indexOf("autoComplete") > 0) {
			return true;
		}

		/*
		 * ############################## FIM FILTRO DE RH
		 */


		// if
		// (requestedPath.endsWith("/pages/relatorioAcompanhamento/relatorioAcompanhamento.load"))
		// {
		// return true;
		// }
		if (requestedPath.endsWith("/pages/relatorioQuantitativoPorServico/relatorioQuantitativoPorServico.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/relatorioQuantitativo/relatorioQuantitativo.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/relatorioServicoAprovar/relatorioServicoAprovar.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/relatorioCargaHoraria/relatorioCargaHoraria.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/pesquisaFaq/pesquisaFaq.load")) {
			return true;
		}

		if (requestedPath.endsWith("/aprovacaoSolicitacaoServico.load")) {
			return true;
		}
		if (requestedPath.endsWith("/atividadesServico/atividadesServico.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/patrimonio/patrimonio.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/notificacaoServicoContrato/notificacaoServicoContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("/solicitacaoServicoMultiContratosPortal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/solicitacaoServicoPortal.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/categoriaOcorrencia/categoriaOcorrencia.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/origemOcorrencia/origemOcorrencia.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/notificacao/notificacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/cargaUsuarioAd/cargaUsuarioAd.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/cargaMensagens/cargaMensagens.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/itemConfiguracaoTree/itemConfiguracaoTree.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load")) {
			return true;
		}
		if (requestedPath.endsWith("recuperaFromGed/recuperaFromGed.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/portal/home.html")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/redefinirSenha/redefinirSenha.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/pesquisaErroConhecido/pesquisaErroConhecido.load")) {
			return true;
		}
		if (requestedPath.endsWith("/ansServicoContratoRelacionado/ansServicoContratoRelacionado.load")) {
			return true;
		}
		if (requestedPath.endsWith("pages/pesquisaRequisicaoMudanca/pesquisaRequisicaoMudanca.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/servicoContrato/servicoContrato.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/checklistQuestionario/checklistQuestionario.load")) {
			return true;
		}
		if (requestedPath.contains("/exportXML/")) {
			return true;
		}
		if (requestedPath.endsWith("pages/servicoContratoMulti/servicoContratoMulti.load")) {
			return true;
		}

		// ---- Pgina de teste de operao Rest -> Ser acionada diretamente pela URL
		if (requestedPath.endsWith("/pages/testeOperacaoRest/testeOperacaoRest.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/requisicaoViagem/requisicaoViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/despesaViagem/despesaViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/adiantamentoViagem/adiantamentoViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/autorizacaoViagem/autorizacaoViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/conferenciaViagem/conferenciaViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/controleFinanceiroViagem/controleFinanceiroViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/prestacaoContasViagem/prestacaoContasViagem.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/itemControleFinanceiroViagem/itemControleFinanceiroViagem.load")) {
			return true;
		}
        if (requestedPath.endsWith("/pages/compraViagem/compraViagem.load")) {
            return true;
        }
	    if (requestedPath.endsWith("/pages/corrigirPrestacaoContas/corrigirPrestacaoContas.load")) {
	    	return true;
	    }
	    if (requestedPath.endsWith("/pages/chatSmart/chatSmart.load")) {
			return true;
		}
	    if (requestedPath.endsWith("/pages/chatSmartListaContatos/chatSmartListaContatos.load")) {
			return true;
		}
		if (requestedPath.endsWith("/pages/motivoSuspensaoAtividade/motivoSuspensaoAtividade.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/informacoesItemConfiguracaoMudanca/informacoesItemConfiguracaoMudanca.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/origemAtendimento/origemAtendimento.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/cadastroConexaoBI/cadastroConexaoBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/agendamentoExecucaoBI/agendamentoExecucaoBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/importManualBI/importManualBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/logImportacaoBI/logImportacaoBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/importarDados/importarDados.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/externalConnection/externalConnection.load")) {
			return true;
		}

		if (requestedPath.endsWith("getExportBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("getLogImportacaoBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("suspensaoReativacaoSolicitacao/suspensaoReativacaoSolicitacao.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/ocorrenciaSolicitacao/ocorrenciaSolicitacao.load")) {
			return true;
		}

		if (requestedPath.startsWith("/dwr") || requestedPath.endsWith(".dwr")) {
            return true;
		}

		if (requestedPath.endsWith("/pages/relatorioIncidentesNaoResolvidos/relatorioIncidentesNaoResolvidos.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/relatorioEficaciaNasEstimativasDasRequisicaoDeServico/relatorioEficaciaNasEstimativasDasRequisicaoDeServico.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/relatorioKpiProdutividade/relatorioKpiProdutividade.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/relatorioEficaciaTeste/relatorioEficaciaTeste.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/relatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodo/relatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodo.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/requisicaoFuncao/requisicaoFuncao.load")) {
			return true;
		}

		if (requestedPath.endsWith("listagemConsultas.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraInfoPivotTable.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraTemplateReport.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraDataTable.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraGraficoPizzaJS.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraGraficoBarraJS.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraJSP.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraURL.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraXML.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraScript.load")) {
			return true;
		}
		if (requestedPath.endsWith("geraRetornoClasse.load")) {
			return true;
		}
		if (requestedPath.endsWith("listagemConsultasObjects.load")) {
			return true;
		}
		if (requestedPath.endsWith("listagemDashBoardsObjects.load")) {
			return true;
		}
		if (requestedPath.endsWith("topReportControl.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("topDashboardBuilder.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("topDashboarView.jsp")) {
			return true;
		}
		if (requestedPath.endsWith("dashBoardBuilderInternal.load")) {
			return true;
		}
		if (requestedPath.endsWith("dashBoardViewInternal.load")) {
			return true;
		}
		if (requestedPath.endsWith("listagemDashBoardsObjects.load")) {
			return true;
		}
		if (requestedPath.endsWith("listagemDashBoards.load")) {
			return true;
		}
		if (requestedPath.contains("/jspEmbedded/")) {
			return true;
		}


		/* Inicio dos autocompletes mapeados que no estavam no filtro de segurana. */

		if (requestedPath.endsWith("/pages/autoCompleteServicoBI/autoCompleteServicoBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteServicoCorporeBI/autoCompleteServicoCorporeBI.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/loginCandidato/loginCandidato.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/recuperaSenhaCandidato/recuperaSenhaCandidato.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/trabalheConosco/trabalheConosco.load") || requestedPath.startsWith("/pages/trabalheConosco/trabalheConosco.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/candidatoTrabalheConosco/candidatoTrabalheConosco.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/templateCurriculoTrabalheConosco/templateCurriculoTrabalheConosco.load")) {
			return true;
		}

		if (requestedPath.endsWith("/pages/visualizarCurriculoTrabalheConosco/visualizarCurriculoTrabalheConosco.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteDescricaoAtribuicaoResponsabilidade/autoCompleteDescricaoAtribuicaoResponsabilidade.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteCausa/autoCompleteCausa.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteAtitudeIndividual/autoCompleteAtitudeIndividual.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteCurso/autoCompleteCurso.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteCertificacao/autoCompleteCertificacao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteCompetenciaTecnica/autoCompleteCompetenciaTecnica.load")) {
			return true;
		}

		if (requestedPath.endsWith("/autoCompleteFuncao/autoCompleteFuncao.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompleteIdioma/autoCompleteIdioma.load")) {
			return true;
		}
		if (requestedPath.endsWith("autoCompleteExperiencia/autoCompleteExperiencia.load")) {
			return true;
		}
		if (requestedPath.endsWith("/autoCompletePerspectivaComportamental/autoCompletePerspectivaComportamental.load")) {
			return true;
		}


		if (requestedPath.endsWith("/dropzone/")) {
			return true;
		}

		if (requestedPath.endsWith("/confirmarNotificacao/confirmarNotificacao.load")) {
			return true;
		}
		/* Fim dos autocompletes mapeados que no estavam no filtro de segurana. */

		if (colLivres != null) {
			if (requestedPath.startsWith("/")) {
				requestedPath = requestedPath.substring(1);
			}
			for (Iterator it = colLivres.iterator(); it.hasNext();) {
				String req = (String) it.next();
				if (req.equalsIgnoreCase(requestedPath)) {
					return true;
				}
			}
		}
		return false;
	}

	private void sendError(int errorCode, String errorMessage, HttpServletResponse response) {
		try {
			response.sendError(errorCode, errorMessage);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
