package br.com.centralit.citcorpore.util;

import java.util.Date;

import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoTelaDTO;
import br.com.citframework.util.Reflexao;

/**
* Classe utilitria utilizada para armazenar os ICs descobertos ou que devem
* ser analisados pelo sistema.
*
* @author euler.ramos
*
*/
public class IPInventario {

    public String ip;
    
    public boolean ativo;
    
    public Date dataUltimaCaptura;
    
    public Date dataProximaCaptura;
    
    public String identificacaoIC;

    public String cronInventario;
    
	public Date getDataUltimaCaptura() {
		return dataUltimaCaptura;
	}

	public void setDataUltimaCaptura(Date dataUltimaCaptura) {
		this.dataUltimaCaptura = dataUltimaCaptura;
	}

	public Date getDataProximaCaptura() {
		return dataProximaCaptura;
	}

	public void setDataProximaCaptura(Date dataProximaCaptura) {
		this.dataProximaCaptura = dataProximaCaptura;
	}

	public String getCronInventario() {
		return cronInventario;
	}

	public void setCronInventario(String cronInventario) {
		this.cronInventario = cronInventario;
	}

	public String getIdentificacaoIC() {
		return identificacaoIC;
	}

	public void setIdentificacaoIC(String identificacaoIC) {
		this.identificacaoIC = identificacaoIC;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public boolean isAtivo() {
		return ativo;
	}

	public void setAtivo(boolean ativo) {
		this.ativo = ativo;
	}
	
	public static String montaUrlWs(EvmInventoryConfiguracaoTelaDTO telaDTO, String ws) throws Exception{
		EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();
		EvmConexaoDTO conexaoDTO = new EvmConexaoDTO();
		Reflexao.copyPropertyValues(telaDTO, configuracaoDTO);
		Reflexao.copyPropertyValues(telaDTO, conexaoDTO);
		return montaUrlWs(conexaoDTO, configuracaoDTO, ws);
	}
	
	public static String montaUrlWs(EvmConexaoDTO conexaoDTO, EvmInventoryConfiguracaoDTO configuracaoDTO, String ws){
		StringBuilder ws_url = new StringBuilder();
		ws_url.append("http://");
		ws_url.append(conexaoDTO.getEndereco());
		if (conexaoDTO.getPorta() != null) {
			ws_url.append(":");
			ws_url.append(conexaoDTO.getPorta());
		}
		ws_url.append("/");
		ws_url.append(configuracaoDTO.getContexto());
		ws_url.append("/ws/");
		ws_url.append(ws);
		return ws_url.toString();
	}

    
}
