package br.com.centralit.citcorpore.util;
import java.util.TreeSet;

public class NoArvoreServico implements Comparable<NoArvoreServico>{
	
	private Integer id;
	private String texto;
	private String nome;
	private String tipo;
	private Integer idFilho;
	private Integer nivel;
	private TreeSet<NoArvoreServico> pais;
	
	public NoArvoreServico(Integer id, String nome, String tipo, Integer idFilho) {
		super();
		this.id = id;
		this.texto = id + " | " + nome;
		this.nome = nome;
		this.tipo = tipo;
		this.idFilho = idFilho;
		this.pais = new TreeSet<NoArvoreServico>();
	}

	public Integer getId() {
		return id;
	}

	public String getTexto() {
		return texto;
	}

	public String getNome() {
		return nome;
	}

	public String getTipo() {
		return tipo;
	}

	public Integer getIdFilho() {
		return idFilho;
	}

	public Integer getNivel() {
		return nivel;
	}

	public void setNivel(Integer nivel) {
		this.nivel = nivel;
	}
	
	public TreeSet<NoArvoreServico> getPais() {
		return pais;
	}

	@Override
	public int compareTo(NoArvoreServico outroNoArvore) {
		return this.getTexto().compareTo(outroNoArvore.getTexto());
	}

}