package br.com.centralit.citcorpore.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.PerfilAcessoMenuDTO;
import br.com.centralit.citcorpore.bean.PermissaoAcessoPaginaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.MenuDao;
import br.com.centralit.citcorpore.util.Enumerados.Permissao;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.UtilStrings;

/**
 * @author joao.morais
 */
public class Permissoes {
	private boolean gravar;
	private boolean deletar;
	private boolean pesquisar;

	private DocumentHTML document;
	private HttpServletRequest request;
	private String caminho;

	public Permissoes(DocumentHTML document, HttpServletRequest request) {
		try {
			this.gravar = false;
			this.deletar = false;
			this.pesquisar = false;
			this.document = document;
			this.request = request;
			this.caminho = "";

			validaPermissao();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public Permissoes(DocumentHTML document, HttpServletRequest request, String caminho) {
		try {
			this.gravar = false;
			this.deletar = false;
			this.pesquisar = false;
			this.document = document;
			this.request = request;
			this.caminho = caminho;

			validaPermissao();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private String getRequestedPath(final HttpServletRequest request) {
		String urlValida = "";
		final String validarPermissoesDeBotoes = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.VALIDAR_BOTOES, SimNao.NAO.getValorStr());

		if (SimNao.SIM.getValorStr().equalsIgnoreCase(validarPermissoesDeBotoes.trim()) && UtilStrings.isNullOrEmpty(caminho)) {
			String linkRequisicao = request.getRequestURI();
			urlValida = getFirstPath(linkRequisicao);
		}

		return urlValida;
	}

	private static String getFirstPath(String path) {
		String[] linkSplit = path.split(Configuracoes.getCaminhoComContexto("/pages/"));
		String link;
		if (linkSplit != null && linkSplit.length > 1 && linkSplit[1] != null) {
			link = linkSplit[1];
			linkSplit = link.split("/");
			link = "/" + linkSplit[0] + "/" + linkSplit[0] + ".load";
		} else {
			linkSplit = path.split(Configuracoes.getCaminhoComContexto("/"));
			link = linkSplit[1];
			linkSplit = link.split("/");

			if (linkSplit != null && linkSplit.length > 0) {
				link = "/" + linkSplit[0] + "/" + linkSplit[0] + ".load";
			}
		}

		return link;
	}

	private static String getPagePath(String path) {
		String[] linkSplit = path.split("/citsmart");
		String link = "";
		if (linkSplit != null && linkSplit.length > 1 && linkSplit[1] != null) {
			link = linkSplit[1];
			linkSplit = link.split("\\.");
			link = linkSplit[0] + ".jsp";
		}

		return link;
	}

	private Collection<PerfilAcessoMenuDTO> getListaPerfilAcessoMenu() throws ServiceException, Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(this.request);
		String url = getRequestedPath(this.request);
		Collection<PerfilAcessoMenuDTO> listaAcessoMenus;

		if (request != null && usuario != null && !url.isEmpty() && url != null) {
			final MenuDao menuDao = new MenuDao();
			final Integer idMenu = menuDao.buscarIdMenu(url);
			listaAcessoMenus = WebUtil.getPerfilAcessoUsuarioByMenu(this.request, usuario, idMenu);
			return listaAcessoMenus;
		}

		return listaAcessoMenus = null;
	}

	private Collection<PermissaoAcessoPaginaDTO> getListaPermissaoAcessoPagina() throws ServiceException, Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(this.request);
		Collection<PermissaoAcessoPaginaDTO> listaPermissaoAcessoPagina;

		if (request != null && usuario != null) {
			listaPermissaoAcessoPagina = WebUtil.getPermissaoAcessoPaginaByUsuario(this.request, usuario);
			return listaPermissaoAcessoPagina;
		}

		return listaPermissaoAcessoPagina = null;
	}

	public static Map<Permissao, String> getPermissoes(String url, HttpServletRequest request) throws ServiceException, Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Map<Permissao, String> permissao = new HashMap<Permissao, String>();
		permissao.put(Permissao.GRAVAR, SimNao.NAO.getValorStr());
		permissao.put(Permissao.PESQUISAR, SimNao.NAO.getValorStr());
		permissao.put(Permissao.EXCLUIR, SimNao.NAO.getValorStr());

		// seta permisso total para administrador e consultor
		if (usuario != null && usuario.getLogin() != null && (usuario.getLogin().equalsIgnoreCase("admin") || usuario.getLogin().equalsIgnoreCase("consultor"))) {

			permissao.put(Permissao.GRAVAR, SimNao.SIM.getValorStr());
			permissao.put(Permissao.PESQUISAR, SimNao.SIM.getValorStr());
			permissao.put(Permissao.EXCLUIR, SimNao.SIM.getValorStr());

			return permissao;
		}

		final String validarPermissoesDeBotoes = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.VALIDAR_BOTOES, SimNao.NAO.getValorStr());

		if (SimNao.NAO.getValorStr().equals(validarPermissoesDeBotoes)) {
			permissao.put(Permissao.GRAVAR, SimNao.SIM.getValorStr());
			permissao.put(Permissao.PESQUISAR, SimNao.SIM.getValorStr());
			permissao.put(Permissao.EXCLUIR, SimNao.SIM.getValorStr());

			return permissao;
		}

		if (request != null && usuario != null && !url.isEmpty() && url != null) {
			final MenuDao menuDao = new MenuDao();
			final Integer idMenu = menuDao.buscarIdMenu(getFirstPath(url));
			Collection<PerfilAcessoMenuDTO> listaAcessoMenus = WebUtil.getPerfilAcessoUsuarioByMenu(request, usuario, idMenu);

			if (listaAcessoMenus != null) {
				for (final PerfilAcessoMenuDTO perfilAcesso : listaAcessoMenus) {
					if (perfilAcesso.getGrava().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
						permissao.put(Permissao.GRAVAR, SimNao.SIM.getValorStr());
					}

					if (perfilAcesso.getPesquisa().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
						permissao.put(Permissao.PESQUISAR, SimNao.SIM.getValorStr());
					}

					if (perfilAcesso.getDeleta().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
						permissao.put(Permissao.EXCLUIR, SimNao.SIM.getValorStr());
					}
				}
			}

			Collection<PermissaoAcessoPaginaDTO> listaPermissaoAcessoPagina = WebUtil.getPermissaoAcessoPaginaByUsuario(request, usuario);

			if (listaPermissaoAcessoPagina != null) {
				for (final PermissaoAcessoPaginaDTO permissaoAcesso : listaPermissaoAcessoPagina) {
					if (permissaoAcesso.getCaminho().equalsIgnoreCase(getPagePath(url))) {
						if (permissaoAcesso.getGrava().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
							permissao.put(Permissao.GRAVAR, SimNao.SIM.getValorStr());
						}

						if (permissaoAcesso.getPesquisa().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
							permissao.put(Permissao.PESQUISAR, SimNao.SIM.getValorStr());
						}

						if (permissaoAcesso.getDeleta().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
							permissao.put(Permissao.EXCLUIR, SimNao.SIM.getValorStr());
						}
					}
				}
			}

		}

		return permissao;
	}

	private void validaPermissao() throws ServiceException, Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(this.request);
		// seta permisso total para administrador e consultor
		if (usuario != null && usuario.getLogin() != null && (usuario.getLogin().equalsIgnoreCase("admin") || usuario.getLogin().equalsIgnoreCase("consultor"))) {
			this.setGravar(true);
			this.setPesquisar(true);
			this.setDeletar(true);
			document.executeScript("permissaoGravar = true;");
			document.executeScript("permissaoPesquisar = true;");
			document.executeScript("permissaoDelete = true;");
			return;
		}

		final String validarPermissoesDeBotoes = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.VALIDAR_BOTOES, SimNao.NAO.getValorStr());

		if (SimNao.NAO.getValorStr().equals(validarPermissoesDeBotoes)) {
			this.setGravar(true);
			this.setPesquisar(true);
			this.setDeletar(true);
			document.executeScript("permissaoGravar = true;");
			document.executeScript("permissaoPesquisar = true;");
			document.executeScript("permissaoDelete = true;");
			return;
		}

		this.setDeletar(false);
		this.setGravar(false);
		this.setPesquisar(false);

		Collection<PerfilAcessoMenuDTO> listaPerfilAcessoMenu = this.getListaPerfilAcessoMenu();

		if (listaPerfilAcessoMenu != null) {
			Boolean canSave = false;
			Boolean canSearch = false;
			Boolean canDelete = false;

			for (final PerfilAcessoMenuDTO perfilAcesso : listaPerfilAcessoMenu) {
				if (perfilAcesso.getGrava().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
					canSave = true;
				}

				if (perfilAcesso.getPesquisa().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
					canSearch = true;
				}

				if (perfilAcesso.getDeleta().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
					canDelete = true;
				}
			}

			this.setGravar(canSave);
			document.executeScript("permissaoGravar = " + canSave + ";");
			this.setPesquisar(canSearch);
			document.executeScript("permissaoPesquisar = " + canSearch + ";");
			this.setDeletar(canDelete);
			document.executeScript("permissaoDelete = " + canDelete + ";");
		}

		Collection<PermissaoAcessoPaginaDTO> listaPermissaoAcessoPagina = this.getListaPermissaoAcessoPagina();

		if (UtilStrings.isNotVazio(caminho) && listaPermissaoAcessoPagina != null) {
			Boolean canSave = false;
			Boolean canSearch = false;
			Boolean canDelete = false;

			for (final PermissaoAcessoPaginaDTO perfilAcesso : listaPermissaoAcessoPagina) {
				if (perfilAcesso.getCaminho().equalsIgnoreCase(caminho)) {
					if (perfilAcesso.getGrava().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
						canSave = true;
					}

					if (perfilAcesso.getPesquisa().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
						canSearch = true;
					}

					if (perfilAcesso.getDeleta().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
						canDelete = true;
					}
				}
			}

			this.setGravar(canSave);
			document.executeScript("permissaoGravar = " + canSave + ";");
			this.setPesquisar(canSearch);
			document.executeScript("permissaoPesquisar = " + canSearch + ";");
			this.setDeletar(canDelete);
			document.executeScript("permissaoDelete = " + canDelete + ";");
		}


		return;
	}
	public boolean isGravar() {
		return gravar;
	}

	public void setGravar(boolean gravar) {
		this.gravar = gravar;
	}

	public boolean isDeletar() {
		return deletar;
	}

	public void setDeletar(boolean deletar) {
		this.deletar = deletar;
	}

	public boolean isPesquisar() {
		return pesquisar;
	}

	public void setPesquisar(boolean pesquisar) {
		this.pesquisar = pesquisar;
	}

}