package br.com.centralit.citcorpore.util;

import java.util.HashMap;
import java.util.Map;

import com.google.common.base.Splitter;

import br.com.citframework.util.UtilStrings;

public class UrlUtil {
	public static Map<String, String> urlQueryStringParametersToMap(String url){
		if(UtilStrings.isNullOrEmpty(url)) {
			return new HashMap<>();
		}

		String queryString = url.replaceAll("[\\w\\.\\/]*\\?", "");
		if(UtilStrings.isNullOrEmpty(queryString)) {
			return new HashMap<>();
		}

		return Splitter.on("&").trimResults().withKeyValueSeparator("=").split(queryString);
	}
}
