package br.com.centralit.citcorpore.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.citframework.util.UtilI18N;

/**
* 
 * @author cristian.guedes
* A seguinte classe pode ser utilizada para validar os scripts Rhino
*/
public class ValidarScript {

                private DocumentHTML document;
                private HttpServletRequest request;
                private HttpServletResponse response;
                private String mensagem;
                private String mensagemResumida;

                public ValidarScript(DocumentHTML document, HttpServletRequest request,
                                               HttpServletResponse response) {
                               this.document = document;
                               this.request = request;
                               this.response = response;

                }

                public boolean validar(String script) {

                               if (script != null && !script.trim().equalsIgnoreCase("")) {
                                               final Context cx = Context.enter();
                                               final Scriptable scope = cx.initStandardObjects();
                                               scope.put("document", scope, document);
                                               scope.put("request", scope, request);
                                               scope.put("response", scope, response);
                                               scope.put("language", scope, WebUtil.getLanguage(request));

                                               try {

                                                               cx.evaluateString(scope, script, "", 1, null);
                                                               setMensagem(UtilI18N.internacionaliza(request, "citcorpore.comum.scriptOk"));
                                                               return true;

                                               } catch (org.mozilla.javascript.EcmaError e) {
                                                               setMensagem(StackParaString(e));
                                                               setMensagemResumida(substringComRegex(getMensagem(), "(?<=EcmaError\\:\\s)(.*)"));
                                                               
                                                               return false;
                                               } catch (org.mozilla.javascript.EvaluatorException e) {
                                                               setMensagem(StackParaString(e));
                                                               setMensagemResumida(substringComRegex(getMensagem(), "(?<=EvaluatorException\\:\\s)(.*)"));
                                                               return false;
                                               } catch (Exception e) {
                                                               setMensagem(StackParaString(e));
                                                               setMensagemResumida(UtilI18N.internacionaliza(request, "evm.monitor.configuracao.scriptinvalido"));
                                                               return false;
                                               }

                               } else {
                                               setMensagem(UtilI18N.internacionaliza(request, "evm.monitor.configuracao.scriptinvalido"));
                                               return false;
                               }

                }

                public String getMensagem() {
                               return mensagem;
                }

                public void setMensagem(String mensagem) {
                               this.mensagem = mensagem;
                }

                private String StackParaString(Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                return sw.toString();                     
                               
                }

                public String getMensagemResumida() {
                               return mensagemResumida;
                }

                public void setMensagemResumida(String mensagemResumida) {
                               this.mensagemResumida = mensagemResumida;
                }
                
                public static String substringComRegex(String string, String regex) {

                	Pattern pattern = Pattern.compile(regex);
                	Matcher matcher = pattern.matcher(string);
                	if (matcher.find())
                	{
                	  return matcher.group(1);
                	} else {
                	return "";
                	}

            	}
                
                

}              
