package br.com.centralit.citged.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.AnexoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudService;

public interface ControleGEDService extends CrudService {

	String getProximaPastaArmazenar() throws Exception;

	Collection<ControleGEDDTO> listByIdTabelaAndID(Integer idTabela, Integer id) throws Exception;

	Collection<UploadDTO> convertListControleGEDToUploadDTO(final Collection<ControleGEDDTO> colAnexosControleGED) throws Exception;

	Collection<ControleGEDDTO> listByIdTabelaAndIdBaseConhecimentoPaiEFilho(final Integer idTabela, final Integer idBasePai, final Integer idBaseFilho) throws PersistenceException, Exception;

	Collection<ControleGEDDTO> listByIdTabelaAndIdBaseConhecimento(final Integer idTabela, final Integer idBaseConhecimento) throws Exception;

	Collection<ControleGEDDTO> listByIdTabelaAndIdLiberacaoAndLigacao(final Integer idTabela, final Integer idRequisicaoLiberacao) throws Exception;

	ControleGEDDTO getControleGED(final AnexoBaseConhecimentoDTO anexoBaseConhecimento) throws Exception;

	String getRelativePathFromGed(ControleGEDDTO controleGEDDTO) throws Exception;

}