package br.com.centralit.citgerencial.generateservices.incidentes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import br.com.centralit.citcorpore.integracao.GraficosDao;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citgerencial.bean.GerencialGenerateService;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

/**
 * @author rodrigo.oliveira
 * @since 14/08/2012
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class GenerateServiceIncidentesPorSituacao extends GerencialGenerateService {

	private HashMap novoParametro = new HashMap();
	private GraficosDao graficosDao;

	private GraficosDao graficosDaoDataBaseAlias;

	private GraficosDao getDao() {
		if(graficosDao == null) {
			graficosDao = new GraficosDao();
		}
		return graficosDao;
	}

	/**
	 * Desenvolvedor: Fabio Amorim - Data: 13/08/2015 - Horrio: 14:48 - ID Citsmart: 176361 -
	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
	private GraficosDao getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (graficosDaoDataBaseAlias == null) {
				graficosDaoDataBaseAlias = new GraficosDao(databaseAlias);
			}
			return graficosDaoDataBaseAlias;
		}
		return this.getDao();
	}

	@Override
	public List execute(HashMap parametersValues, Collection paramtersDefinition) throws ParseException {

		Set set = parametersValues.entrySet();
		Iterator i = set.iterator();

		while (i.hasNext()) {
			Map.Entry entrada = (Map.Entry) i.next();
			getNovoParametro().put(entrada.getKey(), entrada.getValue());
		}

		String datainicial = (String) getNovoParametro().get("PARAM.dataInicial");
		String datafinal = (String) getNovoParametro().get("PARAM.dataFinal");

		Date datafim = new Date();
		Date datainicio = new Date();

		try {
			datainicio = UtilDatas.convertStringToDate(TipoDate.DATE_DEFAULT, datainicial, super.getLanguage(paramtersDefinition));
			datafim = UtilDatas.convertStringToDate(TipoDate.DATE_DEFAULT, datafinal, super.getLanguage(paramtersDefinition));
		} catch (ParseException e) {
			e.printStackTrace();
		}

		Calendar calendar = Calendar.getInstance();
		calendar.setTime(datafim);
		calendar.add(GregorianCalendar.DATE, 1);

		if (CITCorporeUtil.SGBD_PRINCIPAL.equalsIgnoreCase(SQLConfig.MYSQL)) {
			getNovoParametro().put("PARAM.dataInicial", UtilDatas.convertDateToString(TipoDate.FORMAT_DATABASE, datainicio, super.getLanguage(paramtersDefinition)));
			getNovoParametro().put("PARAM.dataFinal", UtilDatas.convertDateToString(TipoDate.FORMAT_DATABASE, calendar.getTime(), super.getLanguage(paramtersDefinition)));
		} else {
			getNovoParametro().put("PARAM.dataInicial", new java.sql.Date(datainicio.getTime()));
			getNovoParametro().put("PARAM.dataFinal", new java.sql.Date(calendar.getTime().getTime()));
		}

		Collection col = null;
		List listaRetorno = null;

		try {
			col = getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).consultaIncidentesPorSituacao(getNovoParametro(), "I");
		} catch (Exception e) {
			e.printStackTrace();
		}

		if (col != null && !col.isEmpty()) {
			Iterator<Object> it = col.iterator();

			while (it.hasNext()) {
				Object[] row = (Object[]) it.next();

				try {
					Object obj = row[0];
					Integer objInt;
					if (Double.class.isInstance(obj)) {
						objInt = ((Double) obj).intValue();
					} else if (BigDecimal.class.isInstance(obj)) {
						objInt = ((BigDecimal) obj).intValue();
					} else if (Long.class.isInstance(obj)) {
						objInt = ((Long) obj).intValue();
					} else if (Integer.class.isInstance(obj)) {
						objInt = ((Integer) obj).intValue();
					} else if (BigInteger.class.isInstance(obj)) {
						objInt = ((BigInteger) obj).intValue();
					} else if (Short.class.isInstance(obj)) {
						objInt = ((Short) obj).intValue();
					} else {
						objInt = (Integer) obj;
					}

					if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(objInt)) {
						row[0] = UtilI18N.internacionaliza(getLanguage(paramtersDefinition), ServiceRequestStatus.getChaveFromId(objInt.intValue()));
					}

				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			listaRetorno = (List) col;
		} else {
			listaRetorno = new ArrayList();
		}

		// resetando parmetro
		setNovoParametro(null);

		return listaRetorno;
	}

	public HashMap getNovoParametro() {
		return novoParametro;
	}

	public void setNovoParametro(HashMap novoParametro) {
		this.novoParametro = novoParametro;
	}

}
