package br.com.centralit.citsmart.gerentemapamemoria;

import java.util.Collection;

/**
 * Classe Singleton dever possuir a estrutura (ainda em estudo) dos eventos que sero processados pelo
 * Citsmart EVM
 * 
 * @author cristian.guedes
 *
 */
public class SingletonMapaMemoria {
	
	private static SingletonMapaMemoria instance = null;
	public static Collection<EventoEVM> eventos;
	
	/**
	 * Este construtor s existe para impedir a instanciao
	 */
	protected SingletonMapaMemoria() {
		
	}
	
	
	/**
	 * Ao invs de criar uma nova instncia desta classe, este mtodo dever ser chamado quando
	 * o primeiro acesso  mesma for feito.
	 * @return
	 */
	public static SingletonMapaMemoria getInstance() {
		if (instance == null) {
			instance = new SingletonMapaMemoria();

//			TODO: inicializar as propriedades da classe singleton aqui
			

		}
		return instance;
	}
	
	/**
	 * Atualizar o mapa de memria com os novos eventos processados pelo Citsmrt EVM
	 */
	public static void atualizarMapaMemoria(Collection<EventoEVM> novosEventos) {
		eventos.addAll(novosEventos);
	}
	

}
