package br.com.centralit.citsmart.rest.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citsmart.rest.bean.RestOperationDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class RestOperationDao extends CrudDaoDefaultImpl {

    public RestOperationDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<Field> getFields() {
        final Collection<Field> listFields = new ArrayList<>();
        listFields.add(new Field("idRestOperation", "idRestOperation", true, true, false, false));
        listFields.add(new Field("idBatchProcessing", "idBatchProcessing", false, false, false, false));
        listFields.add(new Field("name", "name", false, false, false, false));
        listFields.add(new Field("description", "description", false, false, false, false));
        listFields.add(new Field("operationType", "operationType", false, false, false, false));
        listFields.add(new Field("classType", "classType", false, false, false, false));
        listFields.add(new Field("javaClass", "javaClass", false, false, false, false));
        listFields.add(new Field("javaScript", "javaScript", false, false, false, false));
        listFields.add(new Field("status", "status", false, false, false, false));
        listFields.add(new Field("generateLog", "generateLog", false, false, false, false));

        return listFields;
    }

    @Override
    public String getTableName() {
        return this.getOwner() + "Rest_Operation";
    }

    @Override
    public Collection<RestOperationDTO> list() throws PersistenceException {
        return null;
    }

    @Override
    public Class<RestOperationDTO> getBean() {
        return RestOperationDTO.class;
    }

    @Override
    public Collection<RestOperationDTO> find(final IDto arg0) throws PersistenceException {
        return null;
    }

    public Collection<RestOperationDTO> findByIdBatchProcessing(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idBatchProcessing", "=", parm));
        ordenacao.add(new Order("idRestOperation"));
        return super.findByCondition(condicao, ordenacao);
    }

    public RestOperationDTO findByName(final String name) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("name", "=", name));
        final List<RestOperationDTO> result = (List<RestOperationDTO>) super.findByCondition(condicao, ordenacao);
        if (result != null && !result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public void deleteByIdBatchProcessing(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        condicao.add(new Condition("idBatchProcessing", "=", parm));
        super.deleteByCondition(condicao);
    }

    public boolean findRegistroCadastrado() throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idRestOperation", ">", 0));
        ordenacao.add(new Order("idRestOperation"));
        
		List<RestOperationDTO> result = (List<RestOperationDTO>) super.findByCondition(condicao, ordenacao);
        if (result != null && !result.isEmpty()) {
            return true;
        }
        return false;
    }

	public Collection<RestOperationDTO> listCitsmartMobileWebServices() throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<RestOperationDTO> result = new ArrayList<>();

		sql.append("SELECT ").append(this.getNamesFieldsStr());
		sql.append(" FROM ").append(this.getTableName());
		sql.append(" WHERE UPPER(javaclass) like UPPER('%v2%') OR UPPER(name) like UPPER('notification_new') ");

		result = this.execSQL(sql.toString(), null);
		List<RestOperationDTO> listCitsmartMobileWebServices = this.engine.listConvertion(getBean(), result, getListNamesFieldClass());

		return listCitsmartMobileWebServices;
	}
	
	//Filtro
	public Collection<RestOperationDTO> listByText(String text) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();

		List<RestOperationDTO> result = new ArrayList<>();
		List<String> listFieldClassParaPopular = new ArrayList<>();
		Collection<RestOperationDTO> listaWebServices;

		sql.append("SELECT ").append(this.getNamesFieldsStr()).append(" ");
		sql.append("FROM ").append(this.getTableName()).append(" ");
		sql.append("WHERE (UPPER(javaclass) like UPPER('%v2%') OR UPPER(name) like UPPER('notification_new'))");
		sql.append(" AND ").append(Util.getQueryLikeWithCaseInsensitiveAndAccentInsensitive(MAIN_SGBD, "NAME", text));

		listFieldClassParaPopular.addAll(getListNamesFieldClass());

		result = this.execSQL(sql.toString(), parametros.toArray());
		listaWebServices = this.engine.listConvertion(getBean(), result, listFieldClassParaPopular);

		return listaWebServices;
	}

	public RestOperationDTO findByIdRestOperation(Integer idRestOperation) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<RestOperationDTO> result = new ArrayList<>();

		RestOperationDTO restOperation = new RestOperationDTO();

		sql.append("SELECT ").append(this.getNamesFieldsStr());
		sql.append(" FROM ").append(this.getTableName());
		sql.append(" WHERE idrestoperation = ").append(idRestOperation);

		result = this.execSQL(sql.toString(), null);
		List<RestOperationDTO> listCitsmartMobileWebServices = this.engine.listConvertion(getBean(), result, getListNamesFieldClass());

		if (listCitsmartMobileWebServices != null && !listCitsmartMobileWebServices.isEmpty()) {
			for (RestOperationDTO restOp : listCitsmartMobileWebServices) {
				restOperation = restOp;
			}
		}

		return restOperation;
	}
}