package br.com.centralit.citsmart.rest.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citsmart.rest.bean.RestPermissionDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class RestPermissionDao extends CrudDaoDefaultImpl {

    public RestPermissionDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<Field> getFields() {
        final Collection<Field> listFields = new ArrayList<>();
        listFields.add(new Field("idRestOperation", "idRestOperation", true, false, false, false));
        listFields.add(new Field("idGroup", "idGroup", true, false, false, false));
        listFields.add(new Field("status", "status", false, false, false, false));
        return listFields;
    }

    @Override
    public String getTableName() {
        return this.getOwner() + "Rest_Permission";
    }

    @Override
    public Collection<RestPermissionDTO> list() throws PersistenceException {
        return null;
    }

    @Override
    public Class<RestPermissionDTO> getBean() {
        return RestPermissionDTO.class;
    }

    @Override
    public Collection<RestPermissionDTO> find(final IDto arg0) throws PersistenceException {
        final RestPermissionDTO permissionDto = (RestPermissionDTO) arg0;
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        if (permissionDto.getIdRestOperation() != null) {
            condicao.add(new Condition("idRestOperation", "=", permissionDto.getIdRestOperation()));
        }
        if (permissionDto.getIdGroup() != null) {
            condicao.add(new Condition("idGroup", "=", permissionDto.getIdGroup()));
        }
        ordenacao.add(new Order("idRestOperation"));
        return super.findByCondition(condicao, ordenacao);
    }

    public Collection<RestPermissionDTO> findByIdOperation(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idRestOperation", "=", parm));
        ordenacao.add(new Order("idGroup"));
        return super.findByCondition(condicao, ordenacao);
    }

    public void deleteByIdOperation(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        condicao.add(new Condition("idRestOperation", "=", parm));
        super.deleteByCondition(condicao);
    }

    public Collection<RestPermissionDTO> findByIdGroup(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idGroup", "=", parm));
        ordenacao.add(new Order("idRestOperation"));
        return super.findByCondition(condicao, ordenacao);
    }

    public void deleteByIdGroup(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        condicao.add(new Condition("idRestUser", "=", parm));
        super.deleteByCondition(condicao);
    }

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public boolean verifyIfExists(Integer idRestOperation, Integer idGroup) throws PersistenceException {
		boolean retorno = false;

		List params = new ArrayList();
		StringBuilder sql = new StringBuilder();

		sql.append("SELECT ").append(this.getNamesFieldsStr());
		sql.append(" FROM ").append(this.getTableName());
		sql.append(" WHERE idrestoperation = ? ");

		if (idRestOperation != null && idRestOperation > 0) {
			params.add(idRestOperation);
		} else {
			params.add(0);
		}

		sql.append(" AND idgroup = ? ");
		if (idGroup != null && idGroup > 0) {
			params.add(idGroup);
		} else {
			params.add(0);
		}

		List<RestPermissionDTO> result = this.execSQL(sql.toString(), params.toArray());
		if (result != null && !result.isEmpty()) {
			retorno = true;
		}
		return retorno;
	}

	@SuppressWarnings("unchecked")
	public Collection<RestPermissionDTO> listCitsmartMobileLinkedGroups() throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<RestPermissionDTO> result = new ArrayList<>();

		sql.append("SELECT ").append(this.getNamesFieldsStr());
		sql.append(" FROM ").append(this.getTableName());

		result = this.execSQL(sql.toString(), null);
		List<RestPermissionDTO> listCitsmartMobileLinkedGroups = this.engine.listConvertion(getBean(), result, getListNamesFieldClass());

		return listCitsmartMobileLinkedGroups;
	}

	public void unlinkGroupInWebServices(Integer idGroup) throws PersistenceException {
		StringBuilder sql = new StringBuilder();

		sql.append("DELETE FROM ").append(this.getTableName());
		sql.append(" WHERE idgroup = ").append(idGroup);

		this.execUpdate(sql.toString(), null);
	}
}