package br.com.centralit.citsmart.rest.evm;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;

import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citsmart.rest.bean.RestSessionDTO;
import br.com.centralit.citsmart.rest.schema.CtLogin;
import br.com.centralit.citsmart.rest.schema.CtLoginFromCitsmartEventMonitor;
import br.com.centralit.citsmart.rest.service.RestSessionService;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilI18N;

public class RestUtilsEVM implements IRestUtilsEVM {
	@Context
	protected HttpServletRequest httpRequest;
	
	private UsuarioService usuarioService;

	/**
	 * Compara os dados do usurio (enviados no formato JSON para o resteasy) com os dados do usurio no banco
	 * de dados do Citsmart, retornando true caso encontre uma correspondncia
	 * @param login
	 * @return Um valor booleano
	 * @throws ServiceException
	 * @throws LogicException
	 * @throws Exception
	 */
	protected boolean isAutenticar(CtLogin login) throws ServiceException, LogicException, Exception {
		RestSessionService restSessionService = (RestSessionService) ServiceLocator.getInstance().getService(RestSessionService.class, null);
		httpRequest.getSession().setAttribute("locale", UtilI18N.getLocale());

		String algoritmo = br.com.citframework.util.Constantes.getValue("ALGORITMO_CRIPTOGRAFIA_SENHA");
		if (algoritmo == null || !algoritmo.trim().equalsIgnoreCase("")) {
			algoritmo = "SHA-1";
		}

		UsuarioDTO user = getUsuarioService().restoreByLogin(login.getUserName(), CriptoUtils.generateHash(login.getPassword(), algoritmo));
		httpRequest.getSession().setAttribute(Constantes.getValue("USUARIO_SESSAO") + "_CITCORPORE", user);

		RestSessionDTO sessionDto = restSessionService.newSession(httpRequest, login);
		if (sessionDto.getSessionID() != null && !sessionDto.getSessionID().equalsIgnoreCase("")) {
			return true;

		} else {
			return false;
		}
	}

	
	/**
	 * Compara os dados do usurio (enviados no formato JSON para o resteasy) com os dados do usurio no banco de dados do Citsmart, retornando true caso encontre uma correspondncia
	 * 
	 * @param login
	 * @return Um valor booleano
	 * @throws ServiceException
	 * @throws LogicException
	 * @throws Exception
	 */
	protected boolean isAutenticar(CtLoginFromCitsmartEventMonitor login) throws ServiceException, LogicException, Exception {
		CtLogin ctLogin = new CtLogin();
		Reflexao.copyPropertyValues(login, ctLogin);
		return this.isAutenticar(ctLogin);
	}

	public UsuarioService getUsuarioService() throws ServiceException {
		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}

}
